/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AbstractMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;

public class NewDefiningMethodProposal
extends AbstractMethodCompletionProposal {
    private final IFunctionBinding fMethod;
    private final String[] fParamNames;

    public NewDefiningMethodProposal(String label, IJavaScriptUnit targetCU, ASTNode invocationNode, ITypeBinding binding, IFunctionBinding method, String[] paramNames, int relevance) {
        super(label, targetCU, invocationNode, binding, relevance, null);
        this.fMethod = method;
        this.fParamNames = paramNames;
        ImageDescriptor desc = JavaElementImageProvider.getMethodImageDescriptor(binding.isInterface() || binding.isAnnotation(), method.getModifiers());
        this.setImage(JavaScriptPlugin.getImageDescriptorRegistry().get(desc));
    }

    protected boolean isConstructor() {
        return this.fMethod.isConstructor();
    }

    protected void addNewParameters(ASTRewrite rewrite, List takenNames, List params) throws CoreException {
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] bindings = this.fMethod.getParameterTypes();
        IJavaScriptProject project = this.getCompilationUnit().getJavaScriptProject();
        String[][] paramNames = StubUtility.suggestArgumentNamesWithProposals(project, this.fParamNames);
        int i = 0;
        while (i < bindings.length) {
            ITypeBinding curr = bindings[i];
            String[] proposedNames = paramNames[i];
            SingleVariableDeclaration newParam = ast.newSingleVariableDeclaration();
            newParam.setType(importRewrite.addImport(curr, ast));
            newParam.setName(ast.newSimpleName(proposedNames[0]));
            params.add(newParam);
            String groupId = "arg_name_" + i;
            this.addLinkedPosition(rewrite.track((ASTNode)newParam.getName()), false, groupId);
            int k = 0;
            while (k < proposedNames.length) {
                this.addLinkedPositionProposal(groupId, proposedNames[k], null);
                ++k;
            }
            ++i;
        }
    }

    protected SimpleName getNewName(ASTRewrite rewrite) {
        AST ast = rewrite.getAST();
        SimpleName nameNode = ast.newSimpleName(this.fMethod.getName());
        return nameNode;
    }

    private int evaluateModifiers() {
        if (this.getSenderBinding().isInterface()) {
            return 0;
        }
        int modifiers = this.fMethod.getModifiers();
        if (Modifier.isPrivate((int)modifiers)) {
            modifiers |= 4;
        }
        return modifiers & 0xC05;
    }

    protected void addNewModifiers(ASTRewrite rewrite, ASTNode targetTypeDecl, List modifiers) {
        modifiers.addAll(rewrite.getAST().newModifiers(this.evaluateModifiers()));
    }

    protected Type getNewMethodType(ASTRewrite rewrite) throws CoreException {
        return this.getImportRewrite().addImport(this.fMethod.getReturnType(), rewrite.getAST());
    }

    protected void addNewExceptions(ASTRewrite rewrite, List exceptions) throws CoreException {
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] bindings = this.fMethod.getExceptionTypes();
        int i = 0;
        while (i < bindings.length) {
            String typeName = importRewrite.addImport(bindings[i]);
            Name newNode = ASTNodeFactory.newName(ast, typeName);
            exceptions.add(newNode);
            this.addLinkedPosition(rewrite.track((ASTNode)newNode), false, "exc_type_" + i);
            ++i;
        }
    }

    protected void addNewTypeParameters(ASTRewrite rewrite, List takenNames, List params) throws CoreException {
    }
}

