/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;

public class RemoveModuleAction
extends Action {
    protected IServer server;
    protected IModule module;
    protected Shell shell;

    public RemoveModuleAction(Shell shell, IServer server, IModule module) {
        super(Messages.actionRemove);
        this.shell = shell;
        this.server = server;
        this.module = module;
    }

    public void run() {
        if (MessageDialog.openConfirm((Shell)this.shell, (String)Messages.defaultDialogTitle, (String)Messages.dialogRemoveModuleConfirm)) {
            try {
                IServerWorkingCopy wc = this.server.createWorkingCopy();
                wc.modifyModules(null, new IModule[]{this.module}, null);
                this.server = wc.save(true, null);
                if (this.server.getServerState() != 4 && ServerUIPlugin.getPreferences().getPublishOnAddRemoveModule()) {
                    IAdaptable info = new IAdaptable(){

                        public Object getAdapter(Class adapter) {
                            if (Shell.class.equals((Object)adapter)) {
                                return RemoveModuleAction.this.shell;
                            }
                            return null;
                        }
                    };
                    this.server.publish(1, null, info, null);
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not remove module", e);
            }
        }
    }
}

