/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.commentelement.impl.CommentElementConfiguration;
import org.eclipse.wst.xml.core.internal.commentelement.impl.CommentElementRegistry;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.CDATASectionImpl;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.EntityReferenceImpl;
import org.eclipse.wst.xml.core.internal.document.ModelParserAdapter;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.ProcessingInstructionImpl;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionManagementException;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLModelParser {
    private XMLModelContext context = null;
    private DOMModelImpl model = null;
    static /* synthetic */ Class class$0;

    protected XMLModelParser(DOMModelImpl model) {
        if (model != null) {
            this.model = model;
        }
    }

    protected boolean canBeImplicitTag(Element element) {
        ModelParserAdapter adapter = this.getParserAdapter();
        if (adapter != null) {
            return adapter.canBeImplicitTag(element);
        }
        return false;
    }

    protected boolean canBeImplicitTag(Element element, Node child) {
        ModelParserAdapter adapter = this.getParserAdapter();
        if (adapter != null) {
            return adapter.canBeImplicitTag(element, child);
        }
        return false;
    }

    protected boolean canContain(Element element, Node child) {
        if (element == null || child == null) {
            return false;
        }
        ElementImpl impl = (ElementImpl)element;
        if (impl.isEndTag()) {
            return false;
        }
        if (!impl.isContainer()) {
            return false;
        }
        if (child.getNodeType() != 3 && (impl.isJSPContainer() || impl.isCDATAContainer())) {
            return false;
        }
        ModelParserAdapter adapter = this.getParserAdapter();
        if (adapter != null) {
            return adapter.canContain(element, child);
        }
        return true;
    }

    private void changeAttrEqual(IStructuredDocumentRegion flatNode, ITextRegion region) {
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        NodeImpl root = (NodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        Node node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            if (node.getNodeType() == 7) {
                ProcessingInstructionImpl pi = (ProcessingInstructionImpl)node;
                pi.notifyValueChanged();
            }
            return;
        }
    }

    private void changeAttrName(IStructuredDocumentRegion flatNode, ITextRegion region) {
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        NodeImpl root = (NodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        Node node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            if (node.getNodeType() == 7) {
                ProcessingInstructionImpl pi = (ProcessingInstructionImpl)node;
                pi.notifyValueChanged();
            }
            return;
        }
        ElementImpl element = (ElementImpl)node;
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return;
        }
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            AttrImpl attr = (AttrImpl)attributes.item(i);
            if (attr != null && attr.getNameRegion() == region) {
                String name = flatNode.getText(region);
                attr.setName(name);
                break;
            }
            ++i;
        }
    }

    private void changeAttrValue(IStructuredDocumentRegion flatNode, ITextRegion region) {
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        NodeImpl root = (NodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        Node node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            if (node.getNodeType() == 7) {
                ProcessingInstructionImpl pi = (ProcessingInstructionImpl)node;
                pi.notifyValueChanged();
            }
            return;
        }
        ElementImpl element = (ElementImpl)node;
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return;
        }
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            AttrImpl attr = (AttrImpl)attributes.item(i);
            if (attr != null && attr.getValueRegion() == region) {
                attr.notifyValueChanged();
                break;
            }
            ++i;
        }
    }

    private void changeData(IStructuredDocumentRegion flatNode, ITextRegion region) {
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        NodeImpl root = (NodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        Node node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 3: {
                TextImpl text = (TextImpl)node;
                if (text.isSharingStructuredDocumentRegion(flatNode)) {
                    this.changeStructuredDocumentRegion(flatNode);
                    return;
                }
                this.context.setNextNode(node);
                this.cleanupText();
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 1: 
            case 8: {
                this.changeStructuredDocumentRegion(flatNode);
                return;
            }
            default: {
                return;
            }
        }
        NodeImpl impl = (NodeImpl)node;
        impl.notifyValueChanged();
    }

    private void changeEndTag(IStructuredDocumentRegion flatNode, ITextRegionList newRegions, ITextRegionList oldRegions) {
        String regionType;
        ITextRegion region;
        Iterator e;
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        NodeImpl root = (NodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        Node node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            this.changeStructuredDocumentRegion(flatNode);
            return;
        }
        if (newRegions != null) {
            e = newRegions.iterator();
            while (e.hasNext()) {
                region = (ITextRegion)e.next();
                regionType = region.getType();
                if (regionType == "XML_TAG_CLOSE") continue;
                this.changeStructuredDocumentRegion(flatNode);
                return;
            }
        }
        if (oldRegions != null) {
            e = oldRegions.iterator();
            while (e.hasNext()) {
                region = (ITextRegion)e.next();
                regionType = region.getType();
                if (regionType == "XML_TAG_CLOSE") continue;
                this.changeStructuredDocumentRegion(flatNode);
                return;
            }
        }
    }

    void changeRegion(IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (flatNode == null || region == null) {
            return;
        }
        if (this.model.getDocument() == null) {
            return;
        }
        this.context = new XMLModelContext(this.model.getDocument());
        String regionType = region.getType();
        if (regionType == "XML_CONTENT" || regionType == "XML_COMMENT_TEXT" || regionType == "XML_CDATA_TEXT" || regionType == "BLOCK_TEXT" || this.isNestedContent(regionType)) {
            this.changeData(flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
            this.changeAttrName(flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
            this.changeAttrValue(flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_EQUALS") {
            this.changeAttrEqual(flatNode, region);
        } else if (regionType == "XML_TAG_NAME" || this.isNestedTagName(regionType)) {
            this.changeTagName(flatNode, region);
        } else {
            this.changeStructuredDocumentRegion(flatNode);
        }
    }

    private void changeStartTag(IStructuredDocumentRegion flatNode, ITextRegionList newRegions, ITextRegionList oldRegions) {
        ITextRegion region;
        ITextRegionList regions;
        String regionType;
        ITextRegion region2;
        Iterator e;
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        NodeImpl root = (NodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        Node node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            this.changeStructuredDocumentRegion(flatNode);
            return;
        }
        ElementImpl element = (ElementImpl)node;
        boolean tagNameUnchanged = false;
        if (newRegions != null) {
            e = newRegions.iterator();
            while (e.hasNext()) {
                region2 = (ITextRegion)e.next();
                regionType = region2.getType();
                if (regionType == "XML_TAG_ATTRIBUTE_NAME" || regionType == "XML_TAG_ATTRIBUTE_EQUALS" || regionType == "XML_TAG_ATTRIBUTE_VALUE") continue;
                if (regionType == "XML_TAG_CLOSE") {
                    if (!element.isEmptyTag()) {
                        continue;
                    }
                } else if (regionType == "XML_TAG_NAME" || this.isNestedTagName(regionType)) {
                    String oldTagName = element.getTagName();
                    String newTagName = flatNode.getText(region2);
                    if (oldTagName != null && newTagName != null && oldTagName.equals(newTagName)) {
                        tagNameUnchanged = true;
                        continue;
                    }
                }
                this.changeStructuredDocumentRegion(flatNode);
                return;
            }
        }
        if (oldRegions != null) {
            e = oldRegions.iterator();
            while (e.hasNext()) {
                region2 = (ITextRegion)e.next();
                regionType = region2.getType();
                if (regionType == "XML_TAG_ATTRIBUTE_NAME" || regionType == "XML_TAG_ATTRIBUTE_EQUALS" || regionType == "XML_TAG_ATTRIBUTE_VALUE" || (regionType == "XML_TAG_CLOSE" ? !element.isEmptyTag() : (regionType == "XML_TAG_NAME" || this.isNestedTagName(regionType)) && tagNameUnchanged)) continue;
                this.changeStructuredDocumentRegion(flatNode);
                return;
            }
        }
        if ((regions = flatNode.getRegions()) == null) {
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return;
        }
        int regionIndex = 0;
        int attrIndex = 0;
        AttrImpl attr = null;
        while (attrIndex < attributes.getLength()) {
            attr = (AttrImpl)attributes.item(attrIndex);
            if (attr == null) {
                ++attrIndex;
                continue;
            }
            ITextRegion nameRegion = attr.getNameRegion();
            if (nameRegion == null) {
                element.removeAttributeNode(attr);
                continue;
            }
            boolean found = false;
            int i = regionIndex;
            while (i < regions.size()) {
                region = regions.get(i);
                if (region == nameRegion) {
                    regionIndex = i + 1;
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                ++attrIndex;
                continue;
            }
            element.removeAttributeNode(attr);
        }
        attrIndex = 0;
        AttrImpl newAttr = null;
        ITextRegion oldValueRegion = null;
        Iterator e2 = regions.iterator();
        while (e2.hasNext()) {
            region = (ITextRegion)e2.next();
            String regionType2 = region.getType();
            if (regionType2 == "XML_TAG_ATTRIBUTE_NAME") {
                if (newAttr != null) {
                    element.insertAttributeNode(newAttr, attrIndex++);
                    newAttr = null;
                } else if (attr != null && oldValueRegion != null) {
                    attr.notifyValueChanged();
                }
                oldValueRegion = null;
                attr = (AttrImpl)attributes.item(attrIndex);
                if (attr != null && attr.getNameRegion() == region) {
                    ++attrIndex;
                    oldValueRegion = attr.getValueRegion();
                    attr.setEqualRegion(null);
                    attr.setValueRegion(null);
                    continue;
                }
                String name = flatNode.getText(region);
                attr = (AttrImpl)this.model.getDocument().createAttribute(name);
                if (attr != null) {
                    attr.setNameRegion(region);
                }
                newAttr = attr;
                continue;
            }
            if (regionType2 == "XML_TAG_ATTRIBUTE_EQUALS") {
                if (attr == null) continue;
                attr.setEqualRegion(region);
                continue;
            }
            if (regionType2 != "XML_TAG_ATTRIBUTE_VALUE" || attr == null) continue;
            attr.setValueRegion(region);
            if (attr != newAttr && oldValueRegion != region) {
                attr.notifyValueChanged();
            }
            oldValueRegion = null;
            attr = null;
        }
        if (newAttr != null) {
            element.appendAttributeNode(newAttr);
        } else if (attr != null && oldValueRegion != null) {
            attr.notifyValueChanged();
        }
    }

    private void changeStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return;
        }
        if (this.model.getDocument() == null) {
            return;
        }
        this.setupContext(flatNode);
        this.removeStructuredDocumentRegion(flatNode);
        this.context.setLast();
        this.insertStructuredDocumentRegion(flatNode);
        this.cleanupText();
        this.cleanupEndTag();
    }

    private void changeTagName(IStructuredDocumentRegion flatNode, ITextRegion region) {
        String tagName;
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        NodeImpl root = (NodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        Node node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            this.changeStructuredDocumentRegion(flatNode);
            return;
        }
        ElementImpl element = (ElementImpl)node;
        String newTagName = flatNode.getText(region);
        if (newTagName == null || !element.matchTagName(newTagName)) {
            this.changeStructuredDocumentRegion(flatNode);
            return;
        }
        if (!(element.hasStartTag() && StructuredDocumentRegionUtil.getFirstRegionType(flatNode) == "XML_END_TAG_OPEN" || (tagName = element.getTagName()) != null && tagName.equals(newTagName))) {
            element.setTagName(newTagName);
            element.notifyValueChanged();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void cleanupEndTag() {
        parent = this.context.getParentNode();
        next = this.context.getNextNode();
        ** GOTO lbl32
        {
            if (next.getNodeType() == 1 && (element = (ElementImpl)next).isEndTag() && (start = (ElementImpl)this.context.findStartTag(tagName = element.getTagName(), rootName = this.getFindRootName(tagName))) != null) {
                this.insertEndTag(start);
                start.addEndTag(element);
                this.removeNode(element);
                parent = this.context.getParentNode();
                next = this.context.getNextNode();
            } else {
                first = next.getFirstChild();
                if (first != null) {
                    parent = next;
                    next = first;
                    this.context.setNextNode(next);
                } else {
                    next = next.getNextSibling();
                    this.context.setNextNode(next);
                }
            }
            do {
                if (next != null) continue block0;
                if (parent.getNodeType() == 1 && !(element = (ElementImpl)parent).hasEndTag() && element.hasStartTag() && element.getNextSibling() == null && (end = (ElementImpl)this.context.findEndTag(tagName = element.getTagName())) != null) {
                    element.addEndTag(end);
                    this.removeEndTag(end);
                    this.context.setParentNode(parent);
                    continue;
                }
                next = parent.getNextSibling();
                parent = parent.getParentNode();
                if (next != null) {
                    this.context.setNextNode(next);
                    continue;
                }
                this.context.setParentNode(parent);
lbl32:
                // 4 sources

            } while (parent != null);
        }
    }

    private void cleanupText() {
        Node newParent;
        ElementImpl parentElement;
        TextImpl childText;
        Node parent = this.context.getParentNode();
        if (parent == null) {
            return;
        }
        Node next = this.context.getNextNode();
        Node prev = next == null ? parent.getLastChild() : next.getPreviousSibling();
        TextImpl nextText = null;
        TextImpl prevText = null;
        if (next != null && next.getNodeType() == 3) {
            nextText = (TextImpl)next;
        }
        if (prev != null && prev.getNodeType() == 3) {
            prevText = (TextImpl)prev;
        }
        if (nextText == null && prevText == null) {
            return;
        }
        if (nextText != null && prevText != null) {
            IStructuredDocumentRegion flatNode = nextText.getStructuredDocumentRegion();
            if (flatNode != null) {
                prevText.appendStructuredDocumentRegion(flatNode);
            }
            Node newNext = next.getNextSibling();
            parent.removeChild(next);
            next = null;
            this.context.setNextNode(newNext);
        }
        TextImpl textImpl = childText = prevText != null ? prevText : nextText;
        if (childText.getNextSibling() == null && childText.getPreviousSibling() == null && parent.getNodeType() == 1 && !(parentElement = (ElementImpl)parent).hasStartTag() && !parentElement.hasEndTag() && (childText.isWhitespace() || childText.isInvalid()) && (newParent = parent.getParentNode()) != null) {
            Node newNext = parent.getNextSibling();
            newParent.removeChild(parent);
            parent.removeChild(childText);
            newParent.insertBefore(childText, newNext);
            if (childText == next) {
                this.context.setNextNode(childText);
            } else if (newNext != null) {
                this.context.setNextNode(newNext);
            } else {
                this.context.setParentNode(newParent);
            }
            this.cleanupText();
        }
    }

    protected Element createCommentElement(String data, boolean isJSPTag) {
        String trimmedData = data.trim();
        CommentElementConfiguration[] configs = CommentElementRegistry.getInstance().getConfigurations();
        int iConfig = 0;
        while (iConfig < configs.length) {
            CommentElementConfiguration config = configs[iConfig];
            if ((!isJSPTag || config.acceptJSPComment()) && (isJSPTag || config.acceptXMLComment())) {
                String[] prefixes = config.getPrefix();
                int iPrefix = 0;
                while (iPrefix < prefixes.length) {
                    if (trimmedData.startsWith(prefixes[iPrefix])) {
                        return config.createElement(this.model.getDocument(), data, isJSPTag);
                    }
                    ++iPrefix;
                }
            }
            ++iConfig;
        }
        ModelParserAdapter adapter = this.getParserAdapter();
        if (adapter != null) {
            return adapter.createCommentElement(this.model.getDocument(), data, isJSPTag);
        }
        return null;
    }

    protected Element createImplicitElement(Node parent, Node child) {
        ModelParserAdapter adapter = this.getParserAdapter();
        if (adapter != null) {
            return adapter.createImplicitElement(this.model.getDocument(), parent, child);
        }
        return null;
    }

    private void demoteNodes(Node root, Node newParent, Node oldParent, Node next) {
        if (newParent.getNodeType() != 1) {
            return;
        }
        ElementImpl newElement = (ElementImpl)newParent;
        while (next == null) {
            if (oldParent.getNodeType() != 1) {
                return;
            }
            ElementImpl oldElement = (ElementImpl)oldParent;
            if (oldElement.hasEndTag()) {
                return;
            }
            oldParent = oldElement.getParentNode();
            if (oldParent == null) {
                return;
            }
            next = oldElement.getNextSibling();
        }
        block1: while (next != null) {
            ElementImpl nextElement;
            boolean done = false;
            if (next.getNodeType() == 1 && !(nextElement = (ElementImpl)next).hasStartTag()) {
                Node nextChild = nextElement.getFirstChild();
                if (nextChild != null) {
                    next = nextChild;
                    oldParent = nextElement;
                    continue;
                }
                if (nextElement.hasEndTag()) {
                    if (nextElement.matchEndTag(newElement)) {
                        next = nextElement.getNextSibling();
                        oldParent.removeChild(nextElement);
                        newElement.addEndTag(nextElement);
                        if (newElement == root) {
                            return;
                        }
                        Node p = newElement.getParentNode();
                        if (p == null || p == oldParent || p.getNodeType() != 1) {
                            return;
                        }
                        newElement = (ElementImpl)p;
                        done = true;
                    }
                } else {
                    next = nextElement.getNextSibling();
                    oldParent.removeChild(nextElement);
                    done = true;
                }
            }
            if (!done) {
                if (!this.canContain(newElement, next)) {
                    if (newElement == root) {
                        return;
                    }
                    Node p = newElement.getParentNode();
                    if (p == null || p == oldParent || p.getNodeType() != 1) {
                        return;
                    }
                    newElement = (ElementImpl)p;
                    continue;
                }
                Node child = next;
                next = next.getNextSibling();
                oldParent.removeChild(child);
                this.insertNode(newElement, child, null);
                Node childParent = child.getParentNode();
                if (childParent != newElement) {
                    newElement = (ElementImpl)childParent;
                }
            }
            while (next == null) {
                if (oldParent.getNodeType() != 1) {
                    return;
                }
                ElementImpl oldElement = (ElementImpl)oldParent;
                if (!oldElement.hasChildNodes() && !oldElement.hasStartTag()) {
                    oldParent = oldElement.getParentNode();
                    if (oldParent == null) {
                        return;
                    }
                    next = oldElement;
                    continue block1;
                }
                if (oldElement.hasEndTag()) {
                    return;
                }
                oldParent = oldElement.getParentNode();
                if (oldParent == null) {
                    return;
                }
                next = oldElement.getNextSibling();
            }
        }
    }

    private ModelParserAdapter getParserAdapter() {
        IDOMDocument iDOMDocument = this.model.getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.ModelParserAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ModelParserAdapter)iDOMDocument.getAdapterFor(clazz);
    }

    protected String getFindRootName(String tagName) {
        ModelParserAdapter adapter = this.getParserAdapter();
        if (adapter != null) {
            return adapter.getFindRootName(tagName);
        }
        return null;
    }

    protected final IDOMModel getModel() {
        return this.model;
    }

    private void insertCDATASection(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        CDATASectionImpl cdata = null;
        try {
            cdata = (CDATASectionImpl)this.model.getDocument().createCDATASection(null);
        }
        catch (DOMException dOMException) {}
        if (cdata == null) {
            this.insertInvalidDecl(flatNode);
            return;
        }
        cdata.setStructuredDocumentRegion(flatNode);
        this.insertNode(cdata);
    }

    private void insertComment(IStructuredDocumentRegion flatNode) {
        ElementImpl element;
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        String data = null;
        boolean isJSPTag = false;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (this.isNestedCommentOpen(regionType)) {
                isJSPTag = true;
                continue;
            }
            if (regionType != "XML_COMMENT_TEXT" && !this.isNestedCommentText(regionType) || data != null) continue;
            data = flatNode.getText(region);
        }
        if (data != null && (element = (ElementImpl)this.createCommentElement(data, isJSPTag)) != null) {
            if (!this.isEndTag(element)) {
                element.setStartStructuredDocumentRegion(flatNode);
                this.insertStartTag(element);
                return;
            }
            element.setEndStructuredDocumentRegion(flatNode);
            String tagName = element.getTagName();
            String rootName = this.getFindRootName(tagName);
            ElementImpl start = (ElementImpl)this.context.findStartTag(tagName, rootName);
            if (start != null) {
                this.insertEndTag(start);
                start.addEndTag(element);
                return;
            }
            this.insertNode(element);
            return;
        }
        CommentImpl comment = (CommentImpl)this.model.getDocument().createComment(null);
        if (comment == null) {
            return;
        }
        if (isJSPTag) {
            comment.setJSPTag(true);
        }
        comment.setStructuredDocumentRegion(flatNode);
        this.insertNode(comment);
    }

    private void insertDecl(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        boolean isDocType = false;
        String name = null;
        String publicId = null;
        String systemId = null;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (regionType == "XML_DOCTYPE_DECLARATION") {
                isDocType = true;
                continue;
            }
            if (regionType == "XML_DOCTYPE_NAME") {
                if (name != null) continue;
                name = flatNode.getText(region);
                continue;
            }
            if (regionType == "XML_DOCTYPE_EXTERNAL_ID_PUBREF") {
                if (publicId != null) continue;
                publicId = StructuredDocumentRegionUtil.getAttrValue(flatNode, region);
                continue;
            }
            if (regionType != "XML_DOCTYPE_EXTERNAL_ID_SYSREF" || systemId != null) continue;
            systemId = StructuredDocumentRegionUtil.getAttrValue(flatNode, region);
        }
        if (!isDocType) {
            this.insertInvalidDecl(flatNode);
            return;
        }
        DocumentTypeImpl docType = (DocumentTypeImpl)this.model.getDocument().createDoctype(name);
        if (docType == null) {
            return;
        }
        if (publicId != null) {
            docType.setPublicId(publicId);
        }
        if (systemId != null) {
            docType.setSystemId(systemId);
        }
        docType.setStructuredDocumentRegion(flatNode);
        this.insertNode(docType);
    }

    protected void insertEndTag(Element element) {
        if (element == null) {
            return;
        }
        Node newParent = element.getParentNode();
        if (newParent == null) {
            return;
        }
        if (!((ElementImpl)element).isContainer()) {
            Node elementNext = element.getNextSibling();
            if (elementNext != null) {
                this.context.setNextNode(elementNext);
            } else {
                this.context.setParentNode(newParent);
            }
            return;
        }
        Node newNext = element.getNextSibling();
        Node oldParent = this.context.getParentNode();
        if (oldParent == null) {
            return;
        }
        Node oldNext = this.context.getNextNode();
        this.promoteNodes(element, newParent, newNext, oldParent, oldNext);
        newNext = element.getNextSibling();
        if (newNext != null) {
            this.context.setNextNode(newNext);
        } else {
            this.context.setParentNode(newParent);
        }
    }

    private void insertEndTag(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        String tagName = null;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (regionType != "XML_TAG_NAME" && !this.isNestedTagName(regionType) || tagName != null) continue;
            tagName = flatNode.getText(region);
        }
        if (tagName == null) {
            this.insertText(flatNode);
            return;
        }
        String rootName = this.getFindRootName(tagName);
        ElementImpl start = (ElementImpl)this.context.findStartTag(tagName, rootName);
        if (start != null) {
            this.insertEndTag(start);
            start.setEndStructuredDocumentRegion(flatNode);
            return;
        }
        ElementImpl end = null;
        try {
            end = (ElementImpl)this.model.getDocument().createElement(tagName);
        }
        catch (DOMException dOMException) {}
        if (end == null) {
            this.insertText(flatNode);
            return;
        }
        end.setEndStructuredDocumentRegion(flatNode);
        this.insertNode(end);
    }

    private void insertEntityRef(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        String name = null;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (regionType != "XML_ENTITY_REFERENCE" && regionType != "XML_CHAR_REFERENCE" || name != null) continue;
            name = StructuredDocumentRegionUtil.getEntityRefName(flatNode, region);
        }
        if (name == null) {
            this.insertText(flatNode);
            return;
        }
        String value = ((DocumentImpl)this.model.getDocument()).getCharValue(name);
        if (value != null) {
            TextImpl text = (TextImpl)this.context.findPreviousText();
            if (text != null) {
                text.appendStructuredDocumentRegion(flatNode);
                text.notifyValueChanged();
                return;
            }
            text = (TextImpl)this.model.getDocument().createTextNode(null);
            if (text == null) {
                return;
            }
            text.setStructuredDocumentRegion(flatNode);
            this.insertNode(text);
            return;
        }
        EntityReferenceImpl ref = null;
        try {
            ref = (EntityReferenceImpl)this.model.getDocument().createEntityReference(name);
        }
        catch (DOMException dOMException) {}
        if (ref == null) {
            this.insertText(flatNode);
            return;
        }
        ref.setStructuredDocumentRegion(flatNode);
        this.insertNode(ref);
    }

    private void insertInvalidDecl(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        ElementImpl element = null;
        try {
            element = (ElementImpl)this.model.getDocument().createElement("!");
        }
        catch (DOMException dOMException) {}
        if (element == null) {
            this.insertText(flatNode);
            return;
        }
        element.setEmptyTag(true);
        element.setStartStructuredDocumentRegion(flatNode);
        this.insertNode(element);
    }

    private void insertNestedTag(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        String tagName = null;
        AttrImpl attr = null;
        Vector<AttrImpl> attrNodes = null;
        boolean isCloseTag = false;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (this.isNestedTagOpen(regionType) || this.isNestedTagName(regionType)) {
                tagName = this.computeNestedTag(regionType, tagName, flatNode, region);
                continue;
            }
            if (this.isNestedTagClose(regionType)) {
                isCloseTag = true;
                continue;
            }
            if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
                String name = flatNode.getText(region);
                attr = (AttrImpl)this.model.getDocument().createAttribute(name);
                if (attr == null) continue;
                attr.setNameRegion(region);
                if (attrNodes == null) {
                    attrNodes = new Vector<AttrImpl>();
                }
                attrNodes.addElement(attr);
                continue;
            }
            if (regionType == "XML_TAG_ATTRIBUTE_EQUALS") {
                if (attr == null) continue;
                attr.setEqualRegion(region);
                continue;
            }
            if (regionType != "XML_TAG_ATTRIBUTE_VALUE" || attr == null) continue;
            attr.setValueRegion(region);
            attr = null;
        }
        if (tagName == null) {
            ElementImpl start;
            Node parent;
            if (isCloseTag && (parent = this.context.getParentNode()) != null && parent.getNodeType() == 1 && (start = (ElementImpl)parent).isJSPContainer()) {
                this.insertEndTag(start);
                start.setEndStructuredDocumentRegion(flatNode);
                return;
            }
            this.insertText(flatNode);
            return;
        }
        ElementImpl element = null;
        try {
            element = (ElementImpl)this.model.getDocument().createElement(tagName);
        }
        catch (DOMException dOMException) {}
        if (element == null) {
            this.insertText(flatNode);
            return;
        }
        if (attrNodes != null) {
            Enumeration ae = attrNodes.elements();
            while (ae.hasMoreElements()) {
                Attr a = (Attr)ae.nextElement();
                if (a == null) continue;
                element.appendAttributeNode(a);
            }
        }
        element.setJSPTag(true);
        element.setStartStructuredDocumentRegion(flatNode);
        this.insertStartTag(element);
    }

    protected boolean isNestedTagClose(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedTagOpen(String regionType) {
        boolean result = false;
        return result;
    }

    protected String computeNestedTag(String regionType, String tagName, IStructuredDocumentRegion structuredDocumentRegion, ITextRegion region) {
        return tagName;
    }

    private void insertNode(Node node) {
        Node parent;
        if (node != null && this.context != null && (parent = this.context.getParentNode()) != null) {
            Node next = this.context.getNextNode();
            this.insertNode(parent, node, next);
            next = node.getNextSibling();
            if (next != null) {
                this.context.setNextNode(next);
            } else {
                this.context.setParentNode(node.getParentNode());
            }
        }
    }

    private void insertNode(Node parent, Node node, Node next) {
        Element implicitElement;
        while (next != null && next.getNodeType() == 1) {
            ElementImpl nextElement = (ElementImpl)next;
            if (nextElement.hasStartTag() || !this.canBeImplicitTag(nextElement, node)) break;
            parent = nextElement;
            next = nextElement.getFirstChild();
        }
        if ((implicitElement = this.createImplicitElement(parent, node)) != null) {
            node = implicitElement;
        }
        parent.insertBefore(node, next);
    }

    private void insertPI(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        String target = null;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (regionType == "XML_PI_OPEN" || regionType == "XML_PI_CLOSE" || target != null) continue;
            target = flatNode.getText(region);
        }
        ProcessingInstructionImpl pi = (ProcessingInstructionImpl)this.model.getDocument().createProcessingInstruction(target, null);
        if (pi == null) {
            return;
        }
        pi.setStructuredDocumentRegion(flatNode);
        this.insertNode(pi);
    }

    protected void insertStartTag(Element element) {
        if (element == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        this.insertNode(element);
        ElementImpl newElement = (ElementImpl)element;
        if (newElement.isEmptyTag() || !newElement.isContainer()) {
            return;
        }
        Node parent = this.context.getParentNode();
        if (parent == null) {
            return;
        }
        Node next = this.context.getNextNode();
        this.demoteNodes(element, element, parent, next);
        Node firstChild = element.getFirstChild();
        if (firstChild != null) {
            this.context.setNextNode(firstChild);
        } else {
            this.context.setParentNode(element);
        }
    }

    private void insertStartTag(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        String tagName = null;
        boolean isEmptyTag = false;
        AttrImpl attr = null;
        Vector<AttrImpl> attrNodes = null;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (regionType == "XML_TAG_NAME" || this.isNestedTagName(regionType)) {
                if (tagName != null) continue;
                tagName = flatNode.getText(region);
                continue;
            }
            if (regionType == "XML_EMPTY_TAG_CLOSE") {
                isEmptyTag = true;
                continue;
            }
            if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
                String name = flatNode.getText(region);
                attr = (AttrImpl)this.model.getDocument().createAttribute(name);
                if (attr == null) continue;
                attr.setNameRegion(region);
                if (attrNodes == null) {
                    attrNodes = new Vector<AttrImpl>();
                }
                attrNodes.addElement(attr);
                continue;
            }
            if (regionType == "XML_TAG_ATTRIBUTE_EQUALS") {
                if (attr == null) continue;
                attr.setEqualRegion(region);
                continue;
            }
            if (regionType != "XML_TAG_ATTRIBUTE_VALUE" || attr == null) continue;
            attr.setValueRegion(region);
            attr = null;
        }
        if (tagName == null) {
            this.insertText(flatNode);
            return;
        }
        ElementImpl element = null;
        try {
            element = (ElementImpl)this.model.getDocument().createElement(tagName);
        }
        catch (DOMException dOMException) {}
        if (element == null) {
            this.insertText(flatNode);
            return;
        }
        if (attrNodes != null) {
            Enumeration ae = attrNodes.elements();
            while (ae.hasMoreElements()) {
                Attr a = (Attr)ae.nextElement();
                if (a == null) continue;
                element.appendAttributeNode(a);
            }
        }
        if (isEmptyTag) {
            element.setEmptyTag(true);
        }
        element.setStartStructuredDocumentRegion(flatNode);
        this.insertStartTag(element);
    }

    protected void insertStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        String regionType = StructuredDocumentRegionUtil.getFirstRegionType(flatNode);
        if (regionType == "XML_TAG_OPEN") {
            this.insertStartTag(flatNode);
        } else if (regionType == "XML_END_TAG_OPEN") {
            this.insertEndTag(flatNode);
        } else if (regionType == "XML_COMMENT_OPEN" || this.isNestedCommentOpen(regionType)) {
            this.insertComment(flatNode);
        } else if (regionType == "XML_ENTITY_REFERENCE" || regionType == "XML_CHAR_REFERENCE") {
            this.insertEntityRef(flatNode);
        } else if (regionType == "XML_DECLARATION_OPEN") {
            this.insertDecl(flatNode);
        } else if (regionType == "XML_PI_OPEN") {
            this.insertPI(flatNode);
        } else if (regionType == "XML_CDATA_OPEN") {
            this.insertCDATASection(flatNode);
        } else if (this.isNestedTag(regionType)) {
            this.insertNestedTag(flatNode);
        } else {
            this.insertText(flatNode);
        }
    }

    protected boolean isNestedTag(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedCommentText(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedCommentOpen(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedTagName(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedContent(String regionType) {
        boolean result = false;
        return result;
    }

    protected void insertText(IStructuredDocumentRegion flatNode) {
        TextImpl text = (TextImpl)this.context.findPreviousText();
        if (text != null) {
            text.appendStructuredDocumentRegion(flatNode);
            text.notifyValueChanged();
            return;
        }
        text = (TextImpl)this.model.getDocument().createTextNode(null);
        if (text == null) {
            return;
        }
        text.setStructuredDocumentRegion(flatNode);
        this.insertNode(text);
    }

    protected boolean isEndTag(IDOMElement element) {
        ModelParserAdapter adapter = this.getParserAdapter();
        if (adapter != null) {
            return adapter.isEndTag(element);
        }
        return element.isEndTag();
    }

    /*
     * Unable to fully structure code
     */
    private void promoteNodes(Node root, Node newParent, Node newNext, Node oldParent, Node next) {
        newElement = null;
        if (newParent.getNodeType() == 1) {
            newElement = (ElementImpl)newParent;
        }
        rootParent = root.getParentNode();
        ** GOTO lbl65
        {
            done = false;
            endTag = false;
            if (next.getNodeType() != 1 || (nextElement = (ElementImpl)next).hasStartTag()) ** GOTO lbl22
            nextChild = nextElement.getFirstChild();
            if (nextChild != null) {
                next = nextChild;
                oldParent = nextElement;
            } else {
                if (nextElement.hasEndTag()) {
                    if (nextElement.matchEndTag(newElement)) {
                        endTag = true;
                    }
                } else {
                    next = nextElement.getNextSibling();
                    oldParent.removeChild(nextElement);
                    done = true;
                }
lbl22:
                // 3 sources

                if (!done) {
                    if (!endTag && newElement != null && !this.canContain(newElement, next)) {
                        newParent = newElement.getParentNode();
                        if (newParent == null) {
                            return;
                        }
                        elementNext = newElement.getNextSibling();
                        this.promoteNodes(newElement, newParent, elementNext, newElement, newNext);
                        newNext = newElement.getNextSibling();
                        newElement = newParent.getNodeType() == 1 ? (ElementImpl)newParent : null;
                    } else {
                        child = next;
                        next = next.getNextSibling();
                        oldParent.removeChild(child);
                        this.insertNode(newParent, child, newNext);
                        childParent = child.getParentNode();
                        if (childParent != newParent) {
                            newParent = childParent;
                            newElement = (ElementImpl)newParent;
                            newNext = child.getNextSibling();
                        }
                    }
                }
            }
            do {
                if (next != null) continue block0;
                if (oldParent.getNodeType() != 1) {
                    return;
                }
                oldElement = (ElementImpl)oldParent;
                if ((oldParent = oldElement.getParentNode()) == null) {
                    return;
                }
                next = oldElement.getNextSibling();
                if (!oldElement.hasEndTag()) continue;
                end = null;
                if (!oldElement.hasChildNodes() && !oldElement.hasStartTag()) {
                    oldParent.removeChild(oldElement);
                    end = oldElement;
                } else {
                    end = oldElement.removeEndTag();
                }
                if (end == null) continue;
                this.insertNode(newParent, end, newNext);
                endParent = end.getParentNode();
                if (endParent == newParent) continue;
                newParent = endParent;
                newElement = (ElementImpl)newParent;
                newNext = end.getNextSibling();
lbl65:
                // 5 sources

            } while (oldParent != rootParent);
        }
    }

    private void removeEndTag(Element element) {
        if (element == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        Node parent = element.getParentNode();
        if (parent == null) {
            return;
        }
        if (!((ElementImpl)element).isContainer()) {
            Node elementNext = element.getNextSibling();
            if (elementNext != null) {
                this.context.setNextNode(elementNext);
            } else {
                this.context.setParentNode(parent);
            }
            return;
        }
        Node next = element.getNextSibling();
        ElementImpl newElement = (ElementImpl)element;
        Node last = newElement.getLastChild();
        while (last != null) {
            ElementImpl lastElement;
            if (last.getNodeType() != 1 || (lastElement = (ElementImpl)last).hasEndTag() || lastElement.isEmptyTag() || !lastElement.isContainer()) break;
            newElement = lastElement;
            last = last.getLastChild();
        }
        Node lastChild = newElement.getLastChild();
        this.demoteNodes(element, newElement, parent, next);
        Node newNext = null;
        newNext = lastChild != null ? lastChild.getNextSibling() : newElement.getFirstChild();
        if (newNext != null) {
            this.context.setNextNode(newNext);
        } else {
            this.context.setParentNode(newElement);
        }
    }

    private Element removeImplicitElement(Node parent) {
        Node firstChild;
        if (parent == null) {
            return null;
        }
        if (parent.getNodeType() != 1) {
            return null;
        }
        ElementImpl element = (ElementImpl)parent;
        if (!element.isImplicitTag()) {
            return null;
        }
        if (this.canBeImplicitTag(element)) {
            return null;
        }
        Node elementParent = element.getParentNode();
        if (elementParent == null) {
            return null;
        }
        Node child = firstChild = element.getFirstChild();
        Node elementNext = element.getNextSibling();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            element.removeChild(child);
            elementParent.insertBefore(child, elementNext);
            child = nextChild;
        }
        if (this.context.getParentNode() == element) {
            Node oldNext = this.context.getNextNode();
            if (oldNext != null) {
                this.context.setNextNode(oldNext);
            } else if (elementNext != null) {
                this.context.setNextNode(elementNext);
            } else {
                this.context.setParentNode(elementParent);
            }
        } else if (this.context.getNextNode() == element) {
            if (firstChild != null) {
                this.context.setNextNode(firstChild);
            } else if (elementNext != null) {
                this.context.setNextNode(elementNext);
            } else {
                this.context.setParentNode(elementParent);
            }
        }
        this.removeNode(element);
        return element;
    }

    private void removeNode(Node node) {
        ElementImpl newElement;
        if (node == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Node next = node.getNextSibling();
        Node prev = node.getPreviousSibling();
        Node oldParent = this.context.getParentNode();
        if (node == oldParent) {
            if (next != null) {
                this.context.setNextNode(next);
            } else {
                this.context.setParentNode(parent);
            }
        } else {
            Node oldNext = this.context.getNextNode();
            if (node == oldNext) {
                this.context.setNextNode(next);
            }
        }
        parent.removeChild(node);
        if (this.removeImplicitElement(parent) != null) {
            return;
        }
        if (prev != null && prev.getNodeType() == 1 && !(newElement = (ElementImpl)prev).hasEndTag() && !newElement.isEmptyTag() && newElement.isContainer()) {
            Node last = newElement.getLastChild();
            while (last != null) {
                ElementImpl lastElement;
                if (last.getNodeType() != 1 || (lastElement = (ElementImpl)last).hasEndTag() || lastElement.isEmptyTag() || !lastElement.isContainer()) break;
                newElement = lastElement;
                last = last.getLastChild();
            }
            Node lastChild = newElement.getLastChild();
            this.demoteNodes(prev, newElement, parent, next);
            Node newNext = null;
            newNext = lastChild != null ? lastChild.getNextSibling() : newElement.getFirstChild();
            if (newNext != null) {
                this.context.setNextNode(newNext);
            } else {
                this.context.setParentNode(newElement);
            }
        }
    }

    private void removeStartTag(Element element) {
        Node newParent;
        Node elementParent;
        Node parent;
        if (element == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        ElementImpl oldElement = (ElementImpl)element;
        if (this.canBeImplicitTag(oldElement)) {
            ElementImpl prevElement;
            ElementImpl newParent2 = null;
            Node prev = oldElement.getPreviousSibling();
            if (prev != null && prev.getNodeType() == 1 && !(prevElement = (ElementImpl)prev).hasEndTag() && (prevElement.hasStartTag() || prevElement.matchTagName(oldElement.getTagName()))) {
                newParent2 = prevElement;
            }
            if (newParent2 == null) {
                oldElement.removeStartTag();
                Node child = oldElement.getFirstChild();
                if (child != null) {
                    this.context.setNextNode(child);
                } else if (oldElement.hasEndTag()) {
                    this.context.setParentNode(oldElement);
                }
                return;
            }
        }
        if (oldElement.isCommentTag()) {
            oldElement.removeStartTag();
        }
        if ((parent = (elementParent = element.getParentNode())) == null) {
            return;
        }
        Node first = element.getFirstChild();
        ElementImpl firstElement = null;
        if (first != null) {
            Node child;
            Node nextChild;
            ElementImpl newElement = null;
            Node last = element.getPreviousSibling();
            while (last != null) {
                ElementImpl lastElement;
                if (last.getNodeType() != 1 || (lastElement = (ElementImpl)last).hasEndTag() || lastElement.isEmptyTag() || !lastElement.isContainer()) break;
                newElement = lastElement;
                last = last.getLastChild();
            }
            Node next = first;
            if (newElement != null) {
                while (next != null) {
                    ElementImpl nextElement;
                    if (!newElement.hasEndTag() && newElement.hasStartTag() && next.getNodeType() == 1 && !(nextElement = (ElementImpl)next).hasStartTag() && nextElement.hasEndTag() && nextElement.matchEndTag(newElement)) {
                        Node elementChild = nextElement.getFirstChild();
                        while (elementChild != null) {
                            nextChild = elementChild.getNextSibling();
                            nextElement.removeChild(elementChild);
                            newElement.appendChild(elementChild);
                            elementChild = nextChild;
                        }
                        next = nextElement.getNextSibling();
                        element.removeChild(nextElement);
                        newElement.addEndTag(nextElement);
                        if (nextElement == first) {
                            firstElement = newElement;
                        }
                        if ((newParent = newElement.getParentNode()) == parent || newParent == null || newParent.getNodeType() != 1) break;
                        newElement = (ElementImpl)newParent;
                        continue;
                    }
                    if (!this.canContain(newElement, next)) {
                        Node newParent3 = newElement.getParentNode();
                        if (newParent3 == parent || newParent3 == null || newParent3.getNodeType() != 1) break;
                        newElement = (ElementImpl)newParent3;
                        continue;
                    }
                    child = next;
                    next = next.getNextSibling();
                    element.removeChild(child);
                    newElement.appendChild(child);
                }
                newElement = null;
            }
            if (parent.getNodeType() == 1) {
                newElement = (ElementImpl)parent;
            }
            while (next != null) {
                Element end;
                if (newElement == null || this.canContain(newElement, next)) {
                    child = next;
                    next = next.getNextSibling();
                    element.removeChild(child);
                    parent.insertBefore(child, element);
                    continue;
                }
                parent = newElement.getParentNode();
                if (parent == null) {
                    return;
                }
                Node newNext = newElement.getNextSibling();
                Node child2 = element;
                while (child2 != null) {
                    nextChild = child2.getNextSibling();
                    newElement.removeChild(child2);
                    parent.insertBefore(child2, newNext);
                    child2 = nextChild;
                }
                if (newElement.hasEndTag() && (end = newElement.removeEndTag()) != null) {
                    parent.insertBefore(end, newNext);
                }
                if (!newElement.hasStartTag() && !newElement.hasChildNodes()) {
                    parent.removeChild(newElement);
                }
                newElement = parent.getNodeType() == 1 ? (ElementImpl)parent : null;
            }
        }
        Node newNext = element;
        ElementImpl startElement = null;
        if (oldElement.hasEndTag()) {
            Element end;
            ElementImpl newElement = null;
            Node last = element.getPreviousSibling();
            while (last != null) {
                ElementImpl lastElement;
                if (last.getNodeType() != 1 || (lastElement = (ElementImpl)last).hasEndTag() || lastElement.isEmptyTag() || !lastElement.isContainer()) break;
                newElement = lastElement;
                last = last.getLastChild();
            }
            if (newElement != null) {
                Node next = element;
                while (next != null) {
                    Element end2;
                    ElementImpl nextElement;
                    if (!newElement.hasEndTag() && newElement.hasStartTag() && next.getNodeType() == 1 && !(nextElement = (ElementImpl)next).hasStartTag() && nextElement.hasEndTag() && nextElement.matchEndTag(newElement)) {
                        Node newParent4;
                        Node elementChild = nextElement.getFirstChild();
                        while (elementChild != null) {
                            Node nextChild = elementChild.getNextSibling();
                            nextElement.removeChild(elementChild);
                            newElement.appendChild(elementChild);
                            elementChild = nextChild;
                        }
                        next = nextElement.getNextSibling();
                        parent.removeChild(nextElement);
                        newElement.addEndTag(nextElement);
                        if (nextElement == newNext) {
                            startElement = newElement;
                        }
                        if ((newParent4 = newElement.getParentNode()) != parent && newParent4 != null && newParent4.getNodeType() == 1) {
                            newElement = (ElementImpl)newParent4;
                            continue;
                        }
                        break;
                    }
                    if (!this.canContain(newElement, next)) {
                        newParent = newElement.getParentNode();
                        if (newParent != parent && newParent != null && newParent.getNodeType() == 1) {
                            newElement = (ElementImpl)newParent;
                            continue;
                        }
                        break;
                    }
                    Element child = next;
                    next = next.getNextSibling();
                    parent.removeChild(child);
                    if (child == oldElement && !oldElement.isCommentTag() && (end2 = oldElement.removeEndTag()) != null) {
                        child = end2;
                        newNext = end2;
                    }
                    newElement.appendChild(child);
                }
            } else if (!oldElement.isCommentTag() && (end = oldElement.removeEndTag()) != null) {
                parent.insertBefore(end, oldElement);
                parent.removeChild(oldElement);
                newNext = end;
            }
        } else {
            newNext = oldElement.getNextSibling();
            parent.removeChild(oldElement);
        }
        Node oldParent = this.context.getParentNode();
        Node oldNext = this.context.getNextNode();
        if (element == oldParent) {
            if (oldNext != null) {
                this.context.setNextNode(oldNext);
            } else if (newNext != null) {
                this.context.setNextNode(newNext);
            } else {
                this.context.setParentNode(parent);
            }
        } else if (element == oldNext) {
            if (firstElement != null) {
                this.context.setParentNode(firstElement);
            } else if (first != null) {
                this.context.setNextNode(first);
            } else if (startElement != null) {
                this.context.setParentNode(startElement);
            } else {
                this.context.setNextNode(newNext);
            }
        }
        this.removeImplicitElement(elementParent);
    }

    private void removeStructuredDocumentRegion(IStructuredDocumentRegion oldStructuredDocumentRegion) {
        NodeImpl next = (NodeImpl)this.context.getNextNode();
        if (next != null) {
            short nodeType = next.getNodeType();
            if (nodeType != 1) {
                TextImpl nextText;
                IStructuredDocumentRegion flatNode = next.getStructuredDocumentRegion();
                if (flatNode == oldStructuredDocumentRegion) {
                    this.removeNode(next);
                    return;
                }
                if (nodeType != 3) {
                    throw new StructuredDocumentRegionManagementException();
                }
                if (flatNode == null) {
                    this.removeNode(next);
                    this.removeStructuredDocumentRegion(oldStructuredDocumentRegion);
                    return;
                }
                TextImpl text = (TextImpl)next;
                boolean isShared = text.isSharingStructuredDocumentRegion(oldStructuredDocumentRegion);
                if (isShared && ((nextText = (TextImpl)this.context.findNextText()) == null || !nextText.hasStructuredDocumentRegion(oldStructuredDocumentRegion))) {
                    isShared = false;
                }
                if ((oldStructuredDocumentRegion = text.removeStructuredDocumentRegion(oldStructuredDocumentRegion)) == null) {
                    throw new StructuredDocumentRegionManagementException();
                }
                if (text.getStructuredDocumentRegion() == null) {
                    this.removeNode(text);
                } else {
                    text.notifyValueChanged();
                }
                if (isShared) {
                    this.removeStructuredDocumentRegion(oldStructuredDocumentRegion);
                }
                return;
            }
            ElementImpl element = (ElementImpl)next;
            if (element.hasStartTag()) {
                IStructuredDocumentRegion flatNode = element.getStartStructuredDocumentRegion();
                if (flatNode != oldStructuredDocumentRegion) {
                    throw new StructuredDocumentRegionManagementException();
                }
                if (element.hasEndTag() || element.hasChildNodes()) {
                    element.setStartStructuredDocumentRegion(null);
                    this.removeStartTag(element);
                } else {
                    this.removeNode(element);
                }
            } else {
                Node child = element.getFirstChild();
                if (child != null) {
                    this.context.setNextNode(child);
                    this.removeStructuredDocumentRegion(oldStructuredDocumentRegion);
                    return;
                }
                if (!element.hasEndTag()) {
                    this.removeNode(element);
                    this.removeStructuredDocumentRegion(oldStructuredDocumentRegion);
                    return;
                }
                IStructuredDocumentRegion flatNode = element.getEndStructuredDocumentRegion();
                if (flatNode != oldStructuredDocumentRegion) {
                    throw new StructuredDocumentRegionManagementException();
                }
                this.removeNode(element);
            }
            return;
        }
        Node parent = this.context.getParentNode();
        if (parent == null || parent.getNodeType() != 1) {
            throw new StructuredDocumentRegionManagementException();
        }
        ElementImpl end = (ElementImpl)parent;
        if (end.hasEndTag()) {
            IStructuredDocumentRegion flatNode = end.getEndStructuredDocumentRegion();
            if (flatNode != oldStructuredDocumentRegion) {
                throw new StructuredDocumentRegionManagementException();
            }
            if (!end.hasStartTag() && !end.hasChildNodes()) {
                this.context.setNextNode(end);
                this.removeNode(end);
            } else {
                end.setEndStructuredDocumentRegion(null);
                this.removeEndTag(end);
            }
            return;
        }
        next = (NodeImpl)end.getNextSibling();
        if (next != null) {
            this.context.setNextNode(next);
            this.removeStructuredDocumentRegion(oldStructuredDocumentRegion);
            return;
        }
        parent = end.getParentNode();
        if (parent != null) {
            this.context.setParentNode(parent);
            this.removeStructuredDocumentRegion(oldStructuredDocumentRegion);
            return;
        }
    }

    void replaceRegions(IStructuredDocumentRegion flatNode, ITextRegionList newRegions, ITextRegionList oldRegions) {
        if (flatNode == null) {
            return;
        }
        if (this.model.getDocument() == null) {
            return;
        }
        this.context = new XMLModelContext(this.model.getDocument());
        String regionType = StructuredDocumentRegionUtil.getFirstRegionType(flatNode);
        if (regionType == "XML_TAG_OPEN") {
            this.changeStartTag(flatNode, newRegions, oldRegions);
        } else if (regionType == "XML_END_TAG_OPEN") {
            this.changeEndTag(flatNode, newRegions, oldRegions);
        } else {
            this.changeStructuredDocumentRegion(flatNode);
        }
    }

    void replaceStructuredDocumentRegions(IStructuredDocumentRegionList newStructuredDocumentRegions, IStructuredDocumentRegionList oldStructuredDocumentRegions) {
        IStructuredDocumentRegion flatNode;
        Enumeration e;
        int oldCount;
        if (this.model.getDocument() == null) {
            return;
        }
        this.context = new XMLModelContext(this.model.getDocument());
        int newCount = newStructuredDocumentRegions != null ? newStructuredDocumentRegions.getLength() : 0;
        int n = oldCount = oldStructuredDocumentRegions != null ? oldStructuredDocumentRegions.getLength() : 0;
        if (oldCount > 0) {
            this.setupContext(oldStructuredDocumentRegions.item(0));
            e = oldStructuredDocumentRegions.elements();
            while (e.hasMoreElements()) {
                flatNode = (IStructuredDocumentRegion)e.nextElement();
                if (flatNode == null) continue;
                this.removeStructuredDocumentRegion(flatNode);
            }
        } else {
            if (newCount == 0) {
                return;
            }
            this.setupContext(newStructuredDocumentRegions.item(0));
        }
        this.context.setLast();
        if (newCount > 0) {
            e = newStructuredDocumentRegions.elements();
            while (e.hasMoreElements()) {
                flatNode = (IStructuredDocumentRegion)e.nextElement();
                if (flatNode == null) continue;
                this.insertStructuredDocumentRegion(flatNode);
            }
        }
        this.cleanupText();
        this.cleanupEndTag();
    }

    private void setupContext(IStructuredDocumentRegion startStructuredDocumentRegion) {
        int offset = startStructuredDocumentRegion.getStart();
        if (offset < 0) {
            return;
        }
        NodeImpl root = (NodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        if (offset == 0) {
            Node child = root.getFirstChild();
            if (child != null) {
                this.context.setNextNode(child);
            } else {
                this.context.setParentNode(root);
            }
            return;
        }
        NodeImpl node = (NodeImpl)root.getNodeAt(offset);
        if (node == null) {
            this.context.setParentNode(root);
            this.context.setLast();
            return;
        }
        if (offset == node.getStartOffset()) {
            this.context.setNextNode(node);
            return;
        }
        if (node.getNodeType() == 3) {
            TextImpl text = (TextImpl)node;
            Text nextText = text.splitText(startStructuredDocumentRegion);
            text.notifyValueChanged();
            if (nextText == null) {
                return;
            }
            this.context.setNextNode(nextText);
            return;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (offset < ((NodeImpl)child).getEndOffset()) {
                this.context.setNextNode(child);
                return;
            }
            child = child.getNextSibling();
        }
        this.context.setParentNode(node);
        this.context.setLast();
    }

    protected XMLModelContext getContext() {
        return this.context;
    }
}

