/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocSpecificsWizardPage;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocStandardWizardPage;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocTreeWizardPage;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class JavadocWizard
extends Wizard
implements IExportWizard {
    private JavadocTreeWizardPage fJTWPage;
    private JavadocSpecificsWizardPage fJSWPage;
    private JavadocStandardWizardPage fJSpWPage;
    private IPath fDestination;
    private boolean fWriteCustom;
    private boolean fOpenInBrowser;
    private final String TREE_PAGE_DESC = "JavadocTreePage";
    private final String SPECIFICS_PAGE_DESC = "JavadocSpecificsPage";
    private final String STANDARD_PAGE_DESC = "JavadocStandardPage";
    private final int YES = 0;
    private final int YES_TO_ALL = 1;
    private final int NO = 2;
    private final int NO_TO_ALL = 3;
    private final String JAVADOC_ANT_INFORMATION_DIALOG = "javadocAntInformationDialog";
    private JavadocOptionsManager fStore;
    private IWorkspaceRoot fRoot;
    private IFile fXmlJavadocFile;
    private static final String ID_JAVADOC_PROCESS_TYPE = "org.eclipse.wst.jsdt.ui.javadocProcess";

    public static void openJavadocWizard(JavadocWizard wizard, Shell shell, IStructuredSelection selection) {
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(100), converter.convertHeightInCharsToPixels(20));
        dialog.open();
    }

    public JavadocWizard() {
        this(null);
    }

    public JavadocWizard(IFile xmlJavadocFile) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_EXPORT_JAVADOC);
        this.setWindowTitle(JavadocExportMessages.JavadocWizard_javadocwizard_title);
        this.setDialogSettings(JavaScriptPlugin.getDefault().getDialogSettings());
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fXmlJavadocFile = xmlJavadocFile;
        this.fWriteCustom = false;
    }

    public boolean performFinish() {
        int i;
        IJavaScriptProject[] checkedProjects = this.fJTWPage.getCheckedProjects();
        this.updateStore(checkedProjects);
        this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        if (!new RefactoringSaveHelper(1).saveEditors(this.getShell())) {
            return false;
        }
        this.fDestination = Path.fromOSString((String)this.fStore.getDestination());
        this.fDestination.toFile().mkdirs();
        this.fOpenInBrowser = this.fStore.doOpenInBrowser();
        if (this.fStore.isFromStandard()) {
            try {
                URL newURL = this.fDestination.toFile().toURL();
                ArrayList<IJavaScriptProject> projs = new ArrayList<IJavaScriptProject>();
                i = 0;
                while (i < checkedProjects.length) {
                    IJavaScriptProject curr = checkedProjects[i];
                    URL currURL = JavaScriptUI.getProjectJSdocLocation(curr);
                    if (!newURL.equals(currURL)) {
                        projs.add(curr);
                    }
                    ++i;
                }
                if (!projs.isEmpty()) {
                    this.setAllJavadocLocations(projs.toArray(new IJavaScriptProject[projs.size()]), newURL);
                }
            }
            catch (MalformedURLException e) {
                JavaScriptPlugin.log(e);
            }
        }
        if (this.fJSWPage.generateAnt()) {
            OptionalMessageDialog.open("javadocAntInformationDialog", this.getShell(), JavadocExportMessages.JavadocWizard_antInformationDialog_title, null, JavadocExportMessages.JavadocWizard_antInformationDialog_message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            try {
                IFile[] files;
                File file = this.fStore.createXML(checkedProjects);
                if (file != null && (files = this.fRoot.findFilesForLocation(Path.fromOSString((String)file.getPath()))) != null) {
                    i = 0;
                    while (i < files.length) {
                        files[i].refreshLocal(1, null);
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.getShell(), JavadocExportMessages.JavadocWizard_error_writeANT_title, JavadocExportMessages.JavadocWizard_error_writeANT_message);
            }
        }
        return this.executeJavadocGeneration();
    }

    private void updateStore(IJavaScriptProject[] checkedProjects) {
        this.fJTWPage.updateStore(checkedProjects);
        if (!this.fJTWPage.getCustom()) {
            this.fJSpWPage.updateStore();
        }
        this.fJSWPage.updateStore();
    }

    public boolean performCancel() {
        IJavaScriptProject[] checkedProjects = this.fJTWPage.getCheckedProjects();
        this.updateStore(checkedProjects);
        if (this.fXmlJavadocFile == null) {
            this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        }
        return super.performCancel();
    }

    private void setAllJavadocLocations(IJavaScriptProject[] projects, URL newURL) {
        Shell shell = this.getShell();
        String[] buttonlabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
        int j = 0;
        while (j < projects.length) {
            IJavaScriptProject iJavaProject = projects[j];
            String message = Messages.format(JavadocExportMessages.JavadocWizard_updatejavadoclocation_message, new String[]{iJavaProject.getElementName(), this.fDestination.toOSString()});
            MessageDialog dialog = new MessageDialog(shell, JavadocExportMessages.JavadocWizard_updatejavadocdialog_label, null, message, 3, buttonlabels, 1);
            switch (dialog.open()) {
                case 0: {
                    JavaScriptUI.setProjectJSdocLocation(iJavaProject, newURL);
                    break;
                }
                case 1: {
                    int i = j;
                    while (i < projects.length) {
                        iJavaProject = projects[i];
                        JavaScriptUI.setProjectJSdocLocation(iJavaProject, newURL);
                        ++j;
                        ++i;
                    }
                    break;
                }
                case 3: {
                    j = projects.length;
                    break;
                }
            }
            ++j;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeJavadocGeneration() {
        Process process = null;
        try {
            ArrayList<String> vmArgs = new ArrayList<String>();
            ArrayList progArgs = new ArrayList();
            IStatus status = this.fStore.getArgumentArray(vmArgs, progArgs);
            if (!status.isOK()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)JavadocExportMessages.JavadocWizard_error_title, (String)JavadocExportMessages.JavadocWizard_warning_starting_message, (IStatus)status);
            }
            File file = File.createTempFile("javadoc-arguments", ".tmp");
            vmArgs.add(String.valueOf('@') + file.getAbsolutePath());
            FileWriter writer = new FileWriter(file);
            try {
                int i = 0;
                while (i < progArgs.size()) {
                    String curr = (String)progArgs.get(i);
                    curr = this.checkForSpaces(curr);
                    writer.write(curr);
                    writer.write(32);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                writer.close();
                throw throwable;
            }
            {
                Object var9_17 = null;
            }
            writer.close();
            String[] args = vmArgs.toArray(new String[vmArgs.size()]);
            process = Runtime.getRuntime().exec(args);
            if (process == null) return false;
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (true) {
                if (i >= args.length) {
                    JavadocDebugEventListener listener = new JavadocDebugEventListener(this.getShell().getDisplay(), file);
                    DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)listener);
                    ILaunchConfigurationWorkingCopy wc = null;
                    try {
                        ILaunchConfigurationType lcType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.wst.jsdt.core.localJavaApplication");
                        String name = JavadocExportMessages.JavadocWizard_launchconfig_name;
                        wc = lcType.newInstance(null, name);
                        wc.setAttribute("org.eclipse.debug.ui.private", true);
                        Launch newLaunch = new Launch((ILaunchConfiguration)wc, "run", null);
                        IProcess iprocess = DebugPlugin.newProcess((ILaunch)newLaunch, (Process)process, (String)JavadocExportMessages.JavadocWizard_javadocprocess_label);
                        iprocess.setAttribute(IProcess.ATTR_CMDLINE, buf.toString());
                        iprocess.setAttribute(IProcess.ATTR_PROCESS_TYPE, ID_JAVADOC_PROCESS_TYPE);
                        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)newLaunch);
                        return true;
                    }
                    catch (CoreException e) {
                        String title = JavadocExportMessages.JavadocWizard_error_title;
                        String message = JavadocExportMessages.JavadocWizard_launch_error_message;
                        ExceptionHandler.handle(e, this.getShell(), title, message);
                        return true;
                    }
                }
                buf.append(args[i]);
                buf.append(' ');
                ++i;
            }
        }
        catch (IOException e) {
            String title = JavadocExportMessages.JavadocWizard_error_title;
            String message = JavadocExportMessages.JavadocWizard_exec_error_message;
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, e.getMessage(), (Throwable)e);
            ExceptionHandler.handle(new CoreException((IStatus)status), this.getShell(), title, message);
            return false;
        }
    }

    private String checkForSpaces(String curr) {
        if (curr.indexOf(32) == -1) {
            return curr;
        }
        StringBuffer buf = new StringBuffer();
        buf.append('\'');
        int i = 0;
        while (i < curr.length()) {
            char ch = curr.charAt(i);
            if (ch == '\\' || ch == '\'') {
                buf.append('\\');
            }
            buf.append(ch);
            ++i;
        }
        buf.append('\'');
        return buf.toString();
    }

    public void addPages() {
        this.fJTWPage = new JavadocTreeWizardPage("JavadocTreePage", this.fStore);
        this.fJSWPage = new JavadocSpecificsWizardPage("JavadocSpecificsPage", this.fJTWPage, this.fStore);
        this.fJSpWPage = new JavadocStandardWizardPage("JavadocStandardPage", this.fJTWPage, this.fStore);
        super.addPage((IWizardPage)this.fJTWPage);
        super.addPage((IWizardPage)this.fJSpWPage);
        super.addPage((IWizardPage)this.fJSWPage);
        this.fJTWPage.init();
        this.fJSpWPage.init();
        this.fJSWPage.init();
    }

    public void init(IWorkbench workbench, IStructuredSelection structuredSelection) {
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        ArrayList<IJavaScriptElement> selected = Collections.EMPTY_LIST;
        if (window != null) {
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                selected = ((IStructuredSelection)selection).toList();
            } else {
                IJavaScriptElement element = EditorUtility.getActiveEditorJavaInput();
                if (element != null) {
                    selected = new ArrayList<IJavaScriptElement>();
                    selected.add(element);
                }
            }
        }
        this.fStore = new JavadocOptionsManager(this.fXmlJavadocFile, this.getDialogSettings(), selected);
    }

    private void refresh(IPath path) {
        if (this.fRoot.findContainersForLocation(path).length > 0) {
            try {
                this.fRoot.refreshLocal(2, null);
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
            }
        }
    }

    private void spawnInBrowser(Display display) {
        if (this.fOpenInBrowser) {
            try {
                IPath indexFile = this.fDestination.append("index.html");
                URL url = indexFile.toFile().toURL();
                OpenBrowserUtil.open(url, display, this.getWindowTitle());
            }
            catch (MalformedURLException e) {
                JavaScriptPlugin.log(e);
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof JavadocTreeWizardPage) {
            if (!this.fJTWPage.getCustom()) {
                return this.fJSpWPage;
            }
            return this.fJSWPage;
        }
        if (page instanceof JavadocSpecificsWizardPage) {
            return null;
        }
        if (page instanceof JavadocStandardWizardPage) {
            return this.fJSWPage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page instanceof JavadocSpecificsWizardPage) {
            if (!this.fJTWPage.getCustom()) {
                return this.fJSpWPage;
            }
            return this.fJSWPage;
        }
        if (page instanceof JavadocTreeWizardPage) {
            return null;
        }
        if (page instanceof JavadocStandardWizardPage) {
            return this.fJTWPage;
        }
        return null;
    }

    private class JavadocDebugEventListener
    implements IDebugEventSetListener {
        private Display fDisplay;
        private File fFile;

        public JavadocDebugEventListener(Display display, File file) {
            this.fDisplay = display;
            this.fFile = file;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                if (events[i].getKind() == 8) {
                    try {
                        if (!JavadocWizard.this.fWriteCustom) {
                            this.fFile.delete();
                            JavadocWizard.this.refresh(JavadocWizard.this.fDestination);
                            JavadocWizard.this.spawnInBrowser(this.fDisplay);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        return;
                    }
                }
                ++i;
            }
            return;
        }
    }
}

