/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive.internal;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jee.archive.AbstractArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.IArchiveResource;

public class ZipFileArchiveLoadAdapterImpl
extends AbstractArchiveLoadAdapter {
    protected ZipFile zipFile;

    public ZipFileArchiveLoadAdapterImpl() {
    }

    public ZipFileArchiveLoadAdapterImpl(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public void close() {
        super.close();
        try {
            this.getZipFile().close();
        }
        catch (IOException iOException) {}
    }

    public boolean containsArchiveResource(IPath resourcePath) {
        ZipEntry entry = this.getZipFile().getEntry(resourcePath.toString());
        return entry != null;
    }

    public IArchiveResource getArchiveResource(IPath filePath) {
        ZipEntry entry = this.getZipFile().getEntry(filePath.toString());
        IArchiveResource aFile = null;
        if (entry != null) {
            aFile = this.createFile(entry);
        }
        return aFile;
    }

    public List getArchiveResources() {
        ArrayList<IArchiveResource> list = new ArrayList<IArchiveResource>();
        Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            IArchiveResource aFile = this.createFile(entry);
            list.add(aFile);
        }
        return list;
    }

    protected IArchiveResource createFile(ZipEntry entry) {
        Path path = new Path(entry.getName());
        IArchiveResource aFile = null;
        if (!entry.isDirectory()) {
            aFile = this.createFile((IPath)path);
            aFile.setSize(entry.getSize());
            aFile.setLastModified(entry.getTime());
        } else {
            aFile = this.createDirectory((IPath)path);
            aFile.setSize(entry.getSize());
            aFile.setLastModified(entry.getTime());
        }
        return aFile;
    }

    public InputStream getInputStream(IArchiveResource aFile) throws IOException, FileNotFoundException {
        try {
            IPath path = aFile.getPath();
            String uri = path.toString();
            ZipEntry entry = this.getZipFile().getEntry(uri);
            if (entry == null) {
                char[] chars = uri.toCharArray();
                int[] slashIndices = new int[chars.length];
                int slashCount = 0;
                int i = 0;
                while (i < uri.length()) {
                    if (chars[i] == '/' || chars[i] == '\\') {
                        slashIndices[slashCount] = i;
                        ++slashCount;
                    }
                    ++i;
                }
                int slashPow = (int)Math.pow(2.0, slashCount);
                boolean foundIt = false;
                int i2 = 0;
                while (i2 < slashPow && !foundIt) {
                    int j = 0;
                    while (j < slashCount) {
                        chars[slashIndices[j]] = (i2 >> j & 1) == 1 ? 47 : 92;
                        ++j;
                    }
                    entry = this.getZipFile().getEntry(new String(chars));
                    if (entry != null) {
                        foundIt = true;
                    }
                    ++i2;
                }
                if (entry == null) {
                    throw new FileNotFoundException(uri);
                }
            }
            return new BufferedInputStream(this.getZipFile().getInputStream(entry));
        }
        catch (IllegalStateException zipClosed) {
            throw new IOException(zipClosed.toString());
        }
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(ZipFile newZipFile) {
        this.zipFile = newZipFile;
    }

    public String toString() {
        return this.zipFile.getName();
    }

    public boolean containsModelObject(IPath modelObjectPath) {
        return false;
    }

    public Object getModelObject(IPath modelObjectPath) throws ArchiveModelLoadException {
        throw new ArchiveModelLoadException("Simple Zip Archives have no model objects.");
    }
}

