/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;

public final class RefactoringFileBuffers {
    public static ITextFileBuffer acquire(IJavaScriptUnit unit) throws CoreException {
        Assert.isNotNull((Object)unit);
        IResource resource = unit.getResource();
        if (resource != null && resource.getType() == 1) {
            IPath path = resource.getFullPath();
            FileBuffers.getTextFileBufferManager().connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            return FileBuffers.getTextFileBufferManager().getTextFileBuffer(path, LocationKind.IFILE);
        }
        return null;
    }

    public static ITextFileBuffer getTextFileBuffer(IJavaScriptUnit unit) {
        Assert.isNotNull((Object)unit);
        IResource resource = unit.getResource();
        if (resource == null || resource.getType() != 1) {
            return null;
        }
        return FileBuffers.getTextFileBufferManager().getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
    }

    public static void release(IJavaScriptUnit unit) throws CoreException {
        Assert.isNotNull((Object)unit);
        IResource resource = unit.getResource();
        if (resource != null && resource.getType() == 1) {
            FileBuffers.getTextFileBufferManager().disconnect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private RefactoringFileBuffers() {
    }
}

