/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.ManifestFileCreationAction;
import org.eclipse.jst.j2ee.project.facet.EARFacetUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.project.facet.ProductManager;
import org.eclipse.wst.web.internal.facet.RuntimePresetMappingRegistry;

public abstract class J2EEFacetInstallDelegate {
    protected static void addToClasspath(IJavaProject jproj, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] existingEntries;
        IClasspathEntry[] iClasspathEntryArray = existingEntries = jproj.getRawClasspath();
        int n = existingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry existingEntry = iClasspathEntryArray[n2];
            if (existingEntry.equals(entry)) {
                return;
            }
            ++n2;
        }
        IClasspathEntry[] updated = new IClasspathEntry[existingEntries.length + 1];
        System.arraycopy(existingEntries, 0, updated, 0, existingEntries.length);
        updated[existingEntries.length] = entry;
        jproj.setRawClasspath(updated, null);
    }

    protected void installEARFacet(String j2eeVersionText, String earProjectName, IRuntime runtime, IProgressMonitor monitor) {
        IProjectFacetVersion defaultEarFacetVersion;
        IProject project = ProjectUtilities.getProject((String)earProjectName);
        if (project.exists()) {
            return;
        }
        IFacetedProjectWorkingCopy fpjwc = FacetedProjectFramework.createNewProject();
        fpjwc.setProjectName(earProjectName);
        if (runtime != null) {
            fpjwc.setTargetedRuntimes(Collections.singleton(runtime));
        }
        fpjwc.setFixedProjectFacets(Collections.singleton(EARFacetUtils.EAR_FACET));
        fpjwc.setSelectedPreset("default.configuration");
        if (j2eeVersionText != null && !(defaultEarFacetVersion = fpjwc.getProjectFacetVersion(EARFacetUtils.EAR_FACET)).getVersionString().equals(j2eeVersionText)) {
            String presetId = null;
            if (runtime != null) {
                for (IRuntimeComponent rc : runtime.getRuntimeComponents()) {
                    presetId = RuntimePresetMappingRegistry.INSTANCE.getPresetID(rc.getRuntimeComponentType().getId(), rc.getRuntimeComponentVersion().getVersionString(), EARFacetUtils.EAR_FACET.getId(), j2eeVersionText);
                    if (presetId != null) break;
                }
            }
            IProjectFacetVersion earFacetVersion = EARFacetUtils.EAR_FACET.getVersion(j2eeVersionText);
            fpjwc.setProjectFacets(Collections.singleton(earFacetVersion));
            if (presetId != null) {
                fpjwc.setSelectedPreset(presetId);
            }
        }
        try {
            fpjwc.commitChanges(null);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected void createManifest(IProject project, IContainer aFolder, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IFile file = aFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (file.exists()) {
            return;
        }
        try {
            ManifestFileCreationAction.createManifestFile(file, project);
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    protected void addToEar(IVirtualComponent earComp, IVirtualComponent j2eeComp, String moduleURI) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        Map map = (Map)dataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP");
        map.put(j2eeComp, moduleURI);
        dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
        List modList = (List)dataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modList.add(j2eeComp);
        dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
        try {
            dataModel.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected void installAndAddModuletoEAR(String j2eeVersionText, String earProjectName, IRuntime runtime, IProject moduleProject, String moduleURI, IProgressMonitor monitor) {
        this.installEARFacet(j2eeVersionText, earProjectName, runtime, monitor);
        IVirtualComponent c = ComponentCore.createComponent((IProject)moduleProject);
        IProject earProject = ProjectUtilities.getProject((String)earProjectName);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        if (UIContextDetermination.getCurrentContext() == 102) {
            boolean isValidating = RendererFactory.getDefaultRendererFactory().isValidating();
            try {
                if (isValidating) {
                    RendererFactory.getDefaultRendererFactory().setValidating(false);
                }
                this.addToEar(earComp, c, moduleURI);
            }
            finally {
                RendererFactory.getDefaultRendererFactory().setValidating(isValidating);
            }
        } else {
            this.addToEar(earComp, c, moduleURI);
        }
    }

    protected void setOutputFolder(IDataModel model, IVirtualComponent component) {
        String outputFolder = null;
        outputFolder = ProductManager.shouldUseSingleRootStructure() ? model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER") : CommonFrameworksPlugin.getDefault().getPluginPreferences().getString("outputFolder");
        component.setMetaProperty("java-output-path", outputFolder);
    }
}

