/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveWrapper {
    private Archive commonArchive = null;
    private IArchive archive = null;
    private JavaEEQuickPeek jqp = null;
    private ArchiveWrapper cachedParent = null;
    private List<ArchiveWrapper> cachedWebLibs;
    private List<String> cachedDDMappedModuleURIs = null;
    private List<ArchiveWrapper> cachedEARModules;
    private String[] cachedWebContextRoot = null;
    private HashMap<ArchiveWrapper, ArchiveWrapper> cachedEJBClientArchiveWrapper = null;
    private List<ArchiveWrapper> cachedEARUtilitiesAndWebLibs = null;

    public ArchiveWrapper(IArchive archive) {
        this.archive = archive;
        JavaEEArchiveUtilities jea = JavaEEArchiveUtilities.INSTANCE;
        this.jqp = jea.getJavaEEQuickPeek(archive);
    }

    public ArchiveWrapper(Archive mFile) {
        this.commonArchive = mFile;
        int type = -1;
        if (mFile.isApplicationClientFile()) {
            type = 3;
        } else if (mFile.isEARFile()) {
            type = 1;
        } else if (mFile.isEJBJarFile()) {
            type = 0;
        } else if (mFile.isWARFile()) {
            type = 4;
        } else if (mFile.isRARFile()) {
            type = 2;
        }
        if (type != -1) {
            int version = ArchiveUtil.getFastSpecVersion((ModuleFile)((ModuleFile)mFile));
            this.jqp = new JavaEEQuickPeek(type, version);
        } else {
            this.jqp = new JavaEEQuickPeek(null);
        }
    }

    public JavaEEQuickPeek getJavaEEQuickPeek() {
        return this.jqp;
    }

    public Archive getCommonArchive() {
        return this.commonArchive;
    }

    public Object getUnderLyingArchive() {
        if (this.archive != null) {
            return this.archive;
        }
        if (this.commonArchive != null) {
            return this.commonArchive;
        }
        this.fail();
        return null;
    }

    public ArchiveWrapper getParent() {
        if (this.cachedParent != null) {
            return this.cachedParent;
        }
        if (this.archive != null) {
            this.cachedParent = new ArchiveWrapper(this.archive.getArchive());
            return this.cachedParent;
        }
        if (this.commonArchive != null) {
            this.cachedParent = new ArchiveWrapper((Archive)this.commonArchive.eContainer());
            return this.cachedParent;
        }
        this.fail();
        return null;
    }

    public IArchive getIArchive() {
        return this.archive;
    }

    public void close() {
        try {
            if (this.commonArchive != null && this.commonArchive.isOpen()) {
                this.commonArchive.close();
            }
            if (this.archive != null && this.archive.isOpen()) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(this.archive);
            }
        }
        catch (RuntimeException e) {
            Logger.getLogger().logError((Throwable)e);
            throw e;
        }
    }

    public IPath getPath() {
        if (this.commonArchive != null) {
            Path path = new Path(this.commonArchive.getURI());
            return path;
        }
        if (this.archive != null) {
            return this.archive.getPath();
        }
        this.fail();
        return null;
    }

    private void fail() {
        throw new RuntimeException("ArchiveWrapper is inconsistent.");
    }

    public int getSize() {
        if (this.commonArchive != null) {
            return this.commonArchive.getFiles().size();
        }
        return this.archive.getArchiveResources().size();
    }

    public List<ArchiveWrapper> getWebLibs() {
        if (this.cachedWebLibs != null) {
            return this.cachedWebLibs;
        }
        if (this.jqp.getType() != 4) {
            this.fail();
        }
        this.cachedWebLibs = new ArrayList<ArchiveWrapper>();
        if (this.commonArchive != null) {
            WARFile war = (WARFile)this.commonArchive;
            List libs = war.getLibArchives();
            int i = 0;
            while (i < libs.size()) {
                this.cachedWebLibs.add(new ArchiveWrapper((Archive)libs.get(i)));
                ++i;
            }
            return this.cachedWebLibs;
        }
        if (this.archive != null) {
            List resources = this.archive.getArchiveResources();
            for (IArchiveResource resource : resources) {
                String lastSegment;
                IPath path;
                if (resource.getType() == 1 || (path = resource.getPath()).segmentCount() <= 2 || !path.segment(0).equals("WEB-INF") || !path.segment(1).equals("lib") || !(lastSegment = path.lastSegment()).endsWith("jar") && !lastSegment.endsWith("zip")) continue;
                try {
                    IArchive webLib = this.archive.getNestedArchive(resource);
                    this.cachedWebLibs.add(new ArchiveWrapper(webLib));
                }
                catch (ArchiveOpenFailureException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            return this.cachedWebLibs;
        }
        this.fail();
        return null;
    }

    public List<String> getDDMappedModuleURIs() {
        if (this.cachedDDMappedModuleURIs != null) {
            return this.cachedDDMappedModuleURIs;
        }
        if (this.jqp.getType() != 1) {
            this.fail();
        }
        this.cachedDDMappedModuleURIs = new ArrayList<String>();
        if (this.commonArchive != null) {
            EARFile ear = (EARFile)this.commonArchive;
            List earMods = ear.getModuleFiles();
            int i = 0;
            while (i < earMods.size()) {
                this.cachedDDMappedModuleURIs.add(((Archive)earMods.get(i)).getURI());
                ++i;
            }
            return this.cachedDDMappedModuleURIs;
        }
        if (this.archive != null && this.archive.containsArchiveResource((IPath)new Path("META-INF/application.xml"))) {
            if (this.jqp.getJavaEEVersion() == 50) {
                try {
                    org.eclipse.jst.javaee.application.Application application = (org.eclipse.jst.javaee.application.Application)this.archive.getModelObject();
                    List modules = application.getModules();
                    int i = 0;
                    while (i < modules.size()) {
                        Module module = (Module)modules.get(i);
                        String uri = module.getUri();
                        this.cachedDDMappedModuleURIs.add(uri);
                        ++i;
                    }
                }
                catch (ArchiveModelLoadException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            } else {
                try {
                    Application application = (Application)this.archive.getModelObject();
                    EList modules = application.getModules();
                    int i = 0;
                    while (i < modules.size()) {
                        org.eclipse.jst.j2ee.application.Module module = (org.eclipse.jst.j2ee.application.Module)modules.get(i);
                        String uri = module.getUri();
                        this.cachedDDMappedModuleURIs.add(uri);
                        ++i;
                    }
                }
                catch (ArchiveModelLoadException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
        }
        return this.cachedDDMappedModuleURIs;
    }

    public List<ArchiveWrapper> getEarModules() {
        if (this.cachedEARModules != null) {
            return this.cachedEARModules;
        }
        if (this.jqp.getType() != 1) {
            this.fail();
        }
        this.cachedEARModules = new ArrayList<ArchiveWrapper>();
        if (this.commonArchive != null) {
            EARFile ear = (EARFile)this.commonArchive;
            List earMods = ear.getModuleFiles();
            int i = 0;
            while (i < earMods.size()) {
                this.cachedEARModules.add(new ArchiveWrapper((Archive)earMods.get(i)));
                ++i;
            }
            return this.cachedEARModules;
        }
        if (this.archive != null) {
            if (this.jqp.getJavaEEVersion() == 50) {
                List resources = this.archive.getArchiveResources();
                for (IArchiveResource resource : resources) {
                    String lastSegment;
                    IPath path;
                    if (resource.getType() == 1 || (path = resource.getPath()).segmentCount() <= 0 || !(lastSegment = path.lastSegment()).endsWith("jar") && !lastSegment.endsWith("zip") && !lastSegment.endsWith("rar") && !lastSegment.endsWith("war")) continue;
                    try {
                        IArchive earmodule = this.archive.getNestedArchive(resource);
                        this.cachedEARModules.add(new ArchiveWrapper(earmodule));
                    }
                    catch (ArchiveOpenFailureException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
            } else {
                try {
                    Application app = (Application)this.archive.getModelObject();
                    EList modules = app.getModules();
                    int i = 0;
                    while (i < modules.size()) {
                        org.eclipse.jst.j2ee.application.Module mod = (org.eclipse.jst.j2ee.application.Module)modules.get(i);
                        String uri = mod.getUri();
                        Path path = new Path(uri);
                        if (this.archive.containsArchiveResource((IPath)path)) {
                            try {
                                IArchiveResource resource = this.archive.getArchiveResource((IPath)path);
                                IArchive earmodule = this.archive.getNestedArchive(resource);
                                this.cachedEARModules.add(new ArchiveWrapper(earmodule));
                            }
                            catch (ArchiveOpenFailureException e) {
                                Logger.getLogger().logError((Throwable)e);
                            }
                            catch (FileNotFoundException e) {
                                J2EEPlugin.logError(e);
                            }
                        }
                        ++i;
                    }
                }
                catch (ArchiveModelLoadException e) {
                    J2EEPlugin.logError(e);
                }
            }
            return this.cachedEARModules;
        }
        this.fail();
        return null;
    }

    public String getName() {
        if (this.commonArchive != null) {
            return this.commonArchive.getName();
        }
        if (this.archive != null) {
            return this.archive.getPath().lastSegment();
        }
        this.fail();
        return null;
    }

    public boolean isModule() {
        if (this.isApplicationClientFile()) {
            return true;
        }
        if (this.isWARFile()) {
            return true;
        }
        if (this.isEJBJarFile()) {
            return true;
        }
        return this.isRARFile();
    }

    public boolean isApplicationClientFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isApplicationClientFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 3;
        }
        this.fail();
        return false;
    }

    public boolean isWARFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isWARFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 4;
        }
        this.fail();
        return false;
    }

    public boolean isEJBJarFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isEJBJarFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 0;
        }
        this.fail();
        return false;
    }

    public boolean isEarFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isEARFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 1;
        }
        this.fail();
        return false;
    }

    public boolean isRARFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isRARFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 2;
        }
        this.fail();
        return false;
    }

    public String getWebContextRoot() {
        if (this.cachedWebContextRoot != null) {
            return this.cachedWebContextRoot[0];
        }
        if (!this.isWARFile()) {
            this.fail();
            return null;
        }
        this.cachedWebContextRoot = new String[1];
        if (this.commonArchive != null) {
            this.cachedWebContextRoot[0] = ((WebModule)((EARFile)this.commonArchive.getContainer()).getModule(this.commonArchive.getURI(), null)).getContextRoot();
            return this.cachedWebContextRoot[0];
        }
        if (this.archive != null) {
            block14: {
                IArchive earArchive = this.archive.getArchive();
                if (earArchive.containsArchiveResource((IPath)new Path("META-INF/application.xml"))) {
                    JavaEEQuickPeek earJQP = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(earArchive);
                    if (earJQP.getJavaEEVersion() == 50) {
                        try {
                            org.eclipse.jst.javaee.application.Application application = (org.eclipse.jst.javaee.application.Application)earArchive.getModelObject();
                            String moduleName = this.archive.getPath().toString();
                            Module module = application.getFirstModule(moduleName);
                            if (module != null) {
                                this.cachedWebContextRoot[0] = module.getWeb().getContextRoot();
                                break block14;
                            }
                            this.cachedWebContextRoot[0] = this.getDefaultContextRoot();
                        }
                        catch (ArchiveModelLoadException e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                    } else {
                        try {
                            Application application = (Application)earArchive.getModelObject();
                            String moduleName = this.archive.getPath().toString();
                            WebModule module = (WebModule)application.getFirstModule(moduleName);
                            if (module == null) {
                                this.cachedWebContextRoot[0] = null;
                                break block14;
                            }
                            this.cachedWebContextRoot[0] = module.getContextRoot();
                        }
                        catch (ArchiveModelLoadException e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                    }
                } else {
                    this.cachedWebContextRoot[0] = this.getDefaultContextRoot();
                }
            }
            return this.cachedWebContextRoot[0];
        }
        this.fail();
        return null;
    }

    private String getDefaultContextRoot() {
        String contextRoot = this.archive.getPath().toString();
        contextRoot = contextRoot.substring(0, contextRoot.lastIndexOf(46));
        return contextRoot;
    }

    /*
     * Exception decompiling
     */
    public ArchiveWrapper getEJBClientArchiveWrapper(ArchiveWrapper ejbWrapper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<ArchiveWrapper> getEARUtilitiesAndWebLibs() {
        if (this.cachedEARUtilitiesAndWebLibs != null) {
            return this.cachedEARUtilitiesAndWebLibs;
        }
        if (!this.isEarFile()) {
            this.fail();
            return null;
        }
        this.cachedEARUtilitiesAndWebLibs = new ArrayList<ArchiveWrapper>();
        if (this.commonArchive != null) {
            EList files = this.commonArchive.getFiles();
            int i = 0;
            while (i < files.size()) {
                FileImpl file = (FileImpl)files.get(i);
                if (file.isArchive() && !file.isModuleFile() && file.getURI().endsWith(".jar")) {
                    this.cachedEARUtilitiesAndWebLibs.add(new ArchiveWrapper((Archive)file));
                }
                if (file.isWARFile()) {
                    ArchiveWrapper wrapper = new ArchiveWrapper((Archive)file);
                    this.cachedEARUtilitiesAndWebLibs.addAll(wrapper.getWebLibs());
                }
                ++i;
            }
            return this.cachedEARUtilitiesAndWebLibs;
        }
        if (this.archive != null) {
            List files = this.archive.getArchiveResources();
            int i = 0;
            while (i < files.size()) {
                IArchiveResource file = (IArchiveResource)files.get(i);
                String lastSegment = file.getPath().lastSegment();
                if (lastSegment.endsWith(".jar") || lastSegment.endsWith(".rar") || lastSegment.endsWith(".war") || lastSegment.endsWith("zip")) {
                    try {
                        IArchive nestedArchive = this.archive.getNestedArchive(file);
                        ArchiveWrapper nestedWrapper = new ArchiveWrapper(nestedArchive);
                        if (nestedWrapper.isWARFile()) {
                            this.cachedEARUtilitiesAndWebLibs.addAll(nestedWrapper.getWebLibs());
                        } else if (!nestedWrapper.isModule()) {
                            this.cachedEARUtilitiesAndWebLibs.add(nestedWrapper);
                        }
                    }
                    catch (ArchiveOpenFailureException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
                ++i;
            }
            return this.cachedEARUtilitiesAndWebLibs;
        }
        this.fail();
        return null;
    }
}

