/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deployables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEDeployableFactory
extends ProjectModuleFactoryDelegate {
    protected Map moduleDelegates = new HashMap(5);
    public static final String ID = "org.eclipse.jst.j2ee.server";

    protected IModule[] createModules(IProject project) {
        try {
            ModuleCoreNature nature;
            if (project.exists() && (nature = (ModuleCoreNature)project.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) != null) {
                return this.createModules(nature);
            }
        }
        catch (CoreException e) {
            J2EEPlugin.logError(e);
        }
        return null;
    }

    protected IModule[] createModules(ModuleCoreNature nature) {
        IProject project = nature.getProject();
        try {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
            return this.createModuleDelegates(comp);
        }
        catch (Exception e) {
            J2EEPlugin.logError(e);
            return null;
        }
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        return (ModuleDelegate)this.moduleDelegates.get(module);
    }

    protected IModule[] createModuleDelegates(IVirtualComponent component) {
        ArrayList<IModule> projectModules;
        block4: {
            projectModules = new ArrayList<IModule>();
            try {
                if (J2EEProjectUtilities.isLegacyJ2EEProject(component.getProject())) {
                    IModule module = null;
                    String type = JavaEEProjectUtilities.getJ2EEProjectType(component.getProject());
                    String version = J2EEProjectUtilities.getJ2EEProjectVersion(component.getProject());
                    module = this.createModule(component.getDeployedName(), component.getDeployedName(), type, version, component.getProject());
                    J2EEFlexProjDeployable moduleDelegate = new J2EEFlexProjDeployable(component.getProject(), component);
                    this.moduleDelegates.put(module, moduleDelegate);
                    projectModules.add(module);
                    if ("jst.ear".equals(type)) {
                        projectModules.addAll(this.createBinaryModules(component));
                    }
                    break block4;
                }
                return null;
            }
            catch (Exception e) {
                J2EEPlugin.logError(e);
            }
        }
        return projectModules.toArray(new IModule[projectModules.size()]);
    }

    protected List<IModule> createBinaryModules(IVirtualComponent component) {
        ArrayList<IModule> projectModules = new ArrayList<IModule>();
        IVirtualReference[] references = component.getReferences();
        int i = 0;
        while (i < references.length) {
            JavaEEQuickPeek qp;
            IVirtualComponent moduleComponent = references[i].getReferencedComponent();
            if (moduleComponent.isBinary() && (qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(moduleComponent)).getType() != -1) {
                String moduleType = null;
                String moduleVersion = null;
                switch (qp.getType()) {
                    case 3: {
                        moduleType = "jst.appclient";
                        break;
                    }
                    case 4: {
                        moduleType = "jst.web";
                        break;
                    }
                    case 0: {
                        moduleType = "jst.ejb";
                        break;
                    }
                    case 2: {
                        moduleType = "jst.connector";
                        break;
                    }
                    case 1: {
                        moduleType = "jst.ear";
                        break;
                    }
                    default: {
                        moduleType = "jst.utility";
                        moduleVersion = "1.0";
                    }
                }
                int version = qp.getVersion();
                moduleVersion = J2EEVersionUtil.convertVersionIntToString(version);
                IModule nestedModule = this.createModule(moduleComponent.getDeployedName(), moduleComponent.getDeployedName(), moduleType, moduleVersion, moduleComponent.getProject());
                if (nestedModule != null) {
                    J2EEFlexProjDeployable moduleDelegate = new J2EEFlexProjDeployable(moduleComponent.getProject(), moduleComponent);
                    this.moduleDelegates.put(nestedModule, moduleDelegate);
                    projectModules.add(nestedModule);
                    moduleDelegate.getURI(nestedModule);
                }
            }
            ++i;
        }
        return projectModules;
    }

    protected IPath[] getListenerPaths() {
        return new IPath[]{new Path(".project"), new Path(StructureEdit.MODULE_META_FILE_NAME), new Path(".settings/org.eclipse.wst.common.project.facet.core.xml")};
    }

    protected void clearCache() {
        this.moduleDelegates = new HashMap(5);
    }
}

