/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyVirtualComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARComponentArchiveLoadAdapter
extends ComponentArchiveLoadAdapter {
    private Map<IArchiveResource, File> binaryResourcesToDiskFiles = new HashMap<IArchiveResource, File>();

    public EARComponentArchiveLoadAdapter(IVirtualComponent vComponent) {
        super(vComponent);
    }

    public EARComponentArchiveLoadAdapter(IVirtualComponent vComponent, boolean includeClasspathComponents) {
        super(vComponent, includeClasspathComponents);
    }

    @Override
    public List<IArchiveResource> getArchiveResources() {
        this.aggregateSourceFiles();
        this.addModulesAndUtilities();
        List<IArchiveResource> files = this.filesHolder.getFiles();
        Path manifestPath = new Path("META-INF/MANIFEST.MF");
        if (!this.filesHolder.contains((IPath)manifestPath)) {
            IArchiveResource manifest = this.createManifest((IPath)manifestPath);
            files.add(manifest);
        }
        return files;
    }

    @Override
    public InputStream getInputStream(IArchiveResource archiveResource) throws IOException, FileNotFoundException {
        if (this.binaryResourcesToDiskFiles.containsKey(archiveResource)) {
            File diskFile = this.binaryResourcesToDiskFiles.get(archiveResource);
            return new FileInputStream(diskFile);
        }
        return super.getInputStream(archiveResource);
    }

    public void addModulesAndUtilities() {
        IVirtualReference[] components = J2EEProjectUtilities.getComponentReferences(this.vComponent);
        int i = 0;
        while (i < components.length) {
            IVirtualReference reference = components[i];
            IVirtualComponent referencedComponent = reference.getReferencedComponent();
            try {
                String spt;
                IArchive nestedModuleArchive = JavaEEArchiveUtilities.INSTANCE.openArchive(referencedComponent);
                String sPath = reference.getArchiveName();
                String srtp = reference.getRuntimePath().toString();
                if (srtp.startsWith("/")) {
                    srtp = srtp.substring(1);
                }
                if ((spt = String.valueOf(srtp) + '/' + sPath).startsWith("/")) {
                    spt = spt.substring(1);
                }
                nestedModuleArchive.setPath((IPath)new Path(spt));
                nestedModuleArchive.setArchive(this.archive);
                this.filesHolder.addFile((IArchiveResource)nestedModuleArchive);
                if (referencedComponent.isBinary()) {
                    File diskFile = null;
                    diskFile = ((VirtualArchiveComponent)referencedComponent).getUnderlyingDiskFile();
                    if (!diskFile.exists()) {
                        IFile wbFile = ((VirtualArchiveComponent)referencedComponent).getUnderlyingWorkbenchFile();
                        diskFile = new File(wbFile.getLocation().toOSString());
                    }
                    this.binaryResourcesToDiskFiles.put((IArchiveResource)nestedModuleArchive, diskFile);
                } else {
                    IArchiveLoadAdapter nestedLoadAdapter;
                    if (nestedModuleArchive.getType() == 2 && (nestedLoadAdapter = nestedModuleArchive.getLoadAdapter()) instanceof ComponentArchiveLoadAdapter) {
                        ((ComponentArchiveLoadAdapter)nestedLoadAdapter).setExportSource(this.isExportSource());
                    }
                    JavaEEQuickPeek quickPeek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(nestedModuleArchive);
                    switch (quickPeek.getType()) {
                        case 0: 
                        case 2: 
                        case 4: {
                            ((ComponentArchiveLoadAdapter)nestedModuleArchive.getLoadAdapter()).setIncludeClasspathComponents(this.includeClasspathComponents);
                            this.addClasspathComponentDependencies(referencedComponent);
                        }
                    }
                }
            }
            catch (ArchiveOpenFailureException e) {
                ArchiveUtil.warn((Throwable)e);
            }
            ++i;
        }
    }

    private void addClasspathComponentDependencies(IVirtualComponent referencedComponent) {
        if (this.includeClasspathComponents && referencedComponent instanceof J2EEModuleVirtualComponent) {
            IVirtualReference[] cpRefs = ((J2EEModuleVirtualComponent)referencedComponent).getJavaClasspathReferences();
            int j = 0;
            while (j < cpRefs.length) {
                IVirtualReference ref = cpRefs[j];
                if (ref.getRuntimePath().equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH) && ref.getReferencedComponent() instanceof ClasspathDependencyVirtualComponent) {
                    ClasspathDependencyVirtualComponent comp = (ClasspathDependencyVirtualComponent)ref.getReferencedComponent();
                    File cpEntryFile = comp.getUnderlyingDiskFile();
                    if (!cpEntryFile.exists()) {
                        IFile wbFile = comp.getUnderlyingWorkbenchFile();
                        cpEntryFile = new File(wbFile.getLocation().toOSString());
                    }
                    this.addExternalFile((IPath)new Path(ref.getArchiveName()), cpEntryFile);
                }
                ++j;
            }
        }
    }

    @Override
    protected IPath getDefaultModelObjectPath() {
        return new Path("META-INF/application.xml");
    }
}

