/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.tests;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.TestWorkspace;

public class ModuleCoreAPIFVTTest
extends TestCase {
    private static final Class IFOLDER_CLASS = IVirtualFolder.class;
    private static final Class IFILE_CLASS = IVirtualFile.class;
    private final Map virtualResourceTree = new HashMap();
    private static final Map IGNORE = new HashMap();

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ModuleCoreAPIFVTTest.class);
        return suite;
    }

    public ModuleCoreAPIFVTTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setupNavigateComponentTest();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tearDownCreateNewModuleTest();
        this.tearDownCreateLinkTest();
    }

    public void tearDownCreateNewModuleTest() throws Exception {
        IFolder rootFolder = TestWorkspace.getTargetProject().getFolder("TestVirtualAPI");
        if (rootFolder.exists()) {
            rootFolder.delete(5, null);
        }
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)TestWorkspace.getTargetProject());
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            if (wbComponent != null) {
                ComponentResource[] componentResources = wbComponent.findResourcesByRuntimePath((IPath)new Path("/"));
                int i = 0;
                while (i < componentResources.length) {
                    wbComponent.getResources().remove((Object)componentResources[i]);
                    ++i;
                }
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.save(null);
                moduleCore.dispose();
            }
        }
    }

    public void setupNavigateComponentTest() throws Exception {
        TestWorkspace.init();
        Path images = new Path("images");
        this.virtualResourceTree.put(images, new HashMap());
        Path jsps = new Path("jsps");
        this.virtualResourceTree.put(jsps, new HashMap());
        this.virtualResourceTree.put(new Path("META-INF"), new HashMap());
        Path WEB_INF = new Path("WEB-INF");
        this.virtualResourceTree.put(WEB_INF, new HashMap());
        this.virtualResourceTree.put(new Path("TestFile1.txt"), null);
        this.virtualResourceTree.put(new Path("TestFile2.txt"), null);
        ((Map)this.virtualResourceTree.get(images)).put(new Path("icon.gif"), null);
        ((Map)this.virtualResourceTree.get(jsps)).put(new Path("TestJsp1.jsp"), null);
        ((Map)this.virtualResourceTree.get(jsps)).put(new Path("TestJsp2.jsp"), null);
        ((Map)this.virtualResourceTree.get(jsps)).put(new Path("TestJsp3.jsp"), null);
        ((Map)this.virtualResourceTree.get(WEB_INF)).put(new Path("web.xml"), null);
        ((Map)this.virtualResourceTree.get(WEB_INF)).put(new Path("classes"), IGNORE);
        ((Map)this.virtualResourceTree.get(WEB_INF)).put(new Path("lib"), new HashMap());
    }

    public void tearDownCreateLinkTest() throws Exception {
        IFolder module2Images = TestWorkspace.getTargetProject().getFolder((IPath)new Path("/WebModule2/images"));
        if (module2Images.exists()) {
            module2Images.delete(5, null);
        }
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)TestWorkspace.getTargetProject());
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            ComponentResource[] componentResources = wbComponent.findResourcesByRuntimePath((IPath)new Path("/images"));
            int i = 0;
            while (i < componentResources.length) {
                wbComponent.getResources().remove((Object)componentResources[i]);
                ++i;
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.save(null);
                moduleCore.dispose();
            }
        }
    }

    public void assertTree(Map resourceTree, IVirtualFolder virtualFolder) throws Exception {
        this.assertTree(resourceTree, virtualFolder, "");
    }

    public void assertTree(Map resourceTree, IVirtualFolder virtualFolder, String indent) throws Exception {
        IVirtualResource[] members = virtualFolder.members();
        ModuleCoreAPIFVTTest.assertEquals((String)("The number of resources contained by \"" + virtualFolder.getProjectRelativePath() + "\""), (int)resourceTree.size(), (int)members.length);
        int i = 0;
        while (i < members.length) {
            System.out.println(String.valueOf(indent) + members[i]);
            Path relativePath = new Path(members[i].getName());
            Map subTree = (Map)resourceTree.get(relativePath);
            if (subTree != null) {
                this.assertType(members[i], IFOLDER_CLASS);
                if (subTree != IGNORE) {
                    this.assertTree(subTree, (IVirtualFolder)members[i], String.valueOf(indent) + "\t");
                }
            } else {
                this.assertType(members[i], IFILE_CLASS);
            }
            ++i;
        }
    }

    public void assertType(IVirtualResource resource, Class type) {
        ModuleCoreAPIFVTTest.assertTrue((String)("Expected a(n) " + type.getName() + " for member: " + resource.getProjectRelativePath()), (boolean)type.isInstance(resource));
    }

    public void testNavigateComponent() throws Exception {
        IVirtualComponent component = ComponentCore.createComponent((IProject)TestWorkspace.getTargetProject(), (String)"WebModule1");
        IVirtualFolder rootFolder = component.getRootFolder();
        rootFolder.getFolder((IPath)new Path("/"));
    }

    public void testCreateWebModule() throws Exception {
    }

    private boolean isDuplicated(WorkbenchComponent wbComponent, IPath runtimePath) {
        URI runtimeURI = URI.createURI((String)runtimePath.toString());
        boolean found = false;
        EList resourceList = wbComponent.getResources();
        for (ComponentResource resource : resourceList) {
            if (!resource.getRuntimePath().equals((Object)runtimeURI)) continue;
            if (found) {
                return true;
            }
            found = true;
        }
        return false;
    }
}

