/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etools.common.tests.xml;

import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DomComparitor {
    private static HashSet attributeList;

    public static String compareDoms(InputSource source1, InputSource source2, HashSet ignorableAtts, EntityResolver entityResolver) throws Exception {
        return null;
    }

    public static String compareDoms(InputSource source1, InputSource source2, HashSet ignorableAtts) throws Exception {
        return DomComparitor.compareDoms(source1, source2, ignorableAtts, null);
    }

    public static String compareDoms(InputSource source1, InputSource source2) throws Exception {
        return DomComparitor.compareDoms(source1, source2, null);
    }

    public static String compareNodes(Node node1, Node node2) throws Exception {
        if (node1 != null && node2 == null || node1 == null && node2 != null) {
            return DomComparitor.nullNodeEncountered(node1, node2);
        }
        if (node1.getNodeType() != node2.getNodeType()) {
            return DomComparitor.mismatch("Node.getNodeType() " + node1.getNodeType() + " " + node2.getNodeType(), node1, node2);
        }
        if (node1.getNodeName() != node2.getNodeName()) {
            return DomComparitor.mismatch("Node.getNodeName() <" + node1.getNodeName() + "> <" + node2.getNodeName() + ">", node1, node2);
        }
        if (node1.getNodeValue() != null || node2.getNodeValue() != null) {
            if (node1.getNodeValue() == null) {
                return DomComparitor.mismatch("Node.getNodeValue() node A is null", node1, node2);
            }
            if (node2.getNodeValue() == null) {
                return DomComparitor.mismatch("Node.getNodeValue() node B is null", node1, node2);
            }
            if (!node1.getNodeValue().trim().equals(node2.getNodeValue().trim())) {
                return DomComparitor.mismatch("Node.getNodeValue() <" + node1.getNodeValue() + "> <" + node2.getNodeValue() + ">", node1, node2);
            }
        }
        switch (node1.getNodeType()) {
            case 3: 
            case 4: {
                CharacterData cdata1 = (CharacterData)node1;
                CharacterData cdata2 = (CharacterData)node2;
                if (cdata1.getData().trim().equals(cdata2.getData().trim())) break;
                return DomComparitor.mismatch("CharacterData.getData() " + cdata1.getData() + " " + cdata2.getData(), node1, node2);
            }
            case 2: {
                Attr attr1 = (Attr)node1;
                Attr attr2 = (Attr)node2;
                if (!attr1.getName().equals(attr2.getName())) {
                    return DomComparitor.mismatch("Attr.getName() " + attr1.getName() + " " + attr2.getName(), node1, node2);
                }
                if (!attr1.getValue().equals(attr2.getValue())) {
                    return DomComparitor.mismatch("Attr.getValue() " + attr1.getValue() + " " + attr2.getValue(), node1, node2);
                }
                if (attr1.getSpecified() == attr2.getSpecified()) break;
                return DomComparitor.mismatch("Attr.getSpecified() " + attr1.getSpecified() + " " + attr2.getSpecified(), node1, node2);
            }
            case 9: {
                Document doc1 = (Document)node1;
                Document doc2 = (Document)node2;
                String result = DomComparitor.compareNodes(doc1.getDoctype(), doc2.getDoctype());
                if (result == null) break;
                return result;
            }
            case 10: {
                DocumentType docType1 = (DocumentType)node1;
                DocumentType docType2 = (DocumentType)node2;
                if (docType1.getPublicId().equals(docType2.getPublicId())) break;
                return DomComparitor.mismatch("DocumentType.getPublicId() " + docType1.getPublicId() + " " + docType2.getPublicId(), node1, node2);
            }
            case 7: {
                ProcessingInstruction cfr_ignored_0 = (ProcessingInstruction)node1;
                ProcessingInstruction cfr_ignored_1 = (ProcessingInstruction)node2;
                break;
            }
            case 11: {
                DocumentFragment cfr_ignored_2 = (DocumentFragment)node1;
                DocumentFragment cfr_ignored_3 = (DocumentFragment)node2;
                break;
            }
        }
        NamedNodeMap attributes1 = node1.getAttributes();
        NamedNodeMap attributes2 = node2.getAttributes();
        if (attributes1 != null && attributes2 != null) {
            DomComparitor.ignoreAttributes(attributes1, attributes2);
            if (attributes1.getLength() != attributes2.getLength()) {
                return DomComparitor.mismatch("getAttributes().getLength() " + attributes1.getLength() + " " + attributes2.getLength(), node1, node2);
            }
            int i = 0;
            while (i < attributes1.getLength()) {
                Attr attr2;
                Attr attr1 = (Attr)attributes1.item(i);
                String results = DomComparitor.compareNodes(attr1, attr2 = (Attr)attributes2.item(i));
                if (results != null) {
                    return results;
                }
                ++i;
            }
        } else if (attributes1 != null || attributes2 != null) {
            return DomComparitor.mismatch("getAttributes() null", node1, node2);
        }
        ArrayList children1 = DomComparitor.getAsArrayList(node1.getChildNodes());
        ArrayList children2 = DomComparitor.getAsArrayList(node2.getChildNodes());
        DomComparitor.ignoreComments(children1);
        DomComparitor.ignoreComments(children2);
        DomComparitor.ignoreEmptyTextNodes(children1);
        DomComparitor.ignoreEmptyTextNodes(children2);
        if (children1.size() != children2.size()) {
            return DomComparitor.mismatch("Node.hasChildNodes() " + children1.size() + " " + children2.size(), node1, node2);
        }
        int i = 0;
        while (i < children1.size()) {
            Node child2;
            Node child1 = (Node)children1.get(i);
            String results = DomComparitor.compareNodes(child1, child2 = (Node)children2.get(i));
            if (results != null) {
                return results;
            }
            ++i;
        }
        return null;
    }

    private static ArrayList getAsArrayList(NodeList originalList) {
        ArrayList<Node> newList = new ArrayList<Node>();
        if (originalList != null) {
            int i = 0;
            while (i < originalList.getLength()) {
                newList.add(originalList.item(i));
                ++i;
            }
        }
        return newList;
    }

    private static void ignoreComments(ArrayList list) {
        ArrayList<Node> toRemove = new ArrayList<Node>();
        int i = 0;
        while (i < list.size()) {
            Node node = (Node)list.get(i);
            if (node.getNodeType() == 8) {
                toRemove.add(node);
            }
            ++i;
        }
        i = 0;
        while (i < toRemove.size()) {
            list.remove(toRemove.get(i));
            ++i;
        }
    }

    private static void ignoreEmptyTextNodes(ArrayList list) {
        ArrayList<Node> toRemove = new ArrayList<Node>();
        int i = 0;
        while (i < list.size()) {
            Node node = (Node)list.get(i);
            if (node.getNodeType() == 3 && (node.getNodeValue() == null || node.getNodeValue().trim().equals(""))) {
                toRemove.add(node);
            }
            ++i;
        }
        i = 0;
        while (i < toRemove.size()) {
            list.remove(toRemove.get(i));
            ++i;
        }
    }

    private static void ignoreAttributes(NamedNodeMap attributes1, NamedNodeMap attributes2) {
        if (attributeList != null) {
            for (String ignore : attributeList) {
                if (attributes1.getNamedItem(ignore) != null) {
                    attributes1.removeNamedItem(ignore);
                }
                if (attributes2.getNamedItem(ignore) == null) continue;
                attributes2.removeNamedItem(ignore);
            }
        }
    }

    public static String nullNodeEncountered(Node node1, Node node2) {
        String message = "Null node encountered";
        Node nonNullNode = node1 == null ? node2 : node1;
        char source = node1 == null ? (char)'B' : 'A';
        while (nonNullNode != null) {
            message = String.valueOf(message) + source + nonNullNode.getNodeName() + "\n";
            nonNullNode = nonNullNode.getParentNode();
        }
        return message;
    }

    public static String nodeNotCompared(Node node) {
        String message = "Node node compared:";
        while (node != null) {
            message = String.valueOf(message) + node.getNodeName() + "\n";
            node = node.getParentNode();
        }
        return message;
    }

    public static String mismatch(String mismatchtype, Node node1, Node node2) throws Exception {
        String message = "Nodes A and B do not match because of node." + mismatchtype + "\n";
        while (node1 != null && node2 != null) {
            message = String.valueOf(message) + "A:" + node1.getNodeName() + "\n";
            message = String.valueOf(message) + "B:" + node2.getNodeName() + "\n";
            node1 = node1.getParentNode();
            node2 = node2.getParentNode();
        }
        return message;
    }
}

