/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.IVirtualContainerAPITest;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.TestWorkspace;

public class IVirtualComponentAPITest
extends IVirtualContainerAPITest {
    private IVirtualComponent virtualComponent;
    private WorkbenchComponent workbenchComponent;
    private StructureEdit structureEdit;

    public IVirtualComponentAPITest(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new IVirtualComponentAPITest("testGetReferences"));
        return suite;
    }

    protected void doSetup() throws Exception {
        this.virtualComponent = ComponentCore.createComponent((IProject)TestWorkspace.TEST_PROJECT, (String)"WebModule1");
        this.structureEdit = StructureEdit.getStructureEditForRead((IProject)TestWorkspace.TEST_PROJECT);
        this.workbenchComponent = this.structureEdit.getComponent();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.structureEdit != null) {
            this.structureEdit.dispose();
        }
    }

    public void testGetName() {
        this.virtualComponent.getName();
    }

    public void testGetMetaProperties() {
        this.virtualComponent.getMetaProperties();
    }

    public void testGetMetaResources() {
        this.virtualComponent.getMetaResources();
    }

    public void testSetMetaResources() {
        IPath[] metaresources = new IPath[]{new Path("/test")};
        this.virtualComponent.setMetaResources(metaresources);
    }

    public void testGetResources() {
        String resource = "/test";
        IVirtualFolder rootFolder = this.virtualComponent.getRootFolder();
        rootFolder.getResources(resource);
    }

    public void testGetReferences() {
        IVirtualReference[] references = this.virtualComponent.getReferences();
        int i = 0;
        while (i < references.length) {
            this.assertReference(references[i]);
            ++i;
        }
    }

    private void assertReference(IVirtualReference reference) {
        EList referencedComponents = this.workbenchComponent.getReferencedComponents();
        ReferencedComponent referencedComponent = null;
        String componentName = null;
        int i = 0;
        while (i < referencedComponents.size()) {
            referencedComponent = (ReferencedComponent)referencedComponents.get(i);
            try {
                componentName = ModuleURIUtil.getDeployedName((URI)referencedComponent.getHandle());
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            if (componentName != null && componentName.equals(reference.getReferencedComponent().getName())) {
                IVirtualComponentAPITest.assertEquals((String)"The runtime paths must match.", (Object)referencedComponent.getRuntimePath(), (Object)reference.getRuntimePath());
                IVirtualComponentAPITest.assertEquals((String)"The workbench component should match the enclosing component.", (Object)this.virtualComponent, (Object)reference.getEnclosingComponent());
                IVirtualComponentAPITest.assertEquals((String)"The dependencyTypes should match.", (int)referencedComponent.getDependencyType().getValue(), (int)reference.getDependencyType());
                URI actualHandle = ModuleURIUtil.fullyQualifyURI((IProject)reference.getReferencedComponent().getProject());
                IVirtualComponentAPITest.assertEquals((String)"The handles should match.", (Object)referencedComponent.getHandle(), (Object)actualHandle);
                return;
            }
            ++i;
        }
        IVirtualComponentAPITest.fail((String)("A matching reference was not found for " + reference.getRuntimePath()));
    }

    public void testSetReferences() {
    }
}

