/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.widgets;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DataContainerContentProvider
implements ITreeContentProvider {
    private boolean showClosedProjects = true;
    private String[] fileFilter = new String[0];
    private boolean showFiles = true;
    private String[] projectNatureFilter = new String[0];
    private String[] filesToExclude = new String[0];

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        IContainer container;
        Object[] theChildren = new Object[]{};
        if (element instanceof IWorkspace) {
            int i;
            IProject[] allProjects = ((IWorkspace)element).getRoot().getProjects();
            if (this.showClosedProjects) {
                theChildren = allProjects;
            } else {
                ArrayList<IProject> accessibleProjects = new ArrayList<IProject>();
                i = 0;
                while (i < allProjects.length) {
                    if (allProjects[i].isOpen()) {
                        accessibleProjects.add(allProjects[i]);
                    }
                    ++i;
                }
                theChildren = accessibleProjects.toArray();
            }
            if (this.projectNatureFilter.length > 0) {
                ArrayList<Object> filteredProjects = new ArrayList<Object>();
                i = 0;
                while (i < theChildren.length) {
                    try {
                        boolean isProjectAllowed = false;
                        int natureIndex = 0;
                        while (natureIndex < this.projectNatureFilter.length) {
                            if (((IProject)theChildren[i]).isNatureEnabled(this.projectNatureFilter[natureIndex])) {
                                isProjectAllowed = true;
                            }
                            if (isProjectAllowed) {
                                filteredProjects.add(theChildren[i]);
                            }
                            ++natureIndex;
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                theChildren = filteredProjects.toArray();
            }
        } else if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
            try {
                ArrayList<IResource> children = new ArrayList<IResource>();
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    if (members[i].getType() != 1) {
                        children.add(members[i]);
                    }
                    if (this.showFiles && members[i].getType() == 1 && this.satisfiesFileFilter((IFile)members[i]) && this.satifiesExcludedFiles((IFile)members[i])) {
                        children.add(members[i]);
                    }
                    ++i;
                }
                theChildren = children.toArray();
            }
            catch (CoreException coreException) {}
        }
        return theChildren;
    }

    private boolean satisfiesFileFilter(IFile resource) {
        boolean isSatisfied = false;
        if (this.fileFilter == null || this.fileFilter.length == 0) {
            isSatisfied = true;
        } else {
            int index = 0;
            while (index < this.fileFilter.length) {
                if (resource.getFileExtension() != null && this.fileFilter[index].toLowerCase().equals(resource.getFileExtension().toLowerCase())) {
                    isSatisfied = true;
                }
                ++index;
            }
        }
        return isSatisfied;
    }

    private boolean satifiesExcludedFiles(IFile resource) {
        boolean isSatisfied = false;
        if (this.filesToExclude == null || this.filesToExclude.length == 0) {
            isSatisfied = true;
        } else {
            boolean isExcluded = false;
            int index = 0;
            while (index < this.filesToExclude.length) {
                if (this.filesToExclude[index].equals(resource.getFullPath().toString())) {
                    isExcluded = true;
                }
                ++index;
            }
            if (!isExcluded) {
                isSatisfied = true;
            }
        }
        return isSatisfied;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }

    public void showFiles(boolean show) {
        this.showFiles = show;
    }

    public void setFileFilter(String[] filter) {
        this.fileFilter = filter;
    }

    public void setProjectNatureFilter(String[] naturesToShow) {
        this.projectNatureFilter = naturesToShow;
    }

    public void setExcludedFiles(String[] filesToExclude) {
        this.filesToExclude = filesToExclude;
    }
}

