/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.explorer.providers.content.virtual;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;

public abstract class VirtualNode
implements IVirtualNode {
    private String name;
    private String displayName;
    private Object parent;
    private List children = new LinkedList();

    public VirtualNode(String name, String displayName, Object parent) {
        this.name = name;
        this.displayName = displayName;
        this.parent = parent;
        if (parent != null && parent instanceof IVirtualNode) {
            ((IVirtualNode)parent).addChildren(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.name;
    }

    public Object getParent() {
        return this.parent;
    }

    protected List getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Object[] getChildrenArray() {
        return this.children.toArray(new Object[this.children.size()]);
    }

    public void addChildren(Object child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public void removeChildren(Object child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
        }
    }

    public void removeAllChildren() {
        this.children.removeAll(this.children);
    }

    public boolean supports(EClass type) {
        return false;
    }

    public void addChildren(Collection collection) {
        this.children.removeAll(this.children);
        this.children.addAll(collection);
    }

    public ImageDescriptor[] getCreateImageDescriptor() {
        return null;
    }

    public String[] getCreateLabel() {
        return null;
    }

    public EClass[] getCreateType() {
        return null;
    }

    public boolean shouldDisplayAdd() {
        return false;
    }

    public boolean shouldDisplayCreate() {
        return false;
    }
}

