/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.NullMemento;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.CodedStreamCreator;
import org.eclipse.wst.sse.core.internal.encoding.ContentBasedPreferenceGateway;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedOutputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.osgi.framework.Bundle;

public class ModelManagerImpl
implements IModelManager {
    private Exception debugException = null;
    private static ModelManagerImpl instance;
    private static final int READ_BUFFER_SIZE = 4096;
    private final ReadEditType EDIT = new ReadEditType("edit");
    private Dictionary fManagedObjects;
    private ModelHandlerRegistry fModelHandlerRegistry;
    private int modelManagerStateChanging;
    private final ReadEditType READ = new ReadEditType("read");
    static /* synthetic */ Class class$0;

    public static synchronized IModelManager getInstance() {
        if (instance == null) {
            instance = new ModelManagerImpl();
        }
        return instance;
    }

    ModelManagerImpl() {
        this.fManagedObjects = new Hashtable();
    }

    private IStructuredModel _commonCreateModel(InputStream inputStream, String id, IModelHandler handler, URIResolver resolver, ReadEditType rwType, EncodingRule encodingRule) throws IOException {
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        IStructuredModel model = null;
        if (sharedObject == null) {
            try {
                model = this._commonCreateModel(id, handler, resolver);
                IModelLoader loader = handler.getModelLoader();
                loader.load(Utilities.getMarkSupportedStream(inputStream), model, encodingRule);
            }
            catch (ResourceInUse e) {
                this.handleProgramError(e);
            }
            if (model != null) {
                sharedObject = new SharedObject(model);
                this._initCount(sharedObject, rwType);
                this.fManagedObjects.put(id, sharedObject);
            }
        } else {
            this._incrCount(sharedObject, rwType);
        }
        if (sharedObject == null) {
            this.debugException = new Exception("instance only for stack trace");
            Logger.logException("Program Error: no model recorded for id " + id, this.debugException);
        }
        return sharedObject.theSharedModel;
    }

    private IStructuredModel _commonCreateModel(InputStream inputStream, String id, IModelHandler handler, URIResolver resolver, ReadEditType rwType, String encoding, String lineDelimiter) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Program Error: id may not be null");
        }
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        IStructuredModel model = null;
        if (sharedObject == null) {
            try {
                model = this._commonCreateModel(id, handler, resolver);
                IModelLoader loader = handler.getModelLoader();
                if (inputStream == null) {
                    Logger.log(2, "model was requested for id " + id + " without a content InputStream");
                }
                loader.load(id, Utilities.getMarkSupportedStream(inputStream), model, encoding, lineDelimiter);
            }
            catch (ResourceInUse e) {
                this.handleProgramError(e);
            }
            if (model != null) {
                sharedObject = new SharedObject(model);
                this._initCount(sharedObject, rwType);
                this.fManagedObjects.put(id, sharedObject);
            }
        } else {
            this._incrCount(sharedObject, rwType);
        }
        Assert.isNotNull(sharedObject, "Program Error: no model recorded for id " + id);
        return sharedObject.theSharedModel;
    }

    private IStructuredModel _commonCreateModel(String id, IModelHandler handler, URIResolver resolver) throws ResourceInUse {
        IModelLoader loader = handler.getModelLoader();
        IStructuredModel result = loader.createModel();
        if (id != null) {
            result.setId(id);
        }
        result.setModelHandler(handler);
        result.setResolver(resolver);
        result.setBaseLocation(id);
        if (resolver != null) {
            resolver.setFileBaseLocation(id);
        }
        this.addFactories(result, handler);
        return result;
    }

    /*
     * Exception decompiling
     */
    private IStructuredModel _commonGetModel(IFile iFile, ReadEditType rwType, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 90->93)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IStructuredModel _commonGetModel(IFile iFile, ReadEditType rwType, String encoding, String lineDelimiter) throws UnsupportedEncodingException, IOException, CoreException {
        String id = this.calculateId(iFile);
        IModelHandler handler = this.calculateType(iFile);
        URIResolver resolver = this.calculateURIResolver(iFile);
        IStructuredModel model = this._commonGetModel(iFile, id, handler, resolver, rwType, encoding, lineDelimiter);
        return model;
    }

    private IStructuredModel _commonGetModel(IFile file, String id, IModelHandler handler, URIResolver resolver, ReadEditType rwType, String encoding, String lineDelimiter) throws IOException, CoreException {
        if (id == null) {
            throw new IllegalArgumentException("Program Error: id may not be null");
        }
        IStructuredModel model = null;
        if (file != null && file.exists()) {
            SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
            if (sharedObject == null) {
                model = FileBufferModelManager.getInstance().getModel(file);
                if (model != null) {
                    sharedObject = new SharedObject(model);
                    this._initCount(sharedObject, rwType);
                    this.fManagedObjects.put(id, sharedObject);
                }
            } else {
                this._incrCount(sharedObject, rwType);
            }
            if (sharedObject != null) {
                model = sharedObject.theSharedModel;
            }
        }
        return model;
    }

    private SharedObject _commonNewModel(IFile iFile, boolean force) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IStructuredModel aSharedModel = null;
        if (iFile.exists() && !force) {
            throw new ResourceAlreadyExists();
        }
        String id = this.calculateId(iFile);
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null && !force) {
            throw new ResourceInUse();
        }
        aSharedModel = FileBufferModelManager.getInstance().getModel(iFile);
        aSharedModel.setNewState(true);
        sharedObject = this.addToCache(id, aSharedModel);
        aSharedModel.resetSynchronizationStamp((IResource)iFile);
        return sharedObject;
    }

    public IStructuredModel _getModelFor(IStructuredDocument document, ReadEditType accessType) {
        IStructuredModel model = null;
        String id = FileBufferModelManager.getInstance().calculateId(document);
        Assert.isNotNull(id, "unknown IStructuredDocument " + document);
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            sharedObject = (SharedObject)this.fManagedObjects.get(id);
            this._incrCount(sharedObject, accessType);
            model = sharedObject.theSharedModel;
        } else {
            model = FileBufferModelManager.getInstance().getModel(document);
            sharedObject = new SharedObject(model);
            this._initCount(sharedObject, accessType);
            this.fManagedObjects.put(id, sharedObject);
        }
        return model;
    }

    private void _incrCount(SharedObject sharedObject, ReadEditType type) {
        if (type == this.READ) {
            ++sharedObject.referenceCountForRead;
        } else if (type == this.EDIT) {
            ++sharedObject.referenceCountForEdit;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void _initCount(SharedObject sharedObject, ReadEditType type) {
        if (type == this.READ) {
            sharedObject.referenceCountForRead = 1;
        } else if (type == this.EDIT) {
            sharedObject.referenceCountForEdit = 1;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void addFactories(IStructuredModel model, IModelHandler handler) {
        Assert.isNotNull(model, "model can not be null");
        FactoryRegistry registry = model.getFactoryRegistry();
        Assert.isNotNull(registry, "Factory Registry can not be null");
        List factoryList = handler.getAdapterFactories();
        this.addFactories(model, factoryList);
    }

    private void addFactories(IStructuredModel model, List factoryList) {
        Assert.isNotNull(model, "model can not be null");
        FactoryRegistry registry = model.getFactoryRegistry();
        Assert.isNotNull(registry, "Factory Registry can not be null");
        if (factoryList != null) {
            Iterator iterator = factoryList.iterator();
            while (iterator.hasNext()) {
                INodeAdapterFactory factory = (INodeAdapterFactory)iterator.next();
                registry.addFactory(factory);
            }
        }
    }

    private SharedObject addToCache(String id, IStructuredModel aSharedModel) {
        SharedObject sharedObject = new SharedObject(aSharedModel);
        this.fManagedObjects.put(id, sharedObject);
        return sharedObject;
    }

    public String calculateId(IFile file) {
        return FileBufferModelManager.getInstance().calculateId(file);
    }

    private IModelHandler calculateType(IFile iFile) throws CoreException {
        ModelHandlerRegistry cr = this.getModelHandlerRegistry();
        IModelHandler cd = cr.getHandlerFor(iFile);
        return cd;
    }

    private IModelHandler calculateType(String filename, InputStream inputStream) throws IOException {
        ModelHandlerRegistry cr = this.getModelHandlerRegistry();
        IModelHandler cd = cr.getHandlerFor(filename, inputStream);
        return cd;
    }

    private URIResolver calculateURIResolver(IFile file) {
        URIResolver resolver;
        IProject project = file.getProject();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.core.internal.util.URIResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resolver = (URIResolver)project.getAdapter((Class)clazz)) == null) {
            resolver = new ProjectResolver(project);
        }
        resolver.setFileBaseLocation(file.getLocation().toString());
        return resolver;
    }

    private void convertLineDelimiters(IDocument document, IFile iFile) throws CoreException {
        String contentTypeId = this.calculateType(iFile).getAssociatedContentTypeId();
        String endOfLineCode = ContentBasedPreferenceGateway.getPreferencesString(contentTypeId, "endOfLineCode");
        if (endOfLineCode != null && endOfLineCode.length() > 0) {
            String lineDelimiterToUse = System.getProperty("line.separator");
            if (endOfLineCode.equals("EOL_Mac")) {
                lineDelimiterToUse = "\r";
            } else if (endOfLineCode.equals("EOL_Unix")) {
                lineDelimiterToUse = "\n";
            } else if (endOfLineCode.equals("EOL_Windows")) {
                lineDelimiterToUse = "\r\n";
            }
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            int lineCount = document.getNumberOfLines();
            try {
                int i = 0;
                while (i < lineCount) {
                    String currentLineDelimiter;
                    IRegion lineInfo = document.getLineInformation(i);
                    int lineStartOffset = lineInfo.getOffset();
                    int lineLength = lineInfo.getLength();
                    int lineEndOffset = lineStartOffset + lineLength;
                    if (i < lineCount - 1 && (currentLineDelimiter = document.getLineDelimiter(i)) != null && currentLineDelimiter.compareTo(lineDelimiterToUse) != 0) {
                        multiTextEdit.addChild((TextEdit)new ReplaceEdit(lineEndOffset, currentLineDelimiter.length(), lineDelimiterToUse));
                    }
                    ++i;
                }
                if (multiTextEdit.getChildrenSize() > 0) {
                    multiTextEdit.apply(document);
                }
            }
            catch (BadLocationException exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
    }

    private IStructuredModel copy(IStructuredModel model, String newId) throws ResourceInUse {
        IStructuredModel newModel = null;
        IStructuredModel oldModel = model;
        IModelHandler modelHandler = oldModel.getModelHandler();
        IModelLoader loader = modelHandler.getModelLoader();
        newModel = loader.createModel(oldModel);
        newModel.setModelHandler(modelHandler);
        newModel.setResolver(oldModel.getResolver());
        newModel.setModelManager(oldModel.getModelManager());
        newModel.setId(newId);
        String contents = oldModel.getStructuredDocument().getText();
        newModel.getStructuredDocument().setText(this, contents);
        return newModel;
    }

    public synchronized IStructuredModel copyModelForEdit(String oldId, String newId) throws ResourceInUse {
        IStructuredModel newModel = null;
        IStructuredModel model = this.getExistingModel(oldId);
        if (model == null) {
            return null;
        }
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(newId);
        if (sharedObject != null) {
            throw new ResourceInUse();
        }
        newModel = this.copy(model, newId);
        if (newModel != null) {
            sharedObject = new SharedObject(newModel);
            sharedObject.referenceCountForEdit = 1;
            this.fManagedObjects.put(newId, sharedObject);
            this.trace("copied model", newId, sharedObject.referenceCountForEdit);
        }
        return newModel;
    }

    public synchronized IStructuredModel createNewInstance(IStructuredModel oldModel) throws IOException {
        IModelHandler handler = oldModel.getModelHandler();
        IModelLoader loader = handler.getModelLoader();
        IStructuredModel newModel = loader.createModel(oldModel);
        newModel.setModelHandler(handler);
        if (newModel instanceof AbstractStructuredModel) {
            ((AbstractStructuredModel)newModel).setContentTypeIdentifier(oldModel.getContentTypeIdentifier());
        }
        URIResolver oldResolver = oldModel.getResolver();
        newModel.setResolver(oldResolver);
        try {
            newModel.setId("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL");
        }
        catch (ResourceInUse resourceInUse) {}
        newModel.setBaseLocation(null);
        return newModel;
    }

    public synchronized IStructuredDocument createNewStructuredDocumentFor(IFile iFile) throws ResourceAlreadyExists, IOException, CoreException {
        if (iFile.exists()) {
            throw new ResourceAlreadyExists(iFile.getFullPath().toOSString());
        }
        IDocumentLoader loader = null;
        IModelHandler handler = this.calculateType(iFile);
        loader = handler.getDocumentLoader();
        IStructuredDocument result = (IStructuredDocument)loader.createNewStructuredDocument();
        return result;
    }

    public synchronized IStructuredDocument createStructuredDocumentFor(IFile iFile) throws IOException, CoreException {
        if (!iFile.exists()) {
            throw new FileNotFoundException(iFile.getFullPath().toOSString());
        }
        IDocumentLoader loader = null;
        IModelHandler handler = this.calculateType(iFile);
        loader = handler.getDocumentLoader();
        IStructuredDocument result = (IStructuredDocument)loader.createNewStructuredDocument(iFile);
        return result;
    }

    public synchronized IStructuredDocument createStructuredDocumentFor(String contentTypeId) {
        IDocumentLoader loader = null;
        ModelHandlerRegistry cr = this.getModelHandlerRegistry();
        IModelHandler handler = cr.getHandlerForContentTypeId(contentTypeId);
        if (handler == null) {
            Logger.log(4, "Program error: no model handler found for " + contentTypeId);
        }
        loader = handler.getDocumentLoader();
        IStructuredDocument result = (IStructuredDocument)loader.createNewStructuredDocument();
        return result;
    }

    public IStructuredDocument createStructuredDocumentFor(String filename, InputStream inputStream, URIResolver resolver) throws IOException {
        IDocumentLoader loader = null;
        InputStream istream = Utilities.getMarkSupportedStream(inputStream);
        if (istream != null) {
            istream.reset();
        }
        IModelHandler handler = this.calculateType(filename, istream);
        loader = handler.getDocumentLoader();
        IStructuredDocument result = null;
        result = inputStream == null ? (IStructuredDocument)loader.createNewStructuredDocument() : (IStructuredDocument)loader.createNewStructuredDocument(filename, istream);
        return result;
    }

    public synchronized IStructuredDocument createStructuredDocumentFor(String filename, InputStream inputStream, URIResolver resolver, String encoding) throws IOException {
        String content = this.readInputStream(inputStream, encoding);
        IStructuredDocument result = this.createStructuredDocumentFor(filename, content, resolver);
        return result;
    }

    public synchronized IStructuredDocument createStructuredDocumentFor(String filename, String content, URIResolver resolver) throws IOException {
        StringBuffer contentBuffer = new StringBuffer(content);
        IDocumentLoader loader = null;
        IModelHandler handler = this.calculateType(filename, null);
        loader = handler.getDocumentLoader();
        IStructuredDocument result = (IStructuredDocument)loader.createNewStructuredDocument();
        StringBuffer convertedContent = loader.handleLineDelimiter(contentBuffer, result);
        result.setEncodingMemento(new NullMemento());
        result.setText(this, convertedContent.toString());
        return result;
    }

    private IStructuredModel createUnManagedEmptyModelFor(IFile iFile) throws CoreException {
        IStructuredModel result;
        block2: {
            result = null;
            IModelHandler handler = this.calculateType(iFile);
            String id = this.calculateId(iFile);
            URIResolver resolver = this.calculateURIResolver(iFile);
            try {
                result = this._commonCreateModel(id, handler, resolver);
            }
            catch (ResourceInUse resourceInUse) {
                if (!Logger.DEBUG_MODELMANAGER) break block2;
                Logger.log(1, "ModelMangerImpl::createUnManagedStructuredModelFor. Model unexpectedly in use.");
            }
        }
        return result;
    }

    public synchronized IStructuredModel createUnManagedStructuredModelFor(IFile iFile) throws IOException, CoreException {
        IStructuredModel result = null;
        result = this.createUnManagedEmptyModelFor(iFile);
        IDocumentLoader loader = result.getModelHandler().getDocumentLoader();
        IEncodedDocument document = loader.createNewStructuredDocument(iFile);
        result.getStructuredDocument().setText(this, document.get());
        return result;
    }

    public synchronized IStructuredModel createUnManagedStructuredModelFor(String contentTypeId) {
        return this.createUnManagedStructuredModelFor(contentTypeId, null);
    }

    public synchronized IStructuredModel createUnManagedStructuredModelFor(String contentTypeId, URIResolver resolver) {
        IStructuredModel result;
        block2: {
            result = null;
            ModelHandlerRegistry cr = this.getModelHandlerRegistry();
            IModelHandler handler = cr.getHandlerForContentTypeId(contentTypeId);
            try {
                result = this._commonCreateModel("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL", handler, resolver);
            }
            catch (ResourceInUse resourceInUse) {
                if (!Logger.DEBUG_MODELMANAGER) break block2;
                Logger.log(1, "ModelMangerImpl::createUnManagedStructuredModelFor. Model unexpectedly in use.");
            }
        }
        return result;
    }

    private EnumeratedModelIds getEnumeratedModelIds() {
        return new EnumeratedModelIds(this.fManagedObjects);
    }

    private IStructuredModel getExistingModel(Object id) {
        IStructuredModel result = null;
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            result = sharedObject.theSharedModel;
        }
        return result;
    }

    public synchronized IStructuredModel getExistingModelForEdit(IDocument document) {
        IStructuredModel result = null;
        EnumeratedModelIds ids = this.getEnumeratedModelIds();
        while (ids.hasMoreElements()) {
            Object potentialId = ids.nextElement();
            IStructuredModel tempResult = this.getExistingModel(potentialId);
            if (document != tempResult.getStructuredDocument()) continue;
            result = this.getExistingModelForEdit(potentialId);
            break;
        }
        return result;
    }

    public synchronized IStructuredModel getExistingModelForEdit(IFile iFile) {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        String id = this.calculateId(iFile);
        IStructuredModel result = this.getExistingModelForEdit(id);
        return result;
    }

    public synchronized IStructuredModel getExistingModelForEdit(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        IStructuredModel result = null;
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            ++sharedObject.referenceCountForEdit;
            result = sharedObject.theSharedModel;
            this.trace("got existing model for Edit: ", id);
            this.trace("   incremented referenceCountForEdit ", id, sharedObject.referenceCountForEdit);
        }
        return result;
    }

    public synchronized IStructuredModel getExistingModelForRead(IDocument document) {
        IStructuredModel result = null;
        EnumeratedModelIds ids = this.getEnumeratedModelIds();
        while (ids.hasMoreElements()) {
            Object potentialId = ids.nextElement();
            IStructuredModel tempResult = this.getExistingModel(potentialId);
            if (document != tempResult.getStructuredDocument()) continue;
            result = this.getExistingModelForRead(potentialId);
            break;
        }
        return result;
    }

    public synchronized IStructuredModel getExistingModelForRead(IFile iFile) {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        String id = this.calculateId(iFile);
        IStructuredModel result = this.getExistingModelForRead(id);
        return result;
    }

    public synchronized IStructuredModel getExistingModelForRead(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        IStructuredModel result = null;
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            ++sharedObject.referenceCountForRead;
            result = sharedObject.theSharedModel;
        }
        return result;
    }

    public synchronized Enumeration getExistingModelIds() {
        EnumeratedModelIds result = this.getEnumeratedModelIds();
        return result;
    }

    private IFile getFileFor(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String path = model.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)new Path(path));
        return file;
    }

    public synchronized IStructuredModel getModelForEdit(IFile iFile) throws IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.EDIT, null, null);
    }

    public synchronized IStructuredModel getModelForEdit(IFile iFile, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.EDIT, encodingRule);
    }

    public synchronized IStructuredModel getModelForEdit(IFile iFile, String encoding, String lineDelimiter) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.EDIT, encoding, lineDelimiter);
    }

    public synchronized IStructuredModel getModelForEdit(IStructuredDocument document) {
        return this._getModelFor(document, this.EDIT);
    }

    public synchronized IStructuredModel getModelForEdit(Object id, InputStream inputStream, URIResolver resolver) throws UnsupportedEncodingException, IOException {
        Assert.isNotNull(id, "IFile parameter can not be null");
        String stringId = id.toString();
        return this.getModelForEdit(stringId, Utilities.getMarkSupportedStream(inputStream), resolver);
    }

    public synchronized IStructuredModel getModelForEdit(Object id, Object modelType, String encodingName, String lineDelimiter, InputStream inputStream, URIResolver resolver) throws UnsupportedEncodingException, IOException {
        Assert.isNotNull(id, "id parameter can not be null");
        String stringId = id.toString();
        return this.getModelForEdit(stringId, Utilities.getMarkSupportedStream(inputStream), resolver);
    }

    public synchronized IStructuredModel getModelForEdit(String id, InputStream inputStream, URIResolver resolver) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Program Error: id may not be null");
        }
        IStructuredModel result = null;
        InputStream istream = Utilities.getMarkSupportedStream(inputStream);
        IModelHandler handler = this.calculateType(id, istream);
        if (handler != null) {
            result = this._commonCreateModel(istream, id, handler, resolver, this.EDIT, null, null);
        } else {
            Logger.log(1, "no model handler found for id");
        }
        return result;
    }

    public synchronized IStructuredModel getModelForRead(IFile iFile) throws IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.READ, null, null);
    }

    public synchronized IStructuredModel getModelForRead(IFile iFile, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.READ, encodingRule);
    }

    public synchronized IStructuredModel getModelForRead(IFile iFile, String encodingName, String lineDelimiter) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.READ, encodingName, lineDelimiter);
    }

    public synchronized IStructuredModel getModelForRead(IStructuredDocument document) {
        return this._getModelFor(document, this.READ);
    }

    public synchronized IStructuredModel getModelForRead(Object id, InputStream inputStream, URIResolver resolver) throws UnsupportedEncodingException, IOException {
        Assert.isNotNull(id, "id parameter can not be null");
        String stringId = id.toString();
        return this.getModelForRead(stringId, Utilities.getMarkSupportedStream(inputStream), resolver);
    }

    public synchronized IStructuredModel getModelForRead(Object id, Object modelType, String encodingName, String lineDelimiter, InputStream inputStream, URIResolver resolver) throws UnsupportedEncodingException, IOException {
        Assert.isNotNull(id, "id parameter can not be null");
        String stringId = id.toString();
        return this.getModelForRead(stringId, Utilities.getMarkSupportedStream(inputStream), resolver);
    }

    public synchronized IStructuredModel getModelForRead(String id, InputStream inputStream, URIResolver resolver) throws IOException {
        InputStream istream = Utilities.getMarkSupportedStream(inputStream);
        IModelHandler handler = this.calculateType(id, istream);
        IStructuredModel result = null;
        result = this._commonCreateModel(istream, id, handler, resolver, this.READ, null, null);
        return result;
    }

    public ModelHandlerRegistry getModelHandlerRegistry() {
        if (this.fModelHandlerRegistry == null) {
            this.fModelHandlerRegistry = ModelHandlerRegistry.getInstance();
        }
        return this.fModelHandlerRegistry;
    }

    public synchronized IStructuredModel getNewModelForEdit(IFile iFile, boolean force) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        SharedObject sharedObject = this._commonNewModel(iFile, force);
        sharedObject.referenceCountForEdit = 1;
        return sharedObject.theSharedModel;
    }

    public synchronized IStructuredModel getNewModelForRead(IFile iFile, boolean force) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        SharedObject sharedObject = this._commonNewModel(iFile, force);
        sharedObject.referenceCountForRead = 1;
        return sharedObject.theSharedModel;
    }

    public synchronized int getReferenceCount(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            count = sharedObject.referenceCountForRead + sharedObject.referenceCountForEdit;
        }
        return count;
    }

    public synchronized int getReferenceCountForEdit(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            count = sharedObject.referenceCountForEdit;
        }
        return count;
    }

    public synchronized int getReferenceCountForRead(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            count = sharedObject.referenceCountForRead;
        }
        return count;
    }

    private void handleConvertLineDelimiters(IStructuredDocument structuredDocument, IFile iFile, EncodingRule encodingRule, EncodingMemento encodingMemento) throws CoreException, MalformedOutputExceptionWithDetail, UnsupportedEncodingException {
        if (structuredDocument.getNumberOfLines() > 1) {
            this.convertLineDelimiters(structuredDocument, iFile);
        }
    }

    private void handleProgramError(Throwable t) {
        Logger.logException("Impossible Program Error", t);
    }

    public synchronized boolean isShared(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        boolean result = false;
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            count = sharedObject.referenceCountForRead + sharedObject.referenceCountForEdit;
        }
        result = count > 1;
        return result;
    }

    public synchronized boolean isSharedForEdit(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        boolean result = false;
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            count = sharedObject.referenceCountForEdit;
        }
        result = count > 1;
        return result;
    }

    public synchronized boolean isSharedForRead(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        boolean result = false;
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            count = sharedObject.referenceCountForRead;
        }
        result = count > 1;
        return result;
    }

    public synchronized boolean isStateChanging() {
        return this.modelManagerStateChanging > 0;
    }

    public synchronized void moveModel(Object oldId, Object newId) {
        Assert.isNotNull(oldId, "id parameter can not be null");
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(oldId);
        if (sharedObject != null) {
            this.fManagedObjects.remove(oldId);
            this.fManagedObjects.put(newId, sharedObject);
        }
    }

    private String readInputStream(InputStream inputStream, String ianaEncodingName) throws UnsupportedEncodingException, IOException {
        String allText = null;
        if (ianaEncodingName != null && ianaEncodingName.length() != 0) {
            String enc = CodedIO.getAppropriateJavaCharset(ianaEncodingName);
            if (enc == null) {
                enc = ianaEncodingName;
            }
            allText = this.readInputStream(new InputStreamReader(inputStream, enc));
        } else {
            allText = this.readInputStream(new InputStreamReader(inputStream));
        }
        return allText;
    }

    private String readInputStream(InputStreamReader inputStream) throws IOException {
        int numRead = 0;
        StringBuffer buffer = new StringBuffer();
        char[] tBuff = new char[4096];
        while ((numRead = inputStream.read(tBuff, 0, tBuff.length)) != -1) {
            buffer.append(tBuff, 0, numRead);
        }
        return buffer.toString();
    }

    public synchronized IStructuredModel reinitialize(IStructuredModel model) {
        IModelHandler handler = model.getModelHandler();
        IModelLoader loader = handler.getModelLoader();
        model = loader.reinitialize(model);
        return model;
    }

    synchronized void releaseFromEdit(IStructuredModel structuredModel) {
        String id = structuredModel.getId();
        if (id.equals("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL") || id.equals("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL")) {
            this.cleanupDiscardedModel(structuredModel);
        } else {
            this.releaseFromEdit(id);
        }
    }

    synchronized void releaseFromRead(IStructuredModel structuredModel) {
        String id = structuredModel.getId();
        if (id.equals("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL") || id.equals("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL")) {
            this.cleanupDiscardedModel(structuredModel);
        } else {
            this.releaseFromRead(id);
        }
    }

    private synchronized void releaseFromEdit(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        SharedObject sharedObject = null;
        if (id.equals("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL") || id.equals("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL")) {
            throw new IllegalArgumentException("Ids of UNMANAGED_MODEL or DUPLICATED_MODEL are illegal here");
        }
        sharedObject = (SharedObject)this.fManagedObjects.get(id);
        Assert.isNotNull(sharedObject, "release was requested on a model that was not being managed");
        if (sharedObject != null) {
            --sharedObject.referenceCountForEdit;
            if (sharedObject.referenceCountForRead == 0 && sharedObject.referenceCountForEdit == 0) {
                this.discardModel(id, sharedObject);
            }
            if (sharedObject.referenceCountForRead > 0 && sharedObject.referenceCountForEdit == 0 && sharedObject.theSharedModel.isDirty()) {
                this.signalPreLifeCycleListenerRevert(sharedObject.theSharedModel);
                this.revertModel(id, sharedObject);
                sharedObject.theSharedModel.setDirtyState(false);
                this.signalPostLifeCycleListenerRevert(sharedObject.theSharedModel);
            }
        }
    }

    private void revertModel(Object id, SharedObject sharedObject) {
        IStructuredDocument structuredDocument = sharedObject.theSharedModel.getStructuredDocument();
        FileBufferModelManager.getInstance().revert(structuredDocument);
    }

    private void signalPreLifeCycleListenerRevert(IStructuredModel structuredModel) {
        int type = 261;
        ModelLifecycleEvent event = new ModelLifecycleEvent(structuredModel, type);
        ((AbstractStructuredModel)structuredModel).signalLifecycleEvent(event);
    }

    private void signalPostLifeCycleListenerRevert(IStructuredModel structuredModel) {
        int type = 517;
        ModelLifecycleEvent event = new ModelLifecycleEvent(structuredModel, type);
        ((AbstractStructuredModel)structuredModel).signalLifecycleEvent(event);
    }

    private void discardModel(Object id, SharedObject sharedObject) {
        this.fManagedObjects.remove(id);
        IStructuredDocument structuredDocument = sharedObject.theSharedModel.getStructuredDocument();
        if (structuredDocument == null) {
            Platform.getLog((Bundle)SSECorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.wst.sse.core", 4, "Attempted to discard a structured model but the underlying document has already been set to null: " + sharedObject.theSharedModel.getBaseLocation(), null));
        }
        this.cleanupDiscardedModel(sharedObject.theSharedModel);
    }

    private void cleanupDiscardedModel(IStructuredModel structuredModel) {
        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
        structuredModel.getFactoryRegistry().release();
        FileBufferModelManager.getInstance().releaseModel(structuredDocument);
        structuredModel.setStructuredDocument(null);
    }

    private synchronized void releaseFromRead(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        SharedObject sharedObject = null;
        if (id.equals("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL") || id.equals("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL")) {
            throw new IllegalArgumentException("Ids of UNMANAGED_MODEL or DUPLICATED_MODEL are illegal here");
        }
        sharedObject = (SharedObject)this.fManagedObjects.get(id);
        Assert.isNotNull(sharedObject, "release was requested on a model that was not being managed");
        if (sharedObject != null) {
            --sharedObject.referenceCountForRead;
            if (sharedObject.referenceCountForRead == 0 && sharedObject.referenceCountForEdit == 0) {
                this.discardModel(id, sharedObject);
            }
        }
    }

    public synchronized IStructuredModel reloadModel(Object id, InputStream inputStream) throws UnsupportedEncodingException {
        IStructuredModel structuredModel = this.getExistingModel(id);
        if (structuredModel != null) {
            IModelHandler handler = structuredModel.getModelHandler();
            IModelLoader loader = handler.getModelLoader();
            loader.reload(Utilities.getMarkSupportedStream(inputStream), structuredModel);
            this.trace("re-loading model", id);
        }
        return structuredModel;
    }

    public void saveModel(IFile iFile, String id, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject == null || sharedObject.theSharedModel == null) {
            throw new IllegalStateException(SSECoreMessages.Program_Error__ModelManage_EXC_);
        }
        boolean saved = false;
        if (FileBufferModelManager.getInstance().isExistingBuffer(sharedObject.theSharedModel.getStructuredDocument())) {
            ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer(sharedObject.theSharedModel.getStructuredDocument());
            IPath fileLocation = FileBuffers.normalizeLocation((IPath)iFile.getFullPath());
            if (fileLocation.equals((Object)buffer.getLocation())) {
                buffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
                saved = true;
            }
        }
        if (!saved) {
            IStructuredModel model = sharedObject.theSharedModel;
            IStructuredDocument document = model.getStructuredDocument();
            this.saveStructuredDocument(document, iFile, encodingRule);
            this.trace("saving model", id);
        }
        sharedObject.theSharedModel.setDirtyState(false);
        sharedObject.theSharedModel.setNewState(false);
    }

    public void saveModel(String id, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject == null) {
            throw new IllegalStateException(SSECoreMessages.Program_Error__ModelManage_EXC_);
        }
        if (FileBufferModelManager.getInstance().isExistingBuffer(sharedObject.theSharedModel.getStructuredDocument())) {
            ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer(sharedObject.theSharedModel.getStructuredDocument());
            buffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        } else {
            IFile iFile = this.getFileFor(sharedObject.theSharedModel);
            IStructuredModel model = sharedObject.theSharedModel;
            IStructuredDocument document = model.getStructuredDocument();
            this.saveStructuredDocument(document, iFile);
            this.trace("saving model", id);
        }
        sharedObject.theSharedModel.setDirtyState(false);
        sharedObject.theSharedModel.setNewState(false);
    }

    public void saveModel(String id, OutputStream outputStream, EncodingRule encodingRule) throws UnsupportedEncodingException, CoreException, IOException {
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject == null) {
            throw new IllegalStateException(SSECoreMessages.Program_Error__ModelManage_EXC_);
        }
        CodedStreamCreator codedStreamCreator = new CodedStreamCreator();
        codedStreamCreator.set(sharedObject.theSharedModel.getId(), (Reader)new DocumentReader(sharedObject.theSharedModel.getStructuredDocument()));
        codedStreamCreator.setPreviousEncodingMemento(sharedObject.theSharedModel.getStructuredDocument().getEncodingMemento());
        ByteArrayOutputStream byteArrayOutputStream = codedStreamCreator.getCodedByteArrayOutputStream(encodingRule);
        byte[] outputBytes = byteArrayOutputStream.toByteArray();
        outputStream.write(outputBytes);
        this.trace("saving model", id);
        sharedObject.theSharedModel.setDirtyState(false);
        sharedObject.theSharedModel.setNewState(false);
    }

    public void saveStructuredDocument(IStructuredDocument structuredDocument, IFile iFile) throws UnsupportedEncodingException, CoreException, IOException {
        this.saveStructuredDocument(structuredDocument, iFile, EncodingRule.CONTENT_BASED);
    }

    public void saveStructuredDocument(IStructuredDocument structuredDocument, IFile iFile, EncodingRule encodingRule) throws UnsupportedEncodingException, CoreException, IOException {
        if (FileBufferModelManager.getInstance().isExistingBuffer(structuredDocument)) {
            ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer(structuredDocument);
            if (iFile.getLocation().equals((Object)buffer.getLocation())) {
                buffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
            }
        } else {
            CodedStreamCreator codedStreamCreator = new CodedStreamCreator();
            DocumentReader reader = new DocumentReader(structuredDocument);
            codedStreamCreator.set(iFile, (Reader)reader);
            codedStreamCreator.setPreviousEncodingMemento(structuredDocument.getEncodingMemento());
            EncodingMemento encodingMemento = codedStreamCreator.getCurrentEncodingMemento();
            structuredDocument.setEncodingMemento(encodingMemento);
            this.handleConvertLineDelimiters(structuredDocument, iFile, encodingRule, encodingMemento);
            ByteArrayOutputStream codedByteStream = codedStreamCreator.getCodedByteArrayOutputStream(encodingRule);
            ByteArrayInputStream codedStream = new ByteArrayInputStream(codedByteStream.toByteArray());
            if (iFile.exists()) {
                iFile.setContents((InputStream)codedStream, true, true, null);
            } else {
                iFile.create((InputStream)codedStream, false, null);
            }
            codedByteStream.close();
            ((InputStream)codedStream).close();
        }
    }

    private void trace(String msg, Object id) {
        if (Logger.DEBUG_MODELMANAGER) {
            Logger.log(1, String.valueOf(msg) + " " + Utilities.makeShortId(id));
        }
    }

    private void trace(String msg, Object id, int value) {
        if (Logger.DEBUG_MODELMANAGER) {
            Logger.log(1, String.valueOf(msg) + Utilities.makeShortId(id) + " (" + value + ")");
        }
    }

    static class EnumeratedModelIds
    implements Enumeration {
        Enumeration fSharedObjectKeys;

        protected EnumeratedModelIds(Dictionary sharedObjects) {
            this.fSharedObjectKeys = sharedObjects == null ? null : sharedObjects.keys();
        }

        public boolean hasMoreElements() {
            boolean result = false;
            if (this.fSharedObjectKeys != null) {
                result = this.fSharedObjectKeys.hasMoreElements();
            }
            return result;
        }

        public Object nextElement() {
            if (this.fSharedObjectKeys == null) {
                throw new NoSuchElementException();
            }
            return this.fSharedObjectKeys.nextElement();
        }
    }

    static class ReadEditType {
        ReadEditType(String type) {
        }
    }

    static class SharedObject {
        int referenceCountForEdit;
        int referenceCountForRead;
        IStructuredModel theSharedModel;

        SharedObject(IStructuredModel sharedModel) {
            this.theSharedModel = sharedModel;
            this.referenceCountForRead = 0;
            this.referenceCountForEdit = 0;
        }
    }
}

