/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.wizards;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionWizardProperties;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.DisconnectServerAction;
import org.eclipse.wst.rdb.server.internal.ui.wizards.EditJDBCConfigurationWizardPage;
import org.eclipse.wst.rdb.server.internal.ui.wizards.EditSchemaFilterWizardPage;
import org.eclipse.wst.rdb.server.internal.ui.wizards.NewConnectionWizard;

public class EditConnectionWizard
extends Wizard {
    private EditJDBCConfigurationWizardPage jdbcPage;
    private EditSchemaFilterWizardPage schemaFilterPage;
    private IConnectionNode connectionNode;
    private ConnectionInfo connection;
    private static final String CONFIGURE_JDBC_WIZARD_PAGE_NAME = "org.eclipse.wst.rdb.server.internal.ui.wizards.EditJdbcPage";
    private static final String SCHEMA_FILTER_WIZARD_PAGE_NAME = "org.eclipse.wst.rdb.server.internal.ui.wizards.EditSchemaFilterPage";

    public EditConnectionWizard(IConnectionNode connection) {
        this.connectionNode = connection;
        this.setWindowTitle(org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader.INSTANCE.queryString("_UI_DIALOG_EDIT_CONNECTION_TITLE"));
    }

    public void addPages() {
        super.addPages();
        this.jdbcPage = new EditJDBCConfigurationWizardPage(CONFIGURE_JDBC_WIZARD_PAGE_NAME, this.getFilteredExistingConnectionNamesList());
        this.addPage((IWizardPage)this.jdbcPage);
        this.schemaFilterPage = new EditSchemaFilterWizardPage(SCHEMA_FILTER_WIZARD_PAGE_NAME);
        this.addPage((IWizardPage)this.schemaFilterPage);
    }

    public boolean performFinish() {
        boolean isPerformFinishSuccessful = false;
        if (this.getDBConnection(true) != null) {
            this.schemaFilterPage.applyFilter();
            ((ICatalogObject)this.connection.getSharedDatabase()).refresh();
            isPerformFinishSuccessful = true;
        }
        return isPerformFinishSuccessful;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        IWizardContainer container = this.getContainer();
        if (container instanceof IWizardContainer2) {
            ((IWizardContainer2)container).updateSize();
        }
        ConnectionInfo connInfo = this.connectionNode.getConnectionInfo();
        ConnectionWizardProperties wizProps = new ConnectionWizardProperties();
        wizProps.setConnectionName(connInfo.getName());
        wizProps.setDatabaseName(connInfo.getDatabaseName());
        wizProps.setProduct(connInfo.getDatabaseDefinition().getProduct());
        wizProps.setVersion(connInfo.getDatabaseDefinition().getVersion());
        ((Object)((Object)this.jdbcPage)).getClass();
        String driverName = connInfo.getCustomProperty("JDBC_DRIVER");
        if (driverName.equals("")) {
            driverName = ResourceLoader.INSTANCE.queryString("CUI_NEWCW_JDBCDRV_OTHER_VAL_UI_");
        }
        wizProps.setDriverName(driverName);
        wizProps.setDriverClassName(connInfo.getDriverClassName());
        wizProps.setClassLocation(connInfo.getLoadingPath());
        wizProps.setURL(connInfo.getURL());
        wizProps.setUserID(connInfo.getUserName());
        wizProps.setPassword(connInfo.getPassword());
        wizProps.setCustomProperties(connInfo.getCustomProperties());
        this.jdbcPage.setConnectionProperties(wizProps);
    }

    private List getFilteredExistingConnectionNamesList() {
        ConnectionInfo connInfo = this.connectionNode.getConnectionInfo();
        ConnectionInfo[] infos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
        ArrayList<String> nameList = new ArrayList<String>(infos.length);
        int i = 0;
        int n = infos.length;
        while (i < n) {
            if (!nameList.contains(infos[i].getName()) && !infos[i].getName().equals(connInfo.getName())) {
                nameList.add(infos[i].getName().toLowerCase());
            }
            ++i;
        }
        String[] names = nameList.toArray(new String[nameList.size()]);
        return Arrays.asList(names);
    }

    public boolean canFinish() {
        boolean canFinish = false;
        if (this.jdbcPage.isPageComplete() && this.schemaFilterPage.isPageComplete()) {
            canFinish = true;
        }
        return canFinish;
    }

    public ConnectionInfo getDBConnection(boolean showServerMismatchWarning) {
        ConnectionInfo originalConnection = this.connectionNode.getConnectionInfo();
        if (this.connection == null) {
            if (this.jdbcPage.getConnectionName().equals(originalConnection.getName()) && this.jdbcPage.getURL().equals(originalConnection.getURL()) && (originalConnection.getDatabaseDefinition().getProduct().equals(this.jdbcPage.getCurrentDatabaseDefinition().getProduct()) && originalConnection.getDatabaseDefinition().getVersion().equals(this.jdbcPage.getCurrentDatabaseDefinition().getVersion()) || RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().isConnectionUIProductVersionsOverridden(this.jdbcPage.getCurrentDatabaseDefinition().getProduct()))) {
                try {
                    if (originalConnection.getSharedConnection() != null) {
                        new DisconnectServerAction().run(null);
                    }
                    this.jdbcPage.setConnectionDetails(originalConnection);
                    this.jdbcPage.internalSaveWidgetValues();
                    this.jdbcPage.performTestConnection(false, showServerMismatchWarning);
                    if (this.jdbcPage.isFinalConnection()) {
                        this.connection = originalConnection;
                        this.displayNewServer(this.connection);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.jdbcPage.internalSaveWidgetValues();
                this.jdbcPage.performTestConnection(false, showServerMismatchWarning);
                if (this.jdbcPage.isFinalConnection()) {
                    RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(originalConnection.getName());
                    this.connection = this.jdbcPage.getConnection();
                    this.displayNewServer(this.connection);
                }
            }
        }
        return this.connection;
    }

    private boolean displayNewServer(ConnectionInfo connectionInfo) {
        Connection connection = null;
        try {
            connection = connectionInfo.connect();
            connectionInfo.setSharedConnection(connection);
            connectionInfo.saveConnectionInfo();
            new DatabaseProviderHelper().setDatabase(connection, connectionInfo, connectionInfo.getDatabaseName());
            return true;
        }
        catch (Exception e) {
            RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(connectionInfo.getName());
            this.displayError(e.getMessage());
            return false;
        }
    }

    private void displayError(String message) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NewConnectionWizard.CONNECTION_NULL, (String)MessageFormat.format(NewConnectionWizard.CONNECTION_EXCEPTION, message));
    }
}

