/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerConfiguration;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.impl.ServerExplorerContentProviderNav;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;

public class ExpandAction
extends Action {
    private SelectionChangedEvent event;
    private CommonViewer viewer;

    public void initialize() {
        this.viewer = ((ServerExplorerContentProviderNav)IServicesManager.INSTANCE.getServerExplorerContentService()).getViewer();
    }

    private Object getSelection() {
        return ((IStructuredSelection)this.event.getSelection()).getFirstElement();
    }

    private void expand(Object selection) {
        if (this.viewer.getExpandedState(selection)) {
            this.viewer.collapseToLevel(selection, 1);
        } else {
            this.viewer.expandToLevel(selection, 1);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.event = event;
    }

    public void run() {
        Object selection = this.getSelection();
        if (selection instanceof IConnectionNode && !((IConnectionNode)selection).isConnected()) {
            IConnectionNode connection = (IConnectionNode)selection;
            new ServerExplorerConfiguration().restoreConnectionInfo(connection, connection.getConnectionInfo());
        } else {
            this.expand(selection);
        }
    }
}

