/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.popup;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.ws.internal.explorer.LaunchOption;
import org.eclipse.wst.ws.internal.explorer.WSExplorerLauncherCommand;
import org.eclipse.wst.ws.internal.explorer.plugin.ExplorerPlugin;
import org.eclipse.wst.ws.internal.monitor.GetMonitorCommand;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.ui.utils.AdapterUtils;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class PopupTestWSDL
extends Action
implements IActionDelegate {
    public PopupTestWSDL() {
        super(ExplorerPlugin.getMessage("%POPUP_TEST_WSDL"));
    }

    protected IStructuredSelection getWorkbenchSelection() {
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public void run() {
        String stateLocation = ExplorerPlugin.getInstance().getPluginStateLocation();
        String defaultFavoritesLocation = ExplorerPlugin.getInstance().getDefaultFavoritesLocation();
        WSExplorerLauncherCommand command = new WSExplorerLauncherCommand();
        command.setForceLaunchOutsideIDE(false);
        IStructuredSelection selection = this.getWorkbenchSelection();
        Vector launchOptions = new Vector();
        if (selection != null) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Definition definition;
                String wsdlURL = null;
                Object object = it.next();
                if (object instanceof IResource) {
                    File wsdlFile = ((IResource)object).getLocation().toFile();
                    try {
                        wsdlURL = wsdlFile.toURL().toString();
                    }
                    catch (MalformedURLException malformedURLException) {
                        wsdlURL = wsdlFile.toString();
                    }
                } else if (object instanceof ServiceImpl) {
                    ServiceImpl serviceImpl = (ServiceImpl)object;
                    definition = serviceImpl.getEnclosingDefinition();
                    wsdlURL = definition.getLocation();
                } else if (object instanceof WSDLResourceImpl) {
                    WSDLResourceImpl WSDLRImpl = (WSDLResourceImpl)object;
                    definition = WSDLRImpl.getDefinition();
                    wsdlURL = definition.getLocation();
                } else {
                    wsdlURL = object instanceof String ? (String)object : AdapterUtils.getAdaptedWSDL(object);
                }
                this.addLaunchOptions(launchOptions, wsdlURL, stateLocation, defaultFavoritesLocation);
            }
        }
        command.setLaunchOptions(launchOptions.toArray(new LaunchOption[0]));
        command.execute();
    }

    protected void addLaunchOptions(Vector launchOptions, String wsdlURL, String stateLocation, String defaultFavoritesLocation) {
        GetMonitorCommand getMonitorCmd = new GetMonitorCommand();
        getMonitorCmd.setMonitorService(true);
        getMonitorCmd.setCreate(false);
        getMonitorCmd.setWebServicesParser(new WebServicesParser());
        getMonitorCmd.setWsdlURI(wsdlURL);
        getMonitorCmd.execute(null, null);
        List endpoints = getMonitorCmd.getEndpoints();
        Iterator endpointsIt = endpoints.iterator();
        while (endpointsIt.hasNext()) {
            launchOptions.add(new LaunchOption("webServiceEndpoint", (String)endpointsIt.next()));
        }
        launchOptions.add(new LaunchOption("wsdl", wsdlURL));
        launchOptions.add(new LaunchOption("stateLocation", stateLocation));
        launchOptions.add(new LaunchOption("defaultFavoritesLocation", defaultFavoritesLocation));
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

