/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.osgi.framework.Bundle;

public final class ProjectFacetsUiManagerImpl {
    private static final String WIZARD_PAGES_EXTENSION_ID = "wizardPages";
    private static final String WIZARD_PAGES_EXTENSION_ID_OLD = "wizard";
    private static final String IMAGES_EXTENSION_ID = "images";
    private static final String EL_WIZARD_PAGES = "wizard-pages";
    private static final String EL_PAGE = "page";
    private static final String EL_IMAGE = "image";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_RUNTIME_COMPONENT_TYPE = "runtime-component-type";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_ACTION = "action";
    private static final HashMap wizardPages;
    private static final HashMap icons;
    private static ImageDescriptor defaultIcon;

    static {
        icons = new HashMap();
        ProjectFacetsManager.getProjectFacets();
        RuntimeManager.getRuntimeComponentTypes();
        wizardPages = new HashMap();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.project.facet.ui");
        URL url = bundle.getEntry("images/unknown.gif");
        defaultIcon = ImageDescriptor.createFromURL((URL)url);
        ProjectFacetsUiManagerImpl.readWizardPagesExtensions();
        ProjectFacetsUiManagerImpl.readWizardPagesExtensionsOld();
        ProjectFacetsUiManagerImpl.readImagesExtensions();
    }

    private ProjectFacetsUiManagerImpl() {
    }

    public static ImageDescriptor getIcon(Object obj) {
        ImageDescriptor imgdesc = (ImageDescriptor)icons.get(obj);
        return imgdesc != null ? imgdesc : defaultIcon;
    }

    public static List getWizardPages(String actionId) {
        WizardPagesInfo info = (WizardPagesInfo)wizardPages.get(actionId);
        if (info != null) {
            return ProjectFacetsUiManagerImpl.getWizardPages(info.plugin, info.pages);
        }
        return Collections.EMPTY_LIST;
    }

    public static List getWizardPages(IFacetedProject.Action.Type actionType, IProjectFacetVersion fv) {
        if (fv.supports(actionType)) {
            try {
                IActionDefinition def = ((ProjectFacetVersion)fv).getActionDefinition(actionType);
                return ProjectFacetsUiManagerImpl.getWizardPages(def.getId());
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static List getWizardPages(String plugin, List clnames) {
        ArrayList<Object> pages = new ArrayList<Object>();
        Iterator itr = clnames.iterator();
        while (itr.hasNext()) {
            try {
                pages.add(ProjectFacetsUiManagerImpl.create(plugin, (String)itr.next()));
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        return pages;
    }

    private static Object create(String plugin, String clname) throws CoreException {
        Bundle bundle = Platform.getBundle((String)plugin);
        try {
            Class cl = bundle.loadClass(clname);
            return cl.newInstance();
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failedToCreate, (Object)clname);
            IStatus st = FacetUiPlugin.createErrorStatus(msg, e);
            throw new CoreException(st);
        }
    }

    private static void readWizardPagesExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.ui", WIZARD_PAGES_EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement config = elements[j];
                String ename = config.getName();
                if (ename.equals(EL_WIZARD_PAGES)) {
                    String action = config.getAttribute(ATTR_ACTION);
                    if (action == null) {
                        ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_ACTION);
                        return;
                    }
                    String pluginId = config.getContributor().getName();
                    if (ProjectFacetsManager.isActionDefined((String)action)) {
                        WizardPagesInfo pagesInfo = new WizardPagesInfo();
                        pagesInfo.plugin = pluginId;
                        pagesInfo.pages = ProjectFacetsUiManagerImpl.readPageList(config);
                        wizardPages.put(action, pagesInfo);
                    } else {
                        String msg = NLS.bind((String)Resources.actionNotDefined, (Object)pluginId, (Object)action);
                        FacetUiPlugin.logError(msg);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static void readWizardPagesExtensionsOld() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.ui", WIZARD_PAGES_EXTENSION_ID_OLD);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement config = elements[j];
                String ename = config.getName();
                if (ename.equals(EL_WIZARD_PAGES)) {
                    ProjectFacetsUiManagerImpl.readWizardPagesOld(config);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void readWizardPagesOld(IConfigurationElement config) {
        String pluginId = config.getContributor().getName();
        String depMsg = NLS.bind((String)Resources.wizardExtensionPointDeprecated, (Object)pluginId);
        FacetUiPlugin.logWarning(depMsg, true);
        String id = config.getAttribute(ATTR_FACET);
        if (id == null) {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_FACET);
            return;
        }
        if (!ProjectFacetsManager.isProjectFacetDefined((String)id)) {
            String msg = NLS.bind((String)Resources.facetNotDefined, (Object)config.getContributor().getName(), (Object)id);
            FacetUiPlugin.log(msg);
            return;
        }
        IProjectFacet f = ProjectFacetsManager.getProjectFacet((String)id);
        String version = config.getAttribute(ATTR_VERSION);
        if (version == null) {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_VERSION);
            return;
        }
        if (!f.hasVersion(version)) {
            Object[] params = new String[]{config.getContributor().getName(), id, version};
            String msg = NLS.bind((String)Resources.facetVersionNotDefined, (Object[])params);
            FacetUiPlugin.log(msg);
            return;
        }
        IProjectFacetVersion fv = f.getVersion(version);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            IFacetedProject.Action.Type actionType = IFacetedProject.Action.Type.valueOf((String)childName);
            if (actionType == null) {
                String msg = NLS.bind((String)Resources.invalidActionType, (Object)config.getContributor().getName(), (Object)childName);
                FacetUiPlugin.log(msg);
                return;
            }
            if (fv.supports(actionType)) {
                IActionDefinition def;
                try {
                    def = ((ProjectFacetVersion)fv).getActionDefinition(actionType);
                }
                catch (CoreException e) {
                    FacetUiPlugin.log((Exception)((Object)e));
                    return;
                }
                WizardPagesInfo pagesInfo = new WizardPagesInfo();
                pagesInfo.plugin = pluginId;
                pagesInfo.pages = ProjectFacetsUiManagerImpl.readPageList(child);
                wizardPages.put(def.getId(), pagesInfo);
            }
            ++i;
        }
    }

    private static List readPageList(IConfigurationElement config) {
        ArrayList<String> list = new ArrayList<String>();
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_PAGE)) {
                String clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_CLASS);
                } else {
                    list.add(clname);
                }
            }
            ++i;
        }
        return list;
    }

    private static void readImagesExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.ui", IMAGES_EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement config = elements[j];
                String ename = config.getName();
                if (ename.equals(EL_IMAGE)) {
                    ProjectFacetsUiManagerImpl.readImage(config);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void readImage(IConfigurationElement config) {
        String plugin;
        Bundle bundle;
        URL url;
        IProjectFacet target;
        String fid = config.getAttribute(ATTR_FACET);
        String cid = config.getAttribute(ATTR_CATEGORY);
        String rct = config.getAttribute(ATTR_RUNTIME_COMPONENT_TYPE);
        if (fid != null) {
            if (!ProjectFacetsManager.isProjectFacetDefined((String)fid)) {
                String msg = NLS.bind((String)Resources.facetNotDefined, (Object)config.getContributor().getName(), (Object)fid);
                FacetUiPlugin.log(msg);
                return;
            }
            target = ProjectFacetsManager.getProjectFacet((String)fid);
        } else if (cid != null) {
            if (!ProjectFacetsManager.isCategoryDefined((String)cid)) {
                String msg = NLS.bind((String)Resources.categoryNotDefined, (Object)config.getContributor().getName(), (Object)fid);
                FacetUiPlugin.log(msg);
                return;
            }
            target = ProjectFacetsManager.getCategory((String)cid);
        } else if (rct != null) {
            if (!RuntimeManager.isRuntimeComponentTypeDefined((String)rct)) {
                String msg = NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)config.getContributor().getName(), (Object)rct);
                FacetUiPlugin.log(msg);
                return;
            }
            target = RuntimeManager.getRuntimeComponentType((String)rct);
        } else {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_FACET);
            return;
        }
        String path = config.getAttribute(ATTR_PATH);
        if (path == null) {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_PATH);
        }
        if ((url = FileLocator.find((Bundle)(bundle = Platform.getBundle((String)(plugin = config.getContributor().getName()))), (IPath)new Path(path), null)) == null) {
            String msg = NLS.bind((String)Resources.iconNotFound, (Object)plugin, (Object)path);
            FacetUiPlugin.log(msg);
        } else {
            ImageDescriptor imgdesc = ImageDescriptor.createFromURL((URL)url);
            icons.put(target, imgdesc);
        }
    }

    private static void reportMissingAttribute(IConfigurationElement el, String attribute) {
        Object[] params = new String[]{el.getContributor().getName(), el.getName(), attribute};
        String msg = NLS.bind((String)Resources.missingAttribute, (Object[])params);
        FacetUiPlugin.log(msg);
    }

    private static class WizardPagesInfo {
        public String plugin;
        public List pages;

        private WizardPagesInfo() {
        }
    }

    private static final class Resources
    extends NLS {
        public static String missingAttribute;
        public static String facetNotDefined;
        public static String facetVersionNotDefined;
        public static String categoryNotDefined;
        public static String runtimeComponentTypeNotDefined;
        public static String failedToCreate;
        public static String invalidActionType;
        public static String iconNotFound;
        public static String wizardExtensionPointDeprecated;
        public static String actionNotDefined;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.ProjectFacetsUiManagerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.ProjectFacetsUiManagerImpl$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

