/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contenttype;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.util.CommonXML;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.internal.util.FileContentCache;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DeploymentDescriptorPropertyCache {
    private static final PropertyGroup[] NO_PROPERTY_GROUPS = new PropertyGroup[0];
    private static DeploymentDescriptorPropertyCache _instance = new DeploymentDescriptorPropertyCache();
    private static final boolean _debugResolutionCache = false;
    private static final float defaultWebAppVersion = 2.4f;
    static String EL_IGNORED = "el-ignored";
    private static String ID = "id";
    static String INCLUDE_CODA = "include-coda";
    static String INCLUDE_PRELUDE = "include-prelude";
    static String IS_XML = "is-xml";
    private static String JSP_PROPERTY_GROUP = "jsp-property-group";
    static String PAGE_ENCODING = "page-encoding";
    static String SCRIPTING_INVALID = "scripting-invalid";
    static String URL_PATTERN = "url-pattern";
    private static final String WEB_APP_ELEMENT_LOCAL_NAME = ":web-app";
    private static final String WEB_APP_ELEMENT_NAME = "web-app";
    private static final String WEB_APP_VERSION_NAME = "version";
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_XML = "web.xml";
    private static final String SLASH_WEB_INF_WEB_XML = String.valueOf(Path.ROOT.toString()) + "WEB-INF" + '/' + "web.xml";
    private ResourceErrorHandler errorHandler;
    private Map fDeploymentDescriptors = new Hashtable();
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private EntityResolver resolver;
    Map resolvedMap = new HashMap();

    static String getContainedText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    public static DeploymentDescriptorPropertyCache getInstance() {
        return _instance;
    }

    public static void start() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(DeploymentDescriptorPropertyCache.getInstance().fResourceChangeListener, 1);
    }

    public static void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(DeploymentDescriptorPropertyCache.getInstance().fResourceChangeListener);
    }

    private DeploymentDescriptorPropertyCache() {
    }

    private void _parseDocument(IPath path, Float[] version, List groupList, List urlPatterns, SubProgressMonitor subMonitor, Document document) {
        Element webapp = document.getDocumentElement();
        if (webapp != null && (webapp.getTagName().equals(WEB_APP_ELEMENT_NAME) || webapp.getNodeName().endsWith(WEB_APP_ELEMENT_LOCAL_NAME))) {
            DocumentType doctype;
            if (webapp.hasAttribute(WEB_APP_VERSION_NAME)) {
                String versionValue = webapp.getAttribute(WEB_APP_VERSION_NAME);
                if ((versionValue = versionValue.trim()).length() > 0) {
                    try {
                        version[0] = Float.valueOf(versionValue);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (version[0] == null && (doctype = document.getDoctype()) != null) {
                String systemId = doctype.getSystemId();
                String publicId = doctype.getPublicId();
                if (systemId != null && systemId.endsWith("web-app_2_3.dtd") || publicId != null && publicId.indexOf("Web Application 2.3") > 0) {
                    version[0] = new Float(2.3);
                } else if (systemId != null && systemId.endsWith("web-app_2_2.dtd") || publicId != null && publicId.indexOf("Web Application 2.2") > 0) {
                    version[0] = new Float(2.2);
                } else if (systemId != null && systemId.endsWith("web-app_2_1.dtd") || publicId != null && publicId.indexOf("Web Application 2.1") > 0) {
                    version[0] = new Float(2.1);
                }
            }
        }
        NodeList propertyGroupElements = document.getElementsByTagName(JSP_PROPERTY_GROUP);
        int length = propertyGroupElements.getLength();
        subMonitor.beginTask("Reading Property Groups", length);
        int i = 0;
        while (i < length) {
            PropertyGroup group = PropertyGroup.createFrom(path, propertyGroupElements.item(i), i);
            subMonitor.worked(1);
            if (group != null) {
                groupList.add(group);
            }
            ++i;
        }
        NodeList urlPatternElements = document.getElementsByTagName(URL_PATTERN);
        int i2 = 0;
        while (i2 < urlPatternElements.getLength()) {
            String urlPattern = DeploymentDescriptorPropertyCache.getContainedText(urlPatternElements.item(i2));
            if (urlPattern != null && urlPattern.length() > 0) {
                urlPatterns.add(new StringMatcher(urlPattern));
            }
            ++i2;
        }
    }

    private float convertSpecVersions(float version) {
        if (version > 0.0f) {
            if (version == 2.5f) {
                return 2.1f;
            }
            if (version == 2.4f) {
                return 2.0f;
            }
            if (version == 2.3f) {
                return 1.2f;
            }
            if (version == 2.2f) {
                return 1.1f;
            }
            if (version == 2.1f) {
                return 1.0f;
            }
        }
        return this.convertSpecVersions(2.4f);
    }

    void deploymentDescriptorChanged(IPath fullPath) {
        if (this.fDeploymentDescriptors.containsKey(fullPath.makeAbsolute())) {
            this.updateCacheEntry(fullPath);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeploymentDescriptor fetchDescriptor(IPath path, IProgressMonitor monitor) {
        monitor.beginTask("", 3);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        PropertyGroup[] groups = null;
        IStructuredModel model = null;
        ArrayList groupList = new ArrayList();
        ArrayList urlPatterns = new ArrayList();
        Float[] version = new Float[1];
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 2);
        DocumentBuilder builder = CommonXML.getDocumentBuilder(false);
        builder.setEntityResolver(this.getEntityResolver());
        builder.setErrorHandler(this.getErrorHandler(path));
        try {
            try {
                InputSource inputSource = new InputSource();
                String s = FileContentCache.getInstance().getContents(path);
                inputSource.setCharacterStream(new StringReader(s));
                inputSource.setSystemId(path.toString());
                Document document = builder.parse(inputSource);
                this._parseDocument(path, version, groupList, urlPatterns, subMonitor, document);
            }
            catch (SAXException sAXException) {
                try {
                    try {
                        model = StructuredModelManager.getModelManager().getModelForRead(file);
                        monitor.worked(1);
                        if (model instanceof IDOMModel) {
                            IDOMDocument document = ((IDOMModel)model).getDocument();
                            this._parseDocument(path, version, groupList, urlPatterns, subMonitor, (Document)document);
                        }
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    throw throwable;
                }
                {
                    Object var12_15 = null;
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            groups = groupList.toArray(new PropertyGroup[groupList.size()]);
            subMonitor.done();
            throw throwable;
        }
        {
            Object var14_20 = null;
            groups = groupList.toArray(new PropertyGroup[groupList.size()]);
        }
        subMonitor.done();
        if (groups == null) {
            groups = NO_PROPERTY_GROUPS;
        }
        DeploymentDescriptor deploymentDescriptor = new DeploymentDescriptor();
        deploymentDescriptor.modificationStamp = file.getModificationStamp();
        deploymentDescriptor.groups = groups;
        deploymentDescriptor.urlPatterns = urlPatterns.toArray(new StringMatcher[urlPatterns.size()]);
        deploymentDescriptor.version = version[0];
        monitor.done();
        this.fDeploymentDescriptors.put(path, new SoftReference<DeploymentDescriptor>(deploymentDescriptor));
        return deploymentDescriptor;
    }

    private DeploymentDescriptor getCachedDescriptor(IPath jspFilePath) {
        IPath webxmlPath = this.getWebXMLPath(jspFilePath);
        if (webxmlPath == null) {
            return null;
        }
        IFile webxmlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(webxmlPath);
        if (!webxmlFile.isAccessible()) {
            return null;
        }
        Reference descriptorHolder = (Reference)this.fDeploymentDescriptors.get(webxmlPath);
        DeploymentDescriptor descriptor = null;
        if (descriptorHolder == null || (descriptor = (DeploymentDescriptor)descriptorHolder.get()) == null || descriptor.modificationStamp == -1L || descriptor.modificationStamp != webxmlFile.getModificationStamp()) {
            descriptor = this.fetchDescriptor(webxmlPath, (IProgressMonitor)new NullProgressMonitor());
        }
        return descriptor;
    }

    private EntityResolver getEntityResolver() {
        if (this.resolver == null) {
            this.resolver = new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
                    InputSource result = new InputSource(new ByteArrayInputStream(new byte[0]));
                    result.setPublicId(publicID);
                    result.setSystemId(systemID != null ? systemID : "/_" + this.getClass().getName());
                    return result;
                }
            };
        }
        return this.resolver;
    }

    private ErrorHandler getErrorHandler(IPath path) {
        if (this.errorHandler == null) {
            this.errorHandler = new ResourceErrorHandler(false);
        }
        this.errorHandler.setPath(path);
        return this.errorHandler;
    }

    public float getJSPVersion(IPath fullPath) {
        float version = 2.4f;
        DeploymentDescriptor descriptor = this.getCachedDescriptor(fullPath);
        if (descriptor != null && descriptor.version != null) {
            version = descriptor.version.floatValue();
            return this.convertSpecVersions(version);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(fullPath.segment(0));
        version = FacetModuleCoreSupport.getDynamicWebProjectVersion(project);
        return this.convertSpecVersions(version);
    }

    public PropertyGroup[] getPropertyGroups(IPath jspFilePath) {
        ArrayList<PropertyGroup> matchingGroups = new ArrayList<PropertyGroup>(1);
        DeploymentDescriptor descriptor = this.getCachedDescriptor(jspFilePath);
        if (descriptor == null) {
            return NO_PROPERTY_GROUPS;
        }
        int i = 0;
        while (i < descriptor.groups.length) {
            if (descriptor.groups[i].matches(FacetModuleCoreSupport.getRuntimePath(jspFilePath).toString(), false)) {
                matchingGroups.add(descriptor.groups[i]);
            }
            ++i;
        }
        if (matchingGroups.isEmpty()) {
            i = 0;
            while (i < descriptor.groups.length) {
                if (descriptor.groups[i].matches(FacetModuleCoreSupport.getRuntimePath(jspFilePath).toString(), true)) {
                    matchingGroups.add(descriptor.groups[i]);
                }
                ++i;
            }
        }
        return matchingGroups.toArray(new PropertyGroup[matchingGroups.size()]);
    }

    public String getURLMapping(IPath jspFilePath, String reference) {
        DeploymentDescriptor descriptor = this.getCachedDescriptor(jspFilePath);
        if (descriptor == null) {
            return null;
        }
        StringMatcher[] mappings = descriptor.urlPatterns;
        int i = 0;
        while (i < mappings.length) {
            if (mappings[i].match(reference)) {
                return mappings[i].pattern;
            }
            ++i;
        }
        return null;
    }

    private IPath getWebXMLPath(IPath fullPath) {
        IPath resolved = null;
        HashMap<IPath, IPath> mapForProject = null;
        mapForProject = (HashMap<IPath, IPath>)this.resolvedMap.get(fullPath.segment(0));
        if (mapForProject != null) {
            resolved = (IPath)mapForProject.get(fullPath);
        } else {
            mapForProject = new HashMap<IPath, IPath>();
            this.resolvedMap.put(fullPath.segment(0), mapForProject);
        }
        if (resolved == null) {
            resolved = FacetModuleCoreSupport.resolve(fullPath, SLASH_WEB_INF_WEB_XML);
            mapForProject.put(fullPath, resolved);
        }
        return resolved;
    }

    public IFile getWebXML(IPath jspFilePath) {
        IPath webxmlPath = this.getWebXMLPath(jspFilePath);
        if (webxmlPath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(webxmlPath);
    }

    private void updateCacheEntry(IPath fullPath) {
        this.fDeploymentDescriptors.remove(fullPath);
    }

    static class DeploymentDescriptor {
        PropertyGroup[] groups;
        long modificationStamp;
        StringMatcher[] urlPatterns;
        Float version = new Float(2.4f);

        DeploymentDescriptor() {
        }
    }

    public static final class PropertyGroup {
        private boolean el_ignored;
        private String id;
        private IPath[] include_coda = new IPath[0];
        private IPath[] include_prelude = new IPath[0];
        private boolean is_xml;
        private StringMatcher matcher;
        private String page_encoding;
        private boolean scripting_invalid;
        String url_pattern;
        private IPath webxmlPath;
        int number;

        static PropertyGroup createFrom(IPath path, Node propertyGroupNode, int groupNumber) {
            PropertyGroup group = new PropertyGroup(path, groupNumber);
            Node propertyGroupID = propertyGroupNode.getAttributes().getNamedItem(ID);
            if (propertyGroupID != null) {
                group.setId(propertyGroupID.getNodeValue());
            }
            Node node = propertyGroupNode.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    String name = node.getLocalName();
                    if (name == null) {
                        name = node.getNodeName();
                    }
                    if (IS_XML.equals(name)) {
                        group.setIsXML(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (EL_IGNORED.equals(name)) {
                        group.setElignored(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (INCLUDE_CODA.equals(name)) {
                        group.addCoda(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (INCLUDE_PRELUDE.equals(name)) {
                        group.addPrelude(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (SCRIPTING_INVALID.equals(name)) {
                        group.setScriptingInvalid(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (PAGE_ENCODING.equals(name)) {
                        group.setPageEncoding(DeploymentDescriptorPropertyCache.getContainedText(node));
                    } else if (URL_PATTERN.equals(name)) {
                        group.setUrlPattern(DeploymentDescriptorPropertyCache.getContainedText(node));
                    }
                }
                node = node.getNextSibling();
            }
            return group;
        }

        private PropertyGroup(IPath path, int number) {
            this.webxmlPath = path;
            this.number = number;
        }

        private void addCoda(String containedText) {
            if (containedText.length() > 0) {
                IPath[] codas = new IPath[this.include_coda.length + 1];
                System.arraycopy(this.include_coda, 0, codas, 0, this.include_coda.length);
                codas[this.include_coda.length] = this.webxmlPath.removeLastSegments(2).append(containedText);
                this.include_coda = codas;
            }
        }

        private void addPrelude(String containedText) {
            if (containedText.length() > 0) {
                IPath[] preludes = new IPath[this.include_prelude.length + 1];
                System.arraycopy(this.include_prelude, 0, preludes, 0, this.include_prelude.length);
                preludes[this.include_prelude.length] = this.webxmlPath.removeLastSegments(2).append(containedText);
                this.include_prelude = preludes;
            }
        }

        public String getId() {
            return this.id;
        }

        public IPath[] getIncludeCoda() {
            return this.include_coda;
        }

        public IPath[] getIncludePrelude() {
            return this.include_prelude;
        }

        public String getPageEncoding() {
            return this.page_encoding;
        }

        public String getUrlPattern() {
            return this.url_pattern;
        }

        public boolean isELignored() {
            return this.el_ignored;
        }

        public boolean isIsXML() {
            return this.is_xml;
        }

        public boolean isScriptingInvalid() {
            return this.scripting_invalid;
        }

        boolean matches(String pattern, boolean optimistic) {
            if (this.matcher == null) {
                return optimistic;
            }
            return this.matcher.match(pattern);
        }

        private void setElignored(String el_ignored) {
            this.el_ignored = Boolean.valueOf(el_ignored);
        }

        private void setId(String id) {
            this.id = id;
        }

        private void setIsXML(String is_xml) {
            this.is_xml = Boolean.valueOf(is_xml);
        }

        private void setPageEncoding(String page_encoding) {
            this.page_encoding = page_encoding;
        }

        private void setScriptingInvalid(String scripting_invalid) {
            this.scripting_invalid = Boolean.valueOf(scripting_invalid);
        }

        private void setUrlPattern(String url_pattern) {
            this.url_pattern = url_pattern;
            if (url_pattern != null && url_pattern.length() > 0) {
                this.matcher = new StringMatcher(url_pattern);
            }
        }

        public String toString() {
            return String.valueOf(this.number) + ":" + this.url_pattern;
        }
    }

    static class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (event.getType() != 1) {
                return;
            }
            if (delta.getKind() == 4 && (delta.getFlags() == 0x100000 || delta.getFlags() == 131072)) {
                return;
            }
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(this){
                final /* synthetic */ ResourceChangeListener this$1;
                {
                    this.this$1 = resourceChangeListener;
                }

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1) {
                        if (delta.getKind() == 4 && (delta.getFlags() == 0x100000 || delta.getFlags() == 131072)) {
                            return false;
                        }
                        IPath path = resource.getFullPath();
                        int segmentCount = path.segmentCount();
                        if (segmentCount > 1 && path.lastSegment().equals("web.xml") && path.segment(segmentCount - 2).equals("WEB-INF")) {
                            DeploymentDescriptorPropertyCache.getInstance().deploymentDescriptorChanged(path);
                        }
                    } else if (resource.getType() == 4) {
                        String name = resource.getName();
                        DeploymentDescriptorPropertyCache.getInstance().resolvedMap.remove(name);
                    }
                    return true;
                }
            };
            try {
                delta.accept(visitor);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    private static class ResourceErrorHandler
    implements ErrorHandler {
        private boolean fDoLogExceptions = false;
        private IPath fPath;

        ResourceErrorHandler(boolean logExceptions) {
            this.fDoLogExceptions = logExceptions;
        }

        public void error(SAXParseException exception) throws SAXException {
            if (this.fDoLogExceptions) {
                Logger.log(2, "SAXParseException with " + this.fPath + " (error) while reading descriptor: " + exception.getMessage());
            }
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            if (this.fDoLogExceptions) {
                Logger.log(2, "SAXParseException with " + this.fPath + " (fatalError) while reading descriptor: " + exception.getMessage());
            }
        }

        public void setPath(IPath path) {
            this.fPath = path;
        }

        public void warning(SAXParseException exception) throws SAXException {
            if (this.fDoLogExceptions) {
                Logger.log(2, "SAXParseException with " + this.fPath + " (warning) while reading descriptor: " + exception.getMessage());
            }
        }
    }

    private static class StringMatcher {
        private static final char SINGLE_WILD_CARD = '\u0000';
        private int bound = 0;
        private boolean hasLeadingStar;
        private boolean hasTrailingStar;
        final String pattern;
        private final int patternLength;
        private String[] segments;

        StringMatcher(String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException();
            }
            this.pattern = pattern;
            this.patternLength = pattern.length();
            this.parseWildCards();
        }

        private int findPosition(String text, int start, int end, String p) {
            boolean hasWildCard = p.indexOf(0) >= 0;
            int plen = p.length();
            int i = start;
            int max = end - plen;
            while (i <= max) {
                if (hasWildCard ? this.regExpRegionMatches(text, i, p, 0, plen) : text.regionMatches(true, i, p, 0, plen)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        /*
         * Unable to fully structure code
         */
        public boolean match(String text) {
            if (text == null) {
                return false;
            }
            end = text.length();
            segmentCount = this.segments.length;
            if (segmentCount == 0 && (this.hasLeadingStar || this.hasTrailingStar)) {
                return true;
            }
            if (end == 0) {
                return this.patternLength == 0;
            }
            if (this.patternLength == 0) {
                return false;
            }
            currentTextPosition = 0;
            if (end - this.bound < 0) {
                return false;
            }
            segmentIndex = 0;
            current = this.segments[segmentIndex];
            if (!this.hasLeadingStar) {
                currentLength = current.length();
                if (!this.regExpRegionMatches(text, 0, current, 0, currentLength)) {
                    return false;
                }
                ++segmentIndex;
                currentTextPosition += currentLength;
            }
            if (segmentCount != 1 || this.hasLeadingStar || this.hasTrailingStar) ** GOTO lbl30
            return currentTextPosition == end;
lbl-1000:
            // 1 sources

            {
                current = this.segments[segmentIndex];
                currentMatch = this.findPosition(text, currentTextPosition, end, current);
                if (currentMatch < 0) {
                    return false;
                }
                currentTextPosition = currentMatch + current.length();
                ++segmentIndex;
lbl30:
                // 2 sources

                ** while (segmentIndex < segmentCount)
            }
lbl31:
            // 1 sources

            if (!this.hasTrailingStar && currentTextPosition != end) {
                currentLength = current.length();
                return this.regExpRegionMatches(text, end - currentLength, current, 0, currentLength);
            }
            return segmentIndex == segmentCount;
        }

        private void parseWildCards() {
            if (this.pattern.startsWith("*")) {
                this.hasLeadingStar = true;
            }
            if (this.pattern.endsWith("*") && this.patternLength > 1 && this.pattern.charAt(this.patternLength - 2) != '\\') {
                this.hasTrailingStar = true;
            }
            ArrayList<String> temp = new ArrayList<String>();
            int pos = 0;
            StringBuffer buf = new StringBuffer();
            block5: while (pos < this.patternLength) {
                char c = this.pattern.charAt(pos++);
                switch (c) {
                    case '\\': {
                        char next;
                        if (pos >= this.patternLength) {
                            buf.append(c);
                            break;
                        }
                        if ((next = this.pattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                            buf.append(next);
                            break;
                        }
                        buf.append(c);
                        buf.append(next);
                        break;
                    }
                    case '*': {
                        if (buf.length() <= 0) continue block5;
                        temp.add(buf.toString());
                        this.bound += buf.length();
                        buf.setLength(0);
                        break;
                    }
                    case '?': {
                        buf.append('\u0000');
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            if (buf.length() > 0) {
                temp.add(buf.toString());
                this.bound += buf.length();
            }
            this.segments = temp.toArray(new String[temp.size()]);
        }

        private boolean regExpRegionMatches(String text, int tStart, String p, int pStart, int plen) {
            while (plen-- > 0) {
                char pchar;
                char tchar = text.charAt(tStart++);
                if ((pchar = p.charAt(pStart++)) == '\u0000' || pchar == tchar || Character.toUpperCase(tchar) == Character.toUpperCase(pchar) || Character.toLowerCase(tchar) == Character.toLowerCase(pchar)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "StringMatcher: " + this.pattern;
        }
    }
}

