/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.internal.ClasspathTableManager;
import org.eclipse.jst.j2ee.internal.IClasspathTableOwner;
import org.eclipse.jst.j2ee.internal.IJ2EEDependenciesControl;
import org.eclipse.jst.j2ee.internal.J2EEDependenciesPage;
import org.eclipse.jst.j2ee.internal.ManifestErrorPrompter;
import org.eclipse.jst.j2ee.internal.ManifestUIResourceHandler;
import org.eclipse.jst.j2ee.internal.UpdateManifestOperation;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.listeners.IValidateEditListener;
import org.eclipse.jst.j2ee.internal.listeners.ValidateEditListener;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.internal.util.IModuleConstants;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.common.frameworks.internal.ui.WorkspaceModifyComposedOperation;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;

public class JARDependencyPropertiesPage
implements IJ2EEDependenciesControl,
IClasspathTableOwner,
Listener,
ClasspathModelListener {
    protected final IProject project;
    protected final J2EEDependenciesPage propPage;
    protected IOException caughtManifestException;
    protected boolean isDirty;
    protected Text classPathText;
    protected Text componentNameText;
    protected ClasspathModel model;
    protected CCombo availableAppsCombo;
    protected ClasspathTableManager tableManager;
    protected IValidateEditListener validateEditListener;
    protected Label manifestLabel;
    protected Label enterpriseApplicationLabel;
    protected Label availableDependentJars;

    public JARDependencyPropertiesPage(IProject project, J2EEDependenciesPage page) {
        J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
        this.project = project;
        this.propPage = page;
    }

    protected void initialize() {
        this.model = this.createClasspathModel();
        this.model.setProject(this.project);
        if (this.model.getComponent() != null) {
            this.model.addListener((ClasspathModelListener)this);
            this.updateModelManifest();
            this.initializeValidateEditListener();
        }
    }

    protected ClasspathModel createClasspathModel() {
        return new ClasspathModel(null, false);
    }

    public void dispose() {
        J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
        if (this.model != null && this.model.earArtifactEdit != null) {
            this.model.earArtifactEdit.dispose();
            this.model.earArtifactEdit = null;
        }
    }

    /*
     * Exception decompiling
     */
    private void updateModelManifest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 213->217)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void initializeValidateEditListener() {
        this.validateEditListener = new ValidateEditListener(null, (ResourceStateValidator)this.model);
        this.validateEditListener.setShell(this.propPage.getShell());
    }

    public void setVisible(boolean visible) {
        if (visible && this.caughtManifestException != null && !this.model.isDirty()) {
            ManifestErrorPrompter.showManifestException(this.propPage.getShell(), ERROR_READING_MANIFEST_DIALOG_MESSAGE_PROP_PAGE, false, this.caughtManifestException);
        }
    }

    public Composite createContents(Composite parent) {
        this.initialize();
        Composite composite = this.createBasicComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.model.getComponent() != null) {
            if (!this.isValidComponent()) {
                return composite;
            }
            J2EEDependenciesPage.createDescriptionComposite(composite, ManifestUIResourceHandler.J2EE_Modules_Desc);
            this.createProjectLabelsGroup(composite);
            this.createListGroup(composite);
            this.createTextGroup(composite);
            this.refresh();
        }
        return composite;
    }

    protected Composite createBasicComposite(Composite comp) {
        Composite composite = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected boolean isValidComponent() {
        if (J2EEProjectUtilities.isEARProject((IProject)this.project)) {
            this.propPage.setErrorMessage(ManifestUIResourceHandler.EAR_Module_Dep_Error);
            return false;
        }
        if (J2EEProjectUtilities.isStandaloneProject((IProject)this.model.getComponent().getProject())) {
            this.propPage.setErrorMessage(ClasspathModel.NO_EAR_MESSAGE);
            return false;
        }
        return true;
    }

    protected void createProjectLabelsGroup(Composite parent) {
        Composite labelsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        labelsGroup.setLayout((Layout)layout);
        labelsGroup.setLayoutData((Object)new GridData(768));
        this.createEnterpriseAppsControls(labelsGroup);
    }

    private void createEnterpriseAppsControls(Composite labelsGroup) {
        this.enterpriseApplicationLabel = new Label(labelsGroup, 0);
        this.enterpriseApplicationLabel.setText(ManifestUIResourceHandler.EAR_Project_Name__UI__UI_);
        this.availableAppsCombo = new CCombo(labelsGroup, 2056);
        GridData gd = new GridData(768);
        this.availableAppsCombo.setLayoutData((Object)gd);
        this.availableAppsCombo.addListener(13, (Listener)this);
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listGroup.setLayout((Layout)layout);
        GridData gData = new GridData(1808);
        gData.horizontalIndent = 5;
        listGroup.setLayoutData((Object)gData);
        this.availableDependentJars = new Label(listGroup, 0);
        gData = new GridData(272);
        this.availableDependentJars.setText(ManifestUIResourceHandler.Available_dependent_JARs__UI_);
        this.availableDependentJars.setLayoutData((Object)gData);
        this.createTableComposite(listGroup);
    }

    public Group createGroup(Composite parent) {
        return new Group(parent, 0);
    }

    protected void createTextGroup(Composite parent) {
        Composite textGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        textGroup.setLayout((Layout)layout);
        textGroup.setLayoutData((Object)new GridData(1808));
        this.createClassPathText(textGroup);
    }

    protected void createClassPathText(Composite textGroup) {
        this.manifestLabel = new Label(textGroup, 0);
        this.manifestLabel.setText(ManifestUIResourceHandler.Manifest_Class_Path__UI_);
        this.classPathText = new Text(textGroup, 2626);
        GridData gData = new GridData(1808);
        gData.widthHint = 400;
        gData.heightHint = 100;
        this.classPathText.setLayoutData((Object)gData);
        this.classPathText.setEditable(false);
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.tableManager = new ClasspathTableManager(this, this.model, this.validateEditListener);
        this.tableManager.fillComposite(composite);
    }

    public CheckboxTableViewer createAvailableJARsViewer(Composite parent) {
        int flags = 67618;
        Table table = new Table(parent, flags);
        CheckboxTableViewer availableJARsViewer = new CheckboxTableViewer(table);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn fileNameColumn = new TableColumn(table, 0, 0);
        fileNameColumn.setText(ManifestUIResourceHandler.JAR_Module_UI_);
        fileNameColumn.setResizable(true);
        TableColumn projectColumn = new TableColumn(table, 0, 1);
        projectColumn.setText(ManifestUIResourceHandler.Project_UI_);
        projectColumn.setResizable(true);
        tableLayout.layout((Composite)table, true);
        return availableJARsViewer;
    }

    public Composite createButtonColumnComposite(Composite parent) {
        Composite buttonColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonColumn.setLayout((Layout)layout);
        GridData data = new GridData(258);
        buttonColumn.setLayoutData((Object)data);
        return buttonColumn;
    }

    public Button primCreatePushButton(String label, Composite buttonColumn) {
        Button aButton = new Button(buttonColumn, 8);
        aButton.setText(label);
        return aButton;
    }

    public Button primCreateRadioButton(String label, Composite parent) {
        Button aButton = new Button(parent, 16);
        aButton.setText(label);
        return aButton;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.availableAppsCombo) {
            this.availableAppsSelected(event);
        }
    }

    protected void availableAppsSelected(Event event) {
        int index = this.availableAppsCombo.getSelectionIndex();
        this.model.selectEAR(index);
    }

    protected void populateApps() {
        IVirtualComponent[] components = this.model.getAvailableEARComponents();
        String[] values = new String[components.length];
        int i = 0;
        while (i < components.length) {
            values[i] = components[i].getProject().getName();
            ++i;
        }
        if (this.availableAppsCombo != null) {
            this.availableAppsCombo.setItems(values);
            IVirtualComponent selected = this.model.getSelectedEARComponent();
            if (selected != null) {
                int index = Arrays.asList(components).indexOf(selected);
                this.availableAppsCombo.select(index);
            } else {
                this.availableAppsCombo.clearSelection();
            }
        }
    }

    protected void refresh() {
        this.populateApps();
        this.tableManager.refresh();
        this.refreshText();
    }

    public void refreshText() {
        ClassPathSelection sel = this.model.getClassPathSelection();
        if (sel != null && this.classPathText != null) {
            this.classPathText.setText(sel == null ? "" : sel.toString());
        }
    }

    public void modelChanged(ClasspathModelEvent evt) {
        if (evt.getEventType() == 1) {
            this.isDirty = true;
            this.refreshText();
        } else if (evt.getEventType() == 2) {
            this.tableManager.refresh();
        }
    }

    public void performDefaults() {
        this.model.resetClassPathSelection();
        this.refresh();
        this.isDirty = false;
        this.model.dispose();
    }

    public boolean performCancel() {
        this.model.dispose();
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performOk() {
        if (!this.isDirty) {
            return true;
        }
        WorkspaceModifyComposedOperation composed = new WorkspaceModifyComposedOperation((IRunnableWithProgress)this.createManifestOperation());
        try {
            try {
                new ProgressMonitorDialog(this.propPage.getShell()).run(true, true, (IRunnableWithProgress)composed);
            }
            catch (InvocationTargetException ex) {
                block8: {
                    String title;
                    String msg = title = ManifestUIResourceHandler.An_internal_error_occurred_ERROR_;
                    if (ex.getTargetException() != null && ex.getTargetException().getMessage() != null) {
                        msg = ex.getTargetException().getMessage();
                    }
                    MessageDialog.openError((Shell)this.propPage.getShell(), (String)title, (String)msg);
                    Logger.getLogger().logError((Throwable)ex);
                    break block8;
                    catch (InterruptedException interruptedException) {}
                }
                Object var5_5 = null;
                this.model.dispose();
                return false;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.model.dispose();
            throw throwable;
        }
        this.model.dispose();
        this.isDirty = false;
        return true;
    }

    List getUnSelectedClassPathElementsForJ2EEDependency() {
        List unselectedForJ2EE = this.getUnSelectedClassPathSelection().getClasspathElements();
        ArrayList<ClasspathElement> unselected = new ArrayList<ClasspathElement>();
        if (this.model != null && this.model.getClassPathSelectionForWLPs() != null) {
            List wlpSelected = this.model.getClassPathSelectionForWLPs().getSelectedClasspathElements();
            Iterator it = unselectedForJ2EE.iterator();
            while (it.hasNext()) {
                ClasspathElement element = (ClasspathElement)it.next();
                Iterator wlpIterator = wlpSelected.iterator();
                boolean found = false;
                while (wlpIterator.hasNext()) {
                    ClasspathElement wlpElement = (ClasspathElement)wlpIterator.next();
                    String text = element.getText();
                    int index = text.indexOf(".jar");
                    if (index == -1 || !(text = text.substring(0, index)).equals(wlpElement.getText())) continue;
                    found = true;
                    break;
                }
                if (found || unselected.contains(element)) continue;
                unselected.add(element);
            }
        }
        return unselected;
    }

    List getUnSelectedClassPathElementsForWebDependency() {
        List unselectedForWLP = this.getUnSelectedClassPathSelectionForWLPs().getClasspathElements();
        List<ClasspathElement> unselected = new ArrayList();
        if (this.model != null && this.model.getClassPathSelection() != null) {
            List j2eeSelected = this.model.getClassPathSelection().getSelectedClasspathElements();
            Iterator it = unselectedForWLP.iterator();
            while (it.hasNext()) {
                ClasspathElement element = (ClasspathElement)it.next();
                Iterator j2eeIterator = j2eeSelected.iterator();
                boolean found = false;
                while (j2eeIterator.hasNext()) {
                    ClasspathElement j2eeElement = (ClasspathElement)j2eeIterator.next();
                    String text = j2eeElement.getText();
                    int index = text.indexOf(".jar");
                    if (index == -1) continue;
                    text = text.substring(0, index);
                    if (!element.getText().equals(text)) continue;
                    found = true;
                    break;
                }
                if (found || unselected.contains(element)) continue;
                unselected.add(element);
            }
        } else {
            unselected = unselectedForWLP;
        }
        return unselected;
    }

    protected WorkspaceModifyComposedOperation createJ2EEComponentDependencyOperations() {
        ClasspathElement element;
        WorkspaceModifyComposedOperation composedOp = null;
        List selected = this.getSelectedClassPathSelection().getClasspathElements();
        List unselected = this.getUnSelectedClassPathElementsForJ2EEDependency();
        ArrayList<IVirtualComponent> targetComponentsHandles = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < selected.size()) {
            element = (ClasspathElement)selected.get(i);
            IVirtualComponent component = element.getComponent();
            if (component != null) {
                targetComponentsHandles.add(component);
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            composedOp = new WorkspaceModifyComposedOperation();
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.createReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        targetComponentsHandles = new ArrayList();
        i = 0;
        while (i < unselected.size()) {
            element = (ClasspathElement)unselected.get(i);
            IProject elementProject = element.getProject();
            if (elementProject != null) {
                if (ModuleCoreNature.isFlexibleProject((IProject)elementProject)) {
                    IVirtualComponent targetComp = ComponentCore.createComponent((IProject)elementProject);
                    targetComponentsHandles.add(targetComp);
                }
            } else {
                URI archiveURI = element.getArchiveURI();
                if (archiveURI != null && !archiveURI.equals((Object)"")) {
                    IVirtualReference ref;
                    String name = "";
                    try {
                        String type = ModuleURIUtil.getArchiveType((URI)archiveURI);
                        String tmpname = ModuleURIUtil.getArchiveName((URI)archiveURI);
                        name = String.valueOf(type) + '/' + tmpname;
                    }
                    catch (UnresolveableURIException e) {
                        Logger.getLogger().logError(e.getMessage());
                    }
                    if (!name.equals("") && (ref = this.model.getComponent().getReference(name)) != null) {
                        IVirtualComponent referenced = ref.getReferencedComponent();
                        targetComponentsHandles.add(referenced);
                    }
                }
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            if (composedOp == null) {
                composedOp = new WorkspaceModifyComposedOperation();
            }
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.removeReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        return composedOp;
    }

    protected WorkspaceModifyComposedOperation createComponentDependencyOperations() {
        IVirtualComponent targetComp;
        IProject elementProject;
        ClasspathElement element;
        WorkspaceModifyComposedOperation composedOp = null;
        List selected = this.getSelectedClassPathSelectionForWLPs().getClasspathElements();
        List unselected = this.getUnSelectedClassPathSelectionForWLPs().getClasspathElements();
        ArrayList<IVirtualComponent> targetComponentsHandles = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < selected.size()) {
            element = (ClasspathElement)selected.get(i);
            elementProject = element.getProject();
            if (elementProject != null) {
                targetComp = ComponentCore.createComponent((IProject)elementProject);
                targetComponentsHandles.add(targetComp);
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            composedOp = new WorkspaceModifyComposedOperation();
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.createWLPReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        targetComponentsHandles = new ArrayList();
        i = 0;
        while (i < unselected.size()) {
            element = (ClasspathElement)unselected.get(i);
            elementProject = element.getProject();
            if (elementProject != null) {
                if (ModuleCoreNature.isFlexibleProject((IProject)elementProject)) {
                    targetComp = ComponentCore.createComponent((IProject)elementProject);
                    targetComponentsHandles.add(targetComp);
                }
            } else {
                URI archiveURI = element.getArchiveURI();
                if (archiveURI != null && !archiveURI.equals((Object)"")) {
                    String name = "";
                    try {
                        String type = ModuleURIUtil.getArchiveType((URI)archiveURI);
                        String tmpname = ModuleURIUtil.getArchiveName((URI)archiveURI);
                        name = String.valueOf(type) + '/' + tmpname;
                    }
                    catch (UnresolveableURIException e) {
                        Logger.getLogger().logError(e.getMessage());
                    }
                    if (!name.equals("")) {
                        IVirtualReference ref = this.model.getComponent().getReference(name);
                        IVirtualComponent referenced = ref.getReferencedComponent();
                        targetComponentsHandles.add(referenced);
                    }
                }
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            if (composedOp == null) {
                composedOp = new WorkspaceModifyComposedOperation();
            }
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.removeWLPReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        return composedOp;
    }

    protected WorkspaceModifyComposedOperation createFlexProjectOperations() {
        WorkspaceModifyComposedOperation composedOp = null;
        try {
            Object[] elements = this.tableManager.availableJARsViewer.getCheckedElements();
            int i = 0;
            while (i < elements.length) {
                ClasspathElement element = (ClasspathElement)elements[i];
                IProject elementProject = element.getProject();
                if (elementProject != null && !elementProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                    if (composedOp == null) {
                        composedOp = new WorkspaceModifyComposedOperation();
                    }
                    composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)J2EEProjectUtilities.createFlexJavaProjectForProjectOperation((IProject)elementProject, (boolean)false)));
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return composedOp;
    }

    protected IRunnableWithProgress createBuildPathOperation() {
        return null;
    }

    protected IRunnableWithProgress createWLPBuildPathOperation() {
        return null;
    }

    protected ClassPathSelection getUnSelectedClassPathSelectionForWLPs() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        List modelElements = this.model.getClassPathSelectionForWLPs().getClasspathElements();
        int i = 0;
        while (i < modelElements.size()) {
            List<Object> checkedElementsList = Arrays.asList(checkedElements);
            if (!checkedElementsList.contains(modelElements.get(i))) {
                selection.getClasspathElements().add(modelElements.get(i));
            }
            ++i;
        }
        return selection;
    }

    private ClassPathSelection getSelectedClassPathSelection() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            selection.getClasspathElements().add(checkedElements[i]);
            ++i;
        }
        return selection;
    }

    protected ClassPathSelection getUnSelectedClassPathSelection() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        List modelElements = this.model.getClassPathSelection().getClasspathElements();
        int i = 0;
        while (i < modelElements.size()) {
            List<Object> checkedElementsList = Arrays.asList(checkedElements);
            if (!checkedElementsList.contains(modelElements.get(i))) {
                selection.getClasspathElements().add(modelElements.get(i));
            }
            ++i;
        }
        return selection;
    }

    private ClassPathSelection getSelectedClassPathSelectionForWLPs() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            selection.getClasspathElements().add(checkedElements[i]);
            ++i;
        }
        return selection;
    }

    protected UpdateManifestOperation createManifestOperation() {
        return new UpdateManifestOperation(this.project.getName(), this.model.getClassPathSelection().toString(), true);
    }

    protected boolean isReadOnly() {
        return JemProjectUtilities.isBinaryProject((IProject)this.project) && this.project.findMember((IPath)IModuleConstants.COMPONENT_FILE_PATH) == null;
    }
}

