/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.ADTSelectionFeedbackEditPolicy;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ReferenceConnection;
import org.eclipse.wst.xsd.ui.internal.design.figures.GenericGroupFigure;
import org.eclipse.wst.xsd.ui.internal.design.figures.IExtendedFigureFactory;
import org.eclipse.xsd.XSDConcreteComponent;

public abstract class ConnectableEditPart
extends BaseEditPart {
    protected ArrayList connectionFigures = new ArrayList();

    public IExtendedFigureFactory getExtendedFigureFactory() {
        EditPartFactory factory = this.getViewer().getEditPartFactory();
        Assert.isTrue((boolean)(factory instanceof IExtendedFigureFactory), (String)"EditPartFactory must be an instanceof of IExtendedFigureFactory");
        return (IExtendedFigureFactory)factory;
    }

    protected IFigure createFigure() {
        GenericGroupFigure figure = new GenericGroupFigure();
        return figure;
    }

    public XSDConcreteComponent getXSDConcreteComponent() {
        return (XSDConcreteComponent)((XSDBaseAdapter)this.getModel()).getTarget();
    }

    public List getConnectionFigures() {
        return this.connectionFigures;
    }

    public abstract ReferenceConnection createConnectionFigure(BaseEditPart var1);

    public void activate() {
        super.activate();
        this.activateConnection();
    }

    protected void activateConnection() {
        if (this.connectionFigures == null) {
            this.connectionFigures = new ArrayList();
        }
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof BaseEditPart)) continue;
            BaseEditPart g = (BaseEditPart)o;
            ReferenceConnection figure = this.createConnectionFigure(g);
            this.connectionFigures.add(figure);
            figure.setPoints(figure.getPoints());
            this.getLayer("Connection Layer").add((IFigure)figure);
        }
    }

    public void deactivate() {
        super.deactivate();
        this.deactivateConnection();
    }

    protected void deactivateConnection() {
        if (this.connectionFigures != null && !this.connectionFigures.isEmpty()) {
            Iterator i = this.connectionFigures.iterator();
            while (i.hasNext()) {
                ReferenceConnection connectionFigure = (ReferenceConnection)((Object)i.next());
                if (!this.getLayer("Connection Layer").getChildren().contains((Object)connectionFigure)) continue;
                this.getLayer("Connection Layer").remove((IFigure)connectionFigure);
            }
            this.connectionFigures = null;
        }
    }

    public void refresh() {
        super.refresh();
        this.refreshConnection();
    }

    protected void refreshConnection() {
        if (!this.isActive()) {
            return;
        }
        if (this.connectionFigures == null || this.connectionFigures.isEmpty()) {
            this.activateConnection();
        } else {
            this.deactivateConnection();
            this.activateConnection();
        }
    }

    public void addFeedback() {
        if (this.connectionFigures != null && !this.connectionFigures.isEmpty()) {
            Iterator i = this.connectionFigures.iterator();
            while (i.hasNext()) {
                ReferenceConnection connectionFigure = (ReferenceConnection)((Object)i.next());
                connectionFigure.setHighlight(true);
            }
        }
        GenericGroupFigure figure = (GenericGroupFigure)this.getFigure();
        figure.getIconFigure().setMode(1);
        figure.getIconFigure().refresh();
    }

    public void removeFeedback() {
        if (this.connectionFigures != null && !this.connectionFigures.isEmpty()) {
            Iterator i = this.connectionFigures.iterator();
            while (i.hasNext()) {
                ReferenceConnection connectionFigure = (ReferenceConnection)((Object)i.next());
                connectionFigure.setHighlight(false);
            }
        }
        GenericGroupFigure figure = (GenericGroupFigure)this.getFigure();
        figure.getIconFigure().setMode(0);
        figure.getIconFigure().refresh();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        GenericGroupFigure figure = (GenericGroupFigure)this.getFigure();
        figure.getIconFigure().refresh();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ADTSelectionFeedbackEditPolicy());
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().add(child, index);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().remove(child);
    }

    public IFigure getContentPane() {
        return ((GenericGroupFigure)this.getFigure()).getContentFigure();
    }

    public Figure getTargetFigure() {
        return ((GenericGroupFigure)this.getFigure()).getTargetFigure();
    }
}

