/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public final class PublishHelper {
    private static final int BUFFER = 65536;
    private static byte[] buf = new byte[65536];
    private static final IStatus[] EMPTY_STATUS = new IStatus[0];
    private static final File defaultTempDir = ServerPlugin.getInstance().getStateLocation().toFile();
    private static final String TEMPFILE_PREFIX = "tmp";
    private File tempDir;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PublishHelper(File tempDirectory) {
        this.tempDir = tempDirectory;
        if (this.tempDir == null) {
            this.tempDir = defaultTempDir;
        } else if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(InputStream in, IPath to, long ts, IModuleFile mf) throws CoreException {
        OutputStream out;
        block18: {
            out = null;
            File tempFile = null;
            try {
                try {
                    File file = to.toFile();
                    tempFile = File.createTempFile(TEMPFILE_PREFIX, "." + to.getFileExtension(), this.tempDir);
                    out = new FileOutputStream(tempFile);
                    int avail = in.read(buf);
                    while (true) {
                        block19: {
                            if (avail > 0) break block19;
                            out.close();
                            out = null;
                            this.moveTempFile(tempFile, file);
                            if (ts != -1L && ts != 0L) {
                                file.setLastModified(ts);
                            }
                            break;
                        }
                        out.write(buf, 0, avail);
                        avail = in.read(buf);
                    }
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    IPath path = mf.getModuleRelativePath().append(mf.getName());
                    Trace.trace(Trace.SEVERE, "Error copying file: " + path.toOSString() + " to " + to.toOSString(), e);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorSaving, (Object)path.toOSString(), (Object)e.getLocalizedMessage()), null));
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var10_14 = null;
                if (tempFile == null || !tempFile.exists()) break block18;
                tempFile.deleteOnExit();
            }
        }
        try {}
        catch (Exception exception) {}
        if (in != null) {
            in.close();
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (out == null) return;
        out.close();
    }

    private static boolean safeDelete(File f, int retrys) {
        int count = 0;
        while (count < retrys) {
            if (!f.exists()) {
                return true;
            }
            f.delete();
            if (!f.exists()) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void moveTempFile(File tempFile, File file) throws CoreException {
        if (file.exists() && !PublishHelper.safeDelete(file, 2)) {
            try {
                try {
                    FileInputStream in = new FileInputStream(tempFile);
                    IStatus status = this.copyFile(in, file.getPath());
                    if (!status.isOK()) {
                        Trace.trace(Trace.SEVERE, "Error moving file: " + file.toString(), status.getException());
                        MultiStatus status2 = new MultiStatus("org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorSaving, (Object)file.toString()), null);
                        status2.add(status);
                        throw new CoreException((IStatus)status2);
                    }
                    Object var6_6 = null;
                    tempFile.delete();
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                tempFile.delete();
                throw throwable;
            }
            Object var6_8 = null;
            tempFile.delete();
        }
        if (PublishHelper.safeRename(tempFile, file, 10)) return;
        Trace.trace(Trace.SEVERE, "Error moving temp file: " + tempFile.toString());
        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorSaving, (Object)tempFile.toString()), null));
    }

    private static boolean safeRename(File from, File to, int retrys) {
        File dir = to.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        int count = 0;
        while (count < retrys) {
            if (from.renameTo(to)) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private void copyFile(IModuleFile mf, IPath path) throws CoreException {
        IFile file;
        Trace.trace(Trace.FINEST, "Copying: " + mf.getName() + " to " + path.toString());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)mf.getAdapter(clazz)) != null) {
            this.copyFile(file.getContents(), path, file.getLocalTimeStamp(), mf);
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            File file2 = (File)mf.getAdapter(clazz2);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file2);
            }
            catch (IOException e) {
                Trace.trace(Trace.SEVERE, "Error copying file: " + file2.getAbsolutePath(), e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorSaving, (Object)file2.getAbsolutePath()), (Throwable)e));
            }
            this.copyFile(in, path, file2.lastModified(), mf);
        }
    }

    public IStatus[] publishFull(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        if (resources == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        ArrayList status = new ArrayList(2);
        int size = resources.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat = this.copy(resources[i], path, monitor);
            PublishHelper.addArrayToList(status, stat);
            ++i;
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    private IStatus[] copy(IModuleResource resource, IPath path, IProgressMonitor monitor) {
        String name = resource.getName();
        Trace.trace(Trace.FINEST, "Copying: " + name + " to " + path.toString());
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        if (resource instanceof IModuleFolder) {
            IModuleFolder folder = (IModuleFolder)resource;
            IStatus[] stat = this.publishFull(folder.members(), path, monitor);
            PublishHelper.addArrayToList(status, stat);
        } else {
            IModuleFile mf = (IModuleFile)resource;
            File f = (path = path.append(mf.getModuleRelativePath()).append(name)).toFile().getParentFile();
            if (!f.exists()) {
                f.mkdirs();
            }
            try {
                this.copyFile(mf, path);
            }
            catch (CoreException ce) {
                status.add(ce.getStatus());
            }
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus copyFile(InputStream in, String to) {
        IStatus iStatus;
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(to);
                int avail = in.read(buf);
                while (true) {
                    if (avail <= 0) {
                        iStatus = Status.OK_STATUS;
                        Object var5_8 = null;
                        break;
                    }
                    ((OutputStream)out).write(buf, 0, avail);
                    avail = in.read(buf);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error copying file", e);
                Status status = new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorSaving, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
                Object var5_9 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out == null) return status;
                    ((OutputStream)out).close();
                    return status;
                }
                catch (Exception exception) {}
                return status;
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            try {}
            catch (Exception exception) {}
            if (in != null) {
                in.close();
            }
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            if (out == null) throw throwable;
            ((OutputStream)out).close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (in != null) {
            in.close();
        }
        try {}
        catch (Exception exception) {}
        if (out == null) return iStatus;
        ((OutputStream)out).close();
        return iStatus;
    }

    private static void addArrayToList(List list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }
}

