/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.util.XMLChar;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNameCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.RefactoringSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.w3c.dom.Element;

public class XSDAttributeGroupDefinitionSection
extends RefactoringSection {
    protected Text nameText;
    protected CCombo refCombo;
    boolean isReference;

    protected void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        if (this.isReference) {
            GridData data = new GridData();
            data.horizontalAlignment = 32;
            data.grabExcessHorizontalSpace = false;
            CLabel refLabel = this.getWidgetFactory().createCLabel(this.composite, "ref:");
            refLabel.setLayoutData((Object)data);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            this.refCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
            this.refCombo.addSelectionListener((SelectionListener)this);
            this.refCombo.setLayoutData((Object)data);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.refCombo, "org.eclipse.wst.xsd.ui.xsdup0440");
        } else {
            GridData data = new GridData();
            data.horizontalAlignment = 32;
            data.grabExcessHorizontalSpace = false;
            CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_NAME);
            nameLabel.setLayoutData((Object)data);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            this.nameText = this.getWidgetFactory().createText(this.composite, "");
            this.nameText.setLayoutData((Object)data);
            this.applyAllListeners((Control)this.nameText);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameText, "org.eclipse.wst.xsd.ui.xsdup0340");
            this.createRenameHyperlink(this.composite);
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        this.setListenerEnabled(false);
        XSDNamedComponent namedComponent = (XSDNamedComponent)this.input;
        if (this.isReference) {
            Element element = namedComponent.getElement();
            if (element != null) {
                String attrValue = element.getAttribute("ref");
                if (attrValue == null) {
                    attrValue = "";
                }
                this.refCombo.setText(attrValue);
            }
        } else {
            this.nameText.setText("");
            String name = namedComponent.getName();
            if (name != null) {
                this.nameText.setText(name);
            }
        }
        this.setListenerEnabled(true);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.init();
        this.relayout();
        if (this.isReference) {
            TypesHelper helper = new TypesHelper(this.xsdSchema);
            List<String> items = new ArrayList();
            items = helper.getGlobalAttributeGroups();
            items.add(0, "");
            this.refCombo.setItems(items.toArray(new String[0]));
        }
    }

    protected void relayout() {
        Composite parentComposite = this.composite.getParent();
        parentComposite.getParent().setRedraw(false);
        if (parentComposite != null && !parentComposite.isDisposed()) {
            Control[] children = parentComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this.createContents(parentComposite);
        parentComposite.getParent().layout(true, true);
        parentComposite.getParent().setRedraw(true);
        this.refresh();
    }

    protected void init() {
        if (this.input instanceof XSDAttributeGroupDefinition) {
            XSDAttributeGroupDefinition group = (XSDAttributeGroupDefinition)this.input;
            this.isReference = group.isAttributeGroupDefinitionReference();
        }
    }

    public void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.widget == this.nameText) {
            String newValue = this.nameText.getText().trim();
            if (this.input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)this.input;
                if (!this.validateSection()) {
                    return;
                }
                UpdateNameCommand command = null;
                String oldName = namedComponent.getName();
                if (!newValue.equals(oldName)) {
                    command = new UpdateNameCommand(Messages._UI_ACTION_RENAME, namedComponent, newValue);
                }
                if (command != null && this.getCommandStack() != null) {
                    this.getCommandStack().execute((Command)command);
                }
            }
        }
    }

    protected boolean validateSection() {
        if (this.nameText == null || this.nameText.isDisposed()) {
            return true;
        }
        this.setErrorMessage(null);
        String name = this.nameText.getText().trim();
        if (name.length() < 1 || !XMLChar.isValidNCName((String)name)) {
            this.setErrorMessage(Messages._UI_ERROR_INVALID_NAME);
            return false;
        }
        return true;
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.refCombo) {
            String newValue = this.refCombo.getText();
            if (this.input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)this.input;
                Element element = namedComponent.getElement();
                if (namedComponent instanceof XSDAttributeGroupDefinition) {
                    element.setAttribute("ref", newValue);
                }
            }
        }
        super.doWidgetSelected(e);
    }

    public void dispose() {
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.removeListeners((Control)this.nameText);
        }
        super.dispose();
    }
}

