/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.environment.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.environment.StatusException;

public class StatusHandlerTests
extends TestCase {
    private IStatus error = new Status(4, "id", 0, "error message", null);
    private IStatus info = new Status(1, "id", 0, "info message", null);
    private IStatus warning = new Status(2, "id", 0, "warning message", null);
    static /* synthetic */ Class class$0;

    public StatusHandlerTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            StatusHandlerTests.runAll();
        } else if (args.length == 1) {
            String methodToRun = args[0].trim();
            StatusHandlerTests.runOne(methodToRun);
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.environment.tests.StatusHandlerTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected static void runAll() {
        TestRunner.run((Test)StatusHandlerTests.suite());
    }

    public static void runOne(String methodName) {
        TestSuite testSuite = new TestSuite();
        StatusHandlerTests test = new StatusHandlerTests(methodName);
        System.out.println("Calling StatusHandlerTests." + methodName);
        testSuite.addTest((Test)test);
        TestRunner.run((Test)testSuite);
    }

    public void testEnvironmentStatusHandler() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IStatusHandler handler = environment.getStatusHandler();
        try {
            Choice choice1 = new Choice();
            Choice choice2 = new Choice('o', "Ok", "description");
            StatusException someException = new StatusException(this.error);
            StatusHandlerTests.assertTrue((String)"Status not the same ", (someException.getStatus() == this.error ? 1 : 0) != 0);
            handler.report(Status.OK_STATUS);
            handler.report(this.error);
            handler.report(this.warning);
            handler.report(this.info);
            choice1.setShortcut('c');
            choice1.setLabel("cancel");
            choice1.setDescription("cancel description");
            Choice result = handler.report(this.error, null);
            StatusHandlerTests.assertTrue((String)"result not null ", (result == null ? 1 : 0) != 0);
            result = handler.report(this.error, new Choice[0]);
            StatusHandlerTests.assertTrue((String)"result not null ", (result == null ? 1 : 0) != 0);
            result = handler.report(this.error, new Choice[]{choice2, choice1});
            StatusHandlerTests.assertTrue((String)"First choice shortcut not the same", (result.getShortcut() == choice2.getShortcut() ? 1 : 0) != 0);
            StatusHandlerTests.assertTrue((String)"First choice label not the same", (boolean)result.getLabel().equals(choice2.getLabel()));
            StatusHandlerTests.assertTrue((String)"First choice description not the same", (boolean)result.getDescription().equals(choice2.getDescription()));
            handler.reportError(this.error);
            handler.reportInfo(this.info);
        }
        catch (StatusException statusException) {
            StatusHandlerTests.assertTrue((String)"unexpected exception:", (boolean)false);
        }
    }
}

