/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import junit.framework.TestCase;

public abstract class WSDL4JDefinitionVisitor
extends TestCase {
    protected Definition definition;

    private WSDL4JDefinitionVisitor() {
    }

    public WSDL4JDefinitionVisitor(String name) {
        super(name);
    }

    protected WSDL4JDefinitionVisitor(Definition definition) {
        this.definition = definition;
    }

    public void visit() {
        this.visitDefinition(this.definition);
    }

    protected void visitDefinition(Definition def) {
        Map imports = def.getImports();
        Iterator<Object> iterator = imports.keySet().iterator();
        Import myImport = null;
        while (iterator.hasNext()) {
            myImport = (Import)((ArrayList)imports.get(iterator.next())).get(0);
            this.visitImport(myImport);
        }
        Types types = def.getTypes();
        if (types != null) {
            this.visitTypes(types);
        }
        iterator = def.getMessages().values().iterator();
        while (iterator.hasNext()) {
            this.visitMessage((Message)iterator.next());
        }
        iterator = def.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            this.visitPortType((PortType)iterator.next());
        }
        iterator = def.getBindings().values().iterator();
        while (iterator.hasNext()) {
            this.visitBinding((Binding)iterator.next());
        }
        iterator = def.getServices().values().iterator();
        while (iterator.hasNext()) {
            this.visitService((Service)iterator.next());
        }
        iterator = def.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibilityElement)iterator.next());
        }
    }

    protected abstract void visitImport(Import var1);

    protected abstract void visitTypes(Types var1);

    protected void visitMessage(Message message) {
        Iterator iterator = message.getParts().values().iterator();
        while (iterator.hasNext()) {
            this.visitPart((Part)iterator.next());
        }
    }

    protected abstract void visitPart(Part var1);

    protected void visitPortType(PortType portType) {
        Iterator iterator = portType.getOperations().iterator();
        while (iterator.hasNext()) {
            this.visitOperation((Operation)iterator.next());
        }
    }

    protected void visitOperation(Operation operation) {
        Input input = operation.getInput();
        this.visitInput(input);
        Output output = operation.getOutput();
        this.visitOutput(output);
        Map faults = operation.getFaults();
        Iterator iterator = faults.keySet().iterator();
        Fault fault = null;
        while (iterator.hasNext()) {
            fault = (Fault)faults.get(iterator.next());
            this.visitFault(fault);
        }
    }

    protected abstract void visitInput(Input var1);

    protected abstract void visitOutput(Output var1);

    protected abstract void visitFault(Fault var1);

    protected void visitBinding(Binding binding) {
        Iterator iterator = binding.getBindingOperations().iterator();
        while (iterator.hasNext()) {
            this.visitBindingOperation((BindingOperation)iterator.next());
        }
        iterator = binding.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibilityElement)iterator.next());
        }
    }

    protected void visitBindingOperation(BindingOperation operation) {
        BindingInput input = operation.getBindingInput();
        this.visitBindingInput(input);
        BindingOutput output = operation.getBindingOutput();
        this.visitBindingOutput(output);
        Map bindingFaults = operation.getBindingFaults();
        Iterator<Object> iterator = bindingFaults.keySet().iterator();
        BindingFault bindingFault = null;
        while (iterator.hasNext()) {
            bindingFault = (BindingFault)bindingFaults.get(iterator.next());
            this.visitBindingFault(bindingFault);
        }
        iterator = operation.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibilityElement)iterator.next());
        }
    }

    protected void visitBindingInput(BindingInput input) {
        Iterator iterator = input.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibilityElement)iterator.next());
        }
    }

    protected void visitBindingOutput(BindingOutput output) {
        Iterator iterator = output.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibilityElement)iterator.next());
        }
    }

    protected void visitBindingFault(BindingFault fault) {
        Iterator iterator = fault.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibilityElement)iterator.next());
        }
    }

    protected void visitService(Service service) {
        Iterator<Object> iterator = service.getPorts().values().iterator();
        while (iterator.hasNext()) {
            this.visitPort((Port)iterator.next());
        }
        iterator = service.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibilityElement)iterator.next());
        }
    }

    protected void visitPort(Port port) {
        Iterator iterator = port.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibilityElement)iterator.next());
        }
    }

    protected abstract void visitExtensibilityElement(ExtensibilityElement var1);
}

