/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.util;

import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;

public abstract class DefinitionVisitor
extends TestCase {
    protected Definition definition;

    private DefinitionVisitor() {
    }

    public DefinitionVisitor(String name) {
        super(name);
    }

    protected DefinitionVisitor(Definition definition) {
        this.definition = definition;
    }

    public void visit() {
        this.visitDefinition(this.definition);
    }

    protected void visitDefinition(Definition def) {
        Iterator iterator = def.getEImports().iterator();
        while (iterator.hasNext()) {
            this.visitImport((Import)iterator.next());
        }
        Types types = def.getETypes();
        if (types != null) {
            this.visitTypes(types);
        }
        iterator = def.getEMessages().iterator();
        while (iterator.hasNext()) {
            this.visitMessage((Message)iterator.next());
        }
        iterator = def.getEPortTypes().iterator();
        while (iterator.hasNext()) {
            this.visitPortType((PortType)iterator.next());
        }
        iterator = def.getEBindings().iterator();
        while (iterator.hasNext()) {
            this.visitBinding((Binding)iterator.next());
        }
        iterator = def.getEServices().iterator();
        while (iterator.hasNext()) {
            this.visitService((Service)iterator.next());
        }
        iterator = def.getEExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibleElement)def, (ExtensibilityElement)iterator.next());
        }
    }

    protected abstract void visitImport(Import var1);

    protected abstract void visitTypes(Types var1);

    protected void visitMessage(Message message) {
        Iterator iterator = message.getEParts().iterator();
        while (iterator.hasNext()) {
            this.visitPart((Part)iterator.next());
        }
    }

    protected abstract void visitPart(Part var1);

    protected void visitPortType(PortType portType) {
        Iterator iterator = portType.getEOperations().iterator();
        while (iterator.hasNext()) {
            this.visitOperation((Operation)iterator.next());
        }
    }

    protected void visitOperation(Operation operation) {
        Input input = operation.getEInput();
        this.visitInput(input);
        Output output = operation.getEOutput();
        this.visitOutput(output);
        Iterator iterator = operation.getEFaults().iterator();
        while (iterator.hasNext()) {
            this.visitFault((Fault)iterator.next());
        }
    }

    protected abstract void visitInput(Input var1);

    protected abstract void visitOutput(Output var1);

    protected abstract void visitFault(Fault var1);

    protected void visitBinding(Binding binding) {
        Iterator iterator = binding.getEBindingOperations().iterator();
        while (iterator.hasNext()) {
            this.visitBindingOperation((BindingOperation)iterator.next());
        }
        iterator = binding.getEExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibleElement)binding, (ExtensibilityElement)iterator.next());
        }
    }

    protected void visitBindingOperation(BindingOperation operation) {
        BindingInput input = operation.getEBindingInput();
        this.visitBindingInput(input);
        BindingOutput output = operation.getEBindingOutput();
        this.visitBindingOutput(output);
        Iterator iterator = operation.getEBindingFaults().iterator();
        while (iterator.hasNext()) {
            this.visitBindingFault((BindingFault)iterator.next());
        }
        iterator = operation.getEExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibleElement)operation, (ExtensibilityElement)iterator.next());
        }
    }

    protected void visitBindingInput(BindingInput input) {
        Iterator iterator = input.getEExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibleElement)input, (ExtensibilityElement)iterator.next());
        }
    }

    protected void visitBindingOutput(BindingOutput output) {
        Iterator iterator = output.getEExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibleElement)output, (ExtensibilityElement)iterator.next());
        }
    }

    protected void visitBindingFault(BindingFault fault) {
        Iterator iterator = fault.getEExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibleElement)fault, (ExtensibilityElement)iterator.next());
        }
    }

    protected void visitService(Service service) {
        Iterator iterator = service.getEPorts().iterator();
        while (iterator.hasNext()) {
            this.visitPort((Port)iterator.next());
        }
        iterator = service.getEExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibleElement)service, (ExtensibilityElement)iterator.next());
        }
    }

    protected void visitPort(Port port) {
        Iterator iterator = port.getEExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            this.visitExtensibilityElement((ExtensibleElement)port, (ExtensibilityElement)iterator.next());
        }
    }

    protected abstract void visitExtensibilityElement(ExtensibleElement var1, ExtensibilityElement var2);
}

