/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.OperationType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.eclipse.wst.wsdl.binding.mime.MIMEContent;
import org.eclipse.wst.wsdl.binding.mime.MIMEFactory;
import org.eclipse.wst.wsdl.binding.mime.MIMEMimeXml;
import org.eclipse.wst.wsdl.binding.mime.MIMEMultipartRelated;
import org.eclipse.wst.wsdl.binding.mime.MIMEPackage;
import org.eclipse.wst.wsdl.binding.mime.MIMEPart;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;
import org.eclipse.wst.wsdl.binding.soap.SOAPPackage;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.wst.wsdl.internal.util.WSDLUtil;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BugFixesTest
extends TestCase {
    private String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();

    public BugFixesTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)BugFixesTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new BugFixesTest("TypeAndElementResolution"){

            protected void runTest() {
                this.testTypeAndElementResolution();
            }
        });
        suite.addTest((Test)new BugFixesTest("MIMEGetTypeName"){

            protected void runTest() {
                this.testReturnsProperQNameForMIMEExtensibilityElements();
            }
        });
        suite.addTest((Test)new BugFixesTest("ImportsElementOrder"){

            protected void runTest() {
                this.testPlacesImportsAfterTheDefinitionElement();
            }
        });
        suite.addTest((Test)new BugFixesTest("ResolveWSDLElement"){

            protected void runTest() {
                this.testResolvesElementInImports();
            }
        });
        suite.addTest((Test)new BugFixesTest("PartsSerialization"){

            protected void runTest() {
                this.testSerializesPartsInSOAPBody();
            }
        });
        suite.addTest((Test)new BugFixesTest("ImportsSerialization"){

            protected void runTest() {
                this.testSerializesImportsBeforeTypes();
            }
        });
        suite.addTest((Test)new BugFixesTest("LocalNamespacePrefixes"){

            protected void runTest() {
                this.testSupportsLocalNamespacePrefixes();
            }
        });
        suite.addTest((Test)new BugFixesTest("OperationExtensionElements"){

            protected void runTest() {
                this.testTolleratesExtensionElementsForOperation();
            }
        });
        suite.addTest((Test)new BugFixesTest("ReconcilesBindingFaults"){

            protected void runTest() {
                this.testReconcilesBindingFaults();
            }
        });
        suite.addTest((Test)new BugFixesTest("DuplicateSAXErrorDiagnostics"){

            protected void runTest() {
                this.testAvoidDuplicateSAXExceptionDiagnostics();
            }
        });
        suite.addTest((Test)new BugFixesTest("BindingOperationReconciliation"){

            protected void runTest() {
                this.testBindingOperationReconciliation();
            }
        });
        suite.addTest((Test)new BugFixesTest("AllowNullNamespaceURI"){

            protected void runTest() {
                this.testAllowNullNamespaceURI();
            }
        });
        suite.addTest((Test)new BugFixesTest("HandlesDocumentationElements"){

            protected void runTest() {
                this.testHandlesDocumentationElements();
            }
        });
        suite.addTest((Test)new BugFixesTest("GetWSDLType"){

            protected void runTest() {
                this.testGetWSDLType();
            }
        });
        suite.addTest((Test)new BugFixesTest("InvalidXSDImports"){

            protected void runTest() {
                this.testInvalidXSDImports();
            }
        });
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        WSDLPackage pkg = WSDLPackage.eINSTANCE;
        pkg.eClass();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        XSDPackage xsdpkg = XSDPackage.eINSTANCE;
        xsdpkg.eClass();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testTypeAndElementResolution() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/TypeAndElementResolution/Test.wsdl");
            XSDSchema inlineSchema = (XSDSchema)definition.getETypes().getSchemas().get(1);
            XSDImport xsdImport = (XSDImport)inlineSchema.getContents().get(0);
            XSDSchema schema = xsdImport.getResolvedSchema();
            Iterator messagesIterator = definition.getEMessages().iterator();
            while (messagesIterator.hasNext()) {
                Part part;
                Message message = (Message)messagesIterator.next();
                String name = message.getQName().getLocalPart();
                if (name.equals("testRequest")) {
                    part = (Part)message.getEParts().get(0);
                    XSDTypeDefinition myType = part.getTypeDefinition();
                    BugFixesTest.assertEquals((Object)schema, (Object)myType.getContainer());
                    continue;
                }
                if (!name.equals("testResponse")) continue;
                part = (Part)message.getEParts().get(0);
                XSDElementDeclaration myElement = part.getElementDeclaration();
                BugFixesTest.assertEquals((Object)schema, (Object)myElement.getContainer());
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testReturnsProperQNameForMIMEExtensibilityElements() {
        MIMEFactory factory = MIMEPackage.eINSTANCE.getMIMEFactory();
        MIMEContent content = factory.createMIMEContent();
        QName contentElementType = content.getElementType();
        BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/mime/", (String)contentElementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"content", (String)contentElementType.getLocalPart());
        MIMEMimeXml mimeXml = factory.createMIMEMimeXml();
        QName mimeXmlElementType = mimeXml.getElementType();
        BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/mime/", (String)mimeXmlElementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"mimeXml", (String)mimeXmlElementType.getLocalPart());
        MIMEMultipartRelated multipartRelated = factory.createMIMEMultipartRelated();
        QName multipartRelatedElementType = multipartRelated.getElementType();
        BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/mime/", (String)multipartRelatedElementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"multipartRelated", (String)multipartRelatedElementType.getLocalPart());
        MIMEPart part = factory.createMIMEPart();
        QName partElementType = part.getElementType();
        BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/mime/", (String)partElementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"part", (String)partElementType.getLocalPart());
    }

    public void testPlacesImportsAfterTheDefinitionElement() {
        WSDLFactory factory = WSDLPackage.eINSTANCE.getWSDLFactory();
        String namespace = "testNamespace";
        Definition definition = factory.createDefinition();
        definition.setQName(new QName(namespace, "testDefinition"));
        definition.updateElement();
        Service service = factory.createService();
        service.setQName(new QName(namespace, "testService"));
        definition.addService((javax.wsdl.Service)service);
        Import wsdlImport = factory.createImport();
        definition.addImport((javax.wsdl.Import)wsdlImport);
        Element definitionElement = definition.getElement();
        Element serviceElement = service.getElement();
        Element importElement = wsdlImport.getElement();
        NodeList definitionElementChildren = definitionElement.getChildNodes();
        Node firstChild = definitionElementChildren.item(0);
        BugFixesTest.assertSame((Object)importElement, (Object)firstChild);
        Node secondChild = definitionElementChildren.item(1);
        BugFixesTest.assertSame((Object)serviceElement, (Object)secondChild);
    }

    public void testResolvesElementInImports() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/WSDLElementResolution/main.wsdl");
            String targetNamespace = "http://www.example.com";
            QName firstLevelMessageQName = new QName(targetNamespace, "testINPUTmessage");
            javax.wsdl.Message firstLevelMessage = definition.getMessage(firstLevelMessageQName);
            BugFixesTest.assertNotNull((Object)firstLevelMessage);
            QName secondLevelMessageQName = new QName(targetNamespace, "testOUTPUTmessage");
            javax.wsdl.Message secondLevelMessage = definition.getMessage(secondLevelMessageQName);
            BugFixesTest.assertNotNull((Object)secondLevelMessage);
            Import firstLevelImport = (Import)definition.getImports(targetNamespace).get(0);
            Definition firstLevelDefinition = firstLevelImport.getEDefinition();
            BugFixesTest.assertEquals((Object)firstLevelDefinition, (Object)((Message)firstLevelMessage).getEnclosingDefinition());
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testSerializesPartsInSOAPBody() {
        WSDLFactory factory = WSDLPackage.eINSTANCE.getWSDLFactory();
        String targetNamespace = "testNamespace";
        Definition definition = factory.createDefinition();
        definition.setTargetNamespace(targetNamespace);
        definition.setQName(new QName(targetNamespace, "testDefinition"));
        definition.addNamespace("tns", targetNamespace);
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        definition.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        Message message = factory.createMessage();
        QName messageQName = new QName(targetNamespace, "testMessage");
        message.setQName(messageQName);
        definition.addMessage((javax.wsdl.Message)message);
        Part part1 = factory.createPart();
        String part1Name = "part1";
        part1.setName(part1Name);
        part1.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        message.addPart((javax.wsdl.Part)part1);
        Part part2 = factory.createPart();
        String part2Name = "part2";
        part2.setName(part2Name);
        part2.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        message.addPart((javax.wsdl.Part)part2);
        PortType portType = factory.createPortType();
        QName portQName = new QName(targetNamespace, "testPort");
        portType.setQName(portQName);
        definition.addPortType((javax.wsdl.PortType)portType);
        Operation operation = factory.createOperation();
        String operationName = "testOperation";
        operation.setName(operationName);
        portType.addOperation((javax.wsdl.Operation)operation);
        Input input = factory.createInput();
        input.setMessage((javax.wsdl.Message)message);
        operation.setInput((javax.wsdl.Input)input);
        Binding binding = factory.createBinding();
        QName bindingQName = new QName(targetNamespace, "testBinding");
        binding.setQName(bindingQName);
        binding.setPortType((javax.wsdl.PortType)portType);
        definition.addBinding((javax.wsdl.Binding)binding);
        BindingOperation bindingOperation = factory.createBindingOperation();
        bindingOperation.setOperation((javax.wsdl.Operation)operation);
        binding.addBindingOperation((javax.wsdl.BindingOperation)bindingOperation);
        BindingInput bindingInput = factory.createBindingInput();
        bindingOperation.setBindingInput((javax.wsdl.BindingInput)bindingInput);
        SOAPFactory soapFactory = SOAPPackage.eINSTANCE.getSOAPFactory();
        SOAPBody soapBody = soapFactory.createSOAPBody();
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
        definition.updateElement();
        Element soapBodyElement = soapBody.getElement();
        Attr partsAttributeNode = soapBodyElement.getAttributeNode("parts");
        BugFixesTest.assertNull((Object)partsAttributeNode);
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(part1);
        soapBody.setParts(parts);
        soapBody.updateElement();
        soapBodyElement = soapBody.getElement();
        String partsAttributeValue = soapBodyElement.getAttribute("parts");
        BugFixesTest.assertEquals((String)part1Name, (String)partsAttributeValue);
        parts.add(part2);
        soapBody.setParts(parts);
        soapBody.updateElement();
        soapBodyElement = soapBody.getElement();
        partsAttributeValue = soapBodyElement.getAttribute("parts");
        BugFixesTest.assertEquals((String)(String.valueOf(part1Name) + " " + part2Name), (String)partsAttributeValue);
    }

    public void testSerializesImportsBeforeTypes() {
        WSDLFactory factory = WSDLPackage.eINSTANCE.getWSDLFactory();
        String namespace = "testNamespace";
        Definition definition = factory.createDefinition();
        definition.setQName(new QName(namespace, "testDefinition"));
        definition.updateElement();
        Types types = factory.createTypes();
        definition.setTypes((javax.wsdl.Types)types);
        Import wsdlImport = factory.createImport();
        definition.addImport((javax.wsdl.Import)wsdlImport);
        Element definitionElement = definition.getElement();
        Element typesElement = types.getElement();
        Element importElement = wsdlImport.getElement();
        NodeList definitionElementChildren = definitionElement.getChildNodes();
        Node firstChild = definitionElementChildren.item(0);
        BugFixesTest.assertSame((Object)importElement, (Object)firstChild);
        Node secondChild = definitionElementChildren.item(1);
        BugFixesTest.assertSame((Object)typesElement, (Object)secondChild);
        definition.setElement(null);
        definition.updateElement();
        definitionElement = definition.getElement();
        typesElement = types.getElement();
        importElement = wsdlImport.getElement();
        definitionElementChildren = definitionElement.getChildNodes();
        firstChild = definitionElementChildren.item(0);
        BugFixesTest.assertSame((Object)importElement, (Object)firstChild);
        secondChild = definitionElementChildren.item(1);
        BugFixesTest.assertSame((Object)typesElement, (Object)secondChild);
    }

    public void testSupportsLocalNamespacePrefixes() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/LocalNamespace/LocalNamespace.wsdl");
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        String targetNamespace = "http://tempuri.org/Simple/";
        QName responseMessageQName = new QName(targetNamespace, "myOperationResponse");
        javax.wsdl.Message responseMessage = definition.getMessage(responseMessageQName);
        Part responsePart = (Part)responseMessage.getPart("myOperationResponse");
        XSDElementDeclaration responseElementDeclaration = responsePart.getElementDeclaration();
        BugFixesTest.assertNotNull((Object)responseElementDeclaration);
        BugFixesTest.assertNotNull((Object)responseElementDeclaration.getContainer());
        QName requestMessageQName = new QName(targetNamespace, "myOperationRequest");
        javax.wsdl.Message requestMessage = definition.getMessage(requestMessageQName);
        Part requestPart = (Part)requestMessage.getPart("myOperationRequest");
        XSDElementDeclaration requestElementDeclaration = requestPart.getElementDeclaration();
        BugFixesTest.assertNotNull((Object)requestElementDeclaration);
        requestPart.setElementDeclaration(responseElementDeclaration);
        Element partElement = requestPart.getElement();
        String elementAttributeValue = partElement.getAttribute("element");
        BugFixesTest.assertEquals((String)elementAttributeValue, (String)("parttns:" + responseElementDeclaration.getName()));
    }

    public void testTolleratesExtensionElementsForOperation() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/OperationStyle/OperationStyleTest.wsdl");
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        PortType portType = (PortType)definition.getEPortTypes().get(0);
        EList operations = portType.getEOperations();
        Operation operation = (Operation)operations.get(0);
        OperationType operationType = operation.getStyle();
        BugFixesTest.assertEquals((Object)OperationType.REQUEST_RESPONSE, (Object)operationType);
    }

    public void testReconcilesBindingFaults() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/BindingFaultReconciliation/BindingFaultSample.wsdl");
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        EList bindings = definition.getEBindings();
        Binding binding = (Binding)bindings.get(0);
        List bindingOperations = binding.getBindingOperations();
        BindingOperation bindingOperation = (BindingOperation)bindingOperations.get(0);
        BindingFault bindingFault = (BindingFault)bindingOperation.getBindingFault("Operation1Fault");
        Fault fault = bindingFault.getEFault();
        BugFixesTest.assertNull((Object)fault);
        EList portTypes = definition.getEPortTypes();
        PortType portType = (PortType)portTypes.get(0);
        EList operations = portType.getEOperations();
        Operation operation = (Operation)operations.get(1);
        javax.wsdl.Fault expectedFault1 = operation.getFault("Operation2Fault1");
        javax.wsdl.Fault expectedFault2 = operation.getFault("Operation2Fault2");
        BindingOperation bindingOperation2 = (BindingOperation)bindingOperations.get(1);
        BindingFault bindingFault1 = (BindingFault)bindingOperation2.getBindingFault("Operation2Fault1");
        Fault actualFault1 = bindingFault1.getEFault();
        BugFixesTest.assertNotNull((Object)actualFault1);
        BugFixesTest.assertEquals((Object)expectedFault1, (Object)actualFault1);
        BindingFault bindingFault2 = (BindingFault)bindingOperation2.getBindingFault("Operation2Fault2");
        Fault actualFault2 = bindingFault2.getEFault();
        BugFixesTest.assertNotNull((Object)actualFault2);
        BugFixesTest.assertEquals((Object)expectedFault2, (Object)actualFault2);
    }

    public void testAvoidDuplicateSAXExceptionDiagnostics() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/DuplicateSAXException/SAXException.wsdl", true, true);
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        Resource resource = definition.eResource();
        EList errors = resource.getErrors();
        int expectedSize = 1;
        int actualSize = errors.size();
        BugFixesTest.assertEquals((int)expectedSize, (int)actualSize);
    }

    public void testBindingOperationReconciliation() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/BindingOperationReconciliation/BindingOperationReconciliation.wsdl", true);
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        String targetNamespace = "http://www.example.org/BindingOperationReconciliation/";
        QName portTypeQName = new QName(targetNamespace, "BindingOperationReconciliation");
        javax.wsdl.PortType portType = definition.getPortType(portTypeQName);
        String input3Name = "Input3";
        String output3Name = "Output3";
        String operationName = "NewOperation";
        javax.wsdl.Operation operation1 = portType.getOperation(operationName, null, null);
        QName bindingQName = new QName(targetNamespace, "BindingOperationReconciliationSOAP");
        javax.wsdl.Binding binding = definition.getBinding(bindingQName);
        javax.wsdl.BindingOperation bindingOperation1 = binding.getBindingOperation(operationName, null, null);
        javax.wsdl.Operation actualOperation1 = bindingOperation1.getOperation();
        BugFixesTest.assertEquals((Object)operation1, (Object)actualOperation1);
        String input2Name = "Input2";
        String output2Name = "Output2";
        String operation2Name = "NewOperation2";
        javax.wsdl.BindingOperation bindingOperation2 = binding.getBindingOperation(operation2Name, input2Name, output2Name);
        javax.wsdl.Operation actualOperation2 = bindingOperation2.getOperation();
        BugFixesTest.assertEquals(null, (Object)actualOperation2);
        String operation3Name = "NewOperation3";
        javax.wsdl.Operation operation3 = portType.getOperation(operation3Name, input3Name, output3Name);
        javax.wsdl.BindingOperation bindingOperation3 = binding.getBindingOperation(operation3Name, input3Name, output3Name);
        javax.wsdl.Operation actualOperation3 = bindingOperation3.getOperation();
        BugFixesTest.assertEquals((Object)operation3, (Object)actualOperation3);
    }

    public void testAllowNullNamespaceURI() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/NullNamespaceURI/ContactInfoService.wsdl", true);
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        String targetNamespace = "http://www.example.org/ContactInfoService";
        QName output1QName = new QName(targetNamespace, "updatePhoneNumberResponseMsg");
        Message output1Message = (Message)definition.getMessage(output1QName);
        BugFixesTest.assertNotNull((Object)output1Message);
        Part part1 = (Part)output1Message.getPart("output1");
        BugFixesTest.assertNotNull((Object)part1);
        QName output2ElementName = part1.getElementName();
        BugFixesTest.assertNotNull((Object)output2ElementName);
        BugFixesTest.assertEquals((String)"", (String)output2ElementName.getNamespaceURI());
        XSDElementDeclaration output2ElementDeclaration = part1.getElementDeclaration();
        BugFixesTest.assertNotNull((Object)output2ElementDeclaration);
        BugFixesTest.assertNotNull((Object)output2ElementDeclaration.getContainer());
        BugFixesTest.assertNull((Object)output2ElementDeclaration.getTargetNamespace());
        QName output2QName = new QName(targetNamespace, "updateAddressResponseMsg");
        Message output2Message = (Message)definition.getMessage(output2QName);
        BugFixesTest.assertNotNull((Object)output2Message);
        Part part2 = (Part)output2Message.getPart("output2");
        BugFixesTest.assertNotNull((Object)part1);
        QName output2TypeName = part2.getTypeName();
        BugFixesTest.assertNotNull((Object)output2TypeName);
        BugFixesTest.assertEquals((String)"", (String)output2TypeName.getNamespaceURI());
        XSDTypeDefinition output2TypeDefinition = part2.getTypeDefinition();
        BugFixesTest.assertNotNull((Object)output2TypeDefinition);
        BugFixesTest.assertNotNull((Object)output2TypeDefinition.getContainer());
        BugFixesTest.assertNull((Object)output2TypeDefinition.getTargetNamespace());
    }

    public void testHandlesDocumentationElements() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/HandlesDocumentationElements/Documented.wsdl");
            WSDLFactory factory = WSDLFactory.eINSTANCE;
            Import anImport = factory.createImport();
            anImport.setNamespaceURI("http://www.test.com");
            definition.addImport((javax.wsdl.Import)anImport);
            Element definitionDocumentationElement = definition.getDocumentationElement();
            BugFixesTest.assertNotNull((Object)definitionDocumentationElement);
            Element expectedImportElement = this.getNextElement(definitionDocumentationElement);
            Element importElement = anImport.getElement();
            BugFixesTest.assertEquals((Object)importElement, (Object)expectedImportElement);
            Message aMessage = (Message)definition.getEMessages().get(0);
            Part newPart = factory.createPart();
            aMessage.addPart((javax.wsdl.Part)newPart);
            Element messageElement = aMessage.getElement();
            Element messageDocumentationElement = aMessage.getDocumentationElement();
            BugFixesTest.assertNotNull((Object)messageDocumentationElement);
            Element firstChildElement = this.getFirstChildElement(messageElement);
            BugFixesTest.assertEquals((Object)messageDocumentationElement, (Object)firstChildElement);
            Element partElement = newPart.getElement();
            Element lastChildElement = this.getLastChildElement(messageElement);
            BugFixesTest.assertEquals((Object)partElement, (Object)lastChildElement);
            PortType portType = (PortType)definition.getEPortTypes().get(0);
            Operation newOperation = factory.createOperation();
            portType.addOperation((javax.wsdl.Operation)newOperation);
            Element portTypeElement = portType.getElement();
            Element portTypeDocumentationElement = portType.getDocumentationElement();
            BugFixesTest.assertNotNull((Object)portTypeDocumentationElement);
            firstChildElement = this.getFirstChildElement(portTypeElement);
            BugFixesTest.assertEquals((Object)portTypeDocumentationElement, (Object)firstChildElement);
            Element newOperationElement = newOperation.getElement();
            lastChildElement = this.getLastChildElement(portTypeElement);
            BugFixesTest.assertEquals((Object)newOperationElement, (Object)lastChildElement);
            Operation operation = (Operation)portType.getEOperations().get(0);
            Output output = factory.createOutput();
            operation.setOutput((javax.wsdl.Output)output);
            Element operationElement = operation.getElement();
            Element operationDocumentationElement = operation.getDocumentationElement();
            BugFixesTest.assertNotNull((Object)operationDocumentationElement);
            firstChildElement = this.getFirstChildElement(operationElement);
            BugFixesTest.assertEquals((Object)operationDocumentationElement, (Object)firstChildElement);
            Element outputElement = output.getElement();
            lastChildElement = this.getLastChildElement(operationElement);
            BugFixesTest.assertEquals((Object)outputElement, (Object)lastChildElement);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testGetWSDLType() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/GetWSDLType/BadImport.wsdl", true);
            definition.updateElement();
            Element definitionElement = definition.getElement();
            int type = WSDLUtil.getInstance().getWSDLType(definitionElement);
            BugFixesTest.assertEquals((String)"Definition type incorrectly identified", (int)1, (int)type);
            NodeList childNodes = definitionElement.getChildNodes();
            Node n = childNodes.item(0);
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Import type incorrectly identified", (int)4, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"xsd:import type incorrectly identified", (int)-1, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Types type incorrectly identified", (int)13, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Message type incorrectly identified", (int)6, (int)type);
            n = n.getNextSibling();
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Message type incorrectly identified", (int)6, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Port type type incorrectly identified", (int)11, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Binding type incorrectly identified", (int)0, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Service type incorrectly identified", (int)12, (int)type);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testInvalidXSDImports() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/GetWSDLType/BadImport.wsdl", true);
            definition.getTargetNamespace();
            Map imports = definition.getImports();
            BugFixesTest.assertEquals((String)"Incorrect number of imports", (int)1, (int)imports.size());
            List extElements = definition.getExtensibilityElements();
            BugFixesTest.assertEquals((String)"Incorrect number of extensibility elements", (int)1, (int)extElements.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    private Element getNextElement(Element anElement) {
        Node node = anElement.getNextSibling();
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    private Element getFirstChildElement(Element anElement) {
        Node node = anElement.getFirstChild();
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    private Element getLastChildElement(Element anElement) {
        Node node = anElement.getLastChild();
        while (node != null && node.getNodeType() != 1) {
            node = node.getPreviousSibling();
        }
        return (Element)node;
    }
}

