/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests;

import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.IWorkspaceRunnableWithStatus;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;
import org.eclipse.wst.common.tests.BaseTestCase;
import org.eclipse.wst.common.tests.LogUtility;
import org.eclipse.wst.common.tests.PostBuildListener;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.TaskViewUtility;

public abstract class OperationTestCase
extends BaseTestCase {
    public static final String VALIDATOR_JOB_FAMILY = "validators";
    public static String fileSep = System.getProperty("file.separator");
    public static IStatus OK_STATUS = new Status(0, "org.eclipse.jem.util", 0, "OK", null);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setUp() throws Exception {
        super.setUp();
        try {
            try {
                OperationTestCase.deleteAllProjects();
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            RendererFactory.getDefaultRendererFactory().setValidating(false);
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        RendererFactory.getDefaultRendererFactory().setValidating(false);
    }

    public static void deleteAllProjects() {
        IWorkspaceRunnableWithStatus workspaceRunnable = new IWorkspaceRunnableWithStatus(null){

            public void run(IProgressMonitor pm) throws CoreException {
                try {
                    ProjectUtility.deleteAllProjects();
                }
                catch (Exception exception) {}
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)workspaceRunnable, null);
        }
        catch (CoreException coreException) {}
    }

    public OperationTestCase() {
        super("OperationsTestCase");
    }

    public OperationTestCase(String name) {
        super(name);
    }

    public static void runAndVerify(IDataModel dataModel) throws Exception {
        OperationTestCase.runAndVerify(dataModel, true, true);
    }

    public static void runDataModel(IDataModel dataModel) throws Exception {
        OperationTestCase.runDataModel(dataModel, true, true);
    }

    public static void runDataModel(IDataModel dataModel, boolean checkTasks, boolean checkLog) throws Exception {
        OperationTestCase.runDataModel(dataModel, checkTasks, checkLog, null, true, false);
    }

    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog) throws Exception {
        OperationTestCase.runAndVerify(dataModel, checkTasks, checkLog, null, true, false);
    }

    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog, boolean waitForBuildToComplete) throws Exception {
        OperationTestCase.runAndVerify(dataModel, checkTasks, checkLog, null, true, waitForBuildToComplete);
    }

    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound) throws Exception {
        OperationTestCase.runAndVerify(dataModel, checkTasks, checkLog, errorOKList, reportIfExpectedErrorNotFound, false);
    }

    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound, boolean waitForBuildToComplete) throws Exception {
        OperationTestCase.runAndVerify(dataModel, checkTasks, checkLog, errorOKList, reportIfExpectedErrorNotFound, false, false);
    }

    public static void runDataModel(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound, boolean waitForBuildToComplete) throws Exception {
        OperationTestCase.runDataModel(dataModel, checkTasks, checkLog, errorOKList, reportIfExpectedErrorNotFound, false, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound, boolean waitForBuildToComplete, boolean removeAllSameTypesOfErrors) throws Exception {
        block12: {
            PostBuildListener listener = null;
            IWorkspaceDescription desc = null;
            try {
                if (waitForBuildToComplete) {
                    listener = new PostBuildListener();
                    desc = ResourcesPlugin.getWorkspace().getDescription();
                    desc.setAutoBuilding(false);
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
                }
                if (checkLog) {
                    LogUtility.getInstance().resetLogging();
                }
                dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
                if (waitForBuildToComplete) {
                    desc.setAutoBuilding(true);
                    while (!listener.isBuildComplete()) {
                        Thread.sleep(3000L);
                    }
                }
                if (checkTasks && (errorOKList == null || errorOKList.isEmpty())) {
                    OperationTestCase.checkTasksList();
                } else if (checkTasks && errorOKList != null && !errorOKList.isEmpty()) {
                    TaskViewUtility.verifyErrors(errorOKList, reportIfExpectedErrorNotFound, removeAllSameTypesOfErrors);
                }
                if (checkLog) {
                    OperationTestCase.checkLogUtility();
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (listener != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                }
                dataModel.dispose();
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (listener == null) break block12;
            }
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
        dataModel.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runDataModel(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound, boolean waitForBuildToComplete, boolean removeAllSameTypesOfErrors) throws Exception {
        block12: {
            PostBuildListener listener = null;
            IWorkspaceDescription desc = null;
            try {
                if (waitForBuildToComplete) {
                    listener = new PostBuildListener();
                    desc = ResourcesPlugin.getWorkspace().getDescription();
                    desc.setAutoBuilding(false);
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
                }
                if (checkLog) {
                    LogUtility.getInstance().resetLogging();
                }
                dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
                if (waitForBuildToComplete) {
                    desc.setAutoBuilding(true);
                    while (!listener.isBuildComplete()) {
                        Thread.sleep(3000L);
                    }
                }
                if (checkTasks && (errorOKList == null || errorOKList.isEmpty())) {
                    OperationTestCase.checkTasksList();
                } else if (checkTasks && errorOKList != null && !errorOKList.isEmpty()) {
                    TaskViewUtility.verifyErrors(errorOKList, reportIfExpectedErrorNotFound, removeAllSameTypesOfErrors);
                }
                if (checkLog) {
                    OperationTestCase.checkLogUtility();
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (listener != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                }
                dataModel.dispose();
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (listener == null) break block12;
            }
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
        dataModel.dispose();
    }

    protected static void checkLogUtility() {
        LogUtility.getInstance().verifyNoWarnings();
    }

    protected static void checkTasksList() {
    }

    public static void verifyValidDataModel(IDataModel dataModel) {
        IStatus status = dataModel.validate();
        if (!status.isOK() && status.getSeverity() == 4) {
            Assert.assertTrue((String)("DataModel is invalid operation will not run:" + status.toString()), (boolean)false);
        }
    }

    public static void verifyInvalidDataModel(IDataModel dataModel) {
        IStatus status = dataModel.validate();
        if (status.isOK()) {
            Assert.assertTrue((String)("DataModel should be invalid:" + status.getMessage()), (boolean)false);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        IProject[] projects = ProjectUtility.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            Platform.getJobManager().join((Object)(String.valueOf(project.getName()) + VALIDATOR_JOB_FAMILY), null);
            ++i;
        }
    }
}

