/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.environment.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.IURIFactory;
import org.eclipse.wst.common.environment.uri.IURIFilter;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.IURIVisitor;
import org.eclipse.wst.common.environment.uri.URIException;

public class EclipseURITests
extends TestCase {
    private final String projectName_ = "TestProject";
    private File tempFile;
    private File tempDir;
    static /* synthetic */ Class class$0;

    public EclipseURITests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            EclipseURITests.runAll();
        } else if (args.length == 1) {
            String methodToRun = args[0].trim();
            EclipseURITests.runOne(methodToRun);
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.environment.tests.EclipseURITests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected static void runAll() {
        TestRunner.run((Test)EclipseURITests.suite());
    }

    public static void runOne(String methodName) {
        TestSuite testSuite = new TestSuite();
        EclipseURITests test = new EclipseURITests(methodName);
        System.out.println("Calling EclipseURITests." + methodName);
        testSuite.addTest((Test)test);
        TestRunner.run((Test)testSuite);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tempFile = File.createTempFile("tmp", "tmp", null);
        this.tempDir = new File(this.tempFile.getParentFile(), "tmpDir");
        this.tempDir.mkdir();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject("TestProject");
        if (project != null && project.exists()) {
            project.delete(true, null);
        }
        IProjectDescription desc = workspaceRoot.getWorkspace().newProjectDescription("TestProject");
        project.create(desc, null);
        project.open(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject("TestProject");
        project.delete(true, null);
        this.tempFile.delete();
        this.deleteDir(this.tempDir);
    }

    public static Test getTest() {
        return new EclipseURITests("EclipseURITests");
    }

    public void testAvailable() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("EclipseURITests.testAvailable()");
        try {
            IURI uri1 = factory.newURI("platform:/resource/TestProject/myfile");
            IURI uri2 = factory.newURI(this.getTmpFileURL("somefile"));
            IURI uri3 = factory.newURI("relativedirectory/relativefile");
            EclipseURITests.assertTrue((String)"Not available as URL", (boolean)uri1.isAvailableAsURL());
            EclipseURITests.assertTrue((String)"Not available as URL", (boolean)uri2.isAvailableAsURL());
            EclipseURITests.assertTrue((String)"Available as URL", (!uri3.isAvailableAsURL() ? 1 : 0) != 0);
            EclipseURITests.assertTrue((String)"Not available as File", (boolean)uri1.isAvailableAsFile());
            EclipseURITests.assertTrue((String)"Not available as File", (boolean)uri2.isAvailableAsFile());
            EclipseURITests.assertTrue((String)"Available as File", (!uri3.isAvailableAsFile() ? 1 : 0) != 0);
            File file1 = uri1.asFile();
            File file2 = uri2.asFile();
            URL url1 = uri1.asURL();
            URL url2 = uri2.asURL();
            uri1.touchLeaf();
            uri2.touchLeaf();
            EclipseURITests.assertTrue((String)"Is a file", (boolean)file1.isFile());
            EclipseURITests.assertTrue((String)"Is a file", (boolean)file2.isFile());
            EclipseURITests.assertTrue((String)"Wrong protocol", (boolean)url1.getProtocol().equals("platform"));
            EclipseURITests.assertTrue((String)"Wrong protocol", (boolean)url2.getProtocol().equals("file"));
            EclipseURITests.assertTrue((uri1.asString().length() > 5 ? 1 : 0) != 0);
            EclipseURITests.assertTrue((uri2.asString().length() > 5 ? 1 : 0) != 0);
            EclipseURITests.assertTrue((uri1.toString().length() > 5 ? 1 : 0) != 0);
            EclipseURITests.assertTrue((uri2.toString().length() > 5 ? 1 : 0) != 0);
            uri1.erase();
            uri2.erase();
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testFactory() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("EclipseURITests.testFactory()");
        try {
            factory.newURIScheme(null);
            EclipseURITests.assertTrue((String)"Null URI scheme should cause an exception", (boolean)false);
        }
        catch (URIException uRIException) {}
        try {
            factory.newURIScheme("bogusProtocol:/somefolder/somefile.txt");
            EclipseURITests.assertTrue((String)"An undefined protocol should cause an exception", (boolean)false);
        }
        catch (URIException uRIException) {}
        try {
            factory.newURIScheme("/somefolder/somefile.txt");
            EclipseURITests.assertTrue((String)"Absolute path with no protocol should cause an exception", (boolean)false);
        }
        catch (URIException uRIException) {}
        try {
            IURIScheme scheme1 = factory.newURIScheme("platform:/resource/myproj/myfile");
            IURIScheme scheme2 = factory.newURIScheme(this.getTmpFileURL("somefile2"));
            IURIScheme scheme3 = factory.newURIScheme("platform");
            IURIScheme scheme4 = factory.newURIScheme("file");
            IURIScheme scheme5 = factory.newURI("rel1/rel2").getURIScheme();
            IURI uri1 = factory.newURI("platform:/resource/myproj/myfile");
            IURI uri2 = factory.newURI(this.getTmpFileURL("somefile3"));
            IURI uri3 = factory.newURI("relativedirectory/relativefile");
            IURI uri4 = factory.newURI(new URL("platform:/resource/myproj/myfile"));
            IURI uri5 = factory.newURI(new URL(this.getTmpFileURL("somefile4")));
            EclipseURITests.assertTrue((String)"Scheme not platform protocol", (boolean)scheme1.toString().equals("platform"));
            EclipseURITests.assertTrue((String)"Scheme not file protocol", (boolean)scheme2.toString().equals("file"));
            EclipseURITests.assertTrue((String)"Scheme not platform", (boolean)scheme3.toString().equals("platform"));
            EclipseURITests.assertTrue((String)"Scheme not file", (boolean)scheme4.toString().equals("file"));
            EclipseURITests.assertTrue((String)"Scheme not relative", (boolean)scheme5.toString().equals("relative"));
            EclipseURITests.assertTrue((String)"Scheme not platform protocol", (boolean)uri1.getURIScheme().toString().equals("platform"));
            EclipseURITests.assertTrue((String)"Scheme not file protocol", (boolean)uri2.getURIScheme().toString().equals("file"));
            EclipseURITests.assertTrue((String)"Scheme not relative", (boolean)uri3.getURIScheme().toString().equals("relative"));
            EclipseURITests.assertTrue((String)"Scheme not platform protocol", (boolean)uri4.getURIScheme().toString().equals("platform"));
            EclipseURITests.assertTrue((String)"Scheme not file protocol", (boolean)uri5.getURIScheme().toString().equals("file"));
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        catch (MalformedURLException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testTouchFolder() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("EclipseURITests.testTouchFolder()");
        try {
            IPath folderPath = new Path("TestProject").append("topFolder").makeAbsolute();
            IPath folderPath2 = folderPath.append("space folder");
            IURI uri = factory.newURI(this.getURLFromPath(folderPath).toString());
            IURI uri2 = factory.newURI(this.getURLFromPath(folderPath2).toString());
            EclipseURITests.assertTrue((String)"topFolder should not exist", (!uri.isPresent() ? 1 : 0) != 0);
            uri.touchFolder();
            EclipseURITests.assertTrue((String)"topFolder should exist", (boolean)uri.isPresent());
            IPath nestedPath = folderPath.append("level1").append("level2");
            IURI nesteduri = factory.newURI(this.getURLFromPath(nestedPath).toString());
            EclipseURITests.assertTrue((String)"nestedFolder should not exist", (!nesteduri.isPresent() ? 1 : 0) != 0);
            nesteduri.touchFolder();
            EclipseURITests.assertTrue((String)"nestedFolder should exist", (boolean)nesteduri.isPresent());
            IURI child1 = uri2.append(factory.newURI("child1"));
            IURI child2 = uri2.append(factory.newURI("child2"));
            child1.touchLeaf();
            child2.touchLeaf();
            EclipseURITests.assertTrue((String)"Child 1 in blank folder should exist ", (boolean)child1.isPresent());
            EclipseURITests.assertTrue((String)"Child 2 in blank folder should exist ", (boolean)child2.isPresent());
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testList() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("EclipseURITests.testList()");
        try {
            IPath folderPath0 = new Path("TestProject").append("topFolder2").makeAbsolute();
            IPath folderPath1 = new Path("TestProject").append("topFolder2").append("leaf1").makeAbsolute();
            IPath folderPath2 = new Path("TestProject").append("topFolder2").append("leaf2").makeAbsolute();
            IPath folderPath3 = new Path("TestProject").append("topFolder2").append("leaf3").makeAbsolute();
            IURI uri0 = factory.newURI(this.getURLFromPath(folderPath0).toString());
            IURI uri1 = factory.newURI(this.getURLFromPath(folderPath1).toString());
            IURI uri2 = factory.newURI(this.getURLFromPath(folderPath2).toString());
            IURI uri3 = factory.newURI(this.getURLFromPath(folderPath3).toString());
            uri1.touchFolder();
            uri2.touchFolder();
            uri3.touchFolder();
            IURI[] babies = uri0.list();
            EclipseURITests.assertTrue((String)"folder path should have 3 children", (babies.length == 3 ? 1 : 0) != 0);
            int index = 0;
            while (index < babies.length) {
                String folderName = babies[index].toString();
                String leafName = folderName.substring(folderName.length() - 5, folderName.length());
                boolean Ok = leafName.equals("leaf1") || leafName.equals("leaf2") || leafName.equals("leaf3");
                EclipseURITests.assertTrue((String)("Wrong leaf baby uri:" + folderName + "," + leafName), (boolean)Ok);
                ++index;
            }
            IURI[] babies2 = uri0.list(new IURIFilter(){

                public boolean accepts(IURI uri) {
                    return !uri.toString().endsWith("leaf2");
                }
            });
            EclipseURITests.assertTrue((String)"folder path should have 2 filtered children", (babies2.length == 2 ? 1 : 0) != 0);
            int index2 = 0;
            while (index2 < babies2.length) {
                String folderName = babies2[index2].toString();
                String leafName = folderName.substring(folderName.length() - 5, folderName.length());
                boolean Ok = leafName.equals("leaf1") || leafName.equals("leaf3");
                EclipseURITests.assertTrue((String)("Wrong leaf baby uri:" + folderName + "," + leafName), (boolean)Ok);
                ++index2;
            }
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testGetURIScheme() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        try {
            IPath folderPath0 = new Path("TestProject").append("testGetScheme").makeAbsolute();
            IURI uri0 = factory.newURI(this.getURLFromPath(folderPath0).toString());
            IURIScheme scheme = uri0.getURIScheme();
            EclipseURITests.assertTrue((String)"Scheme name is not platform", (boolean)scheme.toString().equals("platform"));
        }
        catch (URIException uRIException) {
            EclipseURITests.assertTrue((String)"Unexpected exception", (boolean)false);
        }
    }

    public void testAppend() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("EclipseURITests.testAppend()");
        try {
            IPath folderPath0 = new Path("TestProject").append("topFolder3").makeAbsolute();
            IURI uri0 = factory.newURI(this.getURLFromPath(folderPath0).toString());
            IURI uriRelative1 = factory.newURI("level1");
            IURI uriRelative2 = factory.newURI("level2");
            IURI newURI = uri0.append(uriRelative1).append(uriRelative2);
            EclipseURITests.assertTrue((String)"newURI should not exist", (!newURI.isPresent() ? 1 : 0) != 0);
            newURI.touchFolder();
            EclipseURITests.assertTrue((String)"newURI should exist", (boolean)newURI.isPresent());
            EclipseURITests.assertTrue((String)"newURI should not be a leaf", (!newURI.isLeaf() ? 1 : 0) != 0);
            try {
                IURI newURI2 = uri0.append(uri0);
                EclipseURITests.assertTrue((String)"Appending using a non-relative should throw and exception", (boolean)true);
                newURI2.asFile();
            }
            catch (URIException uRIException) {}
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTouchLeaf() {
        environment = EnvironmentService.getEclipseConsoleEnvironment();
        factory = environment.getURIFactory();
        System.out.println("EclipseURITests.testTouchLeaf()");
        try {
            block10: {
                folderPath0 = new Path("TestProject").append("topFolder4").makeAbsolute();
                uri0 = factory.newURI(this.getURLFromPath(folderPath0).toString());
                uriRelative1 = factory.newURI("level1");
                uriRelative2 = factory.newURI("leafFile.txt");
                newURI = uri0.append(uriRelative1).append(uriRelative2);
                EclipseURITests.assertTrue((String)"newURI should not exist", (boolean)(newURI.isPresent() == false));
                newURI.touchLeaf();
                EclipseURITests.assertTrue((String)"newURI should exist", (boolean)newURI.isPresent());
                EclipseURITests.assertTrue((String)"newURI should be a leaf", (boolean)newURI.isLeaf());
                stream = newURI.getInputStream();
                byteRead = 0;
                try {
                    try {
                        byteRead = stream.read();
                    }
                    catch (IOException exc) {
                        EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                    }
                }
                catch (Throwable var12_12) {
                    var11_13 = null;
                    try {
                        stream.close();
                        throw var12_12;
                    }
                    catch (IOException exc) {
                        EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                    }
                    throw var12_12;
                }
                {
                    var11_14 = null;
                }
                ** try [egrp 3[TRYBLOCK] [3 : 213->221)] { 
lbl34:
                // 1 sources

                stream.close();
                break block10;
lbl36:
                // 1 sources

                catch (IOException exc) {
                    EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                }
            }
            EclipseURITests.assertTrue((String)"There should be no bytes in this stream", (boolean)(byteRead == -1));
            return;
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testIOOperations() {
        block14: {
            environment = EnvironmentService.getEclipseConsoleEnvironment();
            factory = environment.getURIFactory();
            stream = null;
            writer = null;
            inputStream = null;
            reader = null;
            System.out.println("EclipseURITests.testIOOperations()");
            try {
                try {
                    folderPath0 = new Path("TestProject").append("topFolder5").makeAbsolute();
                    uri0 = factory.newURI(this.getURLFromPath(folderPath0).toString());
                    uriRelative1 = factory.newURI("level1");
                    uriRelative2 = factory.newURI("leafFile.txt");
                    newURI = uri0.append(uriRelative1).append(uriRelative2);
                    EclipseURITests.assertTrue((String)"newURI should not exist", (boolean)(newURI.isPresent() == false));
                    EclipseURITests.assertTrue((String)"newURI should not be readable", (boolean)(newURI.isReadable() == false));
                    EclipseURITests.assertTrue((String)"newURI should be writable", (boolean)(newURI.isWritable() == false));
                    stream = new OutputStreamWriter(newURI.getOutputStream());
                    writer = new PrintWriter(stream);
                    writer.println("This is line 1 of the file.");
                    writer.println("This is line 2 of the file.");
                    writer.println("This is the end of the file.");
                    writer.close();
                    stream.close();
                    writer = null;
                    stream = null;
                    EclipseURITests.assertTrue((String)"newURI should be readable", (boolean)newURI.isReadable());
                    EclipseURITests.assertTrue((String)"newURI should be writable", (boolean)newURI.isWritable());
                    inputStream = new InputStreamReader(newURI.getInputStream());
                    reader = new BufferedReader(inputStream);
                    EclipseURITests.assertTrue((String)"Bad first line of file", (boolean)reader.readLine().equals("This is line 1 of the file."));
                    EclipseURITests.assertTrue((String)"Bad second line of file", (boolean)reader.readLine().equals("This is line 2 of the file."));
                    EclipseURITests.assertTrue((String)"Bad last line of file", (boolean)reader.readLine().equals("This is the end of the file."));
                    EclipseURITests.assertTrue((String)"Extra lines found in file", (boolean)(reader.readLine() == null));
                    reader.close();
                    level1 = uri0.append(uriRelative1);
                    newLevel = uri0.append(factory.newURI("newLevel1"));
                    oldFile = newLevel.append(uriRelative2);
                    newFile = newLevel.append(factory.newURI("newFile"));
                    EclipseURITests.assertTrue((String)"URI is not present", (boolean)newURI.isPresent());
                    EclipseURITests.assertTrue((String)"URI is present", (boolean)(newLevel.append(uriRelative2).isPresent() == false));
                    level1.rename(newLevel);
                    EclipseURITests.assertTrue((String)"URI is present", (boolean)(newURI.isPresent() == false));
                    EclipseURITests.assertTrue((String)"URI is not present", (boolean)newLevel.append(uriRelative2).isPresent());
                    EclipseURITests.assertTrue((String)"URI is present", (boolean)(newFile.isPresent() == false));
                    EclipseURITests.assertTrue((String)"URI is not present", (boolean)oldFile.isPresent());
                    oldFile.rename(newFile);
                    EclipseURITests.assertTrue((String)"URI is not present", (boolean)newFile.isPresent());
                    EclipseURITests.assertTrue((String)"URI is present", (boolean)(oldFile.isPresent() == false));
                }
                catch (URIException exc) {
                    EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                }
                catch (IOException exc) {
                    EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                }
            }
            catch (Throwable var17_18) {
                var16_19 = null;
                if (stream != null) {
                    try {
                        writer.close();
                        stream.close();
                    }
                    catch (IOException exc) {
                        EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                    }
                }
                if (inputStream == null) throw var17_18;
                try {
                    inputStream.close();
                    reader.close();
                    throw var17_18;
                }
                catch (IOException exc) {
                    EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                }
                throw var17_18;
            }
            {
                var16_20 = null;
                if (stream == null) break block14;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 667->679)] { 
lbl79:
            // 1 sources

            writer.close();
            stream.close();
            break block14;
lbl82:
            // 1 sources

            catch (IOException exc) {
                EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
            }
        }
        if (inputStream == null) return;
        try {}
        catch (IOException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
            return;
        }
        inputStream.close();
        reader.close();
    }

    public void testRelative() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("EclipseURITests.testRelative()");
        try {
            IPath folderPath0 = new Path("TestProject").append("relativeProj").makeAbsolute();
            IURI uri0 = factory.newURI(this.getURLFromPath(folderPath0).toString());
            IURI uriRelative1 = factory.newURI("level1");
            IURI level1URI = uri0.append(uriRelative1);
            EclipseURITests.assertTrue((String)"Uri is relative", (!uri0.isRelative() ? 1 : 0) != 0);
            EclipseURITests.assertTrue((String)"Uri is not relative", (boolean)uriRelative1.isRelative());
            EclipseURITests.assertTrue((String)"Uri is relative", (!level1URI.isRelative() ? 1 : 0) != 0);
            EclipseURITests.assertTrue((String)"Uri is not hierarchical", (boolean)uri0.isHierarchical());
            EclipseURITests.assertTrue((String)"Uri is not hierarchical", (boolean)uriRelative1.isHierarchical());
            EclipseURITests.assertTrue((String)"Uri is not hierarchical", (boolean)level1URI.isHierarchical());
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testErase1() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("EclipseURITests.testErase1()");
        try {
            IPath folderPath0 = new Path("TestProject").append("topFolder6").makeAbsolute();
            IURI uri0 = factory.newURI(this.getURLFromPath(folderPath0).toString());
            IURI uriRelative1 = factory.newURI("level1");
            IURI uriRelative2 = factory.newURI("leafFile.txt");
            IURI newURI = uri0.append(uriRelative1).append(uriRelative2);
            IURI level1URI = uri0.append(uriRelative1);
            EclipseURITests.assertTrue((String)"newURI should not exist", (!newURI.isPresent() ? 1 : 0) != 0);
            newURI.touchLeaf();
            EclipseURITests.assertTrue((String)"newURI should exist", (boolean)newURI.isPresent());
            newURI.erase();
            EclipseURITests.assertTrue((String)"newURI should not exist", (!newURI.isPresent() ? 1 : 0) != 0);
            EclipseURITests.assertTrue((String)"folder root should exist", (boolean)uri0.isPresent());
            EclipseURITests.assertTrue((String)"folder level1 should exist", (boolean)level1URI.isPresent());
            uri0.erase();
            EclipseURITests.assertTrue((String)"folder root should not exist", (!uri0.isPresent() ? 1 : 0) != 0);
            EclipseURITests.assertTrue((String)"folder level1 should not exist", (!level1URI.isPresent() ? 1 : 0) != 0);
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testIsLeaf() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("EclipseURITests.testIsLeaf()");
        try {
            IPath folderPath0 = new Path("TestProject").append("topFolder7").makeAbsolute();
            IURI uri0 = factory.newURI(this.getURLFromPath(folderPath0).toString());
            IURI uriRelative1 = factory.newURI("level1");
            IURI uriRelative2 = factory.newURI("leafFile.txt");
            IURI newURI = uri0.append(uriRelative1).append(uriRelative2);
            IURI parent = newURI.parent();
            EclipseURITests.assertTrue((String)"newURI should not exist", (!newURI.isPresent() ? 1 : 0) != 0);
            EclipseURITests.assertTrue((String)"parent should not exist", (!parent.isPresent() ? 1 : 0) != 0);
            EclipseURITests.assertTrue((String)"newURI should not be a leaf yet", (!newURI.isLeaf() ? 1 : 0) != 0);
            EclipseURITests.assertTrue((String)"parent should not be a leaf", (!parent.isLeaf() ? 1 : 0) != 0);
            newURI.touchLeaf();
            EclipseURITests.assertTrue((String)"newURI should exist", (boolean)newURI.isPresent());
            EclipseURITests.assertTrue((String)"parent should exist", (boolean)parent.isPresent());
            EclipseURITests.assertTrue((String)"newURI should be a leaf", (boolean)newURI.isLeaf());
            EclipseURITests.assertTrue((String)"parent should not be a leaf", (!parent.isLeaf() ? 1 : 0) != 0);
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testVisit() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        IURIScheme scheme = EnvironmentService.getEclipseScheme();
        System.out.println("EclipseURITests.testVisit()");
        try {
            IPath folderPath0 = new Path("TestProject").append("root").makeAbsolute();
            IURI uri0 = factory.newURI(this.getURLFromPath(folderPath0).toString());
            Hashtable table = this.buildTestEntries(scheme, uri0);
            uri0.visit((IURIVisitor)new TestVisitor(table));
            this.verifyTable(table);
            this.resetTableForTest2(table);
            uri0.visit((IURIVisitor)new TestVisitor(table));
            this.verifyTable(table);
            this.resetTable(table);
            uri0.visit((IURIVisitor)new TestVisitor(table), (IURIFilter)new TestFilter(table));
            this.verifyTable(table);
            this.resetTableForTest3(table);
            uri0.visit((IURIVisitor)new TestVisitor(table), (IURIFilter)new TestFilter(table));
            this.verifyTable(table);
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    private Hashtable buildTestEntries(IURIScheme scheme, IURI rootURI) {
        Hashtable<String, NodeEntry> table = new Hashtable<String, NodeEntry>();
        try {
            IURI rootc1 = rootURI.append(scheme.newURI("rootc1"));
            IURI rootc2 = rootURI.append(scheme.newURI("rootc2"));
            IURI rootc3 = rootURI.append(scheme.newURI("rootc3"));
            IURI rootc2c1 = rootc2.append(scheme.newURI("rootc2c1"));
            IURI rootc2c2 = rootc2.append(scheme.newURI("rootc2c2"));
            IURI rootc2c3 = rootc2.append(scheme.newURI("rootc2c3"));
            IURI rootc2c2c1 = rootc2c2.append(scheme.newURI("rootc2c2c1"));
            IURI rootc2c2c2 = rootc2c2.append(scheme.newURI("rootc2c2c2"));
            IURI rootc3c1 = rootc3.append(scheme.newURI("rootc3c1"));
            IURI rootc3c2 = rootc3.append(scheme.newURI("rootc3c2"));
            rootc3c1.touchLeaf();
            rootc3c2.touchLeaf();
            rootc2c2c1.touchLeaf();
            rootc2c2c2.touchLeaf();
            rootc2c1.touchLeaf();
            rootc2c3.touchLeaf();
            rootc1.touchFolder();
            table.put("root", new NodeEntry());
            table.put("rootc1", new NodeEntry());
            table.put("rootc2", new NodeEntry());
            table.put("rootc3", new NodeEntry());
            table.put("rootc2c1", new NodeEntry());
            table.put("rootc2c2", new NodeEntry());
            table.put("rootc2c3", new NodeEntry());
            table.put("rootc2c2c1", new NodeEntry());
            table.put("rootc2c2c2", new NodeEntry());
            table.put("rootc3c1", new NodeEntry());
            table.put("rootc3c2", new NodeEntry());
        }
        catch (URIException exc) {
            EclipseURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        return table;
    }

    private String getName(IURI uri) {
        String fullName = uri.toString();
        int slash = fullName.lastIndexOf(47);
        String name = fullName.substring(slash + 1, fullName.length());
        return name;
    }

    private void verifyTable(Hashtable table) {
        Iterator entries = table.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String key = (String)entry.getKey();
            NodeEntry node = (NodeEntry)entry.getValue();
            EclipseURITests.assertTrue((String)("Bad table result for key:" + key + " visited=" + node.wasVisited_ + " shouldbe=" + node.shouldBeVisited_), (node.wasVisited_ == node.shouldBeVisited_ ? 1 : 0) != 0);
        }
    }

    private void resetTableForTest2(Hashtable table) {
        this.resetTable(table);
        NodeEntry rootc2 = (NodeEntry)table.get("rootc2");
        rootc2.stopTraversing_ = true;
        NodeEntry rootc2c1 = (NodeEntry)table.get("rootc2c1");
        rootc2c1.shouldBeVisited_ = false;
        NodeEntry rootc2c2 = (NodeEntry)table.get("rootc2c2");
        rootc2c2.shouldBeVisited_ = false;
        NodeEntry rootc2c3 = (NodeEntry)table.get("rootc2c3");
        rootc2c3.shouldBeVisited_ = false;
        NodeEntry rootc2c2c1 = (NodeEntry)table.get("rootc2c2c1");
        rootc2c2c1.shouldBeVisited_ = false;
        NodeEntry rootc2c2c2 = (NodeEntry)table.get("rootc2c2c2");
        rootc2c2c2.shouldBeVisited_ = false;
    }

    private void resetTableForTest3(Hashtable table) {
        this.resetTable(table);
        NodeEntry rootc3 = (NodeEntry)table.get("rootc3");
        rootc3.visitNode_ = false;
        rootc3.shouldBeVisited_ = false;
        NodeEntry rootc2c2 = (NodeEntry)table.get("rootc2c2");
        rootc2c2.visitNode_ = false;
        rootc2c2.shouldBeVisited_ = false;
        NodeEntry rootc3c1 = (NodeEntry)table.get("rootc3c1");
        rootc3c1.visitNode_ = false;
        rootc3c1.shouldBeVisited_ = false;
    }

    private void resetTable(Hashtable table) {
        Iterator entries = table.values().iterator();
        while (entries.hasNext()) {
            NodeEntry entry = (NodeEntry)entries.next();
            entry.wasVisited_ = false;
            entry.shouldBeVisited_ = true;
            entry.stopTraversing_ = false;
            entry.visitNode_ = true;
        }
    }

    private String getURLFromPath(IPath absolutePath) {
        return "platform:/resource" + absolutePath;
    }

    private String getTmpFileURL(String fileName) {
        File newFile = new File(this.tempDir, fileName);
        return "file:/" + newFile.getAbsolutePath();
    }

    private void deleteDir(File fileOrDirectory) {
        File[] childFiles = fileOrDirectory.listFiles();
        if (childFiles != null) {
            int index = 0;
            while (index < childFiles.length) {
                this.deleteDir(childFiles[index]);
                ++index;
            }
        }
        fileOrDirectory.delete();
    }

    private class NodeEntry {
        public boolean visitNode_;
        public boolean stopTraversing_;
        public boolean wasVisited_;
        public boolean shouldBeVisited_;

        public NodeEntry() {
            this(true, false, true);
        }

        public NodeEntry(boolean visitNode, boolean stop, boolean shouldBeVisited) {
            this.visitNode_ = visitNode;
            this.stopTraversing_ = stop;
            this.shouldBeVisited_ = shouldBeVisited;
            this.wasVisited_ = false;
        }
    }

    private class TestFilter
    implements IURIFilter {
        private Hashtable table_;

        public TestFilter(Hashtable table) {
            this.table_ = table;
        }

        public boolean accepts(IURI uri) {
            NodeEntry entry = (NodeEntry)this.table_.get(EclipseURITests.this.getName(uri));
            return entry.visitNode_;
        }
    }

    private class TestVisitor
    implements IURIVisitor {
        private Hashtable table_;

        public TestVisitor(Hashtable table) {
            this.table_ = table;
        }

        public boolean visit(IURI uri) {
            NodeEntry entry = (NodeEntry)this.table_.get(EclipseURITests.this.getName(uri));
            entry.wasVisited_ = true;
            return !entry.stopTraversing_;
        }
    }
}

