/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.other;

import java.io.IOException;
import org.eclipse.jst.jsp.ui.tests.Logger;
import org.eclipse.jst.jsp.ui.tests.other.DebugDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.util.Debug;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StructuredDocumentToDOMUnitTests
implements IStructuredDocumentListener {
    String getTestString1() {
        return "<a>a<b />b</a>";
    }

    String getTestString2() {
        return "<menu>\n<rname>\nLiam's Chowder House and Grill\n</rname>\n</menu>";
    }

    String getTestString3() {
        return "<test/>\n\n <html>\n</html>";
    }

    String getTestString4() {
        return "<?xml version=\"1.0\" ?>";
    }

    public static void main(String[] args) {
        try {
            StructuredDocumentToDOMUnitTests instance = new StructuredDocumentToDOMUnitTests();
            instance.testNodeDeletion4();
        }
        catch (Exception t) {
            t.printStackTrace();
        }
    }

    void makeChange1(IDOMModel tree) {
        IDOMDocument dom = tree.getDocument();
        NodeList nodes = dom.getChildNodes();
        Node testParentNode = nodes.item(0);
        Node testChildNode = testParentNode.getFirstChild();
        testChildNode = testChildNode.getNextSibling();
        testParentNode.removeChild(testChildNode);
    }

    void makeChange2(IStructuredDocument structuredDocument) {
        structuredDocument.replaceText((Object)this, 19, 1, null);
    }

    void makeChange3(IDOMModel tree) {
        IDOMDocument dom = tree.getDocument();
        Node testChildNode = dom.getLastChild();
        dom.removeChild(testChildNode);
    }

    public void newModel(NewDocumentEvent structuredDocumentEvent) {
        System.out.println("newModel:");
    }

    public void noChange(NoChangeEvent structuredDocumentEvent) {
        Logger.log(1, "StructuredDocumentToDOMUnitTests::noChange needs to be implemented");
    }

    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
        String outString;
        System.out.println("nodesReplaced:");
        System.out.println("\tNewFlatNodes:");
        IStructuredDocumentRegionList flatNodeList = structuredDocumentEvent.getNewStructuredDocumentRegions();
        int len = flatNodeList.getLength();
        int i = 0;
        while (i < len) {
            outString = flatNodeList.item(i).toString();
            outString = StringUtils.escape((String)outString);
            System.out.println("\t\t" + outString);
            ++i;
        }
        System.out.println("\tOldFlatNodes:");
        flatNodeList = structuredDocumentEvent.getOldStructuredDocumentRegions();
        len = flatNodeList.getLength();
        i = 0;
        while (i < len) {
            outString = flatNodeList.item(i).toString();
            outString = StringUtils.escape((String)outString);
            System.out.println("\t\t" + outString);
            ++i;
        }
    }

    public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
        System.out.println("regionChanged:");
    }

    public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
        System.out.println("regionsReplaced:");
    }

    void testNodeDeletion() {
        String initialString = this.getTestString2();
        System.out.println();
        System.out.println("----------------");
        System.out.println("Test Node Deletion");
        String outString = StringUtils.escape((String)initialString);
        System.out.println("Initial String: " + outString);
        IStructuredDocument f = null;
        IModelManager mm = StructuredModelManager.getModelManager();
        try {
            f = mm.createStructuredDocumentFor("dummy.xml", null, null);
        }
        catch (IOException iOException) {}
        f.addDocumentChangedListener((IStructuredDocumentListener)this);
        DOMModelImpl tree = new DOMModelImpl();
        f.addDocumentChangingListener((IStructuredDocumentListener)tree);
        f.setText(null, initialString);
        Debug.dump((IStructuredDocument)f);
        DebugDocument.dump((Document)tree.getDocument());
        this.makeChange2(f);
        System.out.println("resultString (from structuredDocument): ");
        System.out.println(StringUtils.escape((String)f.getText()));
        Debug.dump((IStructuredDocument)f);
        DebugDocument.dump((Document)tree.getDocument());
    }

    void testNodeDeletion3() {
        String initialString = this.getTestString3();
        System.out.println();
        System.out.println("----------------");
        System.out.println("Test Node Deletion");
        String outString = StringUtils.escape((String)initialString);
        System.out.println("Initial String: " + outString);
        IStructuredDocument f = null;
        IModelManager mm = StructuredModelManager.getModelManager();
        try {
            f = mm.createStructuredDocumentFor("dummy.xml", null, null);
        }
        catch (IOException iOException) {}
        f.addDocumentChangedListener((IStructuredDocumentListener)this);
        DOMModelImpl tree = new DOMModelImpl();
        f.addDocumentChangingListener((IStructuredDocumentListener)tree);
        f.setText(null, initialString);
        Debug.dump((IStructuredDocument)f);
        DebugDocument.dump((Document)tree.getDocument());
        this.makeChange3((IDOMModel)tree);
        System.out.println("resultString (from structuredDocument): ");
        System.out.println(StringUtils.escape((String)f.getText()));
        Debug.dump((IStructuredDocument)f);
        DebugDocument.dump((Document)tree.getDocument());
    }

    void testNodeDeletion4() {
        String initialString = this.getTestString4();
        System.out.println();
        System.out.println("----------------");
        System.out.println("Test Node Insert and Delete");
        String outString = StringUtils.escape((String)initialString);
        System.out.println("Initial String: " + outString);
        IStructuredDocument f = null;
        IModelManager mm = StructuredModelManager.getModelManager();
        try {
            f = mm.createStructuredDocumentFor("dummy.xml", null, null);
        }
        catch (IOException iOException) {}
        f.addDocumentChangedListener((IStructuredDocumentListener)this);
        DOMModelImpl tree = new DOMModelImpl();
        f.addDocumentChangingListener((IStructuredDocumentListener)tree);
        f.setText(null, initialString);
        Debug.dump((IStructuredDocument)f);
        DebugDocument.dump((Document)tree.getDocument());
        f.replaceText(null, 0, 0, "a");
        System.out.println(" ==== Results after insert");
        System.out.println("resultString (from structuredDocument): ");
        System.out.println(StringUtils.escape((String)f.getText()));
        Debug.dump((IStructuredDocument)f);
        DebugDocument.dump((Document)tree.getDocument());
        f.replaceText(null, 0, 1, "");
        System.out.println(" ==== Results after delete");
        System.out.println("resultString (from structuredDocument): ");
        System.out.println(StringUtils.escape((String)f.getText()));
        Debug.dump((IStructuredDocument)f);
        DebugDocument.dump((Document)tree.getDocument());
    }
}

