/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class DeleteServerAction
extends AbstractAction {
    private static final String TITLE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.DELETE_CONNECTION_TITLE");
    private static final String MANY = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.DELETE_CONNECTION_MANY");
    private static final String ONE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.DELETE_CONNECTION_ONE");
    private static final String COMA = ",";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private ISelection selection;

    private void removeConnectionInfo(ConnectionInfo info) {
        if (info.getSharedConnection() != null) {
            info.removeSharedConnection();
        }
        if (info.getSharedDatabase() != null) {
            info.removeSharedDatabase();
        }
        connectionManager.removeConnectionInfo(info.getName());
    }

    private String getMessage(String connectionName, IProject[] projects) {
        StringBuffer projectsName = new StringBuffer();
        int i = 0;
        int n = projects.length;
        while (i < n) {
            projectsName.append(i < n - 1 ? QUOTE + projects[i].getName() + QUOTE + COMA + SPACE : QUOTE + projects[i].getName() + QUOTE);
            ++i;
        }
        return MessageFormat.format(projects.length == 1 ? ONE : MANY, projectsName.toString(), connectionName);
    }

    protected void setSelection(ISelection selection) {
        this.selection = selection;
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    public void run(IAction action) {
        IConnectionNode connection = (IConnectionNode)((IStructuredSelection)this.selection).getFirstElement();
        IProject[] projects = connection.getConnectionInfo().getDependentProjects();
        if (projects.length != 0) {
            if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)TITLE, (String)this.getMessage(connection.getDisplayName(), projects))) {
                this.removeConnectionInfo(connection.getConnectionInfo());
            }
        } else {
            this.removeConnectionInfo(connection.getConnectionInfo());
        }
    }
}

