/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.bookmark;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;
import org.eclipse.wst.rdb.server.internal.ui.util.ServerUIDebugOptions;
import org.eclipse.wst.rdb.server.internal.ui.util.logging.Logger;

public class BookmarkSelectionProvider {
    private static final String BOOKMARKVIEW = "org.eclipse.ui.views.BookmarkView";
    private static final String BLANK_ID = "";
    private ISelectionListener listener = null;

    public BookmarkSelectionProvider() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            this.listener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                        Object obj = structuredSelection.getFirstElement();
                        if (obj == null || !(obj instanceof IMarker)) {
                            return;
                        }
                        IMarker marker = (IMarker)obj;
                        try {
                            if (marker.getType().equals("org.eclipse.wst.rdb.core.ui.transientBookmark")) {
                                String attribute = marker.getAttribute("elementId", BookmarkSelectionProvider.BLANK_ID);
                                if (!attribute.equals(BookmarkSelectionProvider.BLANK_ID)) {
                                    IServicesManager.INSTANCE.getServerExplorerContentService().expandNode(attribute);
                                }
                            } else {
                                IDataToolsUIServiceManager.INSTANCE.getMarkerNavigationService().gotoMarker(null, marker);
                            }
                        }
                        catch (CoreException e) {
                            Logger.log(this, e, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
                        }
                    }
                }
            };
            page.addSelectionListener(BOOKMARKVIEW, this.listener);
        }
    }

    public void removeListener() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        if (this.listener != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            page.removeSelectionListener(BOOKMARKVIEW, this.listener);
        }
    }
}

