/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.impl.IResourceFactoryExtPtConstants;
import org.eclipse.wst.common.internal.emf.resource.FileNameResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.resource.ResourceFactoryDescriptor;
import org.eclipse.wst.common.internal.emf.utilities.DefaultOverridableResourceFactoryRegistry;

public class WTPResourceFactoryRegistry
extends FileNameResourceFactoryRegistry {
    public static final WTPResourceFactoryRegistry INSTANCE = new WTPResourceFactoryRegistry();
    private static final boolean LOG_WARNINGS = false;

    private WTPResourceFactoryRegistry() {
        new ResourceFactoryRegistryReader().readRegistry();
    }

    public Resource.Factory delegatedGetFactory(URI uri) {
        if (INSTANCE == this) {
            return super.delegatedGetFactory(uri);
        }
        return INSTANCE.getFactory(uri);
    }

    public synchronized Resource.Factory getFactory(URI uri) {
        ResourceFactoryDescriptor descriptor;
        Resource.Factory resourceFactory = null;
        if (uri != null && uri.lastSegment() != null && (descriptor = this.getDescriptor(uri)) != null) {
            resourceFactory = this.getFactory(descriptor);
        }
        if (resourceFactory == null) {
            resourceFactory = super.getFactory(uri);
        }
        return resourceFactory;
    }

    public synchronized void registerLastFileSegment(String aSimpleFileName, Resource.Factory aFactory) {
        super.registerLastFileSegment(aSimpleFileName, aFactory);
    }

    static /* synthetic */ Resource.Factory access$0() {
        return DefaultOverridableResourceFactoryRegistry.GLOBAL_FACTORY;
    }

    static /* synthetic */ void access$1(WTPResourceFactoryRegistry wTPResourceFactoryRegistry, ResourceFactoryDescriptor resourceFactoryDescriptor) {
        wTPResourceFactoryRegistry.addDescriptor(resourceFactoryDescriptor);
    }

    private class ConfigurationResourceFactoryDescriptor
    extends ResourceFactoryDescriptor
    implements IResourceFactoryExtPtConstants {
        private String shortSegment;
        private final IConfigurationElement element;

        public ConfigurationResourceFactoryDescriptor(IConfigurationElement ext) throws CoreException {
            Assert.isNotNull((Object)ext);
            this.element = ext;
            this.init();
        }

        private void init() throws CoreException {
            this.shortSegment = this.element.getAttribute("shortSegment");
            if (this.shortSegment == null || this.shortSegment.trim().length() == 0) {
                throw new CoreException(ModulecorePlugin.createErrorStatus(0, "The shortSegment attribute of resourceFactory must specify a valid, non-null, non-empty value in " + this.element.getNamespaceIdentifier(), null));
            }
        }

        public boolean isEnabledFor(URI fileURI) {
            if (fileURI != null && fileURI.lastSegment() != null) {
                return this.shortSegment.equals(fileURI.lastSegment());
            }
            return false;
        }

        public Resource.Factory createFactory() {
            Resource.Factory[] factory = new Resource.Factory[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, factory){
                final /* synthetic */ ConfigurationResourceFactoryDescriptor this$1;
                private final /* synthetic */ Resource.Factory[] val$factory;
                {
                    this.this$1 = configurationResourceFactoryDescriptor;
                    this.val$factory = factoryArray;
                }

                public void run() throws Exception {
                    this.val$factory[0] = (Resource.Factory)ConfigurationResourceFactoryDescriptor.access$0(this.this$1).createExecutableExtension("class");
                }

                public void handleException(Throwable exception) {
                    ModulecorePlugin.log(ModulecorePlugin.createErrorStatus(0, exception.getMessage(), exception));
                }
            });
            return factory[0] != null ? factory[0] : WTPResourceFactoryRegistry.access$0();
        }

        public String getShortSegment() {
            return this.shortSegment;
        }

        static /* synthetic */ IConfigurationElement access$0(ConfigurationResourceFactoryDescriptor configurationResourceFactoryDescriptor) {
            return configurationResourceFactoryDescriptor.element;
        }
    }

    private class ResourceFactoryRegistryReader
    extends RegistryReader
    implements IResourceFactoryExtPtConstants {
        public ResourceFactoryRegistryReader() {
            super(Platform.getPluginRegistry(), "org.eclipse.wst.common.modulecore", "resourceFactories");
        }

        public boolean readElement(IConfigurationElement element) {
            if (element != null && "resourceFactory".equals(element.getName())) {
                boolean[] success = new boolean[]{true};
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, element, success){
                    final /* synthetic */ ResourceFactoryRegistryReader this$1;
                    private final /* synthetic */ IConfigurationElement val$element;
                    private final /* synthetic */ boolean[] val$success;
                    {
                        this.this$1 = resourceFactoryRegistryReader;
                        this.val$element = iConfigurationElement;
                        this.val$success = blArray;
                    }

                    public void run() throws Exception {
                        WTPResourceFactoryRegistry.access$1(ResourceFactoryRegistryReader.access$0(this.this$1), ResourceFactoryRegistryReader.access$0(this.this$1).new ConfigurationResourceFactoryDescriptor(this.val$element));
                    }

                    public void handleException(Throwable exception) {
                        ModulecorePlugin.log(ModulecorePlugin.createErrorStatus(0, exception.getMessage(), exception));
                        this.val$success[0] = false;
                    }
                });
                return success[0];
            }
            return false;
        }

        static /* synthetic */ WTPResourceFactoryRegistry access$0(ResourceFactoryRegistryReader resourceFactoryRegistryReader) {
            return resourceFactoryRegistryReader.WTPResourceFactoryRegistry.this;
        }
    }
}

