/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.style.java;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jst.jsp.ui.internal.style.java.JavaWordDetector;

class JavaCodeScanner
extends RuleBasedScanner {
    private IToken fKeywordToken;
    private IToken fTypeToken;
    private IToken fStringToken;
    private IToken fSingleLineCommentToken;
    private IToken fDefaultToken;
    private static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "continue", "default", "do", "else", "extends", "final", "finally", "for", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while", "strictfp"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};

    public void initializeRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("/*", "*/", this.fSingleLineCommentToken));
        rules.add(new EndOfLineRule("//", this.fSingleLineCommentToken));
        rules.add(new SingleLineRule("\"", "\"", this.fStringToken, '\\'));
        rules.add(new SingleLineRule("'", "'", this.fStringToken, '\\'));
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), this.fDefaultToken);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], this.fKeywordToken);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], this.fTypeToken);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], this.fTypeToken);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public void setTokenData(String tokenKey, Object data) {
        if (tokenKey == "keyword") {
            this.fKeywordToken = new Token(data);
            this.fTypeToken = new Token(data);
        } else if (tokenKey == "string") {
            this.fStringToken = new Token(data);
        } else if (tokenKey == "single_line_comment") {
            this.fSingleLineCommentToken = new Token(data);
        } else if (tokenKey == "default") {
            this.fDefaultToken = new Token(data);
        }
    }
}

