/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui;

import java.util.ArrayList;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jst.jsp.core.internal.text.StructuredTextPartitionerForJSP;
import org.eclipse.jst.jsp.ui.internal.autoedit.AutoEditStrategyForTabs;
import org.eclipse.jst.jsp.ui.internal.autoedit.StructuredAutoEditStrategyJSP;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPContentAssistProcessor;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPELContentAssistProcessor;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPJavaContentAssistProcessor;
import org.eclipse.jst.jsp.ui.internal.contentassist.NoRegionContentAssistProcessorForJSP;
import org.eclipse.jst.jsp.ui.internal.format.FormattingStrategyJSPJava;
import org.eclipse.jst.jsp.ui.internal.hyperlink.JSPJavaHyperlinkDetector;
import org.eclipse.jst.jsp.ui.internal.hyperlink.TaglibHyperlinkDetector;
import org.eclipse.jst.jsp.ui.internal.hyperlink.XMLHyperlinkDetector;
import org.eclipse.jst.jsp.ui.internal.style.LineStyleProviderForJSP;
import org.eclipse.jst.jsp.ui.internal.style.java.LineStyleProviderForJava;
import org.eclipse.jst.jsp.ui.internal.style.jspel.LineStyleProviderForJSPEL;
import org.eclipse.jst.jsp.ui.internal.taginfo.JSPInformationProvider;
import org.eclipse.jst.jsp.ui.internal.taginfo.JSPJavaJavadocHoverProcessor;
import org.eclipse.jst.jsp.ui.internal.taginfo.JSPJavaJavadocInformationProvider;
import org.eclipse.jst.jsp.ui.internal.taginfo.JSPTagInfoHoverProcessor;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;

public class StructuredTextViewerConfigurationJSP
extends StructuredTextViewerConfiguration {
    private String[] fConfiguredContentTypes;
    private LineStyleProvider fLineStyleProviderForJava;
    private LineStyleProvider fLineStyleProviderForJSP;
    private LineStyleProvider fLineStyleProviderForJSPEL;
    private StructuredTextViewerConfiguration fHTMLSourceViewerConfiguration;
    private JavaSourceViewerConfiguration fJavaSourceViewerConfiguration;
    private StructuredTextViewerConfiguration fXMLSourceViewerConfiguration;

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] strategies = null;
        if (contentType == "org.eclipse.wst.xml.XML_DEFAULT") {
            strategies = this.getXMLSourceViewerConfiguration().getAutoEditStrategies(sourceViewer, contentType);
        } else if (contentType == "org.eclipse.jst.jsp.SCRIPT.JAVA") {
            ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
            IAutoEditStrategy[] javaStrategies = this.getJavaSourceViewerConfiguration().getAutoEditStrategies(sourceViewer, "___java_partitioning");
            int i = 0;
            while (i < javaStrategies.length) {
                allStrategies.add(javaStrategies[i]);
                ++i;
            }
            allStrategies.add(new AutoEditStrategyForTabs());
            strategies = allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
        } else if (contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.HTML_DECLARATION") {
            ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
            allStrategies.add(new StructuredAutoEditStrategyJSP());
            IAutoEditStrategy[] htmlStrategies = this.getHTMLSourceViewerConfiguration().getAutoEditStrategies(sourceViewer, contentType);
            int i = 0;
            while (i < htmlStrategies.length) {
                allStrategies.add(htmlStrategies[i]);
                ++i;
            }
            strategies = allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
        } else {
            ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
            IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
            int i = 0;
            while (i < superStrategies.length) {
                allStrategies.add(superStrategies[i]);
                ++i;
            }
            allStrategies.add(new AutoEditStrategyForTabs());
            strategies = allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
        }
        return strategies;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.fConfiguredContentTypes == null) {
            String[] htmlTypes = this.getHTMLSourceViewerConfiguration().getConfiguredContentTypes(sourceViewer);
            String[] jspTypes = StructuredTextPartitionerForJSP.getConfiguredContentTypes();
            this.fConfiguredContentTypes = new String[htmlTypes.length + jspTypes.length];
            int index = 0;
            System.arraycopy(htmlTypes, 0, this.fConfiguredContentTypes, index, htmlTypes.length);
            System.arraycopy(jspTypes, 0, this.fConfiguredContentTypes, index += htmlTypes.length, jspTypes.length);
        }
        return this.fConfiguredContentTypes;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        if (partitionType == "org.eclipse.wst.html.SCRIPT") {
            IContentAssistant htmlContentAssistant = this.getHTMLSourceViewerConfiguration().getContentAssistant(sourceViewer);
            IContentAssistProcessor processor = htmlContentAssistant.getContentAssistProcessor("org.eclipse.wst.html.SCRIPT");
            processors = new IContentAssistProcessor[]{processor};
        } else if (partitionType == "org.eclipse.wst.css.STYLE") {
            IContentAssistant htmlContentAssistant = this.getHTMLSourceViewerConfiguration().getContentAssistant(sourceViewer);
            IContentAssistProcessor processor = htmlContentAssistant.getContentAssistProcessor("org.eclipse.wst.css.STYLE");
            processors = new IContentAssistProcessor[]{processor};
        } else if (partitionType == "org.eclipse.wst.xml.XML_DEFAULT" || partitionType == "org.eclipse.wst.html.HTML_DEFAULT" || partitionType == "org.eclipse.wst.html.HTML_COMMENT" || partitionType == "org.eclipse.jst.jsp.DEFAULT_JSP" || partitionType == "org.eclipse.jst.jsp.JSP_DIRECTIVE" || partitionType == "org.eclipse.jst.jsp.SCRIPT.DELIMITER" || partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT" || partitionType == "org.eclipse.jst.jsp.JSP_COMMENT") {
            processors = new IContentAssistProcessor[]{new JSPContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.wst.xml.XML_CDATA" || partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVA") {
            processors = new IContentAssistProcessor[]{new JSPJavaContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.jst.jsp.SCRIPT.JSP_EL") {
            processors = new IContentAssistProcessor[]{new JSPELContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE") {
            processors = new IContentAssistProcessor[]{new NoRegionContentAssistProcessorForJSP()};
        }
        return processors;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.xml.XML_DEFAULT");
        formatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new HTMLFormatProcessorImpl()));
        formatter.setSlaveStrategy((IFormattingStrategy)new FormattingStrategyJSPJava(), "org.eclipse.jst.jsp.SCRIPT.JAVA");
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        ITextDoubleClickStrategy strategy = null;
        strategy = contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.SCRIPT" ? this.getHTMLSourceViewerConfiguration().getDoubleClickStrategy(sourceViewer, contentType) : (contentType == "org.eclipse.jst.jsp.SCRIPT.JAVA" || contentType == "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT" ? this.getJavaSourceViewerConfiguration().getDoubleClickStrategy(sourceViewer, contentType) : (contentType == "org.eclipse.jst.jsp.DEFAULT_JSP" ? this.getHTMLSourceViewerConfiguration().getDoubleClickStrategy(sourceViewer, "org.eclipse.wst.html.HTML_DEFAULT") : super.getDoubleClickStrategy(sourceViewer, contentType)));
        return strategy;
    }

    private StructuredTextViewerConfiguration getHTMLSourceViewerConfiguration() {
        if (this.fHTMLSourceViewerConfiguration == null) {
            this.fHTMLSourceViewerConfiguration = new StructuredTextViewerConfigurationHTML();
        }
        return this.fHTMLSourceViewerConfiguration;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return null;
        }
        if (sourceViewer == null || !this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<Object> allDetectors = new ArrayList<Object>(0);
        allDetectors.add(new JSPJavaHyperlinkDetector());
        allDetectors.add(new TaglibHyperlinkDetector());
        allDetectors.add(new XMLHyperlinkDetector());
        IHyperlinkDetector[] superDetectors = super.getHyperlinkDetectors(sourceViewer);
        int m = 0;
        while (m < superDetectors.length) {
            IHyperlinkDetector detector = superDetectors[m];
            if (!allDetectors.contains(detector)) {
                allDetectors.add(detector);
            }
            ++m;
        }
        return allDetectors.toArray(new IHyperlinkDetector[0]);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        String[] indentations = null;
        indentations = contentType == "org.eclipse.wst.xml.XML_DEFAULT" ? this.getXMLSourceViewerConfiguration().getIndentPrefixes(sourceViewer, contentType) : this.getHTMLSourceViewerConfiguration().getIndentPrefixes(sourceViewer, contentType);
        return indentations;
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        IInformationProvider provider = null;
        if (partitionType == "org.eclipse.wst.html.HTML_DEFAULT") {
            IInformationPresenter htmlPresenter = this.getHTMLSourceViewerConfiguration().getInformationPresenter(sourceViewer);
            provider = htmlPresenter.getInformationProvider("org.eclipse.wst.html.HTML_DEFAULT");
        } else if (partitionType == "org.eclipse.wst.html.SCRIPT") {
            IInformationPresenter htmlPresenter = this.getHTMLSourceViewerConfiguration().getInformationPresenter(sourceViewer);
            provider = htmlPresenter.getInformationProvider("org.eclipse.wst.html.SCRIPT");
        } else if (partitionType == "org.eclipse.wst.xml.XML_DEFAULT") {
            IInformationPresenter xmlPresenter = this.getXMLSourceViewerConfiguration().getInformationPresenter(sourceViewer);
            provider = xmlPresenter.getInformationProvider("org.eclipse.wst.xml.XML_DEFAULT");
        } else if (partitionType == "org.eclipse.jst.jsp.DEFAULT_JSP" || partitionType == "org.eclipse.jst.jsp.JSP_DIRECTIVE") {
            provider = new JSPInformationProvider();
        } else if (partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVA") {
            provider = new JSPJavaJavadocInformationProvider();
        }
        return provider;
    }

    private JavaSourceViewerConfiguration getJavaSourceViewerConfiguration() {
        if (this.fJavaSourceViewerConfiguration == null) {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            JavaTextTools javaTextTools = new JavaTextTools(store);
            this.fJavaSourceViewerConfiguration = new JavaSourceViewerConfiguration(javaTextTools.getColorManager(), store, null, "___java_partitioning");
        }
        return this.fJavaSourceViewerConfiguration;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = null;
        if (partitionType == "org.eclipse.wst.html.HTML_DEFAULT" || partitionType == "org.eclipse.wst.html.HTML_COMMENT" || partitionType == "org.eclipse.wst.html.HTML_DECLARATION") {
            providers = this.getHTMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.html.HTML_DEFAULT");
        } else if (partitionType == "org.eclipse.wst.html.SCRIPT" || partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT") {
            providers = this.getHTMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.html.SCRIPT");
        } else if (partitionType == "org.eclipse.wst.css.STYLE") {
            providers = this.getHTMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.css.STYLE");
        } else if (partitionType == "org.eclipse.wst.xml.XML_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_CDATA" || partitionType == "org.eclipse.wst.xml.XML_COMMENT" || partitionType == "org.eclipse.wst.xml.XML_DECL" || partitionType == "org.eclipse.wst.xml.XML_PI") {
            providers = this.getXMLSourceViewerConfiguration().getLineStyleProviders(sourceViewer, "org.eclipse.wst.xml.XML_DEFAULT");
        } else if (partitionType == "org.eclipse.jst.jsp.SCRIPT.JAVA") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForJava()};
        } else if (partitionType == "org.eclipse.jst.jsp.SCRIPT.JSP_EL") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForJSPEL()};
        } else if (partitionType == "org.eclipse.jst.jsp.JSP_COMMENT" || partitionType == "org.eclipse.jst.jsp.SCRIPT.DELIMITER" || partitionType == "org.eclipse.jst.jsp.DEFAULT_JSP" || partitionType == "org.eclipse.jst.jsp.JSP_DIRECTIVE") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForJSP()};
        }
        return providers;
    }

    private LineStyleProvider getLineStyleProviderForJava() {
        if (this.fLineStyleProviderForJava == null) {
            this.fLineStyleProviderForJava = new LineStyleProviderForJava();
        }
        return this.fLineStyleProviderForJava;
    }

    private LineStyleProvider getLineStyleProviderForJSP() {
        if (this.fLineStyleProviderForJSP == null) {
            this.fLineStyleProviderForJSP = new LineStyleProviderForJSP();
        }
        return this.fLineStyleProviderForJSP;
    }

    private LineStyleProvider getLineStyleProviderForJSPEL() {
        if (this.fLineStyleProviderForJSPEL == null) {
            this.fLineStyleProviderForJSPEL = new LineStyleProviderForJSPEL();
        }
        return this.fLineStyleProviderForJSPEL;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        Object hover = null;
        if (contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.SCRIPT") {
            hover = this.getHTMLSourceViewerConfiguration().getTextHover(sourceViewer, contentType, stateMask);
        } else if (contentType == "org.eclipse.wst.xml.XML_DEFAULT") {
            hover = this.getXMLSourceViewerConfiguration().getTextHover(sourceViewer, contentType, stateMask);
        } else if (contentType == "org.eclipse.jst.jsp.DEFAULT_JSP" || contentType == "org.eclipse.jst.jsp.JSP_DIRECTIVE" || contentType == "org.eclipse.jst.jsp.SCRIPT.JAVA") {
            TextHoverManager manager = SSEUIPlugin.getDefault().getTextHoverManager();
            TextHoverManager.TextHoverDescriptor[] hoverDescs = manager.getTextHovers();
            int i = 0;
            while (i < hoverDescs.length && hover == null) {
                if (hoverDescs[i].isEnabled() && EditorUtility.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                    String hoverType = hoverDescs[i].getId();
                    if ("combinationHover".equalsIgnoreCase(hoverType)) {
                        hover = contentType == "org.eclipse.jst.jsp.DEFAULT_JSP" || contentType == "org.eclipse.jst.jsp.JSP_DIRECTIVE" ? manager.createBestMatchHover((ITextHover)new JSPTagInfoHoverProcessor()) : manager.createBestMatchHover((ITextHover)new JSPJavaJavadocHoverProcessor());
                    } else if ("documentationHover".equalsIgnoreCase(hoverType)) {
                        hover = contentType == "org.eclipse.jst.jsp.DEFAULT_JSP" || contentType == "org.eclipse.jst.jsp.JSP_DIRECTIVE" ? new JSPTagInfoHoverProcessor() : new JSPJavaJavadocHoverProcessor();
                    }
                }
                ++i;
            }
        }
        if (hover == null) {
            hover = super.getTextHover(sourceViewer, contentType, stateMask);
        }
        return hover;
    }

    private StructuredTextViewerConfiguration getXMLSourceViewerConfiguration() {
        if (this.fXMLSourceViewerConfiguration == null) {
            this.fXMLSourceViewerConfiguration = new StructuredTextViewerConfigurationXML();
        }
        return this.fXMLSourceViewerConfiguration;
    }
}

