/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.util.IComponentImplFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ComponentImplRegistryReader
extends RegistryReader {
    private static final String COMPONENT_IMPL_EXTENSION_POINT = "componentimpl";
    private static final String COMPONENT_IMPL = "componentimpl";
    private static final String TYPE = "typeID";
    private static final String CLASS = "class";
    private static final ComponentImplRegistryReader instance = new ComponentImplRegistryReader();
    private final Map descriptors = new HashMap();
    private final Map instances = new HashMap();

    public static ComponentImplRegistryReader instance() {
        return instance;
    }

    public ComponentImplRegistryReader() {
        super("org.eclipse.wst.common.modulecore", "componentimpl");
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ModulecorePlugin.logError(0, exception.getMessage(), exception);
            }

            public void run() throws Exception {
                ComponentImplRegistryReader.this.readRegistry();
            }
        });
    }

    public boolean readElement(IConfigurationElement element) {
        if ("componentimpl".equals(element.getName())) {
            String type = element.getAttribute(TYPE);
            if (type != null) {
                this.descriptors.put(element.getAttribute(TYPE), new ComponentImplDescriptor(element));
            } else {
                ModulecorePlugin.logError(0, "No type attribute is specified for org.eclipse.wst.common.modulecore.componentimpl extension in " + element.getDeclaringExtension().getNamespaceIdentifier(), null);
            }
            return true;
        }
        return false;
    }

    private synchronized IComponentImplFactory getComponentImplFactory(String typeID) {
        ComponentImplDescriptor descriptor = (ComponentImplDescriptor)this.descriptors.get(typeID);
        IComponentImplFactory factory = null;
        if (descriptor != null && (factory = (IComponentImplFactory)this.instances.get(descriptor)) == null) {
            factory = descriptor.createFactory();
            if (factory != null) {
                this.instances.put(descriptor, factory);
            } else {
                this.descriptors.remove(descriptor);
            }
        }
        return factory;
    }

    public IVirtualComponent createComponent(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            Iterator keys = this.descriptors.keySet().iterator();
            while (keys.hasNext()) {
                String typeID = (String)keys.next();
                try {
                    IComponentImplFactory factory;
                    IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
                    if (projectFacet == null || !facetedProject.hasProjectFacet(projectFacet) || (factory = this.getComponentImplFactory(typeID)) == null) continue;
                    return factory.createComponent(project);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return new VirtualComponent(project, (IPath)new Path("/"));
    }

    private class ComponentImplDescriptor {
        private final IConfigurationElement element;
        private final String type;

        public ComponentImplDescriptor(IConfigurationElement configElement) {
            this.element = configElement;
            this.type = this.element.getAttribute(ComponentImplRegistryReader.TYPE);
        }

        public IComponentImplFactory createFactory() {
            IComponentImplFactory[] factory = new IComponentImplFactory[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, factory){
                final /* synthetic */ ComponentImplDescriptor this$1;
                private final /* synthetic */ IComponentImplFactory[] val$factory;
                {
                    this.this$1 = componentImplDescriptor;
                    this.val$factory = iComponentImplFactoryArray;
                }

                public void handleException(Throwable exception) {
                    ModulecorePlugin.logError(0, exception.getMessage(), exception);
                }

                public void run() throws Exception {
                    this.val$factory[0] = (IComponentImplFactory)ComponentImplDescriptor.access$0(this.this$1).createExecutableExtension("class");
                }
            });
            return factory[0];
        }

        public String getType() {
            return this.type;
        }

        static /* synthetic */ IConfigurationElement access$0(ComponentImplDescriptor componentImplDescriptor) {
            return componentImplDescriptor.element;
        }
    }
}

