/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class FacetUtil {
    public static org.eclipse.wst.server.core.IRuntime getRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getProperty("id");
        org.eclipse.wst.server.core.IRuntime[] runtimes = ServerCore.getRuntimes();
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (id.equals(runtimes[i].getId())) {
                return runtimes[i];
            }
            ++i;
        }
        return null;
    }

    public static IRuntime getRuntime(org.eclipse.wst.server.core.IRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getId();
        Set runtimes = RuntimeManager.getRuntimes();
        Iterator iterator = runtimes.iterator();
        while (iterator.hasNext()) {
            IRuntime runtime2 = (IRuntime)iterator.next();
            if (!id.equals(runtime2.getProperty("id"))) continue;
            return runtime2;
        }
        return null;
    }

    public static final IStatus verifyFacets(IProject project, IServer server) {
        if (server == null) {
            return new Status(4, "org.eclipse.jst.server.core", 0, Messages.errorNoRuntime, null);
        }
        org.eclipse.wst.server.core.IRuntime runtime = server.getRuntime();
        if (runtime == null) {
            return new Status(4, "org.eclipse.jst.server.core", 0, Messages.errorNoRuntime, null);
        }
        IRuntime runtime2 = FacetUtil.getRuntime(runtime);
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            Iterator iterator = facetedProject.getProjectFacets().iterator();
            while (iterator.hasNext()) {
                IProjectFacetVersion facet = (IProjectFacetVersion)iterator.next();
                if (runtime2.supports(facet)) continue;
                return new Status(4, "org.eclipse.jst.server.core", 0, NLS.bind((String)Messages.errorFacet, (Object)facet.getProjectFacet().getLabel(), (Object)facet.getVersionString()), null);
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }
}

