/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class NameSection
extends AbstractSection {
    private final String NAME = DTDPropertiesMessages._UI_LABEL_NAME;
    private Text nameText;
    private FontMetrics fFontMetrics;

    public void doHandleEvent(Event event) {
        if (event.widget == this.nameText) {
            Object input = this.getInput();
            String newValue = this.nameText.getText();
            if (newValue.length() > 0 && input instanceof DTDNode) {
                DTDNode dtdNode = (DTDNode)input;
                dtdNode.setName(newValue);
            }
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel nameLabel = this.getWidgetFactory().createCLabel(composite, this.NAME);
        this.initializeFontMetrics((Control)nameLabel);
        int labelWidth = this.getLabelWidth(nameLabel.getText());
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)data);
        this.nameText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)nameLabel, -5);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment((Control)nameLabel, 0, 0x1000000);
        this.nameText.setLayoutData((Object)data);
        this.nameText.addListener(24, (Listener)this);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        this.nameText.setEnabled(true);
        Object input = this.getInput();
        this.nameText.setText("");
        if (input != null && input instanceof DTDNode) {
            this.nameText.setText(((DTDNode)input).getName());
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    private void initializeFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private int getLabelWidth(String labelText) {
        int labelWidth = 98;
        int pixels = Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)(labelText.length() + 5));
        labelWidth = Math.max(pixels, labelWidth);
        return labelWidth;
    }
}

