/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.jst.j2ee.internal.project.Assert;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;

public class WTPJETEmitter
extends JETEmitter {
    public static final String PROJECT_NAME = ".JETEmitters";
    private Map variables;
    private boolean intelligentLinkingEnabled = false;
    private JETCompiler jetCompiler;

    public WTPJETEmitter(String templateURI) {
        super(templateURI);
    }

    public WTPJETEmitter(String[] templateURIPath, String relativeTemplateURI) {
        super(templateURIPath, relativeTemplateURI);
    }

    public WTPJETEmitter(String templateURI, ClassLoader classLoader) {
        super(templateURI, classLoader);
        try {
            this.initialize((IProgressMonitor)new NullProgressMonitor());
        }
        catch (JETException e) {
            e.printStackTrace();
        }
    }

    public WTPJETEmitter(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader) {
        super(templateURIPath, relativeTemplateURI, classLoader);
    }

    public WTPJETEmitter(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader, String encoding) {
        super(templateURIPath, relativeTemplateURI, classLoader, encoding);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(IProgressMonitor progressMonitor) throws JETException {
        progressMonitor.beginTask("", 10);
        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_GeneratingJETEmitterFor_message", new Object[]{this.templateURI}));
        try {
            try {
                IFile targetFile;
                SubProgressMonitor subProgressMonitor;
                String packageName;
                IJavaProject javaProject;
                IProject project;
                IWorkspace workspace;
                block16: {
                    block15: {
                        try {
                            JavaRuntime.getDefaultVMInstall();
                        }
                        catch (Throwable throwable) {
                            URL jreURL = Platform.find((Bundle)Platform.getBundle((String)"org.eclipse.emf.codegen"), (IPath)new Path("plugin.xml"));
                            Path jrePath = new Path(Platform.asLocalURL((URL)jreURL).getFile());
                            jrePath = jrePath.removeLastSegments(1).append((IPath)new Path("../../jre/lib/rt.jar"));
                            if (jrePath.equals((Object)JavaCore.getClasspathVariable((String)"JRE_LIB"))) break block15;
                            JavaCore.setClasspathVariable((String)"JRE_LIB", (IPath)jrePath, null);
                        }
                    }
                    this.getJetCompiler();
                    progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETParsing_message", new Object[]{this.jetCompiler.getResolvedTemplateURI()}));
                    this.jetCompiler.parse();
                    progressMonitor.worked(1);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    this.jetCompiler.generate((OutputStream)outputStream);
                    ByteArrayInputStream contents = new ByteArrayInputStream(outputStream.toByteArray());
                    workspace = ResourcesPlugin.getWorkspace();
                    IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                    if (!javaModel.isOpen()) {
                        javaModel.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    } else {
                        progressMonitor.worked(1);
                    }
                    project = workspace.getRoot().getProject(this.getProjectName());
                    progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETPreparingProject_message", new Object[]{project.getName()}));
                    if (!project.exists()) {
                        javaProject = this.createJavaProject(progressMonitor, workspace, project);
                        this.initializeJavaProject(progressMonitor, project, javaProject);
                        javaProject.close();
                    } else {
                        project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                        javaProject = JavaCore.create((IProject)project);
                    }
                    IPackageFragmentRoot sourcePackageFragmentRoot = this.openJavaProjectIfNecessary(progressMonitor, project, javaProject);
                    packageName = this.jetCompiler.getSkeleton().getPackageName();
                    StringTokenizer stringTokenizer = new StringTokenizer(packageName, ".");
                    subProgressMonitor = new SubProgressMonitor(progressMonitor, 1);
                    subProgressMonitor.beginTask("", stringTokenizer.countTokens() + 4);
                    subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_CreateTargetFile_message"));
                    IContainer sourceContainer = (IContainer)sourcePackageFragmentRoot.getCorrespondingResource();
                    while (true) {
                        if (!stringTokenizer.hasMoreElements()) {
                            targetFile = sourceContainer.getFile((IPath)new Path(String.valueOf(this.jetCompiler.getSkeleton().getClassName()) + ".java"));
                            if (targetFile.exists()) break;
                            subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCreating_message", new Object[]{targetFile.getFullPath()}));
                            targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                            break block16;
                        }
                        String folderName = stringTokenizer.nextToken();
                        if ((sourceContainer = sourceContainer.getFolder((IPath)new Path(folderName))).exists()) continue;
                        ((IFolder)sourceContainer).create(false, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                    }
                    subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETUpdating_message", new Object[]{targetFile.getFullPath()}));
                    targetFile.setContents((InputStream)contents, true, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                }
                boolean errors = this.performBuild(project, (IProgressMonitor)subProgressMonitor, targetFile);
                if (!errors) {
                    this.loadClass(workspace, project, javaProject, packageName, (IProgressMonitor)subProgressMonitor);
                }
                subProgressMonitor.done();
            }
            catch (CoreException exception) {
                throw new JETException((Throwable)exception);
            }
            catch (Exception exception) {
                throw new JETException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var15_19 = null;
        }
        progressMonitor.done();
    }

    protected IPackageFragmentRoot openJavaProjectIfNecessary(IProgressMonitor progressMonitor, IProject project, IJavaProject javaProject) throws JavaModelException {
        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETOpeningJavaProject_message", new Object[]{project.getName()}));
        javaProject.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
        IPackageFragmentRoot sourcePackageFragmentRoot = null;
        int j = 0;
        while (j < packageFragmentRoots.length) {
            IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[j];
            if (packageFragmentRoot.getKind() == 1) {
                sourcePackageFragmentRoot = packageFragmentRoot;
                break;
            }
            ++j;
        }
        return sourcePackageFragmentRoot;
    }

    protected void initializeJavaProject(IProgressMonitor progressMonitor, IProject project, IJavaProject javaProject) throws CoreException, JavaModelException {
        IFolder runtimeFolder;
        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETInitializingProject_message", new Object[]{project.getName()}));
        IClasspathEntry classpathEntry = JavaCore.newSourceEntry((IPath)new Path("/" + project.getName() + "/src"));
        IClasspathEntry jreClasspathEntry = JavaRuntime.getDefaultJREContainerEntry();
        ArrayList<IClasspathEntry> classpath = new ArrayList<IClasspathEntry>();
        classpath.add(classpathEntry);
        classpath.add(jreClasspathEntry);
        classpath.addAll(this.classpathEntries);
        IFolder sourceFolder = project.getFolder((IPath)new Path("src"));
        if (!sourceFolder.exists()) {
            sourceFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        if (!(runtimeFolder = project.getFolder((IPath)new Path("runtime"))).exists()) {
            runtimeFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        IClasspathEntry[] classpathEntryArray = classpath.toArray(new IClasspathEntry[classpath.size()]);
        javaProject.setRawClasspath(classpathEntryArray, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        javaProject.setOutputLocation((IPath)new Path("/" + project.getName() + "/runtime"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        this.createClasspathEntries(project);
    }

    private IJavaProject createJavaProject(IProgressMonitor progressMonitor, IWorkspace workspace, IProject project) throws CoreException {
        progressMonitor.subTask("JET creating project " + project.getName());
        project.create((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCreatingProject_message", new Object[]{project.getName()}));
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        description.setLocation(null);
        project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject;
    }

    protected void loadClass(IWorkspace workspace, IProject project, IJavaProject javaProject, String packageName, IProgressMonitor subProgressMonitor) throws JavaModelException, MalformedURLException, ClassNotFoundException, SecurityException {
        subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETLoadingClass_message", new Object[]{String.valueOf(this.jetCompiler.getSkeleton().getClassName()) + ".class"}));
        URL url = new File(project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/").toURL();
        URLClassLoader theClassLoader = new URLClassLoader(new URL[]{url}, this.classLoader);
        Class<?> theClass = theClassLoader.loadClass(String.valueOf(packageName.length() == 0 ? "" : String.valueOf(packageName) + ".") + this.jetCompiler.getSkeleton().getClassName());
        String methodName = this.jetCompiler.getSkeleton().getMethodName();
        Method[] methods = theClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(methodName)) {
                this.setMethod(methods[i]);
                break;
            }
            ++i;
        }
    }

    protected boolean performBuild(IProject project, IProgressMonitor subProgressMonitor, IFile targetFile) throws CoreException {
        subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETBuilding_message", new Object[]{project.getName()}));
        project.build(10, (IProgressMonitor)new SubProgressMonitor(subProgressMonitor, 1));
        IMarker[] markers = targetFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        boolean errors = false;
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            if (marker.getAttribute("severity", 0) == 2) {
                errors = true;
                subProgressMonitor.subTask(marker.getAttribute("message") + " : " + CodeGenPlugin.getPlugin().getString("jet.mark.file.line", new Object[]{targetFile.getLocation(), marker.getAttribute("lineNumber")}));
            }
            ++i;
        }
        return errors;
    }

    protected void createClasspathEntries(IProject project) {
        Assert.isNotNull(project, "A valid project is required in order to append to a classpath");
        String variableName = null;
        String pluginId = null;
        Iterator variablesKeyIterator = this.getVariables().keySet().iterator();
        while (variablesKeyIterator.hasNext()) {
            variableName = (String)variablesKeyIterator.next();
            pluginId = (String)this.getVariables().get(variableName);
            if (this.hasOutputDirectory(pluginId)) {
                this.addLinkedFolderAsLibrary(project, variableName, pluginId);
                continue;
            }
            this.addRuntimeJarsAsLibrary(project, pluginId);
        }
    }

    protected boolean hasOutputDirectory(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL outputDirectory = Platform.find((Bundle)bundle, (IPath)new Path("bin"));
        if (outputDirectory == null) {
            return false;
        }
        URL installLocation = null;
        try {
            installLocation = Platform.asLocalURL((URL)outputDirectory);
        }
        catch (IOException e) {
            Logger.getLogger().logWarning(String.valueOf(J2EEPluginResourceHandler.getString("Install_Location_Error_", new Object[]{installLocation})) + e);
        }
        File outputDirectoryFile = new File(installLocation.getPath());
        return outputDirectoryFile.canRead() && outputDirectoryFile.isDirectory() && outputDirectoryFile.listFiles().length > 0;
    }

    protected void addRuntimeJarsAsLibrary(IProject project, String pluginId) {
        ManifestElement[] elements = null;
        Bundle bundle = Platform.getBundle((String)pluginId);
        try {
            String requires = (String)bundle.getHeaders().get("Bundle-ClassPath");
            elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires);
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
            elements = new ManifestElement[]{};
        }
        IPath runtimeLibFullPath = null;
        URL fullurl = null;
        if (elements == null) {
            if (bundle.getLocation().endsWith(".jar")) {
                runtimeLibFullPath = this.getJarredPluginPath(bundle);
            }
            this.appendToClassPath(runtimeLibFullPath, project);
            return;
        }
        int i = 0;
        while (i < elements.length) {
            String value = elements[i].getValue();
            if (".".equals(value)) {
                value = "/";
            }
            if ((fullurl = Platform.getBundle((String)pluginId).getEntry(value)) != null) {
                try {
                    runtimeLibFullPath = new Path(Platform.asLocalURL((URL)fullurl).getPath());
                }
                catch (Exception e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                if (bundle.getLocation().endsWith(".jar")) {
                    runtimeLibFullPath = this.getJarredPluginPath(bundle);
                }
                if ("jar".equals(runtimeLibFullPath.getFileExtension()) || "zip".equals(runtimeLibFullPath.getFileExtension())) {
                    this.appendToClassPath(runtimeLibFullPath, project);
                }
            }
            ++i;
        }
    }

    private void appendToClassPath(IPath runtimeLibFullPath, IProject project) {
        IClasspathEntry entry = null;
        entry = JavaCore.newLibraryEntry((IPath)runtimeLibFullPath, null, null, null, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
        try {
            if (!this.classpathEntries.contains(entry)) {
                this.classpathEntries.add(entry);
            }
        }
        catch (Exception e) {
            Logger.getLogger().logError("Problem appending \"" + entry.getPath() + "\" to classpath of Project \"" + project.getName() + "\".");
            Logger.getLogger().logError((Throwable)e);
        }
    }

    private IPath getJarredPluginPath(Bundle bundle) {
        Path runtimeLibFullPath = null;
        String jarPluginLocation = bundle.getLocation().substring(7);
        Path jarPluginPath = new Path(jarPluginLocation);
        if (jarPluginPath.isAbsolute()) {
            runtimeLibFullPath = jarPluginPath;
        } else {
            String installPath = Platform.getInstallLocation().getURL().getPath();
            runtimeLibFullPath = new Path(String.valueOf(installPath) + "/" + jarPluginLocation);
        }
        return runtimeLibFullPath;
    }

    protected void updateProgress(IProgressMonitor progressMonitor, String key) {
        progressMonitor.subTask(this.getMessage(key));
    }

    protected void updateProgress(IProgressMonitor progressMonitor, String key, Object[] args) {
        progressMonitor.subTask(this.getMessage(key, args));
    }

    protected String getMessage(String key) {
        return CodeGenPlugin.getPlugin().getString(key);
    }

    protected String getMessage(String key, Object[] args) {
        return CodeGenPlugin.getPlugin().getString(key, args);
    }

    public void addVariable(String variableName, String pluginID) throws JETException {
        if (!this.isIntelligentLinkingEnabled()) {
            super.addVariable(variableName, pluginID);
        } else {
            this.getVariables().put(variableName, pluginID);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(this.getProjectName());
            if (project != null && project.exists()) {
                this.createClasspathEntries(project);
            }
        }
    }

    private boolean isIntelligentLinkingEnabled() {
        return this.intelligentLinkingEnabled;
    }

    private Map getVariables() {
        if (this.variables == null) {
            this.variables = new HashMap();
        }
        return this.variables;
    }

    protected void addLinkedFolderAsLibrary(IProject project, String variableName, String pluginID) {
        try {
            IClasspathEntry entry;
            URL outputDirectory = Platform.find((Bundle)Platform.getBundle((String)pluginID), (IPath)new Path("bin"));
            String pathString = Platform.asLocalURL((URL)outputDirectory).getPath();
            if (pathString.endsWith("/")) {
                pathString = pathString.substring(0, pathString.length() - 1);
            }
            if (pathString.startsWith("/")) {
                pathString = pathString.substring(1, pathString.length());
            }
            IPath path = new Path(pathString).makeAbsolute();
            String binDirectoryVariable = String.valueOf(variableName) + "_BIN";
            IFolder linkedDirectory = project.getFolder(binDirectoryVariable);
            if (!linkedDirectory.exists()) {
                linkedDirectory.createLink(path, 16, null);
                linkedDirectory.setDerived(true);
                project.refreshLocal(2, null);
            }
            if (!this.classpathEntries.contains(entry = JavaCore.newLibraryEntry((IPath)linkedDirectory.getFullPath(), null, null, null, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false))) {
                this.classpathEntries.add(entry);
            }
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    public void setIntelligentLinkingEnabled(boolean intelligentLinkingEnabled) {
        this.intelligentLinkingEnabled = intelligentLinkingEnabled;
    }

    protected JETCompiler getJetCompiler() {
        try {
            if (this.jetCompiler == null) {
                this.jetCompiler = this.templateURIPath == null ? new JETEmitter.MyJETCompiler((JETEmitter)this, this.templateURI, this.encoding) : new JETEmitter.MyJETCompiler((JETEmitter)this, this.templateURIPath, this.templateURI, this.encoding);
            }
        }
        catch (JETException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return this.jetCompiler;
    }
}

