/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import java.io.File;
import java.util.Set;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.common.frameworks.internal.operations.IProjectCreationPropertiesNew;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationOperationNew;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class ProjectCreationDataModelProviderNew
extends AbstractDataModelProvider
implements IProjectCreationPropertiesNew {
    public IDataModelOperation getDefaultOperation() {
        return new ProjectCreationOperationNew(this.model);
    }

    public void init() {
        super.init();
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IProjectCreationPropertiesNew.PROJECT");
        propertyNames.add("IProjectCreationPropertiesNew.PROJECT_NAME");
        propertyNames.add("IProjectCreationPropertiesNew.PROJECT_LOCATION");
        propertyNames.add("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION");
        propertyNames.add("IProjectCreationPropertiesNew.DEFAULT_LOCATION");
        propertyNames.add("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION");
        propertyNames.add("IProjectCreationPropertiesNew.USER_DEFINED_BASE_LOCATION");
        propertyNames.add("IProjectCreationPropertiesNew.PROJECT_NATURES");
        propertyNames.add("IProjectCreationPropertiesNew.PROJECT_DESCRIPTION");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IProjectCreationPropertiesNew.PROJECT_LOCATION")) {
            if (this.getBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION")) {
                return null;
            }
            if (this.isPropertySet("IProjectCreationPropertiesNew.USER_DEFINED_BASE_LOCATION")) {
                return String.valueOf(this.getStringProperty("IProjectCreationPropertiesNew.USER_DEFINED_BASE_LOCATION")) + File.separator + this.getStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
            }
            return this.getProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION");
        }
        if ("IProjectCreationPropertiesNew.DEFAULT_LOCATION".equals(propertyName)) {
            return this.getDefaultLocation();
        }
        if ("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION".equals(propertyName)) {
            return Boolean.TRUE;
        }
        if ("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION".equals(propertyName) || "IProjectCreationPropertiesNew.USER_DEFINED_BASE_LOCATION".equals(propertyName)) {
            return "";
        }
        if (propertyName.equals("IProjectCreationPropertiesNew.PROJECT_DESCRIPTION")) {
            return this.getProjectDescription();
        }
        return super.getDefaultProperty(propertyName);
    }

    private String getDefaultLocation() {
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String projectName = (String)this.getProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        if (projectName != null) {
            path = path.append(projectName);
        }
        return path.toOSString();
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IProjectCreationPropertiesNew.PROJECT_LOCATION") || propertyName.equals("IProjectCreationPropertiesNew.DEFAULT_LOCATION") || propertyName.equals("IProjectCreationPropertiesNew.PROJECT_DESCRIPTION")) {
            throw new RuntimeException();
        }
        if (propertyName.equals("IProjectCreationPropertiesNew.PROJECT_NAME")) {
            IStatus stat = this.model.validateProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
            if (stat != OK_STATUS) {
                return true;
            }
            this.model.setProperty("IProjectCreationPropertiesNew.PROJECT", this.getProject());
            this.model.notifyPropertyChange("IProjectCreationPropertiesNew.DEFAULT_LOCATION", 1);
            if (this.getBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION") || this.isPropertySet("IProjectCreationPropertiesNew.USER_DEFINED_BASE_LOCATION")) {
                this.model.notifyPropertyChange("IProjectCreationPropertiesNew.PROJECT_LOCATION", 1);
            }
        } else if (propertyName.equals("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION")) {
            this.model.notifyPropertyChange("IProjectCreationPropertiesNew.PROJECT_LOCATION", 1);
        } else if ((propertyName.equals("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION") || propertyName.equals("IProjectCreationPropertiesNew.USER_DEFINED_BASE_LOCATION")) && !this.getBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION")) {
            this.model.notifyPropertyChange("IProjectCreationPropertiesNew.PROJECT_LOCATION", 1);
        }
        return true;
    }

    private IProjectDescription getProjectDescription() {
        String projectName = (String)this.getProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        String projectLocation = (String)this.getProperty("IProjectCreationPropertiesNew.PROJECT_LOCATION");
        if (projectLocation != null) {
            desc.setLocation((IPath)new Path(projectLocation));
        } else {
            desc.setLocation(null);
        }
        return desc;
    }

    protected IProject getProject() {
        String projectName = (String)this.getProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        return projectName != null && projectName.length() > 0 ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
    }

    public IStatus validate(String propertyName) {
        IStatus status;
        String name;
        IStatus status2;
        if (propertyName.equals("IProjectCreationPropertiesNew.PROJECT_NAME") && !(status2 = ProjectCreationDataModelProviderNew.validateName(name = this.model.getStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME"))).isOK()) {
            return status2;
        }
        if (propertyName.equals("IProjectCreationPropertiesNew.PROJECT_LOCATION") && !(status = this.validateLocation()).isOK()) {
            return status;
        }
        if (propertyName.equals("IProjectCreationPropertiesNew.PROJECT_LOCATION") || propertyName.equals("IProjectCreationPropertiesNew.PROJECT_NAME")) {
            String projectName = this.getStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
            String projectLoc = "";
            projectLoc = this.getBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION") ? this.getDefaultLocation() : this.getStringProperty("IProjectCreationPropertiesNew.PROJECT_LOCATION");
            return this.validateExisting(projectName, projectLoc);
        }
        return OK_STATUS;
    }

    private IStatus validateExisting(String projectName, String projectLoc) {
        File dotProject;
        File file;
        if (projectName != null && !projectName.equals("") && (file = new File(projectLoc)).exists() && file.isDirectory() && (dotProject = new File(file, ".project")).exists()) {
            return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("32", new Object[]{file.toString()}));
        }
        return OK_STATUS;
    }

    public static IProject getProjectHandleFromProjectName(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(projectName, 4);
        return projectName != null && projectName.length() > 0 && status.isOK() ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
    }

    public static IStatus validateProjectName(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(projectName, 4);
        if (!status.isOK()) {
            return status;
        }
        if (projectName.endsWith(" ")) {
            return WTPCommonPlugin.createErrorStatus(WTPResourceHandler.getString("41"));
        }
        return OK_STATUS;
    }

    public static IStatus validateName(String name) {
        IResource variant;
        IStatus status = ProjectCreationDataModelProviderNew.validateProjectName(name);
        if (!status.isOK()) {
            return status;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("43", new Object[]{name}));
        }
        if (!WTPPlugin.isPlatformCaseSensitive() && (variant = ((Resource)project).findExistingResourceVariant(project.getFullPath())) != null) {
            return WTPCommonPlugin.createErrorStatus(WTPResourceHandler.getString("42"));
        }
        return OK_STATUS;
    }

    private IStatus validateLocation() {
        String loc = (String)this.getProperty("IProjectCreationPropertiesNew.PROJECT_LOCATION");
        if (loc != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(loc);
            return workspace.validateProjectLocation(this.getProject(), (IPath)path);
        }
        return OK_STATUS;
    }
}

