/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class NewElementWizard
extends Wizard
implements INewWizard {
    private IWorkbench fWorkbench;
    private IStructuredSelection fSelection;

    public NewElementWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected void openResource(final IFile resource) {
        Display display;
        final IWorkbenchPage activePage = PersistenceUiPlugin.getActivePage();
        if (activePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    protected abstract void finishPage(IProgressMonitor var1) throws InterruptedException, CoreException;

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean canRunForked() {
        return true;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
    }

    public boolean performFinish() {
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                try {
                    NewElementWizard.this.finishPage(monitor);
                }
                catch (InterruptedException e) {
                    throw new OperationCanceledException(e.getMessage());
                }
            }
        };
        try {
            ISchedulingRule rule = null;
            Job job = Platform.getJobManager().currentJob();
            if (job != null) {
                rule = job.getRule();
            }
            WorkbenchRunnableAdapter runnable = null;
            runnable = rule != null ? new WorkbenchRunnableAdapter(op, rule, true) : new WorkbenchRunnableAdapter(op, this.getSchedulingRule());
            this.getContainer().run(this.canRunForked(), true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            this.handleFinishException(this.getShell(), e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void warnAboutTypeCommentDeprecation() {
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.fWorkbench = workbench;
        this.fSelection = currentSelection;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
    }
}

