/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.emf.common.util.EList;

final class RDBDatabaseWrapper
extends Database {
    private final org.eclipse.wst.rdb.internal.models.sql.schema.Database rdbDatabase;
    private Set schemata;

    RDBDatabaseWrapper(org.eclipse.wst.rdb.internal.models.sql.schema.Database rdbDatabase) {
        this.rdbDatabase = rdbDatabase;
    }

    public String getName() {
        return this.rdbDatabase.getName();
    }

    public boolean isConnected() {
        return true;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    synchronized Set getSchemata() {
        if (this.schemata == null) {
            this.schemata = this.buildSchemata();
        }
        return this.schemata;
    }

    private Set buildSchemata() {
        EList rdbSchemata = this.rdbDatabase.getSchemas();
        HashSet<Schema> result = new HashSet<Schema>(rdbSchemata.size());
        Iterator stream = rdbSchemata.iterator();
        while (stream.hasNext()) {
            result.add(new Schema(this, (org.eclipse.wst.rdb.internal.models.sql.schema.Schema)stream.next()));
        }
        return result;
    }
}

