package com.leagueplanet.model;

import java.io.Serializable;

public class Location implements Serializable {

	private static final long serialVersionUID = 1L;

	private long id;

	private String name;
	
	private String timeZoneId;

	public String getTimeZoneId() {
		return timeZoneId;
	}

	public void setTimeZoneId(String timeZoneId) {
		this.timeZoneId = timeZoneId;
	}

	public Location() {
		this(0);
	}
	
	public Location(long id) {
		this(id, "");
	}

	public Location(long id, String name) {
		this(id, name, "UTC");
	}
	
	public Location(long id, String name, String timeZoneId) {
		setId(id);
		setName(name);	
		setTimeZoneId(timeZoneId);
	}
	
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
