/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.closure;

import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayName;
import org.eclipse.wst.jsdt.core.dom.ArrowFunctionExpression;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DebuggerStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.ExportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForOfStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.ModuleSpecifier;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.ObjectName;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.RestElementName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SpreadElement;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TemplateElement;
import org.eclipse.wst.jsdt.core.dom.TemplateLiteral;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableKind;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.YieldExpression;
import org.eclipse.wst.jsdt.internal.compiler.closure.ClosureCompiler;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ClosureCompilerTests {
    @Test
    public void createParserInstance() {
        ClosureCompiler parser = ClosureCompiler.newInstance();
        Assert.assertNotNull((Object)parser);
    }

    @Test
    public void parseMultipleCalls() {
        JavaScriptUnit unit = this.parse("var a = 1;");
        Assert.assertNotNull((Object)unit);
        unit = this.parse("var a = true;");
        Assert.assertNotNull((Object)unit);
        unit = this.parse("var a = 'atest';");
        Assert.assertNotNull((Object)unit);
        unit = this.parse("var a = null;");
        Assert.assertNotNull((Object)unit);
    }

    @Test
    public void checkRange() {
        JavaScriptUnit unit = this.parse("var a = 1;");
        Assert.assertNotNull((Object)unit);
        Assert.assertEquals((long)0L, (long)unit.getStartPosition());
        Assert.assertEquals((long)10L, (long)unit.getLength());
    }

    @Test
    public void testVariableDeclaration_VAR() {
        JavaScriptUnit unit = this.parse("var a,b;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 60) continue;
            VariableDeclarationStatement vd = (VariableDeclarationStatement)astNode;
            Assert.assertEquals((Object)VariableKind.VAR, (Object)vd.getKind());
            Assert.assertEquals((long)2L, (long)vd.fragments().size());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testVariableDeclaration_LET() {
        JavaScriptUnit unit = this.parse("let a,b;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 60) continue;
            VariableDeclarationStatement vd = (VariableDeclarationStatement)astNode;
            Assert.assertEquals((Object)VariableKind.LET, (Object)vd.getKind());
            Assert.assertEquals((long)2L, (long)vd.fragments().size());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSimpleAssignment() {
        JavaScriptUnit unit = this.parse("a += 123;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            Assignment assignment = (Assignment)((ExpressionStatement)astNode).getExpression();
            Assert.assertSame((Object)Assignment.Operator.PLUS_ASSIGN, (Object)assignment.getOperator());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testThisExpression() {
        JavaScriptUnit unit = this.parse("this;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            Assert.assertTrue((boolean)(((ExpressionStatement)astNode).getExpression() instanceof ThisExpression));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testArrayExpression() {
        JavaScriptUnit unit = this.parse("[1,2,3];");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            Assert.assertTrue((boolean)(((ExpressionStatement)astNode).getExpression() instanceof ArrayInitializer));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testObjectExpression() {
        JavaScriptUnit unit = this.parse("o={ test:9 };");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            Expression c1 = ((ExpressionStatement)astNode).getExpression();
            Assert.assertTrue((boolean)(c1 instanceof Assignment));
            Assignment a = (Assignment)c1;
            Assert.assertSame((Object)a.getRightHandSide().getNodeType(), (Object)85);
            ObjectLiteral ol = (ObjectLiteral)a.getRightHandSide();
            Assert.assertNotNull(ol.fields().get(0));
            ObjectLiteralField lf = (ObjectLiteralField)ol.fields().get(0);
            Assert.assertEquals((Object)ObjectLiteralField.FieldKind.INIT, (Object)lf.getKind());
            Assert.assertTrue((lf.getInitializer().getNodeType() == 34 ? 1 : 0) != 0);
            return;
        }
        Assert.fail();
    }

    @Test
    public void testPosxFixExpression() {
        JavaScriptUnit unit = this.parse("123++;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            PostfixExpression pf = (PostfixExpression)((ExpressionStatement)astNode).getExpression();
            Assert.assertSame((Object)PostfixExpression.Operator.INCREMENT, (Object)pf.getOperator());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testPreFixExpression() {
        JavaScriptUnit unit = this.parse("delete a;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            PrefixExpression pf = (PrefixExpression)((ExpressionStatement)astNode).getExpression();
            Assert.assertSame((Object)PrefixExpression.Operator.DELETE, (Object)pf.getOperator());
            SimpleName operand = (SimpleName)pf.getOperand();
            Assert.assertEquals((Object)"a", (Object)operand.getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testInfixExpression_0() {
        JavaScriptUnit unit = this.parse("d+7;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            InfixExpression pf = (InfixExpression)((ExpressionStatement)astNode).getExpression();
            Assert.assertSame((Object)InfixExpression.Operator.PLUS, (Object)pf.getOperator());
            SimpleName operand = (SimpleName)pf.getLeftOperand();
            Assert.assertEquals((Object)"d", (Object)operand.getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testInfixExpression_1() {
        JavaScriptUnit unit = this.parse("d && a;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            InfixExpression pf = (InfixExpression)((ExpressionStatement)astNode).getExpression();
            Assert.assertSame((Object)InfixExpression.Operator.CONDITIONAL_AND, (Object)pf.getOperator());
            SimpleName operand = (SimpleName)pf.getLeftOperand();
            Assert.assertEquals((Object)"d", (Object)operand.getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testArrayAccess() {
        JavaScriptUnit unit = this.parse("a[b];");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            Assert.assertTrue((boolean)(((ExpressionStatement)astNode).getExpression() instanceof ArrayAccess));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testFieldAccess() {
        JavaScriptUnit unit = this.parse("a.b;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            Assert.assertTrue((boolean)(((ExpressionStatement)astNode).getExpression() instanceof FieldAccess));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testConditionalExpression() {
        JavaScriptUnit unit = this.parse("a==1?b:c;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement anode = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(anode.getExpression() instanceof ConditionalExpression));
            ConditionalExpression conditional = (ConditionalExpression)anode.getExpression();
            Assert.assertTrue((boolean)(conditional.getExpression() instanceof InfixExpression));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testCallExpression() {
        JavaScriptUnit unit = this.parse("f();");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement anode = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(anode.getExpression() instanceof FunctionInvocation));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testListExpression() {
        JavaScriptUnit unit = this.parse("a,b.y,a[3];");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement anode = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(anode.getExpression() instanceof ListExpression));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testClassInstanceCreation() {
        JavaScriptUnit unit = this.parse("new ab(c,d);");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement anode = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(anode.getExpression() instanceof ClassInstanceCreation));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testFunctionExpression_withIdentifierPattern() {
        JavaScriptUnit unit = this.parse("f = function(a){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement anode = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(anode.getExpression() instanceof Assignment));
            Assignment assignment = (Assignment)anode.getExpression();
            Assert.assertTrue((boolean)(assignment.getRightHandSide() instanceof FunctionExpression));
            FunctionExpression fe = (FunctionExpression)assignment.getRightHandSide();
            Assert.assertFalse((boolean)fe.getMethod().parameters().isEmpty());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testGeneratorFunctionExpression() {
        JavaScriptUnit unit = this.parse("f = function* (a){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement anode = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(anode.getExpression() instanceof Assignment));
            Assignment assignment = (Assignment)anode.getExpression();
            Assert.assertTrue((boolean)(assignment.getRightHandSide() instanceof FunctionExpression));
            FunctionExpression fe = (FunctionExpression)assignment.getRightHandSide();
            Assert.assertTrue((boolean)fe.getMethod().isGenerator());
            Assert.assertFalse((boolean)fe.getMethod().parameters().isEmpty());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testFunctionExpression_withObjectPatternParameter() {
        JavaScriptUnit unit = this.parse("f= function({foo, bar: baz}){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement anode = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(anode.getExpression() instanceof Assignment));
            Assignment assignment = (Assignment)anode.getExpression();
            Assert.assertTrue((boolean)(assignment.getRightHandSide() instanceof FunctionExpression));
            FunctionExpression fe = (FunctionExpression)assignment.getRightHandSide();
            Assert.assertTrue((boolean)(fe.getMethod().parameters().get(0) instanceof SingleVariableDeclaration));
            SingleVariableDeclaration svd = (SingleVariableDeclaration)fe.getMethod().parameters().get(0);
            ObjectName on = (ObjectName)svd.getPattern();
            Assert.assertEquals((long)2L, (long)on.objectProperties().size());
            ObjectLiteralField olf = (ObjectLiteralField)on.objectProperties().get(0);
            Assert.assertEquals((Object)"foo", (Object)((SimpleName)olf.getFieldName()).getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testArrowFunctionExpression() {
        JavaScriptUnit unit = this.parse("foo = (bar) => 5+1;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement anode = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(anode.getExpression() instanceof Assignment));
            Assignment assignment = (Assignment)anode.getExpression();
            Assert.assertTrue((boolean)(assignment.getRightHandSide() instanceof ArrowFunctionExpression));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testBlockStatement() {
        JavaScriptUnit unit = this.parse("{a=2;};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 8) continue;
            Block anode = (Block)astNode;
            Assert.assertFalse((boolean)anode.statements().isEmpty());
            Assert.assertTrue((boolean)(anode.statements().get(0) instanceof ExpressionStatement));
            ExpressionStatement anotherNode = (ExpressionStatement)anode.statements().get(0);
            Assert.assertTrue((boolean)(anotherNode.getExpression() instanceof Assignment));
            Assignment assignment = (Assignment)anotherNode.getExpression();
            Assert.assertTrue((boolean)(assignment.getRightHandSide() instanceof NumberLiteral));
            Assert.assertTrue((boolean)(assignment.getLeftHandSide() instanceof SimpleName));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testYieldExpression() {
        JavaScriptUnit unit = this.parse("function* foo(){yield index++;}");
        Assert.assertNotNull((Object)unit);
        FunctionDeclaration func = (FunctionDeclaration)unit.statements().get(0);
        ExpressionStatement stmt = (ExpressionStatement)func.getBody().statements().get(0);
        Assert.assertEquals((long)93L, (long)stmt.getExpression().getNodeType());
        YieldExpression yieldE = (YieldExpression)stmt.getExpression();
        Assert.assertFalse((boolean)yieldE.getDelegate());
        Assert.assertNotNull((Object)yieldE.getArgument());
    }

    @Test
    public void testFunctionCallTolerantParsing() {
        JavaScriptUnit unit = this.parse("f(a function(){} c);");
        Assert.assertNotNull((Object)unit);
    }

    @Test
    public void testInvalidForIn() {
        JavaScriptUnit unit = this.parse("for (var i, i2 in {});");
        Assert.assertNotNull((Object)unit);
    }

    @Test
    public void testComplexRestInArrowFailure() {
        JavaScriptUnit unit = this.parse("(a,...[a]) => 0;");
        Assert.assertNotNull((Object)unit);
    }

    @Test
    public void testEmptyStatement() {
        JavaScriptUnit unit = this.parse("{;};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 8) continue;
            Block anode = (Block)astNode;
            Assert.assertFalse((boolean)anode.statements().isEmpty());
            Assert.assertTrue((boolean)(anode.statements().get(0) instanceof EmptyStatement));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testDebuggerStatement() {
        JavaScriptUnit unit = this.parse("{debugger;};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 8) continue;
            Block anode = (Block)astNode;
            Assert.assertFalse((boolean)anode.statements().isEmpty());
            Assert.assertTrue((boolean)(anode.statements().get(0) instanceof DebuggerStatement));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testWithStatement() {
        JavaScriptUnit unit = this.parse("with(console){log(\"test\");};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 90) continue;
            WithStatement anode = (WithStatement)astNode;
            Assert.assertTrue((boolean)(anode.getExpression() instanceof SimpleName));
            Assert.assertTrue((boolean)(anode.getBody() instanceof Block));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testReturnStatement() {
        JavaScriptUnit unit = this.parse("f= function(){return 0;};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement stmt = (ExpressionStatement)astNode;
            Assignment asgn = (Assignment)stmt.getExpression();
            FunctionExpression anode = (FunctionExpression)asgn.getRightHandSide();
            Assert.assertFalse((boolean)anode.getMethod().getBody().statements().isEmpty());
            Assert.assertTrue((boolean)(anode.getMethod().getBody().statements().get(0) instanceof ReturnStatement));
            ReturnStatement rs = (ReturnStatement)anode.getMethod().getBody().statements().get(0);
            Assert.assertTrue((boolean)(rs.getExpression() instanceof NumberLiteral));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testLabeledStatement() {
        JavaScriptUnit unit = this.parse("abc: a=7+1;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 30) continue;
            LabeledStatement ls = (LabeledStatement)astNode;
            Assert.assertEquals((Object)"abc", (Object)ls.getLabel().getIdentifier());
            Assert.assertTrue((boolean)(ls.getBody() instanceof ExpressionStatement));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testBreakStatement() {
        JavaScriptUnit unit = this.parse("while(e){break;};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 61) continue;
            WhileStatement ws = (WhileStatement)astNode;
            Assert.assertTrue((boolean)(ws.getExpression() instanceof SimpleName));
            SimpleName sn = (SimpleName)ws.getExpression();
            Assert.assertEquals((Object)"e", (Object)sn.getIdentifier());
            Assert.assertTrue((boolean)(ws.getBody() instanceof Block));
            Block b = (Block)ws.getBody();
            Assert.assertTrue((boolean)(b.statements().get(0) instanceof BreakStatement));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testContinueStatement() {
        JavaScriptUnit unit = this.parse("while(e){continue;};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 61) continue;
            WhileStatement ws = (WhileStatement)astNode;
            Assert.assertTrue((boolean)(ws.getExpression() instanceof SimpleName));
            SimpleName sn = (SimpleName)ws.getExpression();
            Assert.assertEquals((Object)"e", (Object)sn.getIdentifier());
            Assert.assertTrue((boolean)(ws.getBody() instanceof Block));
            Block b = (Block)ws.getBody();
            Assert.assertTrue((boolean)(b.statements().get(0) instanceof ContinueStatement));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testIfStatement() {
        JavaScriptUnit unit = this.parse("if(a){ab;}else ac;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 25) continue;
            IfStatement is = (IfStatement)astNode;
            Assert.assertTrue((boolean)(is.getExpression() instanceof SimpleName));
            SimpleName sn = (SimpleName)is.getExpression();
            Assert.assertEquals((Object)"a", (Object)sn.getIdentifier());
            Assert.assertTrue((boolean)(is.getThenStatement() instanceof Block));
            Assert.assertTrue((boolean)(is.getElseStatement() instanceof ExpressionStatement));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSwitchStatement() {
        JavaScriptUnit unit = this.parse("switch(a) {};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 50) continue;
            SwitchStatement ss = (SwitchStatement)astNode;
            Assert.assertTrue((boolean)(ss.getExpression() instanceof SimpleName));
            SimpleName sn = (SimpleName)ss.getExpression();
            Assert.assertEquals((Object)"a", (Object)sn.getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSwitchCaseStatement() {
        JavaScriptUnit unit = this.parse("switch(a) {case a:b;};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 50) continue;
            SwitchStatement ss = (SwitchStatement)astNode;
            Assert.assertFalse((boolean)ss.statements().isEmpty());
            Assert.assertTrue((boolean)(ss.statements().get(0) instanceof SwitchCase));
            SwitchCase sc = (SwitchCase)ss.statements().get(0);
            Assert.assertTrue((boolean)(sc.getExpression() instanceof SimpleName));
            Assert.assertTrue((boolean)(ss.statements().get(1) instanceof ExpressionStatement));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testNestedSwitchCaseStatement() {
        JavaScriptUnit unit = this.parse("switch(a) {case a: switch(b){case c: d;};};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 50) continue;
            SwitchStatement ss = (SwitchStatement)astNode;
            Assert.assertFalse((boolean)ss.statements().isEmpty());
            Assert.assertTrue((boolean)(ss.statements().get(0) instanceof SwitchCase));
            Assert.assertEquals(SwitchStatement.class, ss.statements().get(1).getClass());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testThrowStatement() {
        JavaScriptUnit unit = this.parse("throw d;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 53) continue;
            ThrowStatement ts = (ThrowStatement)astNode;
            Assert.assertTrue((boolean)(ts.getExpression() instanceof SimpleName));
            SimpleName sn = (SimpleName)ts.getExpression();
            Assert.assertEquals((Object)"d", (Object)sn.getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testTryCatchFinallyStatement() {
        JavaScriptUnit unit = this.parse("try{}catch(e){}finally{}");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 54) continue;
            TryStatement ts = (TryStatement)astNode;
            Assert.assertEquals((long)1L, (long)ts.catchClauses().size());
            CatchClause cc = (CatchClause)ts.catchClauses().get(0);
            Assert.assertEquals((Object)"e", (Object)cc.getException().getName().getIdentifier());
            Assert.assertNotNull((Object)ts.getFinally());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testTryCatchObjectPattern() {
        JavaScriptUnit unit = this.parse("try{}catch({a,b}){}");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 54) continue;
            TryStatement ts = (TryStatement)astNode;
            Assert.assertEquals((long)1L, (long)ts.catchClauses().size());
            CatchClause cc = (CatchClause)ts.catchClauses().get(0);
            Assert.assertNotNull((Object)cc.getException().getPattern());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testWhileStatement() {
        JavaScriptUnit unit = this.parse("while(e){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 61) continue;
            WhileStatement ws = (WhileStatement)astNode;
            Assert.assertTrue((boolean)(ws.getExpression() instanceof SimpleName));
            SimpleName sn = (SimpleName)ws.getExpression();
            Assert.assertEquals((Object)"e", (Object)sn.getIdentifier());
            Assert.assertTrue((boolean)(ws.getBody() instanceof Block));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testDoWhileStatement() {
        JavaScriptUnit unit = this.parse("do{}while(e);");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 19) continue;
            DoStatement ws = (DoStatement)astNode;
            Assert.assertTrue((boolean)(ws.getExpression() instanceof SimpleName));
            SimpleName sn = (SimpleName)ws.getExpression();
            Assert.assertEquals((Object)"e", (Object)sn.getIdentifier());
            Assert.assertTrue((boolean)(ws.getBody() instanceof Block));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testForStatement() {
        JavaScriptUnit unit = this.parse("for(let i=0;i<10;i++){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 24) continue;
            ForStatement fs = (ForStatement)astNode;
            Assert.assertTrue((boolean)(fs.getBody() instanceof Block));
            Assert.assertEquals((long)1L, (long)fs.initializers().size());
            Assert.assertEquals((long)1L, (long)fs.updaters().size());
            Assert.assertTrue((boolean)(fs.initializers().get(0) instanceof VariableDeclarationExpression));
            VariableDeclarationExpression vde = (VariableDeclarationExpression)fs.initializers().get(0);
            Assert.assertEquals((Object)VariableKind.LET, (Object)vde.getKind());
            Assert.assertNotNull((Object)fs.getExpression());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testForInStatement() {
        JavaScriptUnit unit = this.parse("for(let i in a){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 83) continue;
            ForInStatement fs = (ForInStatement)astNode;
            Assert.assertTrue((boolean)(fs.getBody() instanceof Block));
            Assert.assertTrue((boolean)(fs.getIterationVariable() instanceof VariableDeclarationExpression));
            VariableDeclarationExpression vde = (VariableDeclarationExpression)fs.getIterationVariable();
            Assert.assertEquals((Object)VariableKind.LET, (Object)vde.getKind());
            Assert.assertTrue((boolean)(fs.getCollection() instanceof SimpleName));
            SimpleName sn = (SimpleName)fs.getCollection();
            Assert.assertEquals((Object)"a", (Object)sn.getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testForInStatement_1() {
        JavaScriptUnit unit = this.parse("for(i in a){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 83) continue;
            ForInStatement fs = (ForInStatement)astNode;
            Assert.assertTrue((boolean)(fs.getIterationVariable() instanceof Expression));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testForOfStatement() {
        JavaScriptUnit unit = this.parse("for(let i of a){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 96) continue;
            ForOfStatement fs = (ForOfStatement)astNode;
            Assert.assertTrue((boolean)(fs.getBody() instanceof Block));
            Assert.assertTrue((boolean)(fs.getIterationVariable() instanceof VariableDeclarationExpression));
            VariableDeclarationExpression vde = (VariableDeclarationExpression)fs.getIterationVariable();
            Assert.assertEquals((Object)VariableKind.LET, (Object)vde.getKind());
            Assert.assertTrue((boolean)(fs.getCollection() instanceof SimpleName));
            SimpleName sn = (SimpleName)fs.getCollection();
            Assert.assertEquals((Object)"a", (Object)sn.getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testAnonymousFunction() {
        JavaScriptUnit unit = this.parse("f(function(){});");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement es = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(es.getExpression() instanceof FunctionInvocation));
            FunctionInvocation fi = (FunctionInvocation)es.getExpression();
            Assert.assertTrue((boolean)(fi.arguments().get(0) instanceof FunctionExpression));
            FunctionExpression func = (FunctionExpression)fi.arguments().get(0);
            Assert.assertNull((Object)func.getMethod().getName());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testFunctionExpression_andParameter() {
        JavaScriptUnit unit = this.parse("(function(y){});");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement es = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(es.getExpression() instanceof ParenthesizedExpression));
            ParenthesizedExpression pe = (ParenthesizedExpression)es.getExpression();
            FunctionExpression func = (FunctionExpression)pe.getExpression();
            Assert.assertFalse((boolean)func.getMethod().parameters().isEmpty());
            Assert.assertEquals((long)1L, (long)func.getMethod().parameters().size());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testRegularExpression() {
        JavaScriptUnit unit = this.parse("/.{0}/;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement es = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(es.getExpression() instanceof RegularExpressionLiteral));
            RegularExpressionLiteral rel = (RegularExpressionLiteral)es.getExpression();
            Assert.assertEquals((Object)"/.{0}/", (Object)rel.getRegularExpression());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testRegularExpression_2() {
        JavaScriptUnit unit = this.parse("/(^\\/)|(^#)|(^[\\d-\\u]*:)/;");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        Assert.assertFalse(((unit.getFlags() & 1) != 0 ? 1 : 0) != 0);
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement es = (ExpressionStatement)astNode;
            Assert.assertTrue((boolean)(es.getExpression() instanceof RegularExpressionLiteral));
            RegularExpressionLiteral rel = (RegularExpressionLiteral)es.getExpression();
            Assert.assertEquals((Object)"/(^\\/)|(^#)|(^[\\d-\\u]*:)/", (Object)rel.getRegularExpression());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testRegularExpressionWithES6flags() {
        JavaScriptUnit unit = this.parse("/\\u{00000001d306}/u");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement es = (ExpressionStatement)astNode;
            Assert.assertEquals((long)88L, (long)es.getExpression().getNodeType());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testClassDeclaration() {
        JavaScriptUnit unit = this.parse("class MyClass extends YourClass{}");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 56) continue;
            TypeDeclarationStatement tds = (TypeDeclarationStatement)astNode;
            TypeDeclaration td = (TypeDeclaration)tds.getDeclaration();
            Assert.assertEquals((Object)"MyClass", (Object)td.getName().getIdentifier());
            Assert.assertNotNull((Object)td.getSuperclass());
            Assert.assertEquals((Object)"YourClass", (Object)td.getSuperclass().getFullyQualifiedName());
            Assert.assertTrue((boolean)td.bodyDeclarations().isEmpty());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testMethodDefiniton() {
        JavaScriptUnit unit = this.parse("class MyClass extends YourClass{constructor(){};get test(){};static aStaticMethod(){var a=1;};}");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 56) continue;
            TypeDeclarationStatement td = (TypeDeclarationStatement)astNode;
            TypeDeclaration declaration = (TypeDeclaration)td.getDeclaration();
            Assert.assertEquals((Object)"MyClass", (Object)declaration.getName().getIdentifier());
            Assert.assertNotNull((Object)declaration.getSuperclass());
            Assert.assertEquals((Object)"YourClass", (Object)declaration.getSuperclass().getFullyQualifiedName());
            Assert.assertFalse((boolean)declaration.bodyDeclarations().isEmpty());
            Assert.assertEquals((long)3L, (long)declaration.bodyDeclarations().size());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSuper() {
        JavaScriptUnit unit = this.parse("class MyClass extends YourClass{constructor(){super();};}");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 56) continue;
            TypeDeclarationStatement tds = (TypeDeclarationStatement)astNode;
            TypeDeclaration td = (TypeDeclaration)tds.getDeclaration();
            Assert.assertEquals((Object)"MyClass", (Object)td.getName().getIdentifier());
            Assert.assertNotNull((Object)td.getSuperclass());
            Assert.assertEquals((Object)"YourClass", (Object)td.getSuperclass().getFullyQualifiedName());
            Assert.assertFalse((boolean)td.bodyDeclarations().isEmpty());
            int i = 0;
            while (i < td.bodyDeclarations().size()) {
                FunctionDeclaration fd = (FunctionDeclaration)td.bodyDeclarations().get(i);
                if (fd.isConstructor()) {
                    int j = 0;
                    while (j < fd.getBody().statements().size()) {
                        ExpressionStatement estmt;
                        ASTNode n = (ASTNode)fd.getBody().statements().get(i);
                        if (n.getNodeType() == 21 && (estmt = (ExpressionStatement)n).getExpression().getNodeType() == 32) {
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        Assert.fail();
    }

    @Test
    public void testRestElement() {
        JavaScriptUnit unit = this.parse("function foo (bar, ...rest) {}");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 31) continue;
            FunctionDeclaration fd = (FunctionDeclaration)astNode;
            Assert.assertFalse((boolean)fd.parameters().isEmpty());
            Assert.assertEquals((long)2L, (long)fd.parameters().size());
            SingleVariableDeclaration vd = (SingleVariableDeclaration)fd.parameters().get(1);
            Assert.assertTrue((boolean)(vd.getPattern() instanceof RestElementName));
            RestElementName ren = (RestElementName)vd.getPattern();
            Assert.assertEquals((Object)"rest", (Object)((SimpleName)ren.getArgument()).getIdentifier());
            Assert.assertEquals((Object)"...rest", (Object)ren.toString());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testArrayPattern() {
        JavaScriptUnit unit = this.parse("f = function([foo, bar]){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement es = (ExpressionStatement)astNode;
            Assignment assign = (Assignment)es.getExpression();
            FunctionExpression fe = (FunctionExpression)assign.getRightHandSide();
            Assert.assertFalse((boolean)fe.getMethod().parameters().isEmpty());
            Assert.assertTrue((boolean)(fe.getMethod().parameters().get(0) instanceof SingleVariableDeclaration));
            SingleVariableDeclaration sd = (SingleVariableDeclaration)fe.getMethod().parameters().get(0);
            Assert.assertTrue((sd.getPattern().getNodeType() == 97 ? 1 : 0) != 0);
            ArrayName arrayName = (ArrayName)sd.getPattern();
            Assert.assertEquals((long)2L, (long)arrayName.elements().size());
            Assert.assertEquals((Object)"foo", (Object)((SimpleName)arrayName.elements().get(0)).getIdentifier());
            Assert.assertEquals((Object)"bar", (Object)((SimpleName)arrayName.elements().get(1)).getIdentifier());
            Assert.assertEquals((Object)"[foo,bar]", (Object)arrayName.toString());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testObjectPattern() {
        JavaScriptUnit unit = this.parse("function f({ age, name }){};");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 31) continue;
            FunctionDeclaration fd = (FunctionDeclaration)astNode;
            Assert.assertEquals((long)1L, (long)fd.parameters().size());
            SingleVariableDeclaration svd = (SingleVariableDeclaration)fd.parameters().get(0);
            ObjectName on = (ObjectName)svd.getPattern();
            Assert.assertEquals((long)2L, (long)on.objectProperties().size());
            ObjectLiteralField field = (ObjectLiteralField)on.objectProperties().get(0);
            Assert.assertEquals((Object)"age", (Object)((SimpleName)field.getFieldName()).getIdentifier());
            field = (ObjectLiteralField)on.objectProperties().get(1);
            Assert.assertEquals((Object)"name", (Object)((SimpleName)field.getFieldName()).getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testTemplateLiteral() {
        JavaScriptUnit unit = this.parse("`this blog lives ${cheer} at ${host}`");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement es = (ExpressionStatement)astNode;
            Assert.assertEquals((long)99L, (long)es.getExpression().getNodeType());
            TemplateLiteral tl = (TemplateLiteral)es.getExpression();
            Assert.assertEquals((long)3L, (long)tl.elements().size());
            Assert.assertEquals((long)2L, (long)tl.expressions().size());
            Assert.assertNull((Object)tl.getTag());
            TemplateElement el = (TemplateElement)tl.elements().get(0);
            Assert.assertEquals((Object)"this blog lives ", (Object)el.getRawValue());
            Assert.assertFalse((boolean)el.isTail());
            el = (TemplateElement)tl.elements().get(2);
            Assert.assertTrue((boolean)el.isTail());
            SimpleName name = (SimpleName)tl.expressions().get(0);
            Assert.assertEquals((Object)"cheer", (Object)name.getIdentifier());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testTagTemplateLiteral() {
        JavaScriptUnit unit = this.parse("aTag`this blog lives ${cheer} at ${host}`");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement es = (ExpressionStatement)astNode;
            Assert.assertEquals((long)99L, (long)es.getExpression().getNodeType());
            TemplateLiteral tl = (TemplateLiteral)es.getExpression();
            Assert.assertEquals((long)3L, (long)tl.elements().size());
            Assert.assertEquals((long)2L, (long)tl.expressions().size());
            Assert.assertNotNull((Object)tl.getTag());
            SimpleName tag = (SimpleName)tl.getTag();
            Assert.assertEquals((Object)"aTag", (Object)tag.getIdentifier());
            TemplateElement el = (TemplateElement)tl.elements().get(0);
            Assert.assertEquals((Object)"this blog lives ", (Object)el.getRawValue());
            Assert.assertFalse((boolean)el.isTail());
            el = (TemplateElement)tl.elements().get(2);
            Assert.assertTrue((boolean)el.isTail());
            SimpleName name = (SimpleName)tl.expressions().get(0);
            Assert.assertEquals((Object)"cheer", (Object)name.getIdentifier());
            Assert.assertEquals((Object)"aTag`this blog lives ${cheer} at ${host}`", (Object)tl.toString());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSpreadElement() {
        JavaScriptUnit unit = this.parse("[...document.querySelectorAll('div')]");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        ExpressionStatement es = (ExpressionStatement)statements.get(0);
        Assert.assertEquals((long)4L, (long)es.getExpression().getNodeType());
        ArrayInitializer ari = (ArrayInitializer)es.getExpression();
        Assert.assertEquals((long)1L, (long)ari.expressions().size());
        Assert.assertTrue((boolean)(ari.expressions().get(0) instanceof SpreadElement));
        SpreadElement sel = (SpreadElement)ari.expressions().get(0);
        Assert.assertNotNull((Object)sel.getArgument());
        Assert.assertEquals((long)32L, (long)sel.getArgument().getNodeType());
    }

    @Test
    public void testFunctionDeclaration() {
        JavaScriptUnit unit = this.parse("function fName(){return;}");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        FunctionDeclaration fd = (FunctionDeclaration)statements.get(0);
        Assert.assertNotNull((Object)fd.getMethodName());
        Assert.assertEquals((Object)fd.getName(), (Object)fd.getMethodName());
        Assert.assertEquals((Object)"fName", (Object)((SimpleName)fd.getMethodName()).getIdentifier());
    }

    @Test
    public void testAbortingError() {
        JavaScriptUnit unit = this.parse("if(true){a =;};");
        Assert.assertNotNull((Object)unit);
        Assert.assertEquals((long)1L, (long)unit.getMessages().length);
    }

    @Test
    @Ignore
    public void testAbortingError_2() {
        JavaScriptUnit unit = this.parse("}");
        Assert.assertNotNull((Object)unit);
        Assert.assertEquals((long)1L, (long)unit.getMessages().length);
    }

    @Test
    public void testTolerantError() {
        JavaScriptUnit unit = this.parse(" function(){ ");
        Assert.assertNotNull((Object)unit);
        Assert.assertEquals((long)2L, (long)unit.getMessages().length);
    }

    @Test
    public void testObjectDeclare() {
        JavaScriptUnit unit = this.parse("var app = {\ninitialize: function() {\nthis.bindEvents();\n}};");
        Assert.assertFalse((boolean)unit.statements().isEmpty());
        VariableDeclarationStatement vd = (VariableDeclarationStatement)unit.statements().get(0);
        Assert.assertFalse((boolean)vd.fragments().isEmpty());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)vd.fragments().get(0);
        Assert.assertEquals(ObjectLiteral.class, fragment.getInitializer().getClass());
        ObjectLiteral objectLiteral = (ObjectLiteral)fragment.getInitializer();
        Assert.assertFalse((boolean)objectLiteral.fields().isEmpty());
        ObjectLiteralField field = (ObjectLiteralField)objectLiteral.fields().get(0);
        Assert.assertEquals((Object)"initialize", (Object)((SimpleName)field.getFieldName()).getIdentifier());
    }

    @Test
    public void testImport_1() {
        JavaScriptUnit unit = this.parse("import {foo} from 'lib';");
        Assert.assertFalse((boolean)unit.imports().isEmpty());
        ImportDeclaration importDeclaration = (ImportDeclaration)unit.imports().get(0);
        Assert.assertEquals((Object)"lib", (Object)importDeclaration.getSource().getLiteralValue());
        Assert.assertFalse((boolean)importDeclaration.specifiers().isEmpty());
        ModuleSpecifier specifier = (ModuleSpecifier)importDeclaration.specifiers().get(0);
        Assert.assertEquals((Object)"foo", (Object)specifier.getDiscoverableName().getIdentifier());
        Assert.assertNull((Object)specifier.getLocal());
        Assert.assertFalse((boolean)specifier.isDefault());
        Assert.assertFalse((boolean)specifier.isNamespace());
    }

    @Test
    public void testImport_2() {
        JavaScriptUnit unit = this.parse("import {foo as baz} from 'lib';");
        Assert.assertFalse((boolean)unit.imports().isEmpty());
        ImportDeclaration importDeclaration = (ImportDeclaration)unit.imports().get(0);
        Assert.assertEquals((Object)"lib", (Object)importDeclaration.getSource().getLiteralValue());
        Assert.assertFalse((boolean)importDeclaration.specifiers().isEmpty());
        ModuleSpecifier specifier = (ModuleSpecifier)importDeclaration.specifiers().get(0);
        Assert.assertEquals((Object)"baz", (Object)specifier.getLocal().getIdentifier());
        Assert.assertEquals((Object)"foo", (Object)specifier.getDiscoverableName().getIdentifier());
        Assert.assertFalse((boolean)specifier.isDefault());
        Assert.assertFalse((boolean)specifier.isNamespace());
    }

    @Test
    public void testImport_3() {
        JavaScriptUnit unit = this.parse("import foo from 'lib';");
        Assert.assertFalse((boolean)unit.imports().isEmpty());
        ImportDeclaration importDeclaration = (ImportDeclaration)unit.imports().get(0);
        Assert.assertEquals((Object)"lib", (Object)importDeclaration.getSource().getLiteralValue());
        Assert.assertFalse((boolean)importDeclaration.specifiers().isEmpty());
        ModuleSpecifier specifier = (ModuleSpecifier)importDeclaration.specifiers().get(0);
        Assert.assertEquals((Object)"foo", (Object)specifier.getLocal().getIdentifier());
        Assert.assertTrue((boolean)specifier.isDefault());
        Assert.assertFalse((boolean)specifier.isNamespace());
    }

    @Test
    public void testImport_4() {
        JavaScriptUnit unit = this.parse("import * as foo from 'lib';");
        Assert.assertFalse((boolean)unit.imports().isEmpty());
        ImportDeclaration importDeclaration = (ImportDeclaration)unit.imports().get(0);
        Assert.assertEquals((Object)"lib", (Object)importDeclaration.getSource().getLiteralValue());
        Assert.assertFalse((boolean)importDeclaration.specifiers().isEmpty());
        ModuleSpecifier specifier = (ModuleSpecifier)importDeclaration.specifiers().get(0);
        Assert.assertEquals((Object)"foo", (Object)specifier.getLocal().getIdentifier());
        Assert.assertFalse((boolean)specifier.isDefault());
        Assert.assertTrue((boolean)specifier.isNamespace());
    }

    @Test
    public void testExport_1() {
        JavaScriptUnit unit = this.parse("export {foo, bar};");
        Assert.assertFalse((boolean)unit.exports().isEmpty());
        ExportDeclaration export = (ExportDeclaration)unit.exports().get(0);
        Assert.assertEquals((long)2L, (long)export.specifiers().size());
        ModuleSpecifier specifier = (ModuleSpecifier)export.specifiers().get(0);
        Assert.assertEquals((Object)"foo", (Object)specifier.getLocal().getIdentifier());
    }

    @Test
    public void testExport_2() {
        JavaScriptUnit unit = this.parse("export {foo} from 'mod';");
        Assert.assertFalse((boolean)unit.exports().isEmpty());
        ExportDeclaration export = (ExportDeclaration)unit.exports().get(0);
        Assert.assertEquals((Object)"mod", (Object)export.getSource().getLiteralValue());
        Assert.assertEquals((long)1L, (long)export.specifiers().size());
        ModuleSpecifier specifier = (ModuleSpecifier)export.specifiers().get(0);
        Assert.assertEquals((Object)"foo", (Object)specifier.getLocal().getIdentifier());
    }

    @Test
    public void testExport_3() {
        JavaScriptUnit unit = this.parse("export var foo = 1;");
        Assert.assertFalse((boolean)unit.exports().isEmpty());
        ExportDeclaration export = (ExportDeclaration)unit.exports().get(0);
        Assert.assertNotNull((Object)export.getDeclaration());
    }

    @Test
    public void testExport_4() {
        JavaScriptUnit unit = this.parse("export default function () {}");
        Assert.assertFalse((boolean)unit.exports().isEmpty());
        ExportDeclaration export = (ExportDeclaration)unit.exports().get(0);
        Assert.assertNotNull((Object)export.getDeclaration());
        Assert.assertTrue((boolean)export.isDefault());
    }

    @Test
    public void testExport_5() {
        JavaScriptUnit unit = this.parse("export * from 'mod';");
        Assert.assertFalse((boolean)unit.exports().isEmpty());
        ExportDeclaration export = (ExportDeclaration)unit.exports().get(0);
        Assert.assertTrue((boolean)export.isAll());
    }

    @Test
    public void testExport_6() {
        JavaScriptUnit unit = this.parse("export function* agen(){}");
        Assert.assertFalse((boolean)unit.exports().isEmpty());
        ExportDeclaration export = (ExportDeclaration)unit.exports().get(0);
        Assert.assertNotNull((Object)export.getDeclaration());
        Assert.assertEquals((long)31L, (long)export.getDeclaration().getNodeType());
        FunctionDeclaration func = (FunctionDeclaration)export.getDeclaration();
        Assert.assertEquals((Object)"agen", (Object)func.getMethodName().toString());
        Assert.assertTrue((boolean)func.isGenerator());
    }

    @Test
    public void testExport_7() {
        JavaScriptUnit unit = this.parse("export default identifier");
        Assert.assertFalse((boolean)unit.exports().isEmpty());
        ExportDeclaration export = (ExportDeclaration)unit.exports().get(0);
        Assert.assertNotNull((Object)export.getDeclaration());
        Assert.assertTrue((boolean)export.isDefault());
    }

    @Test
    public void testComments() {
        JavaScriptUnit unit = this.parse("/**\n*Life, Universe, and Everything\n*/\nvar answer = 6 * 7;\n//asdfasf\nvar f =function(){\n//asdfasdfff\ntata}");
        List commentList = unit.getCommentList();
        Assert.assertNotNull((Object)commentList);
        Assert.assertEquals((long)3L, (long)commentList.size());
    }

    @Test
    public void testCommentAttachment() {
        JavaScriptUnit unit = this.parse("/** JavaDoc Comment*/\nfunction foo(i) {}");
        List commentList = unit.getCommentList();
        Assert.assertNotNull((Object)commentList);
        Assert.assertEquals((long)1L, (long)commentList.size());
        FunctionDeclaration fd = (FunctionDeclaration)unit.statements().get(0);
        Assert.assertNotNull((String)"JSDoc is NOT attached to function ", (Object)fd.getJavadoc());
    }

    @Test
    public void testCommentAttachment_2() {
        JavaScriptUnit unit = this.parse("/** JavaDoc Comment*/\nvar i;");
        List commentList = unit.getCommentList();
        Assert.assertNotNull((Object)commentList);
        Assert.assertEquals((long)1L, (long)commentList.size());
        VariableDeclarationStatement vd = (VariableDeclarationStatement)unit.statements().get(0);
        Assert.assertNotNull((String)"JSDoc is NOT attached to variable", (Object)vd.getJavadoc());
    }

    @Test
    public void testClassExpression() {
        JavaScriptUnit unit = this.parse("(class A extends 0{})");
        Assert.assertFalse((boolean)unit.statements().isEmpty());
        Assert.assertEquals((long)21L, (long)((ASTNode)unit.statements().get(0)).getNodeType());
        ExpressionStatement es = (ExpressionStatement)unit.statements().get(0);
        ParenthesizedExpression pe = (ParenthesizedExpression)es.getExpression();
        TypeDeclarationExpression dex = (TypeDeclarationExpression)pe.getExpression();
        TypeDeclaration td = (TypeDeclaration)dex.getDeclaration();
        Assert.assertEquals((Object)"A", (Object)td.getName().getIdentifier());
    }

    @Test
    public void tesArrayPatternAssignment() {
        JavaScriptUnit unit = this.parse("[...a[0]] = 0;");
        Assert.assertFalse((boolean)unit.statements().isEmpty());
        ExpressionStatement expressionStatement = (ExpressionStatement)unit.statements().get(0);
        Assert.assertEquals((long)7L, (long)expressionStatement.getExpression().getNodeType());
        Assignment assignment = (Assignment)expressionStatement.getExpression();
        Assert.assertEquals((long)97L, (long)assignment.getLeftHandSide().getNodeType());
        ArrayName arrayName = (ArrayName)assignment.getLeftHandSide();
        Assert.assertFalse((boolean)arrayName.elements().isEmpty());
        Assert.assertEquals((long)2L, (long)((ASTNode)arrayName.elements().get(0)).getNodeType());
        ArrayAccess access = (ArrayAccess)arrayName.elements().get(0);
        Assert.assertEquals((Object)"a", (Object)((SimpleName)access.getArray()).getIdentifier());
        Assert.assertEquals((Object)"0", (Object)((NumberLiteral)access.getIndex()).getToken());
    }

    @Test
    public void tesArrayPatternAssignment_2() {
        JavaScriptUnit unit = this.parse("[a,b=0,[c,...a[0]]={}]=0;");
        Assert.assertFalse((boolean)unit.statements().isEmpty());
        ExpressionStatement expressionStatement = (ExpressionStatement)unit.statements().get(0);
        Assert.assertEquals((long)7L, (long)expressionStatement.getExpression().getNodeType());
        Assignment assignment = (Assignment)expressionStatement.getExpression();
        Assert.assertEquals((long)97L, (long)assignment.getLeftHandSide().getNodeType());
        ArrayName arrayName = (ArrayName)assignment.getLeftHandSide();
        Assert.assertEquals((long)3L, (long)arrayName.elements().size());
    }

    @Test
    public void tesArrayPattern() {
        JavaScriptUnit unit = this.parse("for([a,b[a],{c,d=e,[f]:[g,h().a,(0).k,...i[0]]}] in 0);");
        Assert.assertFalse((boolean)unit.statements().isEmpty());
        ForInStatement forin = (ForInStatement)unit.statements().get(0);
        Assert.assertEquals((long)97L, (long)forin.getIterationVariable().getNodeType());
        ArrayName name = (ArrayName)forin.getIterationVariable();
        Assert.assertEquals((long)3L, (long)name.elements().size());
    }

    @Test
    public void testFunctionDeclarationStatement() {
        JavaScriptUnit unit = this.parse("if (foo) function a(){} else{}");
        Assert.assertFalse((boolean)unit.statements().isEmpty());
        Assert.assertEquals((long)25L, (long)((ASTNode)unit.statements().get(0)).getNodeType());
        IfStatement ifstmt = (IfStatement)unit.statements().get(0);
        Assert.assertEquals((long)109L, (long)ifstmt.getThenStatement().getNodeType());
    }

    @Test
    public void testFunctionDeclarationStatement_2() {
        JavaScriptUnit unit = this.parse("while (foo)function a(){}");
        Assert.assertFalse((boolean)unit.statements().isEmpty());
        Assert.assertEquals((long)61L, (long)((ASTNode)unit.statements().get(0)).getNodeType());
        WhileStatement wstmt = (WhileStatement)unit.statements().get(0);
        Assert.assertEquals((long)109L, (long)wstmt.getBody().getNodeType());
    }

    @Test
    public void testVariableDeclarationAsStatement() {
        JavaScriptUnit unit = this.parse("if (foo) var bar = 0; else{}");
        Assert.assertFalse((boolean)unit.statements().isEmpty());
        Assert.assertEquals((long)25L, (long)((ASTNode)unit.statements().get(0)).getNodeType());
        IfStatement ifstmt = (IfStatement)unit.statements().get(0);
        Assert.assertEquals((long)60L, (long)ifstmt.getThenStatement().getNodeType());
    }

    @Test
    public void testObjectLiteralWithFunctionDeclarationField() {
        JavaScriptUnit unit = this.parse("({ myFunction(){} });");
        Assert.assertNotNull((Object)unit);
        List statements = unit.statements();
        for (ASTNode astNode : statements) {
            if (astNode.getNodeType() != 21) continue;
            ExpressionStatement expression = (ExpressionStatement)astNode;
            Assert.assertEquals((long)36L, (long)expression.getExpression().getNodeType());
            ParenthesizedExpression parans = (ParenthesizedExpression)expression.getExpression();
            Assert.assertEquals((long)85L, (long)parans.getExpression().getNodeType());
            ObjectLiteral obj = (ObjectLiteral)parans.getExpression();
            Assert.assertEquals((long)1L, (long)obj.fields().size());
            ObjectLiteralField field = (ObjectLiteralField)obj.fields().get(0);
            Assert.assertEquals((long)84L, (long)field.getInitializer().getNodeType());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testInvalidObjectLiteral() {
        JavaScriptUnit unit = this.parse("({get[a,b]:0})");
        Assert.assertNotNull((Object)unit);
    }

    @Test
    public void testChainFunctionCall() {
        JavaScriptUnit unit = this.parse("browser \n.init({browserName: 'chrome'}) \n.get('http://angularjs.org/') \n// element method chaining \n.elementById('the-basics') \n.click()    // The 'click' call returns nothing, \n.click()    // So we can call it many times without loosing the element scope \n.click()    // ... \n.text()     // The element scope is preserved and this 'text' call works. \n.should.become('The Basics'); \n");
        Assert.assertNotNull((Object)unit);
        ExpressionStatement expression = (ExpressionStatement)unit.statements().get(0);
        Assert.assertSame((Object)32, (Object)expression.getExpression().getNodeType());
        FunctionInvocation fi = (FunctionInvocation)expression.getExpression();
        Assert.assertNotNull((Object)fi.getExpression());
        Assert.assertSame((Object)22, (Object)fi.getExpression().getNodeType());
        FieldAccess fa = (FieldAccess)fi.getExpression();
        Assert.assertNotNull((Object)fa.getName());
        Assert.assertEquals((Object)"become", (Object)fa.getName().getIdentifier());
    }

    @Test
    public void testParserRunner() {
        InputStream in = this.getClass().getResourceAsStream("es5.js");
        String content = this.readFile(in);
        Config config = ParserRunner.createConfig((boolean)true, (Config.LanguageMode)Config.LanguageMode.ECMASCRIPT6, null);
        SimpleSourceFile sf = new SimpleSourceFile("es2015-script.js", false);
        class TestErrorReporter
        implements ErrorReporter {
            TestErrorReporter() {
            }

            private void report(String message, String name, int line, int column) {
                System.out.println(String.valueOf(message) + " at " + name + " line: " + line + ":" + column);
            }

            public void warning(String message, String sourceName, int line, int lineOffset) {
                this.report("WARNING: " + message, sourceName, line, lineOffset);
            }

            public void error(String message, String sourceName, int line, int lineOffset) {
                this.report("ERROR: " + message, sourceName, line, lineOffset);
            }
        }
        ParserRunner.parse((StaticSourceFile)sf, (String)content, (Config)config, (ErrorReporter)new TestErrorReporter());
    }

    @Test
    public void testTestBuilderJS() {
        JavaScriptUnit unit = this.loadParseJs("TestBuilder.js");
        Assert.assertNotNull((Object)unit);
    }

    @Test
    public void testEverythingJS_es5() {
        this.loadParseJs("es5.js");
    }

    @Test
    @Ignore
    public void testEverythingJS_es2015_script() {
        this.loadParseJs("es2015-script.js");
    }

    @Test
    @Ignore
    public void testEverythingJS_es2015_module() {
        this.loadParseJs("es2015-module.js");
    }

    private JavaScriptUnit parse(String content) {
        return ClosureCompiler.newInstance().toggleComments(true).setSource(content).parse();
    }

    private JavaScriptUnit loadParseJs(String file) {
        InputStream in = this.getClass().getResourceAsStream(file);
        JavaScriptUnit unit = ClosureCompiler.newInstance().toggleComments(true).setSource(this.readFile(in)).parse();
        Assert.assertNotNull((Object)unit);
        Assert.assertFalse((boolean)unit.statements().isEmpty());
        return unit;
    }

    private String readFile(InputStream input) {
        StringBuilder sb;
        block15: {
            BufferedReader br = null;
            sb = new StringBuilder();
            try {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

