/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.zip.ZipFile;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.osgi.framework.Bundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSFTestUtil {
    private static boolean _enableTrace = false;
    private static IJobChangeListener javaScriptJobChangeListener;

    public static void setEnableTrace(boolean enableTrace) {
        _enableTrace = enableTrace;
    }

    public static void setValidationEnabled(boolean isEnabled) throws InvocationTargetException {
        GlobalConfiguration config = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration());
        config.setDisableAllValidation(!isEnabled);
        config.passivate();
        config.store();
        ValidationFramework.getDefault().suspendAllValidation(!isEnabled);
    }

    public static void setInternetProxyPreferences(boolean proxied, String proxyHostName, String proxyPort) {
    }

    public static void loadSourceClass(Bundle bundle, String fileName, String beanClassName, String srcFolderName, String packageName, JDTTestEnvironment jdtTestEnvironment) throws Exception {
        TestFileResource codeRes = new TestFileResource();
        codeRes.load(bundle, fileName);
        String code = codeRes.toString();
        jdtTestEnvironment.addSourceFile(srcFolderName, packageName, beanClassName, code);
    }

    public static ZipFile createZipFile(Bundle bundle, String entryName) throws IOException, URISyntaxException {
        return new ZipFile(new File(JSFTestUtil.getAbsolutePath(bundle, entryName).toOSString()));
    }

    public static URI getPlatformAbsPath(String relativePath) throws MalformedURLException, URISyntaxException {
        File file = new File(String.valueOf(Platform.getInstanceLocation().getURL().getFile()) + File.separator + relativePath);
        return file.toURI();
    }

    public static IPath getAbsolutePath(Bundle bundle, String relativePath) throws IOException, URISyntaxException {
        URL bundleUrl = bundle.getEntry(relativePath);
        Assert.assertNotNull((Object)bundleUrl);
        URL url = FileLocator.resolve((URL)bundleUrl);
        return new Path(new File(url.getFile()).getAbsolutePath());
    }

    public static void savePlatformRelative(TestFileResource testFile, String relativePath) throws IOException, URISyntaxException {
        JSFTestUtil.saveToFileSystem(testFile, JSFTestUtil.getPlatformAbsPath(relativePath));
    }

    public static void saveToFileSystem(TestFileResource testFile, URI absPath) throws IOException {
        JSFTestUtil.saveToFileSystem(testFile.toBytes(), absPath);
    }

    public static void saveToFileSystem(byte[] buffer, URI absPath) throws IOException {
        File file = new File(absPath);
        FileOutputStream outFile = null;
        try {
            outFile = new FileOutputStream(file);
            outFile.write(buffer);
        }
        finally {
            if (outFile != null) {
                outFile.close();
            }
        }
    }

    public static void saveToFileSystem(InputStream inStream, URI absPath) throws IOException {
        ByteArrayOutputStream loadFromInputStream = JSFTestUtil.loadFromInputStream(inStream);
        JSFTestUtil.saveToFileSystem(loadFromInputStream.toByteArray(), absPath);
    }

    public static boolean areEqual(TestFileResource testFile, URI absPath) throws IOException {
        File file = new File(absPath);
        return Arrays.equals(JSFTestUtil.loadFromFile(file).toByteArray(), testFile.toBytes());
    }

    public static ByteArrayOutputStream loadFromFile(IFile file) throws IOException {
        InputStream inStream = null;
        try {
            inStream = file.getContents();
            ByteArrayOutputStream byteArrayOutputStream = JSFTestUtil.loadFromInputStream(inStream);
            return byteArrayOutputStream;
        }
        catch (CoreException coreException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            return byteArrayOutputStream;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public static ByteArrayOutputStream loadFromFile(File file) throws IOException {
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = JSFTestUtil.loadFromInputStream(inFile);
            return byteArrayOutputStream;
        }
        finally {
            if (inFile != null) {
                inFile.close();
            }
        }
    }

    public static ByteArrayOutputStream loadFromInputStream(InputStream stream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] inBuffer = new byte[1024];
        while ((bytesRead = stream.read(inBuffer)) != -1) {
            buffer.write(inBuffer, 0, bytesRead);
        }
        return buffer;
    }

    public static IndexedRegion getIndexedRegion(IStructuredDocument document, int documentOffset) {
        IndexedRegion region;
        block8: {
            IStructuredModel model = JSFTestUtil.getStructuredModel(document);
            region = null;
            if (model != null) {
                try {
                    int lastOffset = documentOffset;
                    region = model.getIndexedRegion(documentOffset);
                    JSFTestUtil.trace("Starting at region: " + region.toString());
                    while (region == null && lastOffset >= 0) {
                        region = model.getIndexedRegion(--lastOffset);
                        JSFTestUtil.trace("Iterating on region: " + region.toString());
                    }
                    JSFTestUtil.trace("Finished with: " + region.toString() + ", Class: " + region.getClass());
                    if (!(region instanceof IDOMElement)) break block8;
                    JSFTestUtil.trace("Region is an IDOMElement");
                    IDOMElement domElement = (IDOMElement)region;
                    NamedNodeMap attributes = domElement.getAttributes();
                    int i = 0;
                    while (i < attributes.getLength()) {
                        Node attrNode = attributes.item(i);
                        if (attrNode instanceof IDOMAttr) {
                            IDOMAttr attr = (IDOMAttr)attrNode;
                            JSFTestUtil.trace("Examining attribute: " + attr.toString());
                            if (documentOffset >= attr.getStartOffset() && documentOffset < attr.getEndOffset()) {
                                region = attr;
                                JSFTestUtil.trace("Found attribute: " + region.toString());
                                break;
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    JSFTestUtil.trace("releasing model");
                    model.releaseFromRead();
                }
            }
        }
        JSFTestUtil.trace("returning: " + region);
        return region;
    }

    private static void trace(String message) {
        if (_enableTrace) {
            System.out.println("getIndexedRegion: " + message);
        }
    }

    private static IStructuredModel getStructuredModel(IStructuredDocument document) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager != null) {
            return StructuredModelManager.getModelManager().getModelForRead(document);
        }
        return null;
    }

    public static boolean safeDelete(IResource resource, int maxTries, int backOffInMs) {
        boolean success = false;
        int attempt = 0;
        while (attempt < maxTries) {
            try {
                resource.delete(true, null);
                success = true;
                break;
            }
            catch (CoreException coreException) {
                try {
                    Thread.sleep(backOffInMs);
                }
                catch (InterruptedException interruptedException) {}
                ++attempt;
            }
        }
        if (!success) {
            System.err.println("Could not delete resource: " + resource.getLocation().toOSString());
        }
        return success;
    }

    public static void preventJavaScriptJobs() {
        if (javaScriptJobChangeListener == null) {
            javaScriptJobChangeListener = new JobChangeAdapter(){

                public void scheduled(IJobChangeEvent event) {
                    String jobName;
                    Job job = event.getJob();
                    if (job != null && (jobName = job.getName()) != null && jobName.length() > 0 && jobName.toUpperCase().contains("JAVASCRIPT")) {
                        job.cancel();
                    }
                }
            };
        }
        Job.getJobManager().addJobChangeListener(javaScriptJobChangeListener);
    }

    public static void allowJavaScriptJobs() {
        if (javaScriptJobChangeListener != null) {
            Job.getJobManager().removeJobChangeListener(javaScriptJobChangeListener);
        }
    }

    public static Class<? extends TestCase> getPreventJavaScriptJobsTestCase() {
        return PreventJavaScriptJobsTestCase.class;
    }

    public static Class<? extends TestCase> getAllowJavaScriptJobsTestCase() {
        return AllowJavaScriptJobsTestCase.class;
    }

    private JSFTestUtil() {
    }

    public static class AllowJavaScriptJobsTestCase
    extends TestCase {
        public void testAllowJavaScriptJobs() throws Exception {
            JSFTestUtil.allowJavaScriptJobs();
        }
    }

    public static class PreventJavaScriptJobsTestCase
    extends TestCase {
        public void testPreventJavaScriptJobs() throws Exception {
            JSFTestUtil.preventJavaScriptJobs();
        }
    }
}

