/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.deque.ArrayDeque;
import org.eclipse.jpt.common.utility.internal.deque.DequeTools;
import org.eclipse.jpt.common.utility.internal.deque.LinkedDeque;
import org.eclipse.jpt.common.utility.internal.deque.SynchronizedDeque;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.deque.DequeTests;
import org.eclipse.jpt.common.utility.tests.internal.deque.DequeToolsTests;

public class SynchronizedDequeTests
extends DequeTests {
    private volatile SynchronizedDeque<String> syncDeque;
    volatile boolean timeoutOccurred;
    volatile long startTime;
    volatile long endTime;
    volatile Object dequeueHeadObject;
    volatile Object dequeueTailObject;
    boolean commandExecuted;
    static final String ITEM_1 = new String();
    static final String ITEM_2 = new String();

    public SynchronizedDequeTests(String name) {
        super(name);
    }

    @Override
    Deque<String> buildDeque() {
        return DequeTools.synchronizedDeque();
    }

    @Override
    public void testClone() {
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.syncDeque = DequeTools.synchronizedDeque();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.dequeueHeadObject = null;
    }

    public void testConstructorDeque() throws Exception {
        ArrayDeque innerDeque = DequeTools.arrayDeque();
        SynchronizedDeque stack = DequeTools.synchronizedDeque((Deque)innerDeque);
        SynchronizedDequeTests.assertNotNull((Object)stack);
        SynchronizedDequeTests.assertSame((Object)stack, (Object)stack.getMutex());
    }

    public void testConstructorDeque_NPE() throws Exception {
        boolean exCaught = false;
        try {
            SynchronizedDeque stack = DequeTools.synchronizedDeque(null);
            SynchronizedDequeTests.fail((String)("bogus stack: " + stack));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedDequeTests.assertTrue((boolean)exCaught);
    }

    public void testConstructorDequeObject() throws Exception {
        String mutex = "mutex";
        ArrayDeque innerDeque = DequeTools.arrayDeque();
        SynchronizedDeque stack = DequeTools.synchronizedDeque((Deque)innerDeque, (Object)mutex);
        SynchronizedDequeTests.assertNotNull((Object)stack);
        SynchronizedDequeTests.assertSame((Object)mutex, (Object)stack.getMutex());
    }

    public void testConstructorDequeObject_NPE1() throws Exception {
        String mutex = "mutex";
        boolean exCaught = false;
        try {
            SynchronizedDeque stack = DequeTools.synchronizedDeque(null, (Object)mutex);
            SynchronizedDequeTests.fail((String)("bogus stack: " + stack));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedDequeTests.assertTrue((boolean)exCaught);
    }

    public void testConstructorDequeObject_NPE2() throws Exception {
        ArrayDeque innerDeque = DequeTools.arrayDeque();
        boolean exCaught = false;
        try {
            SynchronizedDeque stack = DequeTools.synchronizedDeque((Deque)innerDeque, null);
            SynchronizedDequeTests.fail((String)("bogus stack: " + stack));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedDequeTests.assertTrue((boolean)exCaught);
    }

    public void testConcurrentDequeueHead() throws Exception {
        this.verifyConcurrentDequeueHead(new SlowLinkedDeque<String>(), "first");
        this.verifyConcurrentDequeueHead(new SlowSynchronizedDeque<String>(), "second");
    }

    private void verifyConcurrentDequeueHead(SlowDeque<String> slowDeque, String expected) throws Exception {
        slowDeque.enqueueTail("first");
        slowDeque.enqueueTail("second");
        Thread thread = this.buildThread(this.buildRunnableDequeueHead(slowDeque));
        thread.start();
        Thread.sleep(TWO_TICKS);
        SynchronizedDequeTests.assertEquals((String)expected, (String)((String)slowDeque.dequeueHead()));
        thread.join();
        SynchronizedDequeTests.assertTrue((boolean)slowDeque.isEmpty());
    }

    private Runnable buildRunnableDequeueHead(final SlowDeque<String> slowDeque) {
        return new Runnable(){

            @Override
            public void run() {
                slowDeque.slowDequeueHead();
            }
        };
    }

    public void testConcurrentDequeueTail() throws Exception {
        this.verifyConcurrentDequeueTail(new SlowLinkedDeque<String>(), "first");
        this.verifyConcurrentDequeueTail(new SlowSynchronizedDeque<String>(), "second");
    }

    private void verifyConcurrentDequeueTail(SlowDeque<String> slowDeque, String expected) throws Exception {
        slowDeque.enqueueHead("first");
        slowDeque.enqueueHead("second");
        Thread thread = this.buildThread(this.buildRunnableDequeueTail(slowDeque));
        thread.start();
        Thread.sleep(TWO_TICKS);
        SynchronizedDequeTests.assertEquals((String)expected, (String)((String)slowDeque.dequeueTail()));
        thread.join();
        SynchronizedDequeTests.assertTrue((boolean)slowDeque.isEmpty());
    }

    private Runnable buildRunnableDequeueTail(final SlowDeque<String> slowDeque) {
        return new Runnable(){

            @Override
            public void run() {
                slowDeque.slowDequeueTail();
            }
        };
    }

    public void testConcurrentEnqueueTail() throws Exception {
        this.verifyConcurrentEnqueueTail(new SlowLinkedDeque<String>(), "second", "first");
        this.verifyConcurrentEnqueueTail(new SlowSynchronizedDeque<String>(), "first", "second");
    }

    private void verifyConcurrentEnqueueTail(SlowDeque<String> slowDeque, String first, String second) throws Exception {
        Thread thread = this.buildThread(this.buildRunnableEnqueueTail(slowDeque, "first"));
        thread.start();
        Thread.sleep(TWO_TICKS);
        slowDeque.enqueueTail("second");
        thread.join();
        SynchronizedDequeTests.assertEquals((String)first, (String)((String)slowDeque.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)second, (String)((String)slowDeque.dequeueHead()));
        SynchronizedDequeTests.assertTrue((boolean)slowDeque.isEmpty());
    }

    private Runnable buildRunnableEnqueueTail(final SlowDeque<String> slowDeque, final String element) {
        return new Runnable(){

            @Override
            public void run() {
                slowDeque.slowEnqueueTail(element);
            }
        };
    }

    public void testConcurrentEnqueueHead() throws Exception {
        this.verifyConcurrentEnqueueHead(new SlowLinkedDeque<String>(), "second", "first");
        this.verifyConcurrentEnqueueHead(new SlowSynchronizedDeque<String>(), "first", "second");
    }

    private void verifyConcurrentEnqueueHead(SlowDeque<String> slowDeque, String first, String second) throws Exception {
        Thread thread = this.buildThread(this.buildRunnableEnqueueHead(slowDeque, "first"));
        thread.start();
        Thread.sleep(TWO_TICKS);
        slowDeque.enqueueHead("second");
        thread.join();
        SynchronizedDequeTests.assertEquals((String)first, (String)((String)slowDeque.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)second, (String)((String)slowDeque.dequeueTail()));
        SynchronizedDequeTests.assertTrue((boolean)slowDeque.isEmpty());
    }

    private Runnable buildRunnableEnqueueHead(final SlowDeque<String> slowDeque, final String element) {
        return new Runnable(){

            @Override
            public void run() {
                slowDeque.slowEnqueueHead(element);
            }
        };
    }

    public void testConcurrentIsEmpty() throws Exception {
        this.verifyConcurrentIsEmpty(new SlowLinkedDeque<String>(), true);
        this.verifyConcurrentIsEmpty(new SlowSynchronizedDeque<String>(), false);
    }

    private void verifyConcurrentIsEmpty(SlowDeque<String> slowDeque, boolean empty) throws Exception {
        Thread thread = this.buildThread(this.buildRunnableEnqueueTail(slowDeque, "first"));
        thread.start();
        Thread.sleep(TWO_TICKS);
        SynchronizedDequeTests.assertEquals((boolean)empty, (boolean)slowDeque.isEmpty());
        thread.join();
        SynchronizedDequeTests.assertEquals((String)"first", (String)((String)slowDeque.dequeueHead()));
        SynchronizedDequeTests.assertTrue((boolean)slowDeque.isEmpty());
    }

    public void testWaitUntilEmpty() throws Exception {
        this.verifyWaitUntilEmpty(-1L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilEmpty2() throws Exception {
        this.verifyWaitUntilEmpty(0L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilEmptyTimeout() throws Exception {
        this.verifyWaitUntilEmpty(TICK);
        SynchronizedDequeTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilEmpty(long timeout) throws Exception {
        this.syncDeque.enqueueTail((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildDequeueHeadCommand(), this.syncDeque, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitUntilEmptyCommand(timeout), this.syncDeque, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitUntilEmptyCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                SynchronizedDequeTests.this.startTime = System.currentTimeMillis();
                SynchronizedDequeTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedDeque);
                SynchronizedDequeTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedDeque.waitUntilEmpty();
                    return false;
                }
                return !synchronizedDeque.waitUntilEmpty(timeout);
            }
        };
    }

    public void testWaitUntilNotEmpty() throws Exception {
        this.verifyWaitUntilNotEmpty(-1L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.syncDeque.peekHead());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilNotEmpty2() throws Exception {
        this.verifyWaitUntilNotEmpty(0L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.syncDeque.peekHead());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilNotEmptyTimeout() throws Exception {
        this.verifyWaitUntilNotEmpty(TICK);
        SynchronizedDequeTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.syncDeque.peekHead());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilNotEmpty(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildEnqueueTailCommand(), this.syncDeque, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitUntilNotEmptyCommand(timeout), this.syncDeque, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitUntilNotEmptyCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                SynchronizedDequeTests.this.startTime = System.currentTimeMillis();
                SynchronizedDequeTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedDeque);
                SynchronizedDequeTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedDeque.waitUntilNotEmpty();
                    return false;
                }
                return !synchronizedDeque.waitUntilNotEmpty(timeout);
            }
        };
    }

    public void testWaitToDequeueHead() throws Exception {
        this.verifyWaitToDequeueHead(-1L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToDequeueHead2() throws Exception {
        this.verifyWaitToDequeueHead(0L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToDequeueHeadTimeout() throws Exception {
        this.verifyWaitToDequeueHead(TICK);
        SynchronizedDequeTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertNull((Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.syncDeque.peekHead());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToDequeueHead(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildEnqueueTailCommand(), this.syncDeque, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToDequeueHeadCommand(timeout), this.syncDeque, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitToDequeueHeadCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                SynchronizedDequeTests.this.startTime = System.currentTimeMillis();
                this.waitToDequeueHead(synchronizedDeque);
                SynchronizedDequeTests.this.endTime = System.currentTimeMillis();
            }

            private void waitToDequeueHead(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                if (timeout < 0L) {
                    SynchronizedDequeTests.this.dequeueHeadObject = synchronizedDeque.waitToDequeueHead();
                    return;
                }
                try {
                    SynchronizedDequeTests.this.dequeueHeadObject = synchronizedDeque.waitToDequeueHead(timeout);
                }
                catch (NoSuchElementException noSuchElementException) {
                    SynchronizedDequeTests.this.timeoutOccurred = true;
                }
            }
        };
    }

    public void testWaitToDequeueTail() throws Exception {
        this.verifyWaitToDequeueTail(-1L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueTailObject);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToDequeueTail2() throws Exception {
        this.verifyWaitToDequeueTail(0L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueTailObject);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToDequeueTailTimeout() throws Exception {
        this.verifyWaitToDequeueTail(TICK);
        SynchronizedDequeTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertNull((Object)this.dequeueTailObject);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.syncDeque.peekTail());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToDequeueTail(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildEnqueueHeadCommand(), this.syncDeque, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToDequeueTailCommand(timeout), this.syncDeque, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitToDequeueTailCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                SynchronizedDequeTests.this.startTime = System.currentTimeMillis();
                this.waitToDequeueTail(synchronizedDeque);
                SynchronizedDequeTests.this.endTime = System.currentTimeMillis();
            }

            private void waitToDequeueTail(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                if (timeout < 0L) {
                    SynchronizedDequeTests.this.dequeueTailObject = synchronizedDeque.waitToDequeueTail();
                    return;
                }
                try {
                    SynchronizedDequeTests.this.dequeueTailObject = synchronizedDeque.waitToDequeueTail(timeout);
                }
                catch (NoSuchElementException noSuchElementException) {
                    SynchronizedDequeTests.this.timeoutOccurred = true;
                }
            }
        };
    }

    public void testWaitToEnqueueTail() throws Exception {
        this.verifyWaitToEnqueueTail(-1L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertSame((Object)ITEM_2, (Object)this.syncDeque.peekHead());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToEnqueueTail2() throws Exception {
        this.verifyWaitToEnqueueTail(0L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertSame((Object)ITEM_2, (Object)this.syncDeque.peekHead());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToEnqueueTailTimeout() throws Exception {
        this.verifyWaitToEnqueueTail(TICK);
        SynchronizedDequeTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToEnqueueTail(long timeout) throws Exception {
        this.syncDeque.enqueueTail((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildDequeueHeadCommand(), this.syncDeque, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToEnqueueTailCommand(timeout), this.syncDeque, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitToEnqueueTailCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                SynchronizedDequeTests.this.startTime = System.currentTimeMillis();
                SynchronizedDequeTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedDeque);
                SynchronizedDequeTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedDeque.waitToEnqueueTail((Object)ITEM_2);
                    return false;
                }
                return !synchronizedDeque.waitToEnqueueTail((Object)ITEM_2, timeout);
            }
        };
    }

    public void testWaitToEnqueueHead() throws Exception {
        this.verifyWaitToEnqueueHead(-1L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertSame((Object)ITEM_2, (Object)this.syncDeque.peekHead());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToEnqueueHead2() throws Exception {
        this.verifyWaitToEnqueueHead(0L);
        SynchronizedDequeTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertSame((Object)ITEM_2, (Object)this.syncDeque.peekHead());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToEnqueueHeadTimeout() throws Exception {
        this.verifyWaitToEnqueueHead(TICK);
        SynchronizedDequeTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedDequeTests.assertSame((Object)ITEM_1, (Object)this.dequeueHeadObject);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToEnqueueHead(long timeout) throws Exception {
        this.syncDeque.enqueueHead((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildDequeueHeadCommand(), this.syncDeque, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToEnqueueHeadCommand(timeout), this.syncDeque, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitToEnqueueHeadCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                SynchronizedDequeTests.this.startTime = System.currentTimeMillis();
                SynchronizedDequeTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedDeque);
                SynchronizedDequeTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedDeque<String> synchronizedDeque) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedDeque.waitToEnqueueHead((Object)ITEM_2);
                    return false;
                }
                return !synchronizedDeque.waitToEnqueueHead((Object)ITEM_2, timeout);
            }
        };
    }

    private Command buildEnqueueTailCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedDeque<String> synchronizedDeque) {
                synchronizedDeque.enqueueTail((Object)ITEM_1);
            }
        };
    }

    private Command buildEnqueueHeadCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedDeque<String> synchronizedDeque) {
                synchronizedDeque.enqueueHead((Object)ITEM_1);
            }
        };
    }

    private Command buildDequeueHeadCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedDeque<String> synchronizedDeque) {
                SynchronizedDequeTests.this.dequeueHeadObject = synchronizedDeque.dequeueHead();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedDeque<String> synchronizedDeque, final long sleep) {
        return new MultiThreadedTestCase.TestRunnable(this){

            @Override
            protected void run_() throws Throwable {
                if (sleep != 0L) {
                    Thread.sleep(sleep);
                }
                command.execute((SynchronizedDeque<String>)synchronizedDeque);
            }
        };
    }

    long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    public void testExecute() throws Exception {
        org.eclipse.jpt.common.utility.command.Command command = new org.eclipse.jpt.common.utility.command.Command(){

            public void execute() {
                SynchronizedDequeTests.this.commandExecuted = true;
            }
        };
        this.commandExecuted = false;
        this.syncDeque.execute(command);
        SynchronizedDequeTests.assertTrue((boolean)this.commandExecuted);
    }

    public void testEnqueueTailAllIterable() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        this.syncDeque.enqueueTailAll(list);
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueTailAllIterable_empty() throws Exception {
        ArrayList list = new ArrayList();
        this.syncDeque.enqueueTailAll(list);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueTailAllObjectArray() throws Exception {
        this.syncDeque.enqueueTailAll((Object[])new String[]{"one", "two", "three"});
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueTailAllObjectArray_empty() throws Exception {
        this.syncDeque.enqueueTailAll((Object[])new String[0]);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueTailAllStack() throws Exception {
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"one");
        stack.push((Object)"two");
        stack.push((Object)"three");
        this.syncDeque.enqueueTailAll((Stack)stack);
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueTailAllStack_empty() throws Exception {
        ArrayStack stack = StackTools.arrayStack();
        this.syncDeque.enqueueTailAll((Stack)stack);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueTailAllDeque() throws Exception {
        ArrayDeque queue = DequeTools.arrayDeque();
        queue.enqueueTail((Object)"one");
        queue.enqueueTail((Object)"two");
        queue.enqueueTail((Object)"three");
        this.syncDeque.enqueueTailAll((Deque)queue);
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)this.syncDeque.dequeueHead()));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueTailAllDeque_empty() throws Exception {
        ArrayDeque queue = DequeTools.arrayDeque();
        this.syncDeque.enqueueTailAll((Deque)queue);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testDrainHead() throws Exception {
        this.syncDeque.enqueueTail((Object)"one");
        this.syncDeque.enqueueTail((Object)"two");
        this.syncDeque.enqueueTail((Object)"three");
        ArrayList list = this.syncDeque.drainHead();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainHead_empty() throws Exception {
        ArrayList list = this.syncDeque.drainHead();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((boolean)list.isEmpty());
    }

    public void testDrainHeadToCollection() throws Exception {
        this.syncDeque.enqueueTail((Object)"one");
        this.syncDeque.enqueueTail((Object)"two");
        this.syncDeque.enqueueTail((Object)"three");
        ArrayList list = new ArrayList();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainHeadTo(list));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainHeadToCollection_empty() throws Exception {
        ArrayList list = new ArrayList();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainHeadTo(list));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((boolean)list.isEmpty());
    }

    public void testDrainHeadToListInt() throws Exception {
        this.syncDeque.enqueueTail((Object)"one");
        this.syncDeque.enqueueTail((Object)"two");
        this.syncDeque.enqueueTail((Object)"three");
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainHeadTo(list, 2));
        SynchronizedDequeTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)list.get(2)));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)list.get(3)));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)list.get(4)));
        SynchronizedDequeTests.assertEquals((String)"ccc", (String)((String)list.get(5)));
    }

    public void testDrainHeadToListInt_end() throws Exception {
        this.syncDeque.enqueueTail((Object)"one");
        this.syncDeque.enqueueTail((Object)"two");
        this.syncDeque.enqueueTail((Object)"three");
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainHeadTo(list, 3));
        SynchronizedDequeTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)list.get(3)));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)list.get(4)));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)list.get(5)));
    }

    public void testDrainHeadToListInt_empty() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainHeadTo(list, 2));
        SynchronizedDequeTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
    }

    public void testDrainHeadToStack() throws Exception {
        this.syncDeque.enqueueTail((Object)"one");
        this.syncDeque.enqueueTail((Object)"two");
        this.syncDeque.enqueueTail((Object)"three");
        ArrayStack stack = StackTools.arrayStack();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainHeadTo((Stack)stack));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)stack.pop()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)stack.pop()));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)stack.pop()));
        SynchronizedDequeTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testDrainHeadToStack_empty() throws Exception {
        ArrayStack stack = StackTools.arrayStack();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainHeadTo((Stack)stack));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testDrainHeadToDeque() throws Exception {
        this.syncDeque.enqueueTail((Object)"one");
        this.syncDeque.enqueueTail((Object)"two");
        this.syncDeque.enqueueTail((Object)"three");
        ArrayDeque queue = DequeTools.arrayDeque();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainHeadTo((Deque)queue));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)queue.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)queue.dequeueHead()));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)queue.dequeueHead()));
        SynchronizedDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testDrainHeadToDeque_empty() throws Exception {
        ArrayDeque queue = DequeTools.arrayDeque();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainHeadTo((Deque)queue));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testDrainHeadToMapTransformer() {
        this.syncDeque.enqueueTail((Object)"one");
        this.syncDeque.enqueueTail((Object)"two");
        this.syncDeque.enqueueTail((Object)"zero");
        HashMap map = new HashMap();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainHeadTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)map.get("o")));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)map.get("t")));
        SynchronizedDequeTests.assertEquals((String)"zero", (String)((String)map.get("z")));
    }

    public void testDrainHeadToMapTransformer_empty() {
        HashMap map = new HashMap();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainHeadTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER));
        SynchronizedDequeTests.assertTrue((boolean)map.isEmpty());
    }

    public void testDrainHeadToMapTransformerTransformer() {
        this.syncDeque.enqueueTail((Object)"one");
        this.syncDeque.enqueueTail((Object)"two");
        this.syncDeque.enqueueTail((Object)"zero");
        HashMap map = new HashMap();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainHeadTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER, DequeToolsTests.EMPHASIZER));
        SynchronizedDequeTests.assertEquals((String)"*one*", (String)((String)map.get("o")));
        SynchronizedDequeTests.assertEquals((String)"*two*", (String)((String)map.get("t")));
        SynchronizedDequeTests.assertEquals((String)"*zero*", (String)((String)map.get("z")));
    }

    public void testDrainHeadToMapTransformerTransformer_empty() {
        HashMap map = new HashMap();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainHeadTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER, DequeToolsTests.EMPHASIZER));
        SynchronizedDequeTests.assertTrue((boolean)map.isEmpty());
    }

    public void testEnqueueHeadAllIterable() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        this.syncDeque.enqueueHeadAll(list);
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueHeadAllIterable_empty() throws Exception {
        ArrayList list = new ArrayList();
        this.syncDeque.enqueueHeadAll(list);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueHeadAllObjectArray() throws Exception {
        this.syncDeque.enqueueHeadAll((Object[])new String[]{"one", "two", "three"});
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueHeadAllObjectArray_empty() throws Exception {
        this.syncDeque.enqueueHeadAll((Object[])new String[0]);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueHeadAllStack() throws Exception {
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"one");
        stack.push((Object)"two");
        stack.push((Object)"three");
        this.syncDeque.enqueueHeadAll((Stack)stack);
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueHeadAllStack_empty() throws Exception {
        ArrayStack stack = StackTools.arrayStack();
        this.syncDeque.enqueueHeadAll((Stack)stack);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueHeadAllDeque() throws Exception {
        ArrayDeque queue = DequeTools.arrayDeque();
        queue.enqueueHead((Object)"one");
        queue.enqueueHead((Object)"two");
        queue.enqueueHead((Object)"three");
        this.syncDeque.enqueueHeadAll((Deque)queue);
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)this.syncDeque.dequeueTail()));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testEnqueueHeadAllDeque_empty() throws Exception {
        ArrayDeque queue = DequeTools.arrayDeque();
        this.syncDeque.enqueueHeadAll((Deque)queue);
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
    }

    public void testDrainTail() throws Exception {
        this.syncDeque.enqueueHead((Object)"one");
        this.syncDeque.enqueueHead((Object)"two");
        this.syncDeque.enqueueHead((Object)"three");
        ArrayList list = this.syncDeque.drainTail();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainTail_empty() throws Exception {
        ArrayList list = this.syncDeque.drainTail();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((boolean)list.isEmpty());
    }

    public void testDrainTailToCollection() throws Exception {
        this.syncDeque.enqueueHead((Object)"one");
        this.syncDeque.enqueueHead((Object)"two");
        this.syncDeque.enqueueHead((Object)"three");
        ArrayList list = new ArrayList();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainTailTo(list));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainTailToCollection_empty() throws Exception {
        ArrayList list = new ArrayList();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainTailTo(list));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((boolean)list.isEmpty());
    }

    public void testDrainTailToListInt() throws Exception {
        this.syncDeque.enqueueHead((Object)"one");
        this.syncDeque.enqueueHead((Object)"two");
        this.syncDeque.enqueueHead((Object)"three");
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainTailTo(list, 2));
        SynchronizedDequeTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)list.get(2)));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)list.get(3)));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)list.get(4)));
        SynchronizedDequeTests.assertEquals((String)"ccc", (String)((String)list.get(5)));
    }

    public void testDrainTailToListInt_end() throws Exception {
        this.syncDeque.enqueueHead((Object)"one");
        this.syncDeque.enqueueHead((Object)"two");
        this.syncDeque.enqueueHead((Object)"three");
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainTailTo(list, 3));
        SynchronizedDequeTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)list.get(3)));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)list.get(4)));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)list.get(5)));
    }

    public void testDrainTailToListInt_empty() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainTailTo(list, 2));
        SynchronizedDequeTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedDequeTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedDequeTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
    }

    public void testDrainTailToStack() throws Exception {
        this.syncDeque.enqueueHead((Object)"one");
        this.syncDeque.enqueueHead((Object)"two");
        this.syncDeque.enqueueHead((Object)"three");
        ArrayStack stack = StackTools.arrayStack();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainTailTo((Stack)stack));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)stack.pop()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)stack.pop()));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)stack.pop()));
        SynchronizedDequeTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testDrainTailToStack_empty() throws Exception {
        ArrayStack stack = StackTools.arrayStack();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainTailTo((Stack)stack));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testDrainTailToDeque() throws Exception {
        this.syncDeque.enqueueHead((Object)"one");
        this.syncDeque.enqueueHead((Object)"two");
        this.syncDeque.enqueueHead((Object)"three");
        ArrayDeque queue = DequeTools.arrayDeque();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainTailTo((Deque)queue));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)queue.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)queue.dequeueTail()));
        SynchronizedDequeTests.assertEquals((String)"three", (String)((String)queue.dequeueTail()));
        SynchronizedDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testDrainTailToDeque_empty() throws Exception {
        ArrayDeque queue = DequeTools.arrayDeque();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainTailTo((Deque)queue));
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.isEmpty());
        SynchronizedDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testDrainTailToMapTransformer() {
        this.syncDeque.enqueueHead((Object)"one");
        this.syncDeque.enqueueHead((Object)"two");
        this.syncDeque.enqueueHead((Object)"zero");
        HashMap map = new HashMap();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainTailTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER));
        SynchronizedDequeTests.assertEquals((String)"one", (String)((String)map.get("o")));
        SynchronizedDequeTests.assertEquals((String)"two", (String)((String)map.get("t")));
        SynchronizedDequeTests.assertEquals((String)"zero", (String)((String)map.get("z")));
    }

    public void testDrainTailToMapTransformer_empty() {
        HashMap map = new HashMap();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainTailTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER));
        SynchronizedDequeTests.assertTrue((boolean)map.isEmpty());
    }

    public void testDrainTailToMapTransformerTransformer() {
        this.syncDeque.enqueueHead((Object)"one");
        this.syncDeque.enqueueHead((Object)"two");
        this.syncDeque.enqueueHead((Object)"zero");
        HashMap map = new HashMap();
        SynchronizedDequeTests.assertTrue((boolean)this.syncDeque.drainTailTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER, DequeToolsTests.EMPHASIZER));
        SynchronizedDequeTests.assertEquals((String)"*one*", (String)((String)map.get("o")));
        SynchronizedDequeTests.assertEquals((String)"*two*", (String)((String)map.get("t")));
        SynchronizedDequeTests.assertEquals((String)"*zero*", (String)((String)map.get("z")));
    }

    public void testDrainTailToMapTransformerTransformer_empty() {
        HashMap map = new HashMap();
        SynchronizedDequeTests.assertFalse((boolean)this.syncDeque.drainTailTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER, DequeToolsTests.EMPHASIZER));
        SynchronizedDequeTests.assertTrue((boolean)map.isEmpty());
    }

    private static interface Command {
        public void execute(SynchronizedDeque<String> var1) throws InterruptedException;
    }

    private static interface SlowDeque<E>
    extends Deque<E> {
        public Object slowDequeueHead();

        public Object slowDequeueTail();

        public void slowEnqueueTail(E var1);

        public void slowEnqueueHead(E var1);
    }

    private class SlowLinkedDeque<E>
    extends LinkedDeque<E>
    implements SlowDeque<E> {
        private static final long serialVersionUID = 1L;

        SlowLinkedDeque() {
        }

        @Override
        public Object slowDequeueHead() {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.dequeueHead();
        }

        @Override
        public Object slowDequeueTail() {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.dequeueTail();
        }

        @Override
        public void slowEnqueueTail(E element) {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            this.enqueueTail(element);
        }

        @Override
        public void slowEnqueueHead(E element) {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            this.enqueueHead(element);
        }
    }

    private class SlowSynchronizedDeque<E>
    extends SynchronizedDeque<E>
    implements SlowDeque<E> {
        private static final long serialVersionUID = 1L;

        SlowSynchronizedDeque() {
            super((Deque)DequeTools.linkedDeque());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object slowDequeueHead() {
            Object object = this.getMutex();
            synchronized (object) {
                try {
                    Thread.sleep(5L * TICK);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                return this.dequeueHead();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object slowDequeueTail() {
            Object object = this.getMutex();
            synchronized (object) {
                try {
                    Thread.sleep(5L * TICK);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                return this.dequeueTail();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void slowEnqueueTail(E element) {
            Object object = this.getMutex();
            synchronized (object) {
                try {
                    Thread.sleep(5L * TICK);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                this.enqueueTail(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void slowEnqueueHead(E element) {
            Object object = this.getMutex();
            synchronized (object) {
                try {
                    Thread.sleep(5L * TICK);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                this.enqueueHead(element);
            }
        }
    }
}

