/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToOneAnnotation2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaCascade2_0Tests
extends Generic2_0ContextModelTestCase {
    private ICompilationUnit createTestEntityWithOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
    }

    public GenericJavaCascade2_0Tests(String name) {
        super(name);
    }

    public void testUpdateCascadeDetach() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation2_0 annotation = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 mapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        Cascade2_0 cascade = mapping.getCascade();
        GenericJavaCascade2_0Tests.assertFalse((boolean)cascade.isDetach());
        GenericJavaCascade2_0Tests.assertFalse((boolean)annotation.isCascadeDetach());
        annotation.setCascadeDetach(true);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCascade2_0Tests.assertTrue((boolean)annotation.isCascadeDetach());
        GenericJavaCascade2_0Tests.assertTrue((boolean)cascade.isDetach());
        annotation.setCascadeDetach(false);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaCascade2_0Tests.assertFalse((boolean)annotation.isCascadeDetach());
        GenericJavaCascade2_0Tests.assertFalse((boolean)cascade.isDetach());
    }

    public void testModifyCascadeDetach() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation2_0 annotation = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 mapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        Cascade2_0 cascade = mapping.getCascade();
        GenericJavaCascade2_0Tests.assertFalse((boolean)cascade.isDetach());
        GenericJavaCascade2_0Tests.assertFalse((boolean)annotation.isCascadeDetach());
        cascade.setDetach(true);
        GenericJavaCascade2_0Tests.assertTrue((boolean)annotation.isCascadeDetach());
        GenericJavaCascade2_0Tests.assertTrue((boolean)cascade.isDetach());
        cascade.setDetach(false);
        GenericJavaCascade2_0Tests.assertFalse((boolean)annotation.isCascadeDetach());
        GenericJavaCascade2_0Tests.assertFalse((boolean)cascade.isDetach());
    }
}

