/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.eclipse;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.core.internal.validation.eclipse.ValidatorWrapper;
import org.eclipse.wst.xml.validation.tests.internal.XMLValidatorTestsPlugin;

public class ValidatorTest
extends TestCase {
    ValidatorWrapper validator = new ValidatorWrapper();
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.validation.eclipse.ValidatorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testAddInfoToMessage() {
        String COLUMN_NUMBER_ATTRIBUTE = "columnNumber";
        String SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = "squiggleSelectionStrategy";
        String SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = "squiggleNameOrValue";
        ValidationMessage validationMessage = new ValidationMessage("", 1, 1, "");
        Message message = new Message();
        this.validator.addInfoToMessage(validationMessage, (IMessage)message);
        ValidatorTest.assertNull((String)("COLUMN_NUMBER_ATTRIBUTE was not null for a ValidationMessage with a null key. COLUMN_NUMBER_ATTRIBUTE = " + message.getAttribute(COLUMN_NUMBER_ATTRIBUTE)), (Object)message.getAttribute(COLUMN_NUMBER_ATTRIBUTE));
        ValidatorTest.assertNull((String)("SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE was not null for a ValidationMessage with a null key. SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = " + message.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE)), (Object)message.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE));
        ValidatorTest.assertNull((String)("SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE was not null for a ValidationMessage with a null key. SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = " + message.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE)), (Object)message.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE));
        ValidationMessage validationMessage2 = new ValidationMessage("", 1, 1, "", "ElementUnterminated", null);
        Message message2 = new Message();
        this.validator.addInfoToMessage(validationMessage2, (IMessage)message2);
        ValidatorTest.assertEquals((String)("COLUMN_NUMBER_ATTRIBUTE was correctly set to 1 for a ValidationMessage with the key ENTIRE_ELEMENT. COLUMN_NUMBER_ATTRIBUTE = " + message2.getAttribute(COLUMN_NUMBER_ATTRIBUTE)), (Object)new Integer(1), (Object)message2.getAttribute(COLUMN_NUMBER_ATTRIBUTE));
        ValidatorTest.assertEquals((String)("SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE was not ENTIRE_ELEMENT. SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = " + message2.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE)), (Object)"ENTIRE_ELEMENT", (Object)message2.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE));
        ValidatorTest.assertNull((String)("SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE was not null for a ValidationMessage with the key ENTIRE_ELEMENT. SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = " + message2.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE)), (Object)message2.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE));
        ValidationMessage validationMessage3 = new ValidationMessage("", 1, 1, "", "EntityNotDeclared", new Object[]{"MyName"});
        Message message3 = new Message();
        this.validator.addInfoToMessage(validationMessage3, (IMessage)message3);
        ValidatorTest.assertEquals((String)("COLUMN_NUMBER_ATTRIBUTE was correctly set to 1 for a ValidationMessage with the key EntityNotDeclared. COLUMN_NUMBER_ATTRIBUTE = " + message3.getAttribute(COLUMN_NUMBER_ATTRIBUTE)), (Object)new Integer(1), (Object)message3.getAttribute(COLUMN_NUMBER_ATTRIBUTE));
        ValidatorTest.assertEquals((String)("SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE was not TEXT_ENTITY_REFERENCE. SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = " + message3.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE)), (Object)"TEXT_ENTITY_REFERENCE", (Object)message3.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE));
        ValidatorTest.assertEquals((String)("SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE was not set to MyName for a ValidationMessage with the key EntityNotDeclared. SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = " + message3.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE)), (Object)"MyName", (Object)message3.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testValidate() {
        try {
            ValidationReport report2;
            ValidationReport report1;
            block19: {
                Object var7_12;
                InputStream is;
                String uri;
                String PLUGIN_ABSOLUTE_PATH;
                block18: {
                    PLUGIN_ABSOLUTE_PATH = String.valueOf(XMLValidatorTestsPlugin.getPluginLocation().toString()) + "/";
                    uri = "file:///" + PLUGIN_ABSOLUTE_PATH + "testresources/samples/XMLExamples/PublicationCatalogue/Catalogue.xml";
                    report1 = this.validator.validate(uri, null, null);
                    report2 = null;
                    is = null;
                    try {
                        try {
                            is = new URL(uri).openStream();
                            report2 = this.validator.validate(uri, is, null);
                        }
                        catch (Exception e) {
                            ValidatorTest.fail((String)("A problem occurred while validating a valid file with an inputstream: " + e));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var7_12 = null;
                        if (is == null) break block18;
                    }
                    try {}
                    catch (IOException iOException) {}
                    is.close();
                }
                ValidatorTest.assertTrue((String)"Validation using a URI did not product a valid validation result.", (boolean)report1.isValid());
                ValidatorTest.assertEquals((String)"Validation using URI and using inputstream of the same file produces different numbers of errors.", (int)report1.getValidationMessages().length, (int)report2.getValidationMessages().length);
                uri = "file:///" + PLUGIN_ABSOLUTE_PATH + "testresources/samples/Paths/Dash-InPath/DashInPathInvalid.xml";
                report1 = this.validator.validate(uri, null, null);
                report2 = null;
                is = null;
                try {
                    try {
                        is = new URL(uri).openStream();
                        report2 = this.validator.validate(uri, is, null);
                    }
                    catch (Exception e) {
                        ValidatorTest.fail((String)("A problem occurred while validating an invalid file with an inputstream: " + e));
                    }
                }
                catch (Throwable throwable) {
                    var7_12 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    var7_12 = null;
                    if (is == null) break block19;
                }
                try {}
                catch (IOException iOException) {}
                is.close();
            }
            ValidatorTest.assertFalse((String)"Validation using a URI did not product an invalid validation result.", (boolean)report1.isValid());
            ValidatorTest.assertEquals((String)"Validation using URI and using inputstream of the same file produces different numbers of errors.", (int)report1.getValidationMessages().length, (int)report2.getValidationMessages().length);
            return;
        }
        catch (Exception e) {
            ValidatorTest.fail((String)("Unable to locate plug-in location: " + e));
        }
    }

    public void testWarnNoGrammarPreference() {
        this.validator.setupValidation(null);
        ValidatorTest.assertNotSame((String)"The default warn no grammar preference is not enabled.", (Object)new Integer(0), (Object)new Integer(this.validator.getIndicateNoGrammarPreference()));
        XMLCorePlugin.getDefault().getPluginPreferences().setValue("indicateNoGrammar", 0);
        this.validator.setupValidation(null);
        ValidatorTest.assertEquals((String)"The warn no grammar preference is not ignore when the preference is set to ignore.", (int)0, (int)this.validator.getIndicateNoGrammarPreference());
        XMLCorePlugin.getDefault().getPluginPreferences().setValue("indicateNoGrammar", 2);
        this.validator.setupValidation(null);
        ValidatorTest.assertEquals((String)"The warn no grammar preference is not error when the preference is set to error.", (int)2, (int)this.validator.getIndicateNoGrammarPreference());
    }
}

